/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.SignerFactory;
import org.xipki.security.SignerFactoryRegister;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.util.Args;
import org.xipki.util.ObjectCreationException;

public class SignerFactoryRegisterImpl
implements SignerFactoryRegister {
    private static final Logger LOG = LoggerFactory.getLogger(SignerFactoryRegisterImpl.class);
    private final ConcurrentLinkedDeque<SignerFactory> factories = new ConcurrentLinkedDeque();

    @Override
    public Set<String> getSupportedSignerTypes() {
        HashSet<String> types = new HashSet<String>();
        for (SignerFactory service : this.factories) {
            types.addAll(service.getSupportedSignerTypes());
        }
        return Collections.unmodifiableSet(types);
    }

    public void registFactory(SignerFactory factory) {
        if (factory == null) {
            LOG.info("registFactory invoked with null.");
            return;
        }
        boolean replaced = this.factories.remove(factory);
        this.factories.add(factory);
        String action = replaced ? "replaced" : "added";
        LOG.info("{} SignerFactory binding for {}", (Object)action, (Object)factory);
    }

    public void unregistFactory(SignerFactory factory) {
        if (factory == null) {
            LOG.info("unregistFactory invoked with null.");
            return;
        }
        if (this.factories.remove(factory)) {
            LOG.info("removed SignerFactory binding for {}", (Object)factory);
        } else {
            LOG.info("no SignerFactory binding found to remove for '{}'", (Object)factory);
        }
    }

    @Override
    public ConcurrentContentSigner newSigner(SecurityFactory securityFactory, String type, SignerConf conf, X509Cert[] certificateChain) throws ObjectCreationException {
        Args.notBlank((String)type, (String)"type");
        for (SignerFactory service : this.factories) {
            if (!service.canCreateSigner(type)) continue;
            return service.newSigner(type, conf, certificateChain);
        }
        throw new ObjectCreationException("could not find Factory to create Signer of type " + type);
    }

    @Override
    public void refreshTokenForSignerType(String signerType) throws XiSecurityException {
        for (SignerFactory service : this.factories) {
            if (!service.canCreateSigner(signerType)) continue;
            service.refreshToken(signerType);
            break;
        }
    }
}

