/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.SignAlgo;
import org.xipki.util.Args;

public class CollectionAlgorithmValidator
implements AlgorithmValidator {
    private final Set<SignAlgo> algos;
    private final Set<String> algoNames;

    public CollectionAlgorithmValidator(Collection<SignAlgo> algos) {
        this.algos = Collections.unmodifiableSet(new HashSet<SignAlgo>(algos));
        HashSet<String> names = new HashSet<String>();
        for (SignAlgo m : algos) {
            names.add(m.getJceName());
        }
        this.algoNames = Collections.unmodifiableSet(names);
    }

    public Set<SignAlgo> getAlgos() {
        return this.algos;
    }

    public Set<String> getAlgoNames() {
        return this.algoNames;
    }

    @Override
    public boolean isAlgorithmPermitted(AlgorithmIdentifier algId) {
        SignAlgo algo;
        Args.notNull((Object)algId, (String)"algId");
        if (this.algos.isEmpty()) {
            return true;
        }
        try {
            algo = SignAlgo.getInstance(algId);
        }
        catch (NoSuchAlgorithmException ex) {
            return false;
        }
        return this.algos.contains((Object)algo);
    }

    @Override
    public boolean isAlgorithmPermitted(SignAlgo algo) {
        Args.notNull((Object)((Object)algo), (String)"algo");
        return this.algos.contains((Object)algo);
    }
}

