/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.cmp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.xipki.util.Args;

public class CmpUtf8Pairs {
    public static final String KEY_NOTBEFORE = "notbefore";
    public static final String KEY_NOTAFTER = "notafter";
    private static final char NAME_TERM = '?';
    private static final char TOKEN_TERM = '%';
    private final Map<String, String> pairs = new HashMap<String, String>();

    public CmpUtf8Pairs(String name, String value) {
        this.putUtf8Pair(name, value);
    }

    public CmpUtf8Pairs() {
    }

    public CmpUtf8Pairs(String encodedCmpUtf8Pairs) {
        String encoded = Args.notBlank((String)encodedCmpUtf8Pairs, (String)"encodedCmpUtf8Pairs");
        while (encoded.charAt(encoded.length() - 1) == '%') {
            encoded = encoded.substring(0, encoded.length() - 1);
        }
        LinkedList<Integer> positions = new LinkedList<Integer>();
        int idx = 1;
        int len = encoded.length();
        while (idx < len) {
            char ch2;
            char ch;
            if ((ch = encoded.charAt(idx++)) != '%' || (ch2 = encoded.charAt(idx)) >= '0' && ch2 <= '9') continue;
            positions.add(idx - 1);
        }
        positions.add(encoded.length());
        int beginIndex = 0;
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int endIndex = (Integer)iterator.next();
            String token = encoded.substring(beginIndex, endIndex);
            int sepIdx = token.indexOf(63);
            if (sepIdx == -1 || sepIdx == token.length() - 1) {
                throw new IllegalArgumentException("invalid token: " + token);
            }
            String name = token.substring(0, sepIdx);
            name = CmpUtf8Pairs.decodeNameOrValue(name);
            String value = token.substring(sepIdx + 1);
            value = CmpUtf8Pairs.decodeNameOrValue(value);
            this.pairs.put(name, value);
            beginIndex = endIndex + 1;
        }
    }

    public final void putUtf8Pair(String name, String value) {
        Args.notNull((Object)name, (String)"name");
        Args.notNull((Object)value, (String)"value");
        char ch = name.charAt(0);
        if (ch >= '0' && ch <= '9') {
            throw new IllegalArgumentException("name may not begin with " + ch);
        }
        this.pairs.put(name, value);
    }

    public void removeUtf8Pair(String name) {
        Args.notNull((Object)name, (String)"name");
        this.pairs.remove(name);
    }

    public String value(String name) {
        Args.notNull((Object)name, (String)"name");
        return this.pairs.get(name);
    }

    public Set<String> names() {
        return Collections.unmodifiableSet(this.pairs.keySet());
    }

    public String encoded() {
        String value;
        StringBuilder sb = new StringBuilder();
        LinkedList<String> names = new LinkedList<String>();
        for (Map.Entry<String, String> entry : this.pairs.entrySet()) {
            value = entry.getValue();
            if (value.length() > 100) continue;
            names.add(entry.getKey());
        }
        Collections.sort(names);
        for (String name : this.pairs.keySet()) {
            if (names.contains(name)) continue;
            names.add(name);
        }
        for (String name : names) {
            value = this.pairs.get(name);
            sb.append(CmpUtf8Pairs.encodeNameOrValue(name));
            sb.append('?');
            if (value != null) {
                sb.append(CmpUtf8Pairs.encodeNameOrValue(value));
            }
            sb.append('%');
        }
        return sb.toString();
    }

    public String toString() {
        return this.encoded();
    }

    public int hashCode() {
        return this.encoded().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CmpUtf8Pairs)) {
            return false;
        }
        CmpUtf8Pairs objB = (CmpUtf8Pairs)obj;
        return this.pairs.equals(objB.pairs);
    }

    private static String encodeNameOrValue(String str) {
        String tmpStr = str;
        if (tmpStr.contains("%")) {
            tmpStr = tmpStr.replaceAll("%", "%25");
        }
        if (tmpStr.contains("?")) {
            tmpStr = tmpStr.replaceAll("\\?", "%3f");
        }
        return tmpStr;
    }

    private static String decodeNameOrValue(String str) {
        int idx = str.indexOf(37);
        if (idx == -1) {
            return str;
        }
        StringBuilder newS = new StringBuilder();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch != '%') {
                newS.append(ch);
                ++i;
                continue;
            }
            if (i + 3 <= str.length()) {
                String hex = str.substring(i + 1, i + 3);
                ch = (char)Byte.parseByte(hex, 16);
                newS.append(ch);
                i += 3;
                continue;
            }
            newS.append(str.substring(i));
            break;
        }
        return newS.toString();
    }
}

