/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.jce;

import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPathBuilderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.SignAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.jce.JceSigner;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;

public class JceSignerBuilder {
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final String providerName;
    private final Provider provider;
    private final X509Cert[] certificateChain;

    public JceSignerBuilder(PrivateKey privateKey, PublicKey publicKey, X509Cert[] certificateChain, String providerName) throws XiSecurityException {
        this(privateKey, publicKey, certificateChain, providerName, null);
    }

    public JceSignerBuilder(PrivateKey privateKey, PublicKey publicKey, X509Cert[] certificateChain, Provider provider) throws XiSecurityException {
        this(privateKey, publicKey, certificateChain, null, provider);
    }

    private JceSignerBuilder(PrivateKey privateKey, PublicKey publicKey, X509Cert[] certificateChain, String providerName, Provider provider) throws XiSecurityException {
        this.privateKey = (PrivateKey)Args.notNull((Object)privateKey, (String)"privateKey");
        this.publicKey = (PublicKey)Args.notNull((Object)publicKey, (String)"publicKey");
        this.providerName = providerName;
        this.provider = provider;
        X509Cert[] chain = null;
        if (certificateChain != null && certificateChain.length > 0) {
            int n = certificateChain.length;
            X509Cert cert = certificateChain[0];
            if (n > 1) {
                HashSet<X509Cert> caCerts = new HashSet<X509Cert>();
                caCerts.addAll(Arrays.asList(certificateChain).subList(1, n));
                try {
                    chain = X509Util.buildCertPath(cert, caCerts);
                }
                catch (CertPathBuilderException ex) {
                    throw new XiSecurityException(ex);
                }
            }
        }
        this.certificateChain = chain;
    }

    public ConcurrentContentSigner createSigner(SignAlgo signAlgo, int parallelism) throws XiSecurityException {
        DfltConcurrentContentSigner concurrentSigner;
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            JceSigner signer = new JceSigner(this.privateKey, signAlgo, this.providerName, this.provider);
            signers.add(signer);
        }
        try {
            concurrentSigner = new DfltConcurrentContentSigner(false, signers, this.privateKey);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        if (this.certificateChain != null) {
            concurrentSigner.setCertificateChain(this.certificateChain);
        } else {
            concurrentSigner.setPublicKey(this.publicKey);
        }
        return concurrentSigner;
    }
}

