/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.iaik;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.CharArrayAttribute;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECPublicKey;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.parameters.InitializationVectorParameters;
import iaik.pkcs.pkcs11.parameters.OpaqueParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsPssParameters;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.EdECConstants;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.CollectionUtil;
import org.xipki.util.Hex;
import org.xipki.util.LogUtil;

class IaikP11SlotUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IaikP11SlotUtil.class);

    IaikP11SlotUtil() {
    }

    static void singleLogin(Session session, long userType, char[] pin) throws P11TokenException {
        char[] tmpPin = pin;
        if (pin == null) {
            tmpPin = new char[]{};
        }
        String userTypeText = IaikP11SlotUtil.getUserTypeText(userType);
        try {
            session.login(userType, tmpPin);
            LOG.info("login successful as user " + userTypeText);
        }
        catch (TokenException ex) {
            if (ex instanceof PKCS11Exception && ((PKCS11Exception)((Object)ex)).getErrorCode() == 256L) {
                LOG.info("user already logged in");
            }
            LOG.info("login failed as user " + userTypeText);
            throw new P11TokenException("login failed as user " + userTypeText + ": " + ex.getMessage(), ex);
        }
    }

    private static String getUserTypeText(long userType) {
        if (userType == 0L) {
            return "CKU_SO";
        }
        if (userType == 1L) {
            return "CKU_USER";
        }
        if (userType == 2L) {
            return "CKU_CONTEXT_SPECIFIC";
        }
        return "VENDOR_" + userType;
    }

    static byte[] digestKey(Session session, int digestLen, Mechanism mechanism, SecretKey key) throws TokenException {
        session.digestInit(mechanism);
        session.digestKey(key);
        byte[] digest = new byte[digestLen];
        session.digestFinal(digest, 0, digestLen);
        return digest;
    }

    static Mechanism getMechanism(long mechanism, P11Params parameters) throws P11TokenException {
        OpaqueParameters paramObj;
        Mechanism ret = Mechanism.get((long)mechanism);
        if (parameters == null) {
            return ret;
        }
        if (parameters instanceof P11Params.P11RSAPkcsPssParams) {
            P11Params.P11RSAPkcsPssParams param = (P11Params.P11RSAPkcsPssParams)parameters;
            paramObj = new RSAPkcsPssParameters(param.getHashAlgorithm(), param.getMaskGenerationFunction(), param.getSaltLength());
        } else if (parameters instanceof P11Params.P11ByteArrayParams) {
            paramObj = new OpaqueParameters(((P11Params.P11ByteArrayParams)parameters).getBytes());
        } else if (parameters instanceof P11Params.P11IVParams) {
            paramObj = new InitializationVectorParameters(((P11Params.P11IVParams)parameters).getIV());
        } else {
            throw new P11TokenException("unknown P11Parameters " + parameters.getClass().getName());
        }
        ret.setParameters((Parameters)paramObj);
        return ret;
    }

    static X509PublicKeyCertificate getCertificateObject(Session session, byte[] keyId, char[] keyLabel) throws P11TokenException {
        Object[] certs = IaikP11SlotUtil.getCertificateObjects(session, keyId, keyLabel);
        if (CollectionUtil.isEmpty((Object[])certs)) {
            LOG.info("found no certificate identified by {}", (Object)P11Slot.getDescription(keyId, keyLabel));
            return null;
        }
        int size = certs.length;
        if (size > 1) {
            LOG.warn("found {} public key identified by {}, use the first one", (Object)size, (Object)P11Slot.getDescription(keyId, keyLabel));
        }
        return certs[0];
    }

    static boolean checkSessionLoggedIn(Session session, long userType) throws P11TokenException {
        SessionInfo info;
        try {
            info = session.getSessionInfo();
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("SessionInfo: {}", (Object)info);
        }
        State state = info.getState();
        long deviceError = info.getDeviceError();
        LOG.debug("to be verified PKCS11Module: state = {}, deviceError: {}", (Object)state, (Object)deviceError);
        if (deviceError != 0L) {
            LOG.error("deviceError {}", (Object)deviceError);
            return false;
        }
        boolean sessionLoggedIn = userType == 0L ? state.equals((Object)State.RW_SO_FUNCTIONS) : state.equals((Object)State.RW_USER_FUNCTIONS) || state.equals((Object)State.RO_USER_FUNCTIONS);
        LOG.debug("sessionLoggedIn: {}", (Object)sessionLoggedIn);
        return sessionLoggedIn;
    }

    static byte[] value(ByteArrayAttribute attr) {
        return attr == null ? null : attr.getByteArrayValue();
    }

    static char[] value(CharArrayAttribute attr) {
        return attr == null ? null : attr.getCharArrayValue();
    }

    static String valueStr(CharArrayAttribute attr) {
        char[] chars = attr == null ? null : attr.getCharArrayValue();
        return chars == null ? null : new String(chars);
    }

    static List<Storage> getObjects(Session session, Storage template) throws P11TokenException {
        return IaikP11SlotUtil.getObjects(session, template, 9999);
    }

    static List<Storage> getObjects(Session session, Storage template, int maxNo) throws P11TokenException {
        LinkedList<Storage> objList = new LinkedList<Storage>();
        try {
            PKCS11Object[] foundObjects;
            session.findObjectsInit((PKCS11Object)template);
            while (objList.size() < maxNo && (foundObjects = session.findObjects(1)) != null) {
                if (foundObjects.length == 0) {
                    break;
                }
                for (PKCS11Object object : foundObjects) {
                    IaikP11SlotUtil.logPkcs11ObjectAttributes("found object: ", object);
                    objList.add((Storage)object);
                }
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            try {
                session.findObjectsFinal();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"session.findObjectsFinal() failed");
            }
        }
        return objList;
    }

    static PublicKey generatePublicKey(iaik.pkcs.pkcs11.objects.PublicKey p11Key) throws XiSecurityException {
        if (p11Key instanceof RSAPublicKey) {
            RSAPublicKey rsaP11Key = (RSAPublicKey)p11Key;
            BigInteger exp = new BigInteger(1, IaikP11SlotUtil.value(rsaP11Key.getPublicExponent()));
            byte[] modBytes = IaikP11SlotUtil.value(rsaP11Key.getModulus());
            BigInteger mod = new BigInteger(1, modBytes);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            try {
                return KeyUtil.generateRSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        if (p11Key instanceof DSAPublicKey) {
            DSAPublicKey dsaP11Key = (DSAPublicKey)p11Key;
            BigInteger prime = new BigInteger(1, IaikP11SlotUtil.value(dsaP11Key.getPrime()));
            BigInteger subPrime = new BigInteger(1, IaikP11SlotUtil.value(dsaP11Key.getSubprime()));
            BigInteger base = new BigInteger(1, IaikP11SlotUtil.value(dsaP11Key.getBase()));
            BigInteger value = new BigInteger(1, IaikP11SlotUtil.value(dsaP11Key.getValue()));
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(value, prime, subPrime, base);
            try {
                return KeyUtil.generateDSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        if (p11Key instanceof ECPublicKey) {
            ECPublicKey ecP11Key = (ECPublicKey)p11Key;
            long keyType = ecP11Key.getKeyType().getLongValue();
            byte[] ecParameters = IaikP11SlotUtil.value(ecP11Key.getEcdsaParams());
            byte[] ecPoint = IaikP11SlotUtil.value(ecP11Key.getEcPoint());
            byte[] encodedPoint = null;
            if (keyType == 0xFFFFF001L && ecParameters == null) {
                ecParameters = Hex.decode((String)"06082a811ccf5501822d");
            }
            ASN1ObjectIdentifier curveOid = ASN1ObjectIdentifier.getInstance((Object)ecParameters);
            if (keyType == 0xFFFFF001L || keyType == 3L) {
                int coordSize;
                if (GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)curveOid) || SECObjectIdentifiers.secp256r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP256r1.equals((ASN1Primitive)curveOid)) {
                    coordSize = 32;
                } else if (SECObjectIdentifiers.secp384r1.equals((ASN1Primitive)curveOid) || TeleTrusTObjectIdentifiers.brainpoolP384r1.equals((ASN1Primitive)curveOid)) {
                    coordSize = 48;
                } else if (SECObjectIdentifiers.secp521r1.equals((ASN1Primitive)curveOid)) {
                    coordSize = 66;
                } else if (TeleTrusTObjectIdentifiers.brainpoolP512r1.equals((ASN1Primitive)curveOid)) {
                    coordSize = 64;
                } else {
                    throw new XiSecurityException("unknown curve " + curveOid.getId());
                }
                if (ecPoint.length == 2 * coordSize) {
                    encodedPoint = new byte[1 + 2 * coordSize];
                    encodedPoint[0] = 4;
                    System.arraycopy(ecPoint, 0, encodedPoint, 1, ecPoint.length);
                } else if (ecPoint.length == 1 + 2 * coordSize) {
                    encodedPoint = ecPoint;
                }
            }
            if (encodedPoint == null) {
                encodedPoint = DEROctetString.getInstance((Object)ecPoint).getOctets();
            }
            if (keyType == 64L || keyType == 65L) {
                if (keyType == 64L) {
                    if (!EdECConstants.isEdwardsCurve(curveOid)) {
                        throw new XiSecurityException("unknown Edwards curve OID " + curveOid);
                    }
                } else if (!EdECConstants.isMontgomeryCurve(curveOid)) {
                    throw new XiSecurityException("unknown Montgomery curve OID " + curveOid);
                }
                SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(curveOid), encodedPoint);
                try {
                    return KeyUtil.generatePublicKey(pkInfo);
                }
                catch (InvalidKeySpecException ex) {
                    throw new XiSecurityException(ex.getMessage(), ex);
                }
            }
            try {
                return KeyUtil.createECPublicKey(ecParameters, encodedPoint);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        throw new XiSecurityException("unknown publicKey class " + p11Key.getClass().getName());
    }

    static X509Cert parseCert(X509PublicKeyCertificate p11Cert) throws P11TokenException {
        try {
            byte[] encoded = IaikP11SlotUtil.value(p11Cert.getValue());
            return X509Util.parseCert(encoded);
        }
        catch (CertificateException ex) {
            throw new P11TokenException("could not parse certificate: " + ex.getMessage(), ex);
        }
    }

    static List<X509PublicKeyCertificate> getAllCertificateObjects(Session session) throws P11TokenException {
        X509PublicKeyCertificate template = new X509PublicKeyCertificate();
        List<Storage> tmpObjects = IaikP11SlotUtil.getObjects(session, (Storage)template);
        ArrayList<X509PublicKeyCertificate> certs = new ArrayList<X509PublicKeyCertificate>(tmpObjects.size());
        for (PKCS11Object pKCS11Object : tmpObjects) {
            X509PublicKeyCertificate cert = (X509PublicKeyCertificate)pKCS11Object;
            certs.add(cert);
        }
        return certs;
    }

    static int removeObjects0(Session session, Storage template, String desc) throws P11TokenException {
        try {
            List<Storage> objects = IaikP11SlotUtil.getObjects(session, template);
            for (Storage obj : objects) {
                session.destroyObject((PKCS11Object)obj);
            }
            return objects.size();
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not remove " + desc));
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    static void setKeyAttributes(P11Slot.P11NewKeyControl control, iaik.pkcs.pkcs11.objects.PublicKey publicKey, PrivateKey privateKey, P11ModuleConf.P11NewObjectConf newObjectConf) {
        if (privateKey != null) {
            privateKey.getToken().setBooleanValue(Boolean.valueOf(true));
            if (newObjectConf.isIgnoreLabel()) {
                if (control.getLabel() != null) {
                    LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
                }
            } else {
                privateKey.getLabel().setCharArrayValue(control.getLabel().toCharArray());
            }
            privateKey.getPrivate().setBooleanValue(Boolean.valueOf(true));
            if (control.getExtractable() != null) {
                privateKey.getExtractable().setBooleanValue(control.getExtractable());
            }
            if (control.getSensitive() != null) {
                privateKey.getSensitive().setBooleanValue(control.getSensitive());
            }
            Set<P11Slot.P11KeyUsage> usages = control.getUsages();
            Boolean TRUE = Boolean.TRUE;
            if (CollectionUtil.isNotEmpty(usages)) {
                for (P11Slot.P11KeyUsage usage : usages) {
                    if (usage == P11Slot.P11KeyUsage.DECRYPT) {
                        privateKey.getDecrypt().setBooleanValue(TRUE);
                        continue;
                    }
                    if (usage == P11Slot.P11KeyUsage.DERIVE) {
                        privateKey.getDerive().setBooleanValue(TRUE);
                        continue;
                    }
                    if (usage == P11Slot.P11KeyUsage.SIGN) {
                        privateKey.getSign().setBooleanValue(TRUE);
                        continue;
                    }
                    if (usage == P11Slot.P11KeyUsage.SIGN_RECOVER) {
                        privateKey.getSignRecover().setBooleanValue(TRUE);
                        continue;
                    }
                    if (usage != P11Slot.P11KeyUsage.UNWRAP) continue;
                    privateKey.getUnwrap().setBooleanValue(TRUE);
                }
            } else {
                long keyType = privateKey.getKeyType().getLongValue();
                if (keyType == 3L || keyType == 0L || keyType == 1L || keyType == 0xFFFFF001L) {
                    privateKey.getSign().setBooleanValue(TRUE);
                }
                if (keyType == 0L) {
                    privateKey.getUnwrap().setBooleanValue(TRUE);
                    privateKey.getDecrypt().setBooleanValue(TRUE);
                }
            }
        }
        if (publicKey != null) {
            publicKey.getToken().setBooleanValue(Boolean.valueOf(true));
            if (!newObjectConf.isIgnoreLabel()) {
                publicKey.getLabel().setCharArrayValue(control.getLabel().toCharArray());
            }
            publicKey.getVerify().setBooleanValue(Boolean.valueOf(true));
        }
    }

    static void setKeyAttributes(P11Slot.P11NewKeyControl control, SecretKey template, char[] label) {
        template.getToken().setBooleanValue(Boolean.valueOf(true));
        if (label != null) {
            template.getLabel().setCharArrayValue(label);
        }
        if (control.getExtractable() != null) {
            template.getExtractable().setBooleanValue(control.getExtractable());
        }
        if (control.getSensitive() != null) {
            template.getSensitive().setBooleanValue(control.getSensitive());
        }
        Set<P11Slot.P11KeyUsage> usages = control.getUsages();
        Boolean TRUE = Boolean.TRUE;
        if (CollectionUtil.isNotEmpty(usages)) {
            for (P11Slot.P11KeyUsage usage : usages) {
                if (usage == P11Slot.P11KeyUsage.DECRYPT) {
                    template.getDecrypt().setBooleanValue(TRUE);
                    continue;
                }
                if (usage == P11Slot.P11KeyUsage.DERIVE) {
                    template.getDerive().setBooleanValue(TRUE);
                    continue;
                }
                if (usage == P11Slot.P11KeyUsage.SIGN) {
                    template.getSign().setBooleanValue(TRUE);
                    continue;
                }
                if (usage != P11Slot.P11KeyUsage.UNWRAP) continue;
                template.getUnwrap().setBooleanValue(TRUE);
            }
        }
    }

    static X509PublicKeyCertificate[] getCertificateObjects(Session session, byte[] keyId, char[] keyLabel) throws P11TokenException {
        List<Storage> tmpObjects;
        X509PublicKeyCertificate template = new X509PublicKeyCertificate();
        if (keyId != null) {
            template.getId().setByteArrayValue(keyId);
        }
        if (keyLabel != null) {
            template.getLabel().setCharArrayValue(keyLabel);
        }
        if (CollectionUtil.isEmpty(tmpObjects = IaikP11SlotUtil.getObjects(session, (Storage)template))) {
            LOG.info("found no certificate identified by {}", (Object)P11Slot.getDescription(keyId, keyLabel));
            return null;
        }
        int size = tmpObjects.size();
        X509PublicKeyCertificate[] certs = new X509PublicKeyCertificate[size];
        for (int i = 0; i < size; ++i) {
            certs[i] = (X509PublicKeyCertificate)tmpObjects.get(i);
        }
        return certs;
    }

    static void logPkcs11ObjectAttributes(String prefix, PKCS11Object p11Object) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        Hashtable table = p11Object.getAttributeTable();
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            Attribute attr = p11Object.getAttribute(((Long)keys.nextElement()).longValue());
            sb.append("\n  ").append(attr.toString(true));
        }
        LOG.debug(sb.toString());
    }
}

