/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import org.bouncycastle.operator.bc.BcDSAContentVerifierProviderBuilder;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.asn1.Asn1StreamParser;
import org.xipki.security.bc.XiECContentVerifierProviderBuilder;
import org.xipki.security.bc.XiEdDSAContentVerifierProvider;
import org.xipki.security.bc.XiRSAContentVerifierProviderBuilder;
import org.xipki.security.bc.XiXDHContentVerifierProvider;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.Args;

public class SignerUtil {
    private static final DigestAlgorithmIdentifierFinder DIGESTALG_IDENTIFIER_FINDER = new DefaultDigestAlgorithmIdentifierFinder();
    private static final Map<String, BcContentVerifierProviderBuilder> VERIFIER_PROVIDER_BUILDER = new HashMap<String, BcContentVerifierProviderBuilder>();

    private SignerUtil() {
    }

    public static RSAKeyParameters generateRSAPrivateKeyParameter(RSAPrivateKey key) {
        Args.notNull((Object)key, (String)"key");
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(rsaKey.getModulus(), rsaKey.getPublicExponent(), rsaKey.getPrivateExponent(), rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getPrimeExponentP(), rsaKey.getPrimeExponentQ(), rsaKey.getCrtCoefficient());
        }
        return new RSAKeyParameters(true, key.getModulus(), key.getPrivateExponent());
    }

    public static Signer createPSSRSASigner(SignAlgo sigAlgo) throws XiSecurityException {
        return SignerUtil.createPSSRSASigner(sigAlgo, null);
    }

    public static Signer createPSSRSASigner(SignAlgo sigAlgo, AsymmetricBlockCipher cipher) throws XiSecurityException {
        Args.notNull((Object)((Object)sigAlgo), (String)"sigAlgo");
        if (!sigAlgo.isRSAPSSSigAlgo()) {
            throw new XiSecurityException((Object)((Object)sigAlgo) + " is not an RSAPSS algorithm");
        }
        HashAlgo hashAlgo = sigAlgo.getHashAlgo();
        AsymmetricBlockCipher tmpCipher = cipher == null ? new RSABlindedEngine() : cipher;
        ExtendedDigest dig = hashAlgo.createDigest();
        ExtendedDigest mgfDig = hashAlgo.createDigest();
        return new PSSSigner(tmpCipher, (Digest)dig, (Digest)mgfDig, hashAlgo.getLength(), -68);
    }

    public static byte[] dsaSigPlainToX962(byte[] signature) throws XiSecurityException {
        Args.notNull((Object)signature, (String)"signature");
        if (signature.length % 2 != 0) {
            throw new XiSecurityException("signature.lenth must be even, but is odd");
        }
        byte[] ba = new byte[signature.length / 2];
        ASN1EncodableVector sigder = new ASN1EncodableVector();
        System.arraycopy(signature, 0, ba, 0, ba.length);
        sigder.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, ba)));
        System.arraycopy(signature, ba.length, ba, 0, ba.length);
        sigder.add((ASN1Encodable)new ASN1Integer(new BigInteger(1, ba)));
        DERSequence seq = new DERSequence(sigder);
        try {
            return seq.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("IOException, message: " + ex.getMessage(), ex);
        }
    }

    public static byte[] dsaSigX962ToPlain(byte[] x962Signature, int keyBitLen) throws XiSecurityException {
        Args.notNull((Object)x962Signature, (String)"x962Signature");
        try {
            BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(x962Signature));
            int tag = Asn1StreamParser.markAndReadTag(is);
            Asn1StreamParser.assertTag(48, tag, "X962Signature");
            Asn1StreamParser.MyInt lenBytesLen = new Asn1StreamParser.MyInt();
            int len = Asn1StreamParser.readLength(lenBytesLen, is);
            if (1 + lenBytesLen.get() + len != x962Signature.length) {
                throw new XiSecurityException("invalid length");
            }
            byte[] r = Asn1StreamParser.readValue(2, is, "r");
            byte[] s = Asn1StreamParser.readValue(2, is, "s");
            return SignerUtil.dsaSigToPlain(new BigInteger(1, r), new BigInteger(1, s), keyBitLen);
        }
        catch (IOException ex) {
            throw new XiSecurityException("error parsing X509Signature", ex);
        }
    }

    public static byte[] dsaSigToPlain(BigInteger sigR, BigInteger sigS, int keyBitLen) throws XiSecurityException {
        Args.notNull((Object)sigR, (String)"sigR");
        Args.notNull((Object)sigS, (String)"sigS");
        int blockSize = (keyBitLen + 7) / 8;
        int bitLenOfR = sigR.bitLength();
        int bitLenOfS = sigS.bitLength();
        int bitLen = Math.max(bitLenOfR, bitLenOfS);
        if ((bitLen + 7) / 8 > blockSize) {
            throw new XiSecurityException("signature is too large");
        }
        byte[] plainSignature = new byte[2 * blockSize];
        SignerUtil.bigIntToBytes(sigR, plainSignature, 0, blockSize);
        SignerUtil.bigIntToBytes(sigS, plainSignature, blockSize, blockSize);
        return plainSignature;
    }

    private static void bigIntToBytes(BigInteger num, byte[] dest, int destPos, int length) {
        byte[] bytes = num.toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, dest, destPos, length);
        } else if (bytes.length < length) {
            System.arraycopy(bytes, 0, dest, destPos + length - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - length, dest, destPos, length);
        }
    }

    public static ContentVerifierProvider getContentVerifierProvider(PublicKey publicKey, DHSigStaticKeyCertPair ownerKeyAndCert) throws InvalidKeyException {
        Args.notNull((Object)publicKey, (String)"publicKey");
        String keyAlg = publicKey.getAlgorithm().toUpperCase();
        if ("ED25519".equals(keyAlg) || "ED448".equals(keyAlg)) {
            return new XiEdDSAContentVerifierProvider(publicKey);
        }
        if ("X25519".equals(keyAlg) || "X448".equals(keyAlg)) {
            if (ownerKeyAndCert == null) {
                throw new InvalidKeyException("ownerKeyAndCert is required but absent");
            }
            return new XiXDHContentVerifierProvider(publicKey, ownerKeyAndCert);
        }
        Object builder = VERIFIER_PROVIDER_BUILDER.get(keyAlg);
        if (builder == null) {
            switch (keyAlg) {
                case "RSA": {
                    builder = new XiRSAContentVerifierProviderBuilder();
                    break;
                }
                case "DSA": {
                    builder = new BcDSAContentVerifierProviderBuilder(DIGESTALG_IDENTIFIER_FINDER);
                    break;
                }
                case "EC": 
                case "ECDSA": {
                    builder = new XiECContentVerifierProviderBuilder();
                    break;
                }
                default: {
                    throw new InvalidKeyException("unknown key algorithm of the public key " + keyAlg);
                }
            }
            VERIFIER_PROVIDER_BUILDER.put(keyAlg, (BcContentVerifierProviderBuilder)builder);
        }
        AsymmetricKeyParameter keyParam = KeyUtil.generatePublicKeyParameter(publicKey);
        try {
            return builder.build(keyParam);
        }
        catch (OperatorCreationException ex) {
            throw new InvalidKeyException("could not build ContentVerifierProvider: " + ex.getMessage(), ex);
        }
    }
}

