/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.util.Args;

public class CollectionAlgorithmValidator
implements AlgorithmValidator {
    private final Set<String> algoNames;

    public CollectionAlgorithmValidator(Collection<String> algoNames) throws NoSuchAlgorithmException {
        HashSet<String> canonicalizedNames = new HashSet<String>();
        if (algoNames != null) {
            for (String m : algoNames) {
                canonicalizedNames.add(AlgorithmUtil.canonicalizeSignatureAlgo(m));
            }
        }
        this.algoNames = Collections.unmodifiableSet(canonicalizedNames);
    }

    public Set<String> getAlgoNames() {
        return this.algoNames;
    }

    @Override
    public boolean isAlgorithmPermitted(AlgorithmIdentifier algId) {
        String name;
        Args.notNull((Object)algId, (String)"algId");
        if (this.algoNames.isEmpty()) {
            return true;
        }
        try {
            name = AlgorithmUtil.getSignatureAlgoName(algId);
        }
        catch (NoSuchAlgorithmException ex) {
            return false;
        }
        return this.algoNames.contains(name);
    }

    @Override
    public boolean isAlgorithmPermitted(String algoName) {
        String name;
        Args.notBlank((String)algoName, (String)"algoName");
        if (this.algoNames.isEmpty()) {
            return true;
        }
        if (this.algoNames.contains(algoName)) {
            return true;
        }
        try {
            name = AlgorithmUtil.canonicalizeSignatureAlgo(algoName);
        }
        catch (NoSuchAlgorithmException ex) {
            return false;
        }
        return this.algoNames.contains(name);
    }
}

