/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.P11UnsupportedMechanismException;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public abstract class P11Identity
implements Comparable<P11Identity> {
    private static final Logger LOG = LoggerFactory.getLogger(P11Identity.class);
    protected final P11Slot slot;
    protected final P11IdentityId id;
    protected final PublicKey publicKey;
    private final int signatureKeyBitLength;
    protected X509Certificate[] certificateChain;

    protected P11Identity(P11Slot slot, P11IdentityId id, int signatureBitLen) {
        this.slot = (P11Slot)Args.notNull((Object)slot, (String)"slot");
        this.id = (P11IdentityId)Args.notNull((Object)id, (String)"id");
        this.publicKey = null;
        this.signatureKeyBitLength = signatureBitLen;
    }

    protected P11Identity(P11Slot slot, P11IdentityId id, PublicKey publicKey, X509Certificate[] certificateChain) {
        this.slot = (P11Slot)Args.notNull((Object)slot, (String)"slot");
        this.id = (P11IdentityId)Args.notNull((Object)id, (String)"id");
        if (certificateChain != null && certificateChain.length > 0 && certificateChain[0] != null) {
            this.publicKey = certificateChain[0].getPublicKey();
            this.certificateChain = certificateChain;
        } else if (publicKey != null) {
            this.publicKey = publicKey;
            this.certificateChain = null;
        } else {
            throw new IllegalArgumentException("neither certificate nor publicKey is non-null");
        }
        if (this.publicKey instanceof RSAPublicKey) {
            this.signatureKeyBitLength = ((RSAPublicKey)this.publicKey).getModulus().bitLength();
        } else if (this.publicKey instanceof ECPublicKey) {
            this.signatureKeyBitLength = ((ECPublicKey)this.publicKey).getParams().getOrder().bitLength();
        } else if (this.publicKey instanceof DSAPublicKey) {
            this.signatureKeyBitLength = ((DSAPublicKey)this.publicKey).getParams().getQ().bitLength();
        } else if (this.publicKey instanceof EdDSAKey) {
            this.signatureKeyBitLength = 0;
        } else if (this.publicKey instanceof XDHKey) {
            this.signatureKeyBitLength = 0;
        } else {
            throw new IllegalArgumentException("currently only RSA, DSA, EC and Edwards public key are supported, but not " + this.publicKey.getAlgorithm() + " (class: " + this.publicKey.getClass().getName() + ")");
        }
    }

    public byte[] sign(long mechanism, P11Params parameters, byte[] content) throws P11TokenException {
        if (this.publicKey instanceof XDHKey) {
            throw new P11TokenException("this identity is not suitable for sign");
        }
        Args.notNull((Object)content, (String)"content");
        this.slot.assertMechanismSupported(mechanism);
        if (!this.supportsMechanism(mechanism, parameters)) {
            throw new P11UnsupportedMechanismException(mechanism, this.id);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sign with mechanism {}", (Object)Functions.getMechanismDescription((long)mechanism));
        }
        return this.sign0(mechanism, parameters, content);
    }

    protected abstract byte[] sign0(long var1, P11Params var3, byte[] var4) throws P11TokenException;

    public byte[] digestSecretKey(long mechanism) throws P11TokenException, XiSecurityException {
        this.slot.assertMechanismSupported(mechanism);
        if (LOG.isDebugEnabled()) {
            LOG.debug("digest secret with mechanism {}", (Object)Functions.getMechanismDescription((long)mechanism));
        }
        return this.digestSecretKey0(mechanism);
    }

    protected abstract byte[] digestSecretKey0(long var1) throws P11TokenException;

    public P11IdentityId getId() {
        return this.id;
    }

    public X509Certificate getCertificate() {
        return this.certificateChain != null && this.certificateChain.length > 0 ? this.certificateChain[0] : null;
    }

    public X509Certificate[] certificateChain() {
        return this.certificateChain == null ? null : Arrays.copyOf(this.certificateChain, this.certificateChain.length);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setCertificates(X509Certificate[] certificateChain) throws P11TokenException {
        if (CollectionUtil.isEmpty((Object[])certificateChain)) {
            this.certificateChain = null;
        } else {
            PublicKey pk = certificateChain[0].getPublicKey();
            if (!this.publicKey.equals(pk)) {
                throw new P11TokenException("certificateChain is not for the key");
            }
            this.certificateChain = certificateChain;
        }
    }

    public boolean match(P11IdentityId id) {
        return this.id.equals(id);
    }

    public boolean match(P11SlotIdentifier slotId, String keyLabel) {
        return this.id.match(slotId, keyLabel);
    }

    public int getSignatureKeyBitLength() {
        return this.signatureKeyBitLength;
    }

    @Override
    public int compareTo(P11Identity obj) {
        return this.id.compareTo(obj.id);
    }

    public boolean supportsMechanism(long mechanism, P11Params parameters) {
        if (this.publicKey == null && (545L == mechanism || 598L == mechanism || 593L == mechanism || 609L == mechanism || 625L == mechanism || 694L == mechanism || 689L == mechanism || 705L == mechanism || 721L == mechanism)) {
            return parameters == null;
        }
        if (this.publicKey instanceof RSAPublicKey) {
            if (2L == mechanism || 1L == mechanism || 6L == mechanism || 70L == mechanism || 64L == mechanism || 65L == mechanism || 66L == mechanism) {
                return parameters == null;
            }
            if (13L == mechanism || 14L == mechanism || 71L == mechanism || 67L == mechanism || 68L == mechanism || 69L == mechanism) {
                return parameters instanceof P11Params.P11RSAPkcsPssParams;
            }
            if (3L == mechanism) {
                return parameters == null;
            }
        } else if (this.publicKey instanceof DSAPublicKey) {
            if (parameters != null) {
                return false;
            }
            if (17L == mechanism || 18L == mechanism || 19L == mechanism || 20L == mechanism || 21L == mechanism || 22L == mechanism) {
                return true;
            }
        } else if (this.publicKey instanceof ECPublicKey) {
            if (4161L == mechanism || 4162L == mechanism || 4163L == mechanism || 4164L == mechanism || 4165L == mechanism || 4166L == mechanism || PKCS11Constants.CKM_VENDOR_SM2 == mechanism) {
                return parameters == null;
            }
            if (PKCS11Constants.CKM_VENDOR_SM2_SM3 == mechanism) {
                return parameters instanceof P11Params.P11ByteArrayParams;
            }
        } else if (this.publicKey instanceof EdDSAKey && 4183L == mechanism) {
            return true;
        }
        return false;
    }
}

