/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.util.Arrays;
import org.xipki.util.Args;
import org.xipki.util.Hex;

public class P11ObjectIdentifier
implements Comparable<P11ObjectIdentifier> {
    private final byte[] id;
    private final String idHex;
    private final String label;

    public P11ObjectIdentifier(byte[] id, String label) {
        this.id = (byte[])Args.notNull((Object)id, (String)"id");
        this.label = (String)Args.notNull((Object)label, (String)"label");
        this.idHex = Hex.encode((byte[])id);
    }

    public byte[] getId() {
        return this.id;
    }

    public boolean matchesId(byte[] id) {
        return Arrays.equals(id, this.id);
    }

    public String getIdHex() {
        return this.idHex;
    }

    public String getLabel() {
        return this.label;
    }

    public char[] getLabelChars() {
        return this.label.toCharArray();
    }

    public String toString() {
        return String.format("(id = %s, label = %s)", this.idHex, this.label);
    }

    public int hashCode() {
        int hashCode = new BigInteger(1, this.id).hashCode();
        return hashCode += 31 * this.label.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof P11ObjectIdentifier)) {
            return false;
        }
        P11ObjectIdentifier another = (P11ObjectIdentifier)obj;
        return Arrays.equals(this.id, another.id) && this.label.equals(another.label);
    }

    @Override
    public int compareTo(P11ObjectIdentifier obj) {
        Args.notNull((Object)obj, (String)"obj");
        if (this == obj) {
            return 0;
        }
        return this.label.compareTo(obj.label);
    }
}

