/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs12.HmacContentSigner;
import org.xipki.security.pkcs12.KeypairWithCert;
import org.xipki.util.Args;

public class P12XdhMacContentSignerBuilder {
    private SecretKey key;
    private AlgorithmIdentifier algId;
    private HashAlgo hash;
    private IssuerAndSerialNumber peerIssuerAndSerial;
    private final PublicKey publicKey;
    private final X509Certificate[] certificateChain;

    public P12XdhMacContentSignerBuilder(X509Certificate peerCert, PrivateKey privateKey, PublicKey publicKey) throws XiSecurityException {
        Args.notNull((Object)privateKey, (String)"privateKey");
        Args.notNull((Object)peerCert, (String)"peerCert");
        this.publicKey = (PublicKey)Args.notNull((Object)publicKey, (String)"publicKey");
        this.certificateChain = null;
        this.init(privateKey, peerCert);
    }

    public P12XdhMacContentSignerBuilder(KeypairWithCert keypairWithCert, X509Certificate peerCert) throws XiSecurityException {
        Args.notNull((Object)keypairWithCert, (String)"keypairWithCert");
        Args.notNull((Object)peerCert, (String)"peerCert");
        this.publicKey = keypairWithCert.getPublicKey();
        this.certificateChain = keypairWithCert.getCertificateChain();
        this.init(keypairWithCert.getKey(), peerCert);
    }

    private void init(PrivateKey privateKey, X509Certificate peerCert) throws XiSecurityException {
        byte[] zz;
        String algorithm = privateKey.getAlgorithm();
        if ("X25519".equalsIgnoreCase(algorithm)) {
            this.algId = new AlgorithmIdentifier(ObjectIdentifiers.Xipki.id_alg_dhPop_x25519_sha256);
            this.hash = HashAlgo.SHA256;
        } else if ("X448".equalsIgnoreCase(algorithm)) {
            this.algId = new AlgorithmIdentifier(ObjectIdentifiers.Xipki.id_alg_dhPop_x448_sha512);
            this.hash = HashAlgo.SHA512;
        } else {
            throw new IllegalArgumentException("unsupported key.getAlgorithm(): " + algorithm);
        }
        PublicKey peerPubKey = peerCert.getPublicKey();
        if (!algorithm.equalsIgnoreCase(peerPubKey.getAlgorithm())) {
            throw new IllegalArgumentException("peerCert and key does not match");
        }
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(algorithm, "BC");
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(peerPubKey, true);
            zz = keyAgreement.generateSecret();
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new XiSecurityException("KeyChange error", ex);
        }
        byte[] leadingInfo = peerCert.getSubjectX500Principal().getEncoded();
        byte[] trailingInfo = peerCert.getIssuerX500Principal().getEncoded();
        byte[] k = this.hash.hash(leadingInfo, zz, trailingInfo);
        this.key = new SecretKeySpec(k, "HMAC-" + this.hash.getName());
        this.peerIssuerAndSerial = new IssuerAndSerialNumber(X500Name.getInstance((Object)trailingInfo), peerCert.getSerialNumber());
    }

    public ConcurrentContentSigner createSigner(int parallelism) throws XiSecurityException {
        DfltConcurrentContentSigner concurrentSigner;
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            XdhMacContentSigner signer = new XdhMacContentSigner(this.hash, this.algId, this.key, this.peerIssuerAndSerial);
            signers.add(signer);
        }
        boolean mac = true;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(true, signers, this.key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        concurrentSigner.setSha1DigestOfMacKey(HashAlgo.SHA1.hash(new byte[][]{this.key.getEncoded()}));
        if (this.certificateChain != null) {
            concurrentSigner.setCertificateChain(this.certificateChain);
        } else {
            concurrentSigner.setPublicKey(this.publicKey);
        }
        return concurrentSigner;
    }

    private static class XdhMacContentSigner
    extends HmacContentSigner {
        private final byte[] prefix;
        private final int hashLen;

        private XdhMacContentSigner(HashAlgo hashAlgo, AlgorithmIdentifier algorithmIdentifier, SecretKey signingKey, IssuerAndSerialNumber peerIssuerAndSerial) throws XiSecurityException {
            super(hashAlgo, algorithmIdentifier, signingKey);
            byte[] encodedSig;
            this.hashLen = hashAlgo.getLength();
            ASN1EncodableVector vec = new ASN1EncodableVector();
            if (peerIssuerAndSerial != null) {
                vec.add((ASN1Encodable)peerIssuerAndSerial);
            }
            vec.add((ASN1Encodable)new DEROctetString(new byte[this.hashLen]));
            try {
                encodedSig = new DERSequence(vec).getEncoded();
            }
            catch (IOException ex) {
                throw new XiSecurityException("exception initializing ContentSigner: " + ex.getMessage(), ex);
            }
            this.prefix = Arrays.copyOfRange(encodedSig, 0, encodedSig.length - this.hashLen);
        }

        @Override
        public byte[] getSignature() {
            byte[] hashValue = super.getSignature();
            if (hashValue.length != this.hashLen) {
                throw new RuntimeOperatorException("exception obtaining signature: invalid signature length");
            }
            byte[] sigValue = new byte[this.prefix.length + this.hashLen];
            System.arraycopy(this.prefix, 0, sigValue, 0, this.prefix.length);
            System.arraycopy(hashValue, 0, sigValue, this.prefix.length, this.hashLen);
            return sigValue;
        }
    }
}

