/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.params.Ed448PublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.xipki.security.EdECConstants;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;

public class KeyUtil {
    private static final byte[] x25519Prefix = Hex.decode((String)"302a300506032b656e032100");
    private static final byte[] Ed25519Prefix = Hex.decode((String)"302a300506032b6570032100");
    private static final byte[] x448Prefix = Hex.decode((String)"3042300506032b656f033900");
    private static final byte[] Ed448Prefix = Hex.decode((String)"3043300506032b6571033a00");
    private static final Map<String, KeyFactory> KEY_FACTORIES = new HashMap<String, KeyFactory>();
    private static final Map<String, KeyPairGenerator> KEYPAIR_GENERATORS = new HashMap<String, KeyPairGenerator>();

    private KeyUtil() {
    }

    public static KeyStore getKeyStore(String storeType) throws KeyStoreException {
        Args.notBlank((String)storeType, (String)"storeType");
        if ("JKS".equalsIgnoreCase(storeType) || "JCEKS".equalsIgnoreCase(storeType)) {
            return KeyStore.getInstance(storeType);
        }
        try {
            return KeyStore.getInstance(storeType, "BC");
        }
        catch (KeyStoreException | NoSuchProviderException ex) {
            return KeyStore.getInstance(storeType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateRSAKeypair(int keysize, BigInteger publicExponent, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        BigInteger tmpPublicExponent = publicExponent;
        if (tmpPublicExponent == null) {
            tmpPublicExponent = RSAKeyGenParameterSpec.F4;
        }
        RSAKeyGenParameterSpec params = new RSAKeyGenParameterSpec(keysize, tmpPublicExponent);
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator("RSA");
        synchronized (keyPairGenerator) {
            if (random == null) {
                kpGen.initialize(params);
            } else {
                kpGen.initialize(params, random);
            }
            return kpGen.generateKeyPair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateDSAKeypair(int plength, int qlength, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        DSAParameterSpec dsaParamSpec = DSAParameterCache.getDSAParameterSpec(plength, qlength, random);
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator("DSA");
        synchronized (keyPairGenerator) {
            kpGen.initialize(dsaParamSpec, random);
            return kpGen.generateKeyPair();
        }
    }

    public static KeyPair generateDSAKeypair(DSAParameters dsaParams, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        DSAParameterSpec dsaParamSpec = new DSAParameterSpec(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
        return KeyUtil.generateDSAKeypair(dsaParamSpec, random);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateDSAKeypair(DSAParameterSpec dsaParamSpec, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator("DSA");
        synchronized (keyPairGenerator) {
            kpGen.initialize(dsaParamSpec, random);
            return kpGen.generateKeyPair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSAPublicKey generateDSAPublicKey(DSAPublicKeySpec keySpec) throws InvalidKeySpecException {
        KeyFactory kf;
        Args.notNull((Object)keySpec, (String)"keySpec");
        KeyFactory keyFactory = kf = KeyUtil.getKeyFactory("DSA");
        synchronized (keyFactory) {
            return (DSAPublicKey)kf.generatePublic(keySpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateEdECKeypair(ASN1ObjectIdentifier curveId, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        Args.notNull((Object)curveId, (String)"curveId");
        String algorithm = EdECConstants.getName(curveId);
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator(algorithm);
        synchronized (keyPairGenerator) {
            if (random != null) {
                kpGen.initialize(EdECConstants.getKeyBitSize(curveId), random);
            }
            return kpGen.generateKeyPair();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPair generateECKeypair(ASN1ObjectIdentifier curveId, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator kpGen;
        Args.notNull((Object)curveId, (String)"curveId");
        ECGenParameterSpec spec = new ECGenParameterSpec(curveId.getId());
        KeyPairGenerator keyPairGenerator = kpGen = KeyUtil.getKeyPairGenerator("EC");
        synchronized (keyPairGenerator) {
            if (random == null) {
                kpGen.initialize(spec);
            } else {
                kpGen.initialize(spec, random);
            }
            return kpGen.generateKeyPair();
        }
    }

    public static PrivateKey convertXDHToDummyEdDSAPrivateKey(PrivateKey key) throws InvalidKeySpecException {
        if (key instanceof XDHKey && key instanceof PrivateKey) {
            PrivateKeyInfo xdhPki = PrivateKeyInfo.getInstance((Object)key.getEncoded());
            String xdhAlgo = key.getAlgorithm();
            try {
                PrivateKeyInfo edPki;
                if (xdhAlgo.equalsIgnoreCase("X25519")) {
                    edPki = new PrivateKeyInfo(new AlgorithmIdentifier(EdECConstants.id_Ed25519), xdhPki.parsePrivateKey());
                } else if (xdhAlgo.equalsIgnoreCase("X448")) {
                    byte[] x448Octets = ASN1OctetString.getInstance((Object)xdhPki.parsePrivateKey()).getOctets();
                    byte[] ed448Octets = new byte[57];
                    System.arraycopy(x448Octets, 0, ed448Octets, 0, 56);
                    edPki = new PrivateKeyInfo(new AlgorithmIdentifier(EdECConstants.id_Ed448), (ASN1Encodable)new DEROctetString(ed448Octets));
                } else {
                    throw new IllegalArgumentException("unknown key algorithm " + xdhAlgo);
                }
                byte[] encoded = edPki.getEncoded();
                return KeyUtil.getKeyFactory("EDDSA").generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            catch (IOException ex) {
                throw new InvalidKeySpecException("could not convert XDH to EdDSA private key", ex);
            }
        }
        throw new IllegalArgumentException("key is not an XDH private key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyFactory getKeyFactory(String algorithm) throws InvalidKeySpecException {
        String alg = algorithm.toUpperCase();
        if ("ECDSA".equals(alg)) {
            alg = "EC";
        }
        Map<String, KeyFactory> map = KEY_FACTORIES;
        synchronized (map) {
            KeyFactory kf = KEY_FACTORIES.get(algorithm);
            if (kf != null) {
                return kf;
            }
            try {
                kf = KeyFactory.getInstance(algorithm, "BC");
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
                throw new InvalidKeySpecException("could not find KeyFactory for " + algorithm + ": " + ex.getMessage());
            }
            KEY_FACTORIES.put(algorithm, kf);
            return kf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyPairGenerator getKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        String alg = algorithm.toUpperCase();
        if ("ECDSA".equals(alg)) {
            alg = "EC";
        }
        Map<String, KeyPairGenerator> map = KEYPAIR_GENERATORS;
        synchronized (map) {
            KeyPairGenerator kg = KEYPAIR_GENERATORS.get(algorithm);
            if (kg != null) {
                return kg;
            }
            kg = KeyPairGenerator.getInstance(algorithm, "BC");
            KEYPAIR_GENERATORS.put(algorithm, kg);
            return kg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey generatePublicKey(SubjectPublicKeyInfo pkInfo) throws InvalidKeySpecException {
        KeyFactory kf;
        X509EncodedKeySpec keyspec;
        Args.notNull((Object)pkInfo, (String)"pkInfo");
        try {
            keyspec = new X509EncodedKeySpec(pkInfo.getEncoded());
        }
        catch (IOException ex) {
            throw new InvalidKeySpecException(ex.getMessage(), ex);
        }
        ASN1ObjectIdentifier aid = pkInfo.getAlgorithm().getAlgorithm();
        String algorithm = PKCSObjectIdentifiers.rsaEncryption.equals((Object)aid) ? "RSA" : (X9ObjectIdentifiers.id_dsa.equals((Object)aid) ? "DSA" : (X9ObjectIdentifiers.id_ecPublicKey.equals((Object)aid) ? "EC" : EdECConstants.getName(pkInfo.getAlgorithm().getAlgorithm())));
        if (algorithm == null) {
            throw new InvalidKeySpecException("unsupported key algorithm: " + aid);
        }
        KeyFactory keyFactory = kf = KeyUtil.getKeyFactory(algorithm);
        synchronized (keyFactory) {
            return kf.generatePublic(keyspec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.security.interfaces.RSAPublicKey generateRSAPublicKey(RSAPublicKeySpec keySpec) throws InvalidKeySpecException {
        KeyFactory kf;
        Args.notNull((Object)keySpec, (String)"keySpec");
        KeyFactory keyFactory = kf = KeyUtil.getKeyFactory("RSA");
        synchronized (keyFactory) {
            return (java.security.interfaces.RSAPublicKey)kf.generatePublic(keySpec);
        }
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        Args.notNull((Object)key, (String)"key");
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeyParameters(rsaKey.getModulus(), rsaKey.getPublicExponent(), rsaKey.getPrivateExponent(), rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getPrimeExponentP(), rsaKey.getPrimeExponentQ(), rsaKey.getCrtCoefficient());
        }
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rsaKey = (RSAPrivateKey)key;
            return new RSAKeyParameters(true, rsaKey.getModulus(), rsaKey.getPrivateExponent());
        }
        if (key instanceof ECPrivateKey) {
            return ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        }
        if (key instanceof DSAPrivateKey) {
            return DSAUtil.generatePrivateKeyParameter((PrivateKey)key);
        }
        if (key instanceof XDHKey || key instanceof EdDSAKey) {
            try {
                return PrivateKeyFactory.createKey((byte[])key.getEncoded());
            }
            catch (IOException ex) {
                throw new InvalidKeyException("exception creating key: " + ex.getMessage(), ex);
            }
        }
        throw new InvalidKeyException("unknown key " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        Args.notNull((Object)key, (String)"key");
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rsaKey = (java.security.interfaces.RSAPublicKey)key;
            return new RSAKeyParameters(false, rsaKey.getModulus(), rsaKey.getPublicExponent());
        }
        if (key instanceof ECPublicKey) {
            return ECUtil.generatePublicKeyParameter((PublicKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return DSAUtil.generatePublicKeyParameter((PublicKey)key);
        }
        if (key instanceof XDHKey || key instanceof EdDSAKey) {
            byte[] encoded = key.getEncoded();
            String algorithm = key.getAlgorithm();
            if ("X25519".equalsIgnoreCase(algorithm)) {
                return new X25519PublicKeyParameters(encoded, encoded.length - 32);
            }
            if ("Ed25519".equalsIgnoreCase(algorithm)) {
                return new Ed25519PublicKeyParameters(encoded, encoded.length - 32);
            }
            if ("X448".equalsIgnoreCase(algorithm)) {
                return new X448PublicKeyParameters(encoded, encoded.length - 56);
            }
            if ("Ed448".equalsIgnoreCase(algorithm)) {
                return new Ed448PublicKeyParameters(encoded, encoded.length - 57);
            }
            throw new InvalidKeyException("unknown Edwards key " + algorithm);
        }
        throw new InvalidKeyException("unknown key " + key.getClass().getName());
    }

    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(PublicKey publicKey) throws InvalidKeyException {
        Args.notNull((Object)publicKey, (String)"publicKey");
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPubKey = (DSAPublicKey)publicKey;
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1Integer(dsaPubKey.getParams().getP()));
            vec.add((ASN1Encodable)new ASN1Integer(dsaPubKey.getParams().getQ()));
            vec.add((ASN1Encodable)new ASN1Integer(dsaPubKey.getParams().getG()));
            DERSequence dssParams = new DERSequence(vec);
            try {
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)dssParams), (ASN1Encodable)new ASN1Integer(dsaPubKey.getY()));
            }
            catch (IOException ex) {
                throw new InvalidKeyException(ex.getMessage(), ex);
            }
        }
        if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rsaPubKey = (java.security.interfaces.RSAPublicKey)publicKey;
            try {
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)new RSAPublicKey(rsaPubKey.getModulus(), rsaPubKey.getPublicExponent()));
            }
            catch (IOException ex) {
                throw new InvalidKeyException(ex.getMessage(), ex);
            }
        }
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPubKey = (ECPublicKey)publicKey;
            ECParameterSpec paramSpec = ecPubKey.getParams();
            ASN1ObjectIdentifier curveOid = KeyUtil.detectCurveOid(paramSpec);
            if (curveOid == null) {
                throw new InvalidKeyException("Cannot find namedCurve of the given private key");
            }
            ECPoint pointW = ecPubKey.getW();
            BigInteger wx = pointW.getAffineX();
            if (wx.signum() != 1) {
                throw new InvalidKeyException("Wx is not positive");
            }
            BigInteger wy = pointW.getAffineY();
            if (wy.signum() != 1) {
                throw new InvalidKeyException("Wy is not positive");
            }
            int keysize = (paramSpec.getOrder().bitLength() + 7) / 8;
            byte[] wxBytes = BigIntegers.asUnsignedByteArray((int)keysize, (BigInteger)wx);
            byte[] wyBytes = BigIntegers.asUnsignedByteArray((int)keysize, (BigInteger)wy);
            byte[] pubKey = new byte[1 + keysize * 2];
            pubKey[0] = 4;
            System.arraycopy(wxBytes, 0, pubKey, 1, keysize);
            System.arraycopy(wyBytes, 0, pubKey, 1 + keysize, keysize);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid);
            return new SubjectPublicKeyInfo(algId, pubKey);
        }
        if (publicKey instanceof XDHKey || publicKey instanceof EdDSAKey) {
            byte[] prefix;
            int keysize;
            ASN1ObjectIdentifier algOid;
            String algorithm = publicKey.getAlgorithm();
            byte[] encoded = publicKey.getEncoded();
            if ("Ed25519".equalsIgnoreCase(algorithm)) {
                algOid = EdECConstants.id_Ed25519;
                keysize = 32;
                prefix = Ed25519Prefix;
            } else if ("X25519".equalsIgnoreCase(algorithm)) {
                algOid = EdECConstants.id_X25519;
                keysize = 32;
                prefix = x25519Prefix;
            } else if ("Ed448".equalsIgnoreCase(algorithm)) {
                algOid = EdECConstants.id_Ed448;
                keysize = 57;
                prefix = Ed448Prefix;
            } else if ("X448".equalsIgnoreCase(algorithm)) {
                algOid = EdECConstants.id_X448;
                keysize = 56;
                prefix = x448Prefix;
            } else {
                throw new IllegalArgumentException("invalid algorithm " + algorithm);
            }
            if (encoded.length != prefix.length + keysize) {
                throw new IllegalArgumentException("invalid encoded PublicKey");
            }
            if (!CompareUtil.areEqual((byte[])encoded, (int)0, (byte[])prefix, (int)0, (int)prefix.length)) {
                throw new IllegalArgumentException("invalid encoded PublicKey");
            }
            byte[] keyData = Arrays.copyOfRange(encoded, prefix.length, prefix.length + keysize);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(algOid);
            return new SubjectPublicKeyInfo(algId, keyData);
        }
        throw new InvalidKeyException("unknown publicKey class " + publicKey.getClass().getName());
    }

    public static ECPublicKey createECPublicKey(byte[] encodedAlgorithmIdParameters, byte[] encodedPoint) throws InvalidKeySpecException {
        KeyFactory kf;
        X509EncodedKeySpec keySpec;
        Args.notNull((Object)encodedAlgorithmIdParameters, (String)"encodedAlgorithmIdParameters");
        Args.notNull((Object)encodedPoint, (String)"encodedPoint");
        Object algParams = encodedAlgorithmIdParameters[0] == 6 ? ASN1ObjectIdentifier.getInstance((Object)encodedAlgorithmIdParameters) : X962Parameters.getInstance((Object)encodedAlgorithmIdParameters);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)algParams);
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(algId, encodedPoint);
        try {
            keySpec = new X509EncodedKeySpec(spki.getEncoded());
        }
        catch (IOException ex) {
            throw new InvalidKeySpecException(ex.getMessage(), ex);
        }
        try {
            kf = KeyFactory.getInstance("EC", "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new InvalidKeySpecException(ex.getMessage(), ex);
        }
        return (ECPublicKey)kf.generatePublic(keySpec);
    }

    private static ASN1ObjectIdentifier detectCurveOid(ECParameterSpec paramSpec) {
        org.bouncycastle.jce.spec.ECParameterSpec bcParamSpec = EC5Util.convertSpec((ECParameterSpec)paramSpec, (boolean)false);
        return ECUtil.getNamedCurveOid((org.bouncycastle.jce.spec.ECParameterSpec)bcParamSpec);
    }

    public static byte[] getUncompressedEncodedECPoint(ECPoint point, int orderBitLength) {
        int orderByteLength = (orderBitLength + 7) / 8;
        byte[] keyData = new byte[1 + orderByteLength * 2];
        keyData[0] = 4;
        KeyUtil.unsignedByteArrayCopy(keyData, 1, orderByteLength, point.getAffineX());
        KeyUtil.unsignedByteArrayCopy(keyData, 1 + orderByteLength, orderByteLength, point.getAffineY());
        return keyData;
    }

    private static void unsignedByteArrayCopy(byte[] dest, int destPos, int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, dest, destPos, length);
        } else {
            int start = bytes[0] == 0 ? 1 : 0;
            int count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, dest, destPos + length - count, count);
        }
    }
}

