/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.security.HashAlgo;
import org.xipki.security.HashCalculator;
import org.xipki.util.Args;

public class IssuerHash {
    private final HashAlgo hashAlgo;
    private final byte[] issuerNameHash;
    private final byte[] issuerKeyHash;

    public IssuerHash(HashAlgo hashAlgo, byte[] issuerNameHash, byte[] issuerKeyHash) {
        this.hashAlgo = (HashAlgo)((Object)Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo"));
        this.issuerNameHash = (byte[])Args.notNull((Object)issuerNameHash, (String)"issuerNameHash");
        this.issuerKeyHash = (byte[])Args.notNull((Object)issuerKeyHash, (String)"issuerKeyHash");
        int len = hashAlgo.getLength();
        Args.range((int)issuerNameHash.length, (String)"issuerNameHash.length", (int)len, (int)len);
        Args.range((int)issuerKeyHash.length, (String)"issuerKeyHash.length", (int)len, (int)len);
    }

    public IssuerHash(HashAlgo hashAlgo, Certificate issuerCert) throws IOException {
        this.hashAlgo = (HashAlgo)((Object)Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo"));
        Args.notNull((Object)issuerCert, (String)"issuerCert");
        byte[] encodedName = issuerCert.getSubject().getEncoded();
        byte[] encodedKey = issuerCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
        this.issuerNameHash = HashCalculator.hash(hashAlgo, new byte[][]{encodedName});
        this.issuerKeyHash = HashCalculator.hash(hashAlgo, new byte[][]{encodedKey});
    }

    public HashAlgo getHashAlgo() {
        return this.hashAlgo;
    }

    public byte[] getIssuerNameHash() {
        return Arrays.copyOf(this.issuerNameHash, this.issuerNameHash.length);
    }

    public byte[] getIssuerKeyHash() {
        return Arrays.copyOf(this.issuerKeyHash, this.issuerKeyHash.length);
    }

    public boolean match(HashAlgo hashAlgo, byte[] issuerNameHash, byte[] issuerKeyHash) {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        Args.notNull((Object)issuerNameHash, (String)"issuerNameHash");
        Args.notNull((Object)issuerKeyHash, (String)"issuerKeyHash");
        return this.hashAlgo == hashAlgo && Arrays.equals(this.issuerNameHash, issuerNameHash) && Arrays.equals(this.issuerKeyHash, issuerKeyHash);
    }
}

