/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.bc;

import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcECContentVerifierProviderBuilder;
import org.xipki.security.DSAPlainDigestSigner;
import org.xipki.security.util.AlgorithmUtil;

public class XiECContentVerifierProviderBuilder
extends BcECContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public XiECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        super(digestAlgorithmFinder);
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        boolean plainDsa = AlgorithmUtil.isPlainECDSASigAlg(sigAlgId);
        if (plainDsa) {
            AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
            ExtendedDigest dig = this.digestProvider.get(digAlg);
            return new DSAPlainDigestSigner((DSA)new ECDSASigner(), (Digest)dig);
        }
        boolean sm2 = AlgorithmUtil.isSM2SigAlg(sigAlgId);
        if (sm2) {
            AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
            if (GMObjectIdentifiers.sm3.equals((Object)digAlg.getAlgorithm())) {
                return new SM2Signer();
            }
            throw new OperatorCreationException("cannot create SM2 signer for hash algorithm " + digAlg.getAlgorithm().getId());
        }
        return super.createSigner(sigAlgId);
    }
}

