/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.bc;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.crmf.DhSigStatic;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.util.Args;

public class XiXDHContentVerifierProvider
implements ContentVerifierProvider {
    private final SecretKey hmacKey;
    private final String hmacAlgoithm;
    private final ASN1ObjectIdentifier sigAlgOid;

    public XiXDHContentVerifierProvider(PublicKey verifyKey, DHSigStaticKeyCertPair ownerKeyAndCert) throws InvalidKeyException {
        byte[] zz;
        HashAlgo hash;
        Args.notNull((Object)verifyKey, (String)"verifyKey");
        Args.notNull((Object)ownerKeyAndCert, (String)"ownerKeyAndCert");
        String keyAlgName = verifyKey.getAlgorithm();
        if ("X25519".equalsIgnoreCase(keyAlgName)) {
            this.sigAlgOid = ObjectIdentifiers.Xipki.id_alg_dhPop_x25519_sha256;
            this.hmacAlgoithm = "HMAC-SHA256";
            hash = HashAlgo.SHA256;
        } else if ("X448".equalsIgnoreCase(keyAlgName)) {
            this.sigAlgOid = ObjectIdentifiers.Xipki.id_alg_dhPop_x448_sha512;
            this.hmacAlgoithm = "HMAC-SHA512";
            hash = HashAlgo.SHA512;
        } else {
            throw new InvalidKeyException("unsupported verifyKey.getAlgorithm(): " + keyAlgName);
        }
        if (!keyAlgName.equals(ownerKeyAndCert.getPrivateKey().getAlgorithm())) {
            throw new InvalidKeyException("verifyKey and ownerKeyAndCert does not match");
        }
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(keyAlgName, "BC");
            keyAgreement.init(ownerKeyAndCert.getPrivateKey());
            keyAgreement.doPhase(verifyKey, true);
            zz = keyAgreement.generateSecret();
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new InvalidKeyException("KeyChange error", ex);
        }
        byte[] leadingInfo = ownerKeyAndCert.getEncodedSubject();
        byte[] trailingInfo = ownerKeyAndCert.getEncodedIssuer();
        byte[] k = hash.hash(leadingInfo, zz, trailingInfo);
        this.hmacKey = new SecretKeySpec(k, this.hmacAlgoithm);
    }

    public boolean hasAssociatedCertificate() {
        return false;
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return null;
    }

    public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
        Mac hmac;
        ASN1ObjectIdentifier oid = verifierAlgorithmIdentifier.getAlgorithm();
        if (!this.sigAlgOid.equals((Object)oid)) {
            throw new OperatorCreationException("given public key is not suitable for the alogithm " + oid.getId());
        }
        try {
            hmac = Mac.getInstance(this.hmacAlgoithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new OperatorCreationException(ex.getMessage());
        }
        return new XDHContentVerifier(verifierAlgorithmIdentifier, hmac, this.hmacKey);
    }

    private static class XDHContentVerifier
    implements ContentVerifier {
        private final AlgorithmIdentifier algId;
        private final HmacOutputStream outputStream;
        private final Mac hmac;
        private final SecretKey macKey;

        private XDHContentVerifier(AlgorithmIdentifier algId, Mac hmac, SecretKey macKey) {
            this.algId = algId;
            this.hmac = hmac;
            this.macKey = macKey;
            this.outputStream = new HmacOutputStream();
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algId;
        }

        public OutputStream getOutputStream() {
            try {
                this.hmac.init(this.macKey);
            }
            catch (InvalidKeyException ex) {
                throw new RuntimeCryptoException("could not init MAC: " + ex.getMessage());
            }
            return this.outputStream;
        }

        public boolean verify(byte[] expected) {
            DhSigStatic dhsig = DhSigStatic.getInstance((Object)expected);
            byte[] expectedHashValue = dhsig.getHashValue();
            byte[] hashValue = this.hmac.doFinal();
            return Arrays.equals(expectedHashValue, hashValue);
        }

        private class HmacOutputStream
        extends OutputStream {
            private HmacOutputStream() {
            }

            @Override
            public void write(int bb) throws IOException {
                XDHContentVerifier.this.hmac.update((byte)bb);
            }

            @Override
            public void write(byte[] bytes) throws IOException {
                XDHContentVerifier.this.hmac.update(bytes, 0, bytes.length);
            }

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                XDHContentVerifier.this.hmac.update(bytes, off, len);
            }
        }
    }
}

