/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.macs.GMac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.emulator.SM2Signer;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.Args;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

public class EmulatorP11Identity
extends P11Identity {
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorP11Identity.class);
    private final Key signingKey;
    private final ConcurrentBag<ConcurrentBagEntry<Cipher>> rsaCiphers;
    private final ConcurrentBag<ConcurrentBagEntry<Signature>> dsaSignatures;
    private final ConcurrentBag<ConcurrentBagEntry<Signature>> eddsaSignatures;
    private final ConcurrentBag<ConcurrentBagEntry<SM2Signer>> sm2Signers;
    private final SecureRandom random;

    public EmulatorP11Identity(P11Slot slot, P11IdentityId identityId, SecretKey signingKey, int maxSessions, SecureRandom random) {
        super(slot, identityId, 0);
        this.rsaCiphers = new ConcurrentBag();
        this.dsaSignatures = new ConcurrentBag();
        this.eddsaSignatures = new ConcurrentBag();
        this.sm2Signers = new ConcurrentBag();
        this.signingKey = (Key)Args.notNull((Object)signingKey, (String)"signingKey");
        this.random = (SecureRandom)Args.notNull((Object)random, (String)"random");
    }

    public EmulatorP11Identity(P11Slot slot, P11IdentityId identityId, PrivateKey privateKey, PublicKey publicKey, X509Certificate[] certificateChain, int maxSessions, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        block18: {
            int i;
            block20: {
                String algorithm;
                block19: {
                    block17: {
                        super(slot, identityId, publicKey, certificateChain);
                        this.rsaCiphers = new ConcurrentBag();
                        this.dsaSignatures = new ConcurrentBag();
                        this.eddsaSignatures = new ConcurrentBag();
                        this.sm2Signers = new ConcurrentBag();
                        this.signingKey = (Key)Args.notNull((Object)privateKey, (String)"privateKey");
                        this.random = (SecureRandom)Args.notNull((Object)random, (String)"random");
                        if (!(this.publicKey instanceof RSAPublicKey)) break block17;
                        String providerName = "BC";
                        LOG.info("use provider {}", (Object)providerName);
                        for (int i2 = 0; i2 < maxSessions; ++i2) {
                            Cipher rsaCipher;
                            try {
                                String algo = "RSA/ECB/NoPadding";
                                rsaCipher = Cipher.getInstance("RSA/ECB/NoPadding", providerName);
                                LOG.info("use cipher algorithm {}", (Object)"RSA/ECB/NoPadding");
                            }
                            catch (NoSuchPaddingException ex) {
                                throw new NoSuchAlgorithmException("NoSuchPadding", ex);
                            }
                            catch (NoSuchAlgorithmException ex) {
                                String algo = "RSA/NONE/NoPadding";
                                try {
                                    rsaCipher = Cipher.getInstance("RSA/NONE/NoPadding", providerName);
                                    LOG.info("use cipher algorithm {}", (Object)"RSA/NONE/NoPadding");
                                }
                                catch (NoSuchPaddingException e1) {
                                    throw new NoSuchAlgorithmException("NoSuchPadding", ex);
                                }
                            }
                            rsaCipher.init(1, privateKey);
                            this.rsaCiphers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)rsaCipher));
                        }
                        break block18;
                    }
                    if (this.publicKey instanceof ECPublicKey) {
                        boolean sm2curve = GMUtil.isSm2primev2Curve(((ECPublicKey)this.publicKey).getParams().getCurve());
                        algorithm = sm2curve ? null : "NONEwithECDSA";
                    } else if (this.publicKey instanceof DSAPublicKey) {
                        algorithm = "NONEwithDSA";
                    } else if (this.publicKey instanceof EdDSAKey) {
                        algorithm = null;
                    } else if (this.publicKey instanceof XDHKey) {
                        algorithm = null;
                    } else {
                        throw new IllegalArgumentException("Currently only RSA, DSA, EC, EC Edwards and EC Montgomery public key are supported, but not " + this.publicKey.getAlgorithm() + " (class: " + this.publicKey.getClass().getName() + ")");
                    }
                    if (algorithm == null) break block19;
                    for (i = 0; i < maxSessions; ++i) {
                        Signature dsaSignature = Signature.getInstance(algorithm, "BC");
                        dsaSignature.initSign(privateKey, random);
                        this.dsaSignatures.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)dsaSignature));
                    }
                    break block18;
                }
                if (!(this.publicKey instanceof EdDSAKey)) break block20;
                algorithm = this.publicKey.getAlgorithm();
                for (i = 0; i < maxSessions; ++i) {
                    Signature signature = Signature.getInstance(algorithm, "BC");
                    signature.initSign(privateKey);
                    this.eddsaSignatures.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)signature));
                }
                break block18;
            }
            if (this.publicKey instanceof XDHKey) break block18;
            for (i = 0; i < maxSessions; ++i) {
                SM2Signer sm2signer = new SM2Signer((CipherParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey));
                this.sm2Signers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)sm2signer));
            }
        }
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws P11TokenException {
        if (!(this.signingKey instanceof SecretKey)) {
            throw new P11TokenException("digestSecretKey could not be applied to non-SecretKey");
        }
        HashAlgo hashAlgo = EmulatorP11Identity.getHashAlgoForPkcs11HashMech(mechanism);
        if (hashAlgo == null) {
            throw new P11TokenException("unknown mechanism " + Functions.mechanismCodeToString((long)mechanism));
        }
        return hashAlgo.hash(new byte[][]{((SecretKey)this.signingKey).getEncoded()});
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws P11TokenException {
        if (4161L == mechanism) {
            return this.dsaAndEcdsaSign(content, null);
        }
        if (4162L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA1);
        }
        if (4163L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA224);
        }
        if (4164L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA256);
        }
        if (4165L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA384);
        }
        if (4166L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA512);
        }
        if (4167L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA3_224);
        }
        if (4168L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA3_256);
        }
        if (4169L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA3_384);
        }
        if (4170L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA3_512);
        }
        if (4183L == mechanism) {
            return this.eddsaSign(content);
        }
        if (PKCS11Constants.CKM_VENDOR_SM2 == mechanism) {
            return this.sm2SignHash(content);
        }
        if (PKCS11Constants.CKM_VENDOR_SM2_SM3 == mechanism) {
            return this.sm2Sign(parameters, content, HashAlgo.SM3);
        }
        if (17L == mechanism) {
            return this.dsaAndEcdsaSign(content, null);
        }
        if (18L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA1);
        }
        if (19L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA224);
        }
        if (20L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA256);
        }
        if (21L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA384);
        }
        if (22L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA512);
        }
        if (24L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA3_224);
        }
        if (25L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA3_256);
        }
        if (26L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA3_384);
        }
        if (27L == mechanism) {
            return this.dsaAndEcdsaSign(content, HashAlgo.SHA3_512);
        }
        if (3L == mechanism) {
            return this.rsaX509Sign(content);
        }
        if (1L == mechanism) {
            return this.rsaPkcsSign(content, null);
        }
        if (6L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA1);
        }
        if (70L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA224);
        }
        if (64L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA256);
        }
        if (65L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA384);
        }
        if (66L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA512);
        }
        if (102L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA3_224);
        }
        if (96L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA3_256);
        }
        if (97L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA3_384);
        }
        if (98L == mechanism) {
            return this.rsaPkcsSign(content, HashAlgo.SHA3_512);
        }
        if (13L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, null);
        }
        if (14L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA1);
        }
        if (71L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA224);
        }
        if (67L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA256);
        }
        if (68L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA384);
        }
        if (69L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA512);
        }
        if (103L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA3_224);
        }
        if (99L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA3_256);
        }
        if (100L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA3_384);
        }
        if (101L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, HashAlgo.SHA3_512);
        }
        if (545L == mechanism) {
            return this.hmac(content, HashAlgo.SHA1);
        }
        if (598L == mechanism) {
            return this.hmac(content, HashAlgo.SHA224);
        }
        if (593L == mechanism) {
            return this.hmac(content, HashAlgo.SHA256);
        }
        if (609L == mechanism) {
            return this.hmac(content, HashAlgo.SHA384);
        }
        if (625L == mechanism) {
            return this.hmac(content, HashAlgo.SHA512);
        }
        if (694L == mechanism) {
            return this.hmac(content, HashAlgo.SHA3_224);
        }
        if (689L == mechanism) {
            return this.hmac(content, HashAlgo.SHA3_256);
        }
        if (705L == mechanism) {
            return this.hmac(content, HashAlgo.SHA3_384);
        }
        if (721L == mechanism) {
            return this.hmac(content, HashAlgo.SHA3_512);
        }
        if (4238L == mechanism) {
            return this.aesGmac(parameters, content);
        }
        throw new P11TokenException("unsupported mechanism " + mechanism);
    }

    private byte[] hmac(byte[] contentToSign, HashAlgo hashAlgo) {
        HMac hmac = new HMac(hashAlgo.createDigest());
        hmac.init((CipherParameters)new KeyParameter(this.signingKey.getEncoded()));
        hmac.update(contentToSign, 0, contentToSign.length);
        byte[] signature = new byte[hmac.getMacSize()];
        hmac.doFinal(signature, 0);
        return signature;
    }

    private byte[] aesGmac(P11Params params, byte[] contentToSign) throws P11TokenException {
        if (params == null) {
            throw new P11TokenException("iv may not be null");
        }
        if (!(params instanceof P11Params.P11IVParams)) {
            throw new P11TokenException("params must be instanceof P11IVParams");
        }
        byte[] iv = ((P11Params.P11IVParams)params).getIV();
        GMac gmac = new GMac(new GCMBlockCipher((BlockCipher)new AESEngine()));
        ParametersWithIV paramsWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(this.signingKey.getEncoded()), iv);
        gmac.init((CipherParameters)paramsWithIv);
        gmac.update(contentToSign, 0, contentToSign.length);
        byte[] signature = new byte[gmac.getMacSize()];
        gmac.doFinal(signature, 0);
        return signature;
    }

    private byte[] rsaPkcsPssSign(P11Params parameters, byte[] contentToSign, HashAlgo hashAlgo) throws P11TokenException {
        byte[] encodedHashValue;
        if (!(parameters instanceof P11Params.P11RSAPkcsPssParams)) {
            throw new P11TokenException("the parameters is not of " + P11Params.P11RSAPkcsPssParams.class.getName());
        }
        P11Params.P11RSAPkcsPssParams pssParam = (P11Params.P11RSAPkcsPssParams)parameters;
        HashAlgo contentHash = EmulatorP11Identity.getHashAlgoForPkcs11HashMech(pssParam.getHashAlgorithm());
        if (contentHash == null) {
            throw new P11TokenException("unsupported HashAlgorithm " + pssParam.getHashAlgorithm());
        }
        if (hashAlgo != null && contentHash != hashAlgo) {
            throw new P11TokenException("Invalid parameters: invalid hash algorithm");
        }
        HashAlgo mgfHash = EmulatorP11Identity.getHashAlgoForPkcs11MgfMech(pssParam.getMaskGenerationFunction());
        if (mgfHash == null) {
            throw new P11TokenException("unsupported MaskGenerationFunction " + pssParam.getHashAlgorithm());
        }
        byte[] hashValue = hashAlgo == null ? contentToSign : hashAlgo.hash(new byte[][]{contentToSign});
        try {
            encodedHashValue = SignerUtil.EMSA_PSS_ENCODE(contentHash, hashValue, mgfHash, (int)pssParam.getSaltLength(), this.getSignatureKeyBitLength(), this.random);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        return this.rsaX509Sign(encodedHashValue);
    }

    private byte[] rsaPkcsSign(byte[] contentToSign, HashAlgo hashAlgo) throws P11TokenException {
        byte[] paddedHash;
        int modulusBitLen = this.getSignatureKeyBitLength();
        try {
            if (hashAlgo == null) {
                paddedHash = SignerUtil.EMSA_PKCS1_v1_5_encoding(contentToSign, modulusBitLen);
            } else {
                byte[] hash = hashAlgo.hash(new byte[][]{contentToSign});
                paddedHash = SignerUtil.EMSA_PKCS1_v1_5_encoding(hash, modulusBitLen, hashAlgo);
            }
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        return this.rsaX509Sign(paddedHash);
    }

    private byte[] rsaX509Sign(byte[] dataToSign) throws P11TokenException {
        ConcurrentBagEntry cipher;
        try {
            cipher = (ConcurrentBagEntry)this.rsaCiphers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("could not take any idle signer");
        }
        if (cipher == null) {
            throw new P11TokenException("no idle RSA cipher available");
        }
        try {
            byte[] ex = ((Cipher)cipher.value()).doFinal(dataToSign);
            return ex;
        }
        catch (BadPaddingException ex) {
            throw new P11TokenException("BadPaddingException: " + ex.getMessage(), ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new P11TokenException("IllegalBlockSizeException: " + ex.getMessage(), ex);
        }
        finally {
            this.rsaCiphers.requite((ConcurrentBag.IConcurrentBagEntry)cipher);
        }
    }

    private byte[] dsaAndEcdsaSign(byte[] dataToSign, HashAlgo hashAlgo) throws P11TokenException {
        ConcurrentBagEntry sig0;
        byte[] hash = hashAlgo == null ? dataToSign : hashAlgo.hash(new byte[][]{dataToSign});
        try {
            sig0 = (ConcurrentBagEntry)this.dsaSignatures.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle DSA Signature available");
        }
        try {
            Signature sig = (Signature)sig0.value();
            sig.update(hash);
            byte[] x962Signature = sig.sign();
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.getSignatureKeyBitLength());
            return byArray;
        }
        catch (SignatureException ex) {
            throw new P11TokenException("SignatureException: " + ex.getMessage(), ex);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        finally {
            this.dsaSignatures.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    private byte[] eddsaSign(byte[] dataToSign) throws P11TokenException {
        ConcurrentBagEntry sig0;
        if (!(this.signingKey instanceof EdDSAKey)) {
            throw new P11TokenException("given signing key is not suitable for EdDSA sign");
        }
        try {
            sig0 = (ConcurrentBagEntry)this.eddsaSignatures.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle DSA Signature available");
        }
        try {
            Signature sig = (Signature)sig0.value();
            sig.update(dataToSign);
            byte[] byArray = sig.sign();
            return byArray;
        }
        catch (SignatureException ex) {
            throw new P11TokenException("SignatureException: " + ex.getMessage(), ex);
        }
        finally {
            this.eddsaSignatures.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    private byte[] sm2SignHash(byte[] hash) throws P11TokenException {
        ConcurrentBagEntry sig0;
        try {
            sig0 = (ConcurrentBagEntry)this.sm2Signers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle SM2 Signer available");
        }
        try {
            SM2Signer sig = (SM2Signer)sig0.value();
            byte[] x962Signature = sig.generateSignatureForHash(hash);
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.getSignatureKeyBitLength());
            return byArray;
        }
        catch (CryptoException ex) {
            throw new P11TokenException("CryptoException: " + ex.getMessage(), ex);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        finally {
            this.sm2Signers.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    private byte[] sm2Sign(P11Params params, byte[] dataToSign, HashAlgo hash) throws P11TokenException {
        ConcurrentBagEntry sig0;
        if (params == null) {
            throw new P11TokenException("userId may not be null");
        }
        if (!(params instanceof P11Params.P11ByteArrayParams)) {
            throw new P11TokenException("params must be instanceof P11ByteArrayParams");
        }
        byte[] userId = ((P11Params.P11ByteArrayParams)params).getBytes();
        try {
            sig0 = (ConcurrentBagEntry)this.sm2Signers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle SM2 Signer available");
        }
        try {
            SM2Signer sig = (SM2Signer)sig0.value();
            byte[] x962Signature = sig.generateSignatureForMessage(userId, dataToSign);
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.getSignatureKeyBitLength());
            return byArray;
        }
        catch (CryptoException ex) {
            throw new P11TokenException("CryptoException: " + ex.getMessage(), ex);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        finally {
            this.sm2Signers.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    Key getSigningKey() {
        return this.signingKey;
    }

    private static HashAlgo getHashAlgoForPkcs11HashMech(long hashMech) {
        if (hashMech == 544L) {
            return HashAlgo.SHA1;
        }
        if (hashMech == 597L) {
            return HashAlgo.SHA224;
        }
        if (hashMech == 592L) {
            return HashAlgo.SHA256;
        }
        if (hashMech == 608L) {
            return HashAlgo.SHA384;
        }
        if (hashMech == 624L) {
            return HashAlgo.SHA512;
        }
        if (hashMech == 693L) {
            return HashAlgo.SHA3_224;
        }
        if (hashMech == 688L) {
            return HashAlgo.SHA3_256;
        }
        if (hashMech == 704L) {
            return HashAlgo.SHA3_384;
        }
        if (hashMech == 720L) {
            return HashAlgo.SHA3_512;
        }
        if (hashMech == PKCS11Constants.CKM_VENDOR_SM3) {
            return HashAlgo.SM3;
        }
        return null;
    }

    private static HashAlgo getHashAlgoForPkcs11MgfMech(long hashMech) {
        if (hashMech == 1L) {
            return HashAlgo.SHA1;
        }
        if (hashMech == 5L) {
            return HashAlgo.SHA224;
        }
        if (hashMech == 2L) {
            return HashAlgo.SHA256;
        }
        if (hashMech == 3L) {
            return HashAlgo.SHA384;
        }
        if (hashMech == 4L) {
            return HashAlgo.SHA512;
        }
        if (hashMech == 6L) {
            return HashAlgo.SHA3_224;
        }
        if (hashMech == 7L) {
            return HashAlgo.SHA3_256;
        }
        if (hashMech == 8L) {
            return HashAlgo.SHA3_384;
        }
        if (hashMech == 9L) {
            return HashAlgo.SHA3_512;
        }
        return null;
    }
}

