/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import org.xipki.security.HashAlgo;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11PrivateKey;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.util.SignerUtil;

abstract class AbstractP11ECDSASignatureSpi
extends SignatureSpi {
    private final HashAlgo hashAlgo;
    private final boolean plain;
    private long mechanism;
    private OutputStream outputStream;
    private P11PrivateKey signingKey;

    AbstractP11ECDSASignatureSpi(HashAlgo hashAlgo, boolean plain) {
        this.hashAlgo = hashAlgo;
        this.plain = plain;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException("engineInitVerify unsupported");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof P11PrivateKey)) {
            throw new InvalidKeyException("privateKey is not instanceof " + P11PrivateKey.class.getName());
        }
        String algo = privateKey.getAlgorithm();
        if (!"EC".equals(algo) && !"ECDSA".equals(algo)) {
            throw new InvalidKeyException("privateKey is not an EC private key: " + algo);
        }
        this.signingKey = (P11PrivateKey)privateKey;
        if (this.signingKey.supportsMechanism(4161L)) {
            this.mechanism = 4161L;
            this.outputStream = this.hashAlgo == null ? new ByteArrayOutputStream() : new DigestOutputStream(this.hashAlgo.createDigest());
        } else {
            if (this.hashAlgo == HashAlgo.SHA1 && this.signingKey.supportsMechanism(4162L)) {
                this.mechanism = 4162L;
            } else if (this.hashAlgo == HashAlgo.SHA224 && this.signingKey.supportsMechanism(4163L)) {
                this.mechanism = 4163L;
            } else if (this.hashAlgo == HashAlgo.SHA256 && this.signingKey.supportsMechanism(4164L)) {
                this.mechanism = 4164L;
            } else if (this.hashAlgo == HashAlgo.SHA384 && this.signingKey.supportsMechanism(4165L)) {
                this.mechanism = 4165L;
            } else if (this.hashAlgo == HashAlgo.SHA512 && this.signingKey.supportsMechanism(4166L)) {
                this.mechanism = 4166L;
            } else if (this.hashAlgo == HashAlgo.SHA3_224 && this.signingKey.supportsMechanism(4167L)) {
                this.mechanism = 4167L;
            } else if (this.hashAlgo == HashAlgo.SHA3_256 && this.signingKey.supportsMechanism(4168L)) {
                this.mechanism = 4168L;
            } else if (this.hashAlgo == HashAlgo.SHA3_384 && this.signingKey.supportsMechanism(4169L)) {
                this.mechanism = 4169L;
            } else if (this.hashAlgo == HashAlgo.SHA3_512 && this.signingKey.supportsMechanism(4170L)) {
                this.mechanism = 4170L;
            } else {
                throw new InvalidKeyException("privateKey and algorithm does not match");
            }
            this.outputStream = new ByteArrayOutputStream();
        }
        this.signingKey = (P11PrivateKey)privateKey;
    }

    @Override
    protected void engineUpdate(byte input) throws SignatureException {
        try {
            this.outputStream.write(input);
        }
        catch (IOException ex) {
            throw new SignatureException("IOException: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
        try {
            this.outputStream.write(input, off, len);
        }
        catch (IOException ex) {
            throw new SignatureException("IOException: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] dataToSign;
        if (this.outputStream instanceof ByteArrayOutputStream) {
            dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
            ((ByteArrayOutputStream)this.outputStream).reset();
        } else {
            dataToSign = ((DigestOutputStream)this.outputStream).digest();
            ((DigestOutputStream)this.outputStream).reset();
        }
        try {
            byte[] plainSignature = this.signingKey.sign(this.mechanism, null, dataToSign);
            return this.plain ? plainSignature : SignerUtil.dsaSigPlainToX962(plainSignature);
        }
        catch (XiSecurityException | P11TokenException ex) {
            throw new SignatureException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new UnsupportedOperationException("engineVerify unsupported");
    }
}

