/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.util.Args;

public class P11RSAKeyParameter
extends RSAKeyParameters {
    private final P11CryptService p11CryptService;
    private final P11IdentityId identityId;
    private final int keysize;

    private P11RSAKeyParameter(P11CryptService p11CryptService, P11IdentityId identityId, BigInteger modulus, BigInteger publicExponent) {
        super(true, modulus, publicExponent);
        Args.notNull((Object)modulus, (String)"modulus");
        Args.notNull((Object)publicExponent, (String)"publicExponent");
        this.p11CryptService = (P11CryptService)Args.notNull((Object)p11CryptService, (String)"p11CryptService");
        this.identityId = (P11IdentityId)Args.notNull((Object)identityId, (String)"identityId");
        this.keysize = modulus.bitLength();
    }

    int getKeysize() {
        return this.keysize;
    }

    P11CryptService getP11CryptService() {
        return this.p11CryptService;
    }

    P11IdentityId getIdentityId() {
        return this.identityId;
    }

    public static P11RSAKeyParameter getInstance(P11CryptService p11CryptService, P11IdentityId identityId) throws InvalidKeyException {
        RSAPublicKey key;
        Args.notNull((Object)p11CryptService, (String)"p11CryptService");
        Args.notNull((Object)identityId, (String)"identityId");
        try {
            key = (RSAPublicKey)p11CryptService.getIdentity(identityId).getPublicKey();
        }
        catch (P11TokenException ex) {
            throw new InvalidKeyException(ex.getMessage(), ex);
        }
        BigInteger modulus = key.getModulus();
        BigInteger publicExponent = key.getPublicExponent();
        return new P11RSAKeyParameter(p11CryptService, identityId, modulus, publicExponent);
    }
}

