/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.proxy.ProxyMessage;
import org.xipki.security.pkcs11.proxy.ProxyP11Slot;

class ProxyP11Identity
extends P11Identity {
    private final ProxyMessage.ObjectIdentifier asn1KeyId;

    ProxyP11Identity(ProxyP11Slot slot, P11IdentityId identityId) {
        super(slot, identityId, 0);
        this.asn1KeyId = new ProxyMessage.ObjectIdentifier(identityId.getKeyId());
    }

    ProxyP11Identity(ProxyP11Slot slot, P11IdentityId identityId, PublicKey publicKey, X509Certificate[] certificateChain) {
        super(slot, identityId, publicKey, certificateChain);
        this.asn1KeyId = new ProxyMessage.ObjectIdentifier(identityId.getKeyId());
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws P11TokenException {
        ASN1OctetString octetString;
        ProxyMessage.P11Params p11Param = null;
        if (parameters != null) {
            if (parameters instanceof P11Params.P11RSAPkcsPssParams) {
                p11Param = new ProxyMessage.P11Params(0, (ASN1Encodable)new ProxyMessage.RSAPkcsPssParams((P11Params.P11RSAPkcsPssParams)parameters));
            } else if (parameters instanceof P11Params.P11ByteArrayParams) {
                byte[] bytes = ((P11Params.P11ByteArrayParams)parameters).getBytes();
                p11Param = new ProxyMessage.P11Params(1, (ASN1Encodable)new DEROctetString(bytes));
            } else if (parameters instanceof P11Params.P11IVParams) {
                p11Param = new ProxyMessage.P11Params(2, (ASN1Encodable)new DEROctetString(((P11Params.P11IVParams)parameters).getIV()));
            } else {
                throw new IllegalArgumentException("unkown parameter 'parameters'");
            }
        }
        ProxyMessage.SignTemplate signTemplate = new ProxyMessage.SignTemplate(((ProxyP11Slot)this.slot).getAsn1SlotId(), this.asn1KeyId, mechanism, p11Param, content);
        byte[] result = ((ProxyP11Slot)this.slot).getModule().send((short)288, signTemplate);
        try {
            octetString = DEROctetString.getInstance((Object)result);
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException("the returned result is not OCTET STRING");
        }
        return octetString == null ? null : octetString.getOctets();
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws P11TokenException {
        ASN1OctetString octetString;
        ProxyMessage.DigestSecretKeyTemplate template = new ProxyMessage.DigestSecretKeyTemplate(((ProxyP11Slot)this.slot).getAsn1SlotId(), this.asn1KeyId, mechanism);
        byte[] result = ((ProxyP11Slot)this.slot).getModule().send((short)308, template);
        try {
            octetString = DEROctetString.getInstance((Object)result);
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException("the returned result is not OCTET STRING");
        }
        return octetString == null ? null : octetString.getOctets();
    }
}

