/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.xipki.password.PasswordResolver;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.KeyCertPair;
import org.xipki.security.SignerConf;
import org.xipki.security.XiSecurityException;
import org.xipki.util.ObjectCreationException;

public interface SecurityFactory {
    public PasswordResolver getPasswordResolver();

    public Set<String> getSupportedSignerTypes();

    public KeyCertPair createPrivateKeyAndCert(String var1, SignerConf var2, X509Certificate var3) throws ObjectCreationException;

    public ConcurrentContentSigner createSigner(String var1, SignerConf var2, X509Certificate var3) throws ObjectCreationException;

    public ConcurrentContentSigner createSigner(String var1, SignerConf var2, X509Certificate[] var3) throws ObjectCreationException;

    public ContentVerifierProvider getContentVerifierProvider(PublicKey var1) throws InvalidKeyException;

    public ContentVerifierProvider getContentVerifierProvider(PublicKey var1, DHSigStaticKeyCertPair var2) throws InvalidKeyException;

    public ContentVerifierProvider getContentVerifierProvider(X509Certificate var1) throws InvalidKeyException;

    public ContentVerifierProvider getContentVerifierProvider(X509CertificateHolder var1) throws InvalidKeyException;

    public boolean verifyPopo(PKCS10CertificationRequest var1, AlgorithmValidator var2);

    public boolean verifyPopo(PKCS10CertificationRequest var1, AlgorithmValidator var2, DHSigStaticKeyCertPair var3);

    public boolean verifyPopo(CertificationRequest var1, AlgorithmValidator var2);

    public boolean verifyPopo(CertificationRequest var1, AlgorithmValidator var2, DHSigStaticKeyCertPair var3);

    public PublicKey generatePublicKey(SubjectPublicKeyInfo var1) throws InvalidKeyException;

    public byte[] extractMinimalKeyStore(String var1, byte[] var2, String var3, char[] var4, X509Certificate[] var5) throws KeyStoreException;

    public SecureRandom getRandom4Sign();

    public SecureRandom getRandom4Key();

    public int getDfltSignerParallelism();

    public void refreshTokenForSignerType(String var1) throws XiSecurityException;
}

