/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.iaik;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.SessionInfo;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.State;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECPrivateKey;
import iaik.pkcs.pkcs11.objects.ECPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.ValuedSecretKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.parameters.InitializationVectorParameters;
import iaik.pkcs.pkcs11.parameters.OpaqueParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.parameters.RSAPkcsPssParameters;
import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.EdECConstants;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.P11UnknownEntityException;
import org.xipki.security.pkcs11.iaik.IaikP11Identity;
import org.xipki.security.pkcs11.iaik.IaikP11Module;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

class IaikP11Slot
extends P11Slot {
    private static final Logger LOG = LoggerFactory.getLogger(IaikP11Slot.class);
    private static final long DEFAULT_MAX_COUNT_SESSION = 32L;
    private final int maxMessageSize;
    private Slot slot;
    private final String userTypeText;
    private final long userType;
    private List<char[]> password;
    private int maxSessionCount;
    private long timeOutWaitNewSession = 10000L;
    private final AtomicLong countSessions = new AtomicLong(0L);
    private final SecureRandom random = new SecureRandom();
    private final P11ModuleConf.P11NewObjectConf newObjectConf;
    private final ConcurrentBag<ConcurrentBagEntry<Session>> sessions = new ConcurrentBag();
    private final IaikP11Module.Vendor vendor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IaikP11Slot(String moduleName, P11SlotIdentifier slotId, Slot slot, boolean readOnly, long userType, List<char[]> password, int maxMessageSize, P11ModuleConf.P11MechanismFilter mechanismFilter, P11ModuleConf.P11NewObjectConf newObjectConf, IaikP11Module.Vendor vendor) throws P11TokenException {
        super(moduleName, slotId, readOnly, mechanismFilter);
        this.newObjectConf = (P11ModuleConf.P11NewObjectConf)Args.notNull((Object)newObjectConf, (String)"newObjectConf");
        this.slot = (Slot)Args.notNull((Object)slot, (String)"slot");
        this.maxMessageSize = Args.positive((int)maxMessageSize, (String)"maxMessageSize");
        this.vendor = (IaikP11Module.Vendor)((Object)Args.notNull((Object)((Object)vendor), (String)"vendo r"));
        this.userType = userType;
        this.userTypeText = userType == 0L ? "CKU_SO" : (userType == 1L ? "CKU_USER" : (userType == 2L ? "CKU_CONTEXT_SPECIFIC" : "VENDOR_" + userType));
        this.password = password;
        boolean successful = false;
        try {
            long maxSessionCount2;
            Token token;
            Session session;
            try {
                session = this.openSession();
            }
            catch (P11TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"openSession");
                throw ex;
            }
            try {
                this.firstLogin(session, password);
            }
            catch (P11TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"firstLogin");
                throw ex;
            }
            try {
                token = this.slot.getToken();
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not getToken: " + ex.getMessage(), ex);
            }
            try {
                maxSessionCount2 = token.getTokenInfo().getMaxSessionCount();
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not get tokenInfo: " + ex.getMessage(), ex);
            }
            maxSessionCount2 = maxSessionCount2 == 0L ? 32L : (maxSessionCount2 < 3L ? 1L : maxSessionCount2 - 2L);
            this.maxSessionCount = (int)maxSessionCount2;
            LOG.info("maxSessionCount: {}", (Object)this.maxSessionCount);
            this.sessions.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)session));
            this.refresh();
            successful = true;
        }
        finally {
            if (!successful) {
                this.close();
            }
        }
    }

    Slot getSlot() {
        return this.slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11Slot.P11SlotRefreshResult refresh0() throws P11TokenException {
        Mechanism[] mechanisms;
        try {
            mechanisms = this.slot.getToken().getMechanismList();
        }
        catch (TokenException ex) {
            throw new P11TokenException("could not getMechanismList: " + ex.getMessage(), ex);
        }
        P11Slot.P11SlotRefreshResult ret = new P11Slot.P11SlotRefreshResult();
        if (mechanisms != null) {
            for (Mechanism mech : mechanisms) {
                ret.addMechanism(mech.getMechanismCode());
            }
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            List<SecretKey> secretKeys = this.getAllSecretKeyObjects(session);
            for (SecretKey secretKey : secretKeys) {
                byte[] keyId = secretKey.getId().getByteArrayValue();
                if (keyId == null || keyId.length == 0) continue;
                this.analyseSingleKey(secretKey, ret);
            }
            List<X509PublicKeyCertificate> p11Certs = this.getAllCertificateObjects(session);
            for (X509PublicKeyCertificate p11Cert : p11Certs) {
                byte[] id = p11Cert.getId().getByteArrayValue();
                char[] label = p11Cert.getLabel().getCharArrayValue();
                if (id == null || label == null) continue;
                P11ObjectIdentifier objId = new P11ObjectIdentifier(id, new String(label));
                ret.addCertificate(objId, IaikP11Slot.parseCert(p11Cert));
            }
            List<PrivateKey> list = this.getAllPrivateObjects(session);
            for (PrivateKey privKey : list) {
                byte[] keyId = privKey.getId().getByteArrayValue();
                try {
                    this.analyseSingleKey(session, privKey, ret);
                }
                catch (XiSecurityException ex) {
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)("XiSecurityException while initializing private key with id " + IaikP11Slot.hex(keyId)));
                }
                catch (Throwable th) {
                    String label = "";
                    if (privKey.getLabel() != null) {
                        label = new String(privKey.getLabel().getCharArrayValue());
                    }
                    LOG.error("unexpected exception while initializing private key with id " + IaikP11Slot.hex(keyId) + " and label " + label, th);
                }
            }
            P11Slot.P11SlotRefreshResult p11SlotRefreshResult = ret;
            return p11SlotRefreshResult;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    public final void close() {
        if (this.slot != null) {
            try {
                LOG.info("close all sessions on token: {}", (Object)this.slot.getSlotID());
                for (ConcurrentBagEntry session : this.sessions.values()) {
                    ((Session)session.value()).closeSession();
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not slot.getToken().closeAllSessions()");
            }
            this.slot = null;
        }
        this.sessions.close();
        this.countSessions.lazySet(0L);
    }

    private void analyseSingleKey(SecretKey secretKey, P11Slot.P11SlotRefreshResult refreshResult) {
        byte[] id = secretKey.getId().getByteArrayValue();
        char[] label = secretKey.getLabel().getCharArrayValue();
        if (id == null || label == null) {
            return;
        }
        P11ObjectIdentifier objectId = new P11ObjectIdentifier(id, new String(label));
        IaikP11Identity identity = new IaikP11Identity(this, new P11IdentityId(this.slotId, objectId, null, null), secretKey);
        refreshResult.addIdentity(identity);
    }

    private void analyseSingleKey(Session session, PrivateKey privKey, P11Slot.P11SlotRefreshResult refreshResult) throws P11TokenException, XiSecurityException {
        X509Certificate[] x509CertificateArray;
        byte[] id = privKey.getId().getByteArrayValue();
        char[] label = privKey.getLabel().getCharArrayValue();
        if (id == null || label == null) {
            return;
        }
        String pubKeyLabel = null;
        iaik.pkcs.pkcs11.objects.PublicKey p11PublicKey = this.getPublicKeyObject(session, id, null);
        if (p11PublicKey != null) {
            pubKeyLabel = new String(p11PublicKey.getLabel().getCharArrayValue());
        }
        String certLabel = null;
        PublicKey pubKey = null;
        X509Cert cert = refreshResult.getCertForId(id);
        if (cert != null) {
            certLabel = refreshResult.getCertLabelForId(id);
            pubKey = cert.getCert().getPublicKey();
        } else if (p11PublicKey != null) {
            pubKey = IaikP11Slot.generatePublicKey(p11PublicKey);
        } else {
            LOG.info("neither certificate nor public key for the key (" + IaikP11Slot.hex(id) + " is available");
            return;
        }
        P11ObjectIdentifier objectId = new P11ObjectIdentifier(id, new String(label));
        if (cert == null) {
            x509CertificateArray = null;
        } else {
            X509Certificate[] x509CertificateArray2 = new X509Certificate[1];
            x509CertificateArray = x509CertificateArray2;
            x509CertificateArray2[0] = cert.getCert();
        }
        X509Certificate[] certs = x509CertificateArray;
        IaikP11Identity identity = new IaikP11Identity(this, new P11IdentityId(this.slotId, objectId, pubKeyLabel, certLabel), privKey, pubKey, certs);
        refreshResult.addIdentity(identity);
    }

    /*
     * Exception decompiling
     */
    byte[] digestKey(long mechanism, IaikP11Identity identity) throws P11TokenException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 6[CATCHBLOCK], 5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] digestKey0(Session session, int digestLen, Mechanism mechanism, SecretKey key) throws TokenException {
        session.digestInit(mechanism);
        session.digestKey(key);
        byte[] digest = new byte[digestLen];
        session.digestFinal(digest, 0, digestLen);
        return digest;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] sign(long mechanism, P11Params parameters, byte[] content, IaikP11Identity identity) throws P11TokenException {
        Args.notNull((Object)content, (String)"content");
        this.assertMechanismSupported(mechanism);
        int expectedSignatureLen = mechanism == 545L ? 20 : (mechanism == 598L || mechanism == 693L ? 28 : (mechanism == 593L || mechanism == 688L ? 32 : (mechanism == 609L || mechanism == 704L ? 48 : (mechanism == 625L || mechanism == 720L ? 64 : (mechanism == PKCS11Constants.CKM_VENDOR_SM2 || mechanism == PKCS11Constants.CKM_VENDOR_SM2_SM3 ? 32 : identity.getExpectedSignatureLen())))));
        Mechanism mechanismObj = IaikP11Slot.getMechanism(mechanism, parameters);
        Key signingKey = identity.getSigningKey();
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            Session session = (Session)session0.value();
            try {
                byte[] byArray = this.sign0(session, expectedSignatureLen, mechanismObj, content, signingKey);
                return byArray;
            }
            catch (PKCS11Exception ex) {
                long errorCode = ex.getErrorCode();
                if (errorCode != 257L) throw ex;
                LOG.info("sign ended with ERROR CKR_USER_NOT_LOGGED_IN, login and then retry it");
                this.forceLogin(session);
                byte[] byArray2 = this.sign0(session, expectedSignatureLen, mechanismObj, content, signingKey);
                return byArray2;
            }
            finally {
                this.sessions.requite(session0);
            }
        }
        catch (TokenException ex2) {
            throw new P11TokenException(ex2.getMessage(), ex2);
        }
    }

    private byte[] sign0(Session session, int expectedSignatureLen, Mechanism mechanism, byte[] content, Key signingKey) throws TokenException {
        int len = content.length;
        if (len <= this.maxMessageSize) {
            return this.singleSign(session, mechanism, content, signingKey);
        }
        LOG.debug("sign (init, update, then finish)");
        session.signInit(mechanism, signingKey);
        for (int i = 0; i < len; i += this.maxMessageSize) {
            int blockLen = Math.min(this.maxMessageSize, len - i);
            session.signUpdate(content, i, blockLen);
        }
        return session.signFinal(expectedSignatureLen);
    }

    private byte[] singleSign(Session session, Mechanism mechanism, byte[] content, Key signingKey) throws TokenException {
        LOG.debug("single sign");
        session.signInit(mechanism, signingKey);
        byte[] signature = session.sign(content);
        return signature;
    }

    private static Mechanism getMechanism(long mechanism, P11Params parameters) throws P11TokenException {
        OpaqueParameters paramObj;
        Mechanism ret = Mechanism.get((long)mechanism);
        if (parameters == null) {
            return ret;
        }
        if (parameters instanceof P11Params.P11RSAPkcsPssParams) {
            P11Params.P11RSAPkcsPssParams param = (P11Params.P11RSAPkcsPssParams)parameters;
            paramObj = new RSAPkcsPssParameters(param.getHashAlgorithm(), param.getMaskGenerationFunction(), param.getSaltLength());
        } else if (parameters instanceof P11Params.P11ByteArrayParams) {
            paramObj = new OpaqueParameters(((P11Params.P11ByteArrayParams)parameters).getBytes());
        } else if (parameters instanceof P11Params.P11IVParams) {
            paramObj = new InitializationVectorParameters(((P11Params.P11IVParams)parameters).getIV());
        } else {
            throw new P11TokenException("unknown P11Parameters " + parameters.getClass().getName());
        }
        if (paramObj != null) {
            ret.setParameters((Parameters)paramObj);
        }
        return ret;
    }

    private Session openSession() throws P11TokenException {
        Session session;
        try {
            boolean rw = !this.isReadOnly();
            session = this.slot.getToken().openSession(true, rw, null, null);
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        this.countSessions.incrementAndGet();
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentBagEntry<Session> borrowSession() throws P11TokenException {
        ConcurrentBagEntry session = null;
        ConcurrentBag<ConcurrentBagEntry<Session>> concurrentBag = this.sessions;
        synchronized (concurrentBag) {
            if (this.countSessions.get() < (long)this.maxSessionCount) {
                try {
                    session = (ConcurrentBagEntry)this.sessions.borrow(1L, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (session == null) {
                    this.sessions.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)this.openSession()));
                }
            }
        }
        if (session == null) {
            try {
                session = (ConcurrentBagEntry)this.sessions.borrow(this.timeOutWaitNewSession, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (session == null) {
            throw new P11TokenException("no idle session");
        }
        this.login((Session)session.value());
        return session;
    }

    private void firstLogin(Session session, List<char[]> password) throws P11TokenException {
        try {
            boolean isProtectedAuthenticationPath = session.getToken().getTokenInfo().isProtectedAuthenticationPath();
            if (isProtectedAuthenticationPath || CollectionUtil.isEmpty(password)) {
                LOG.info("verify on PKCS11Module with PROTECTED_AUTHENTICATION_PATH");
                this.singleLogin(session, null);
            } else {
                LOG.info("verify on PKCS11Module with PIN");
                for (char[] singlePwd : password) {
                    this.singleLogin(session, singlePwd);
                }
                this.password = password;
            }
        }
        catch (PKCS11Exception ex) {
            if (ex.getErrorCode() != 256L) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    private void login(Session session) throws P11TokenException {
        boolean loginRequired;
        boolean isSessionLoggedIn = this.checkSessionLoggedIn(session);
        if (isSessionLoggedIn) {
            return;
        }
        try {
            loginRequired = session.getToken().getTokenInfo().isLoginRequired();
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not check whether LoginRequired of token");
            loginRequired = true;
        }
        LOG.debug("loginRequired: {}", (Object)loginRequired);
        if (!loginRequired) {
            return;
        }
        if (CollectionUtil.isEmpty(this.password)) {
            this.singleLogin(session, null);
        } else {
            for (char[] singlePwd : this.password) {
                this.singleLogin(session, singlePwd);
            }
        }
    }

    private void forceLogin(Session session) throws P11TokenException {
        if (CollectionUtil.isEmpty(this.password)) {
            LOG.info("verify on PKCS11Module with NULL PIN");
            this.singleLogin(session, null);
        } else {
            LOG.info("verify on PKCS11Module with PIN");
            for (char[] singlePwd : this.password) {
                this.singleLogin(session, singlePwd);
            }
        }
    }

    private void singleLogin(Session session, char[] pin) throws P11TokenException {
        char[] tmpPin = pin;
        if (pin == null) {
            tmpPin = new char[]{};
        }
        try {
            session.login(this.userType, tmpPin);
            LOG.info("login successful as user " + this.userTypeText);
        }
        catch (TokenException ex) {
            if (ex instanceof PKCS11Exception && ((PKCS11Exception)((Object)ex)).getErrorCode() == 256L) {
                LOG.info("user already logged in");
            }
            LOG.info("login failed as user " + this.userTypeText);
            throw new P11TokenException("login failed as user " + this.userTypeText + ": " + ex.getMessage(), ex);
        }
    }

    private List<PrivateKey> getAllPrivateObjects(Session session) throws P11TokenException {
        PrivateKey template = new PrivateKey();
        List<Storage> tmpObjects = IaikP11Slot.getObjects(session, (Storage)template);
        if (CollectionUtil.isEmpty(tmpObjects)) {
            return Collections.emptyList();
        }
        int n = tmpObjects.size();
        LOG.info("found {} private keys", (Object)n);
        ArrayList<PrivateKey> privateKeys = new ArrayList<PrivateKey>(n);
        for (Storage tmpObject : tmpObjects) {
            privateKeys.add((PrivateKey)tmpObject);
        }
        return privateKeys;
    }

    private List<SecretKey> getAllSecretKeyObjects(Session session) throws P11TokenException {
        SecretKey template = new SecretKey();
        List<Storage> tmpObjects = IaikP11Slot.getObjects(session, (Storage)template);
        if (CollectionUtil.isEmpty(tmpObjects)) {
            return Collections.emptyList();
        }
        int n = tmpObjects.size();
        LOG.info("found {} private keys", (Object)n);
        ArrayList<SecretKey> keys = new ArrayList<SecretKey>(n);
        for (Storage tmpObject : tmpObjects) {
            keys.add((SecretKey)tmpObject);
        }
        return keys;
    }

    private SecretKey getSecretKeyObject(Session session, byte[] keyId, char[] keyLabel) throws P11TokenException {
        return (SecretKey)this.getKeyObject(session, (Key)new SecretKey(), keyId, keyLabel);
    }

    private PrivateKey getPrivateKeyObject(Session session, byte[] keyId, char[] keyLabel) throws P11TokenException {
        return (PrivateKey)this.getKeyObject(session, (Key)new PrivateKey(), keyId, keyLabel);
    }

    private iaik.pkcs.pkcs11.objects.PublicKey getPublicKeyObject(Session session, byte[] keyId, char[] keyLabel) throws P11TokenException {
        return (iaik.pkcs.pkcs11.objects.PublicKey)this.getKeyObject(session, (Key)new iaik.pkcs.pkcs11.objects.PublicKey(), keyId, keyLabel);
    }

    private Key getKeyObject(Session session, Key template, byte[] keyId, char[] keyLabel) throws P11TokenException {
        List<Storage> tmpObjects;
        if (keyId != null) {
            template.getId().setByteArrayValue(keyId);
        }
        if (keyLabel != null) {
            template.getLabel().setCharArrayValue(keyLabel);
        }
        if (CollectionUtil.isEmpty(tmpObjects = IaikP11Slot.getObjects(session, (Storage)template, 2))) {
            return null;
        }
        int size = tmpObjects.size();
        if (size > 1) {
            LOG.warn("found {} public key identified by {}, use the first one", (Object)size, (Object)IaikP11Slot.getDescription(keyId, keyLabel));
        }
        return (Key)tmpObjects.get(0);
    }

    private X509PublicKeyCertificate getCertificateObject(Session session, byte[] keyId, char[] keyLabel) throws P11TokenException {
        List<Storage> tmpObjects;
        X509PublicKeyCertificate template = new X509PublicKeyCertificate();
        if (keyId != null) {
            template.getId().setByteArrayValue(keyId);
        }
        if (keyLabel != null) {
            template.getLabel().setCharArrayValue(keyLabel);
        }
        if (CollectionUtil.isEmpty(tmpObjects = IaikP11Slot.getObjects(session, (Storage)template, 2))) {
            LOG.info("found no certificate identified by {}", (Object)IaikP11Slot.getDescription(keyId, keyLabel));
            return null;
        }
        int size = tmpObjects.size();
        if (size > 1) {
            LOG.warn("found {} public key identified by {}, use the first one", (Object)size, (Object)IaikP11Slot.getDescription(keyId, keyLabel));
        }
        return (X509PublicKeyCertificate)tmpObjects.get(0);
    }

    private boolean checkSessionLoggedIn(Session session) throws P11TokenException {
        SessionInfo info;
        try {
            info = session.getSessionInfo();
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("SessionInfo: {}", (Object)info);
        }
        State state = info.getState();
        long deviceError = info.getDeviceError();
        LOG.debug("to be verified PKCS11Module: state = {}, deviceError: {}", (Object)state, (Object)deviceError);
        if (deviceError != 0L) {
            LOG.error("deviceError {}", (Object)deviceError);
            return false;
        }
        boolean sessionLoggedIn = this.userType == 0L ? state.equals((Object)State.RW_SO_FUNCTIONS) : state.equals((Object)State.RW_USER_FUNCTIONS) || state.equals((Object)State.RO_USER_FUNCTIONS);
        LOG.debug("sessionLoggedIn: {}", (Object)sessionLoggedIn);
        return sessionLoggedIn;
    }

    private static List<Storage> getObjects(Session session, Storage template) throws P11TokenException {
        return IaikP11Slot.getObjects(session, template, 9999);
    }

    private static List<Storage> getObjects(Session session, Storage template, int maxNo) throws P11TokenException {
        LinkedList<Storage> objList = new LinkedList<Storage>();
        try {
            PKCS11Object[] foundObjects;
            session.findObjectsInit((PKCS11Object)template);
            while (objList.size() < maxNo && (foundObjects = session.findObjects(1)) != null) {
                if (foundObjects.length == 0) {
                    break;
                }
                for (PKCS11Object object : foundObjects) {
                    IaikP11Slot.logPkcs11ObjectAttributes("found object: ", object);
                    objList.add((Storage)object);
                }
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            try {
                session.findObjectsFinal();
            }
            catch (Exception ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"session.findObjectsFinal() failed");
            }
        }
        return objList;
    }

    private static PublicKey generatePublicKey(iaik.pkcs.pkcs11.objects.PublicKey p11Key) throws XiSecurityException {
        if (p11Key instanceof RSAPublicKey) {
            RSAPublicKey rsaP11Key = (RSAPublicKey)p11Key;
            byte[] expBytes = rsaP11Key.getPublicExponent().getByteArrayValue();
            BigInteger exp = new BigInteger(1, expBytes);
            byte[] modBytes = rsaP11Key.getModulus().getByteArrayValue();
            BigInteger mod = new BigInteger(1, modBytes);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            try {
                return KeyUtil.generateRSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        if (p11Key instanceof DSAPublicKey) {
            DSAPublicKey dsaP11Key = (DSAPublicKey)p11Key;
            BigInteger prime = new BigInteger(1, dsaP11Key.getPrime().getByteArrayValue());
            BigInteger subPrime = new BigInteger(1, dsaP11Key.getSubprime().getByteArrayValue());
            BigInteger base = new BigInteger(1, dsaP11Key.getBase().getByteArrayValue());
            BigInteger value = new BigInteger(1, dsaP11Key.getValue().getByteArrayValue());
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(value, prime, subPrime, base);
            try {
                return KeyUtil.generateDSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        if (p11Key instanceof ECPublicKey) {
            ECPublicKey ecP11Key = (ECPublicKey)p11Key;
            long keyType = ecP11Key.getKeyType().getLongValue();
            byte[] ecParameters = ecP11Key.getEcdsaParams().getByteArrayValue();
            byte[] encodedPoint = DEROctetString.getInstance((Object)ecP11Key.getEcPoint().getByteArrayValue()).getOctets();
            if (keyType == Key.KeyType.EC_EDWARDS || keyType == Key.KeyType.EC_MONTGOMERY) {
                ASN1ObjectIdentifier algOid = ASN1ObjectIdentifier.getInstance((Object)ecParameters);
                if (keyType == Key.KeyType.EC_EDWARDS) {
                    if (!EdECConstants.isEdwardsCurve(algOid)) {
                        throw new XiSecurityException("unknown Edwards curve OID " + algOid);
                    }
                } else if (!EdECConstants.isMontgomeryCurve(algOid)) {
                    throw new XiSecurityException("unknown Montgomery curve OID " + algOid);
                }
                SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(algOid), encodedPoint);
                try {
                    return KeyUtil.generatePublicKey(pkInfo);
                }
                catch (InvalidKeySpecException ex) {
                    throw new XiSecurityException(ex.getMessage(), ex);
                }
            }
            try {
                return KeyUtil.createECPublicKey(ecParameters, encodedPoint);
            }
            catch (InvalidKeySpecException ex) {
                throw new XiSecurityException(ex.getMessage(), ex);
            }
        }
        throw new XiSecurityException("unknown publicKey class " + p11Key.getClass().getName());
    }

    private static X509Cert parseCert(X509PublicKeyCertificate p11Cert) throws P11TokenException {
        try {
            byte[] encoded = p11Cert.getValue().getByteArrayValue();
            return new X509Cert(X509Util.parseCert(encoded), encoded);
        }
        catch (CertificateException ex) {
            throw new P11TokenException("could not parse certificate: " + ex.getMessage(), ex);
        }
    }

    private List<X509PublicKeyCertificate> getAllCertificateObjects(Session session) throws P11TokenException {
        X509PublicKeyCertificate template = new X509PublicKeyCertificate();
        List<Storage> tmpObjects = IaikP11Slot.getObjects(session, (Storage)template);
        ArrayList<X509PublicKeyCertificate> certs = new ArrayList<X509PublicKeyCertificate>(tmpObjects.size());
        for (PKCS11Object pKCS11Object : tmpObjects) {
            X509PublicKeyCertificate cert = (X509PublicKeyCertificate)pKCS11Object;
            certs.add(cert);
        }
        return certs;
    }

    @Override
    public int removeObjects(byte[] id, String label) throws P11TokenException {
        return this.removeObjects(id, label == null ? null : label.toCharArray());
    }

    private int removeObjects(byte[] id, char[] label) throws P11TokenException {
        boolean labelNotBlank;
        boolean bl = labelNotBlank = label != null && label.length != 0;
        if (!(id != null && id.length != 0 || labelNotBlank)) {
            throw new IllegalArgumentException("at least one of id and label may not be null");
        }
        Key keyTemplate = new Key();
        if (id != null && id.length > 0) {
            keyTemplate.getId().setByteArrayValue(id);
        }
        if (labelNotBlank) {
            keyTemplate.getLabel().setCharArrayValue(label);
        }
        String objIdDesc = IaikP11Slot.getDescription(id, label);
        int num = this.removeObjects((Storage)keyTemplate, "keys " + objIdDesc);
        X509PublicKeyCertificate certTemplate = new X509PublicKeyCertificate();
        if (id != null && id.length > 0) {
            certTemplate.getId().setByteArrayValue(id);
        }
        if (labelNotBlank) {
            certTemplate.getLabel().setCharArrayValue(label);
        }
        return num += this.removeObjects((Storage)certTemplate, "certificates" + objIdDesc);
    }

    private int removeObjects(Storage template, String desc) throws P11TokenException {
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            List<Storage> objects = IaikP11Slot.getObjects(session, template);
            for (Storage obj : objects) {
                if (this.vendor == IaikP11Module.Vendor.YUBIKEY) {
                    if (obj instanceof X509PublicKeyCertificate) {
                        throw new P11TokenException("cannot delete certificates in Yubikey token");
                    }
                    if (obj instanceof PrivateKey || obj instanceof iaik.pkcs.pkcs11.objects.PublicKey) {
                        // empty if block
                    }
                }
                session.destroyObject((PKCS11Object)obj);
            }
            int n = objects.size();
            return n;
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("could not remove " + desc));
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected void removeCerts0(P11ObjectIdentifier objectId) throws P11TokenException {
        if (this.vendor == IaikP11Module.Vendor.YUBIKEY) {
            throw new P11TokenException("Unsupported operation removeCerts() in yubikey token");
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            X509PublicKeyCertificate[] existingCerts = this.getCertificateObjects(session, objectId.getId(), objectId.getLabelChars());
            if (existingCerts == null || existingCerts.length == 0) {
                LOG.warn("could not find certificates " + objectId);
                return;
            }
            for (X509PublicKeyCertificate cert : existingCerts) {
                session.destroyObject((PKCS11Object)cert);
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11ObjectIdentifier addCert0(X509Certificate cert, P11Slot.P11NewObjectControl control) throws P11TokenException {
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            X509PublicKeyCertificate newCertTemp = this.createPkcs11Template(session, new X509Cert(cert), control);
            X509PublicKeyCertificate newCert = (X509PublicKeyCertificate)session.createObject((PKCS11Object)newCertTemp);
            P11ObjectIdentifier p11ObjectIdentifier = new P11ObjectIdentifier(newCert.getId().getByteArrayValue(), new String(newCert.getLabel().getCharArrayValue()));
            return p11ObjectIdentifier;
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11Identity generateSecretKey0(long keyType, int keysize, P11Slot.P11NewKeyControl control) throws P11TokenException {
        long mech;
        if (keysize % 8 != 0) {
            throw new IllegalArgumentException("keysize is not multiple of 8: " + keysize);
        }
        if (31L == keyType) {
            mech = 4224L;
        } else if (21L == keyType) {
            mech = 305L;
        } else if (16L == keyType) {
            mech = 848L;
        } else if (40L == keyType || 46L == keyType || 43L == keyType || 44L == keyType || 45L == keyType || 54L == keyType || 55L == keyType || 56L == keyType || 57L == keyType) {
            mech = 848L;
        } else {
            throw new IllegalArgumentException("unsupported key type 0x" + Functions.toFullHex((long)((int)keyType)));
        }
        this.assertMechanismSupported(mech);
        char[] labelChars = this.newObjectConf.isIgnoreLabel() ? null : control.getLabel().toCharArray();
        byte[] id = control.getId();
        ValuedSecretKey template = new ValuedSecretKey(keyType);
        template.getToken().setBooleanValue(Boolean.valueOf(true));
        if (labelChars != null) {
            template.getLabel().setCharArrayValue(labelChars);
        }
        if (control.getExtractable() != null) {
            template.getExtractable().setBooleanValue(control.getExtractable());
        }
        if (control.getSensitive() != null) {
            template.getSensitive().setBooleanValue(control.getSensitive());
        }
        Set<P11Slot.P11KeyUsage> usages = control.getUsages();
        Boolean TRUE = Boolean.TRUE;
        if (CollectionUtil.isNotEmpty(usages)) {
            for (P11Slot.P11KeyUsage usage : usages) {
                switch (usage) {
                    case DECRYPT: {
                        template.getDecrypt().setBooleanValue(TRUE);
                        break;
                    }
                    case DERIVE: {
                        template.getDerive().setBooleanValue(TRUE);
                        break;
                    }
                    case SIGN: {
                        template.getSign().setBooleanValue(TRUE);
                        break;
                    }
                    case UNWRAP: {
                        template.getUnwrap().setBooleanValue(TRUE);
                        break;
                    }
                }
            }
        }
        template.getValueLen().setLongValue(Long.valueOf(keysize / 8));
        Mechanism mechanism = Mechanism.get((long)mech);
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            SecretKey key;
            Session session = (Session)bagEntry.value();
            if (labelChars != null && IaikP11Slot.labelExists(session, labelChars)) {
                throw new IllegalArgumentException("label " + control.getLabel() + " exists, please specify another one");
            }
            if (id == null) {
                id = this.generateId(session);
            }
            template.getId().setByteArrayValue(id);
            try {
                key = (SecretKey)session.generateKey(mechanism, (PKCS11Object)template);
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not generate generic secret key using " + mechanism.getName(), ex);
            }
            labelChars = key.getLabel().getCharArrayValue();
            P11ObjectIdentifier objId = new P11ObjectIdentifier(id, new String(labelChars));
            P11IdentityId entityId = new P11IdentityId(this.slotId, objId, null, null);
            IaikP11Identity iaikP11Identity = new IaikP11Identity(this, entityId, key);
            return iaikP11Identity;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11Identity importSecretKey0(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) throws P11TokenException {
        char[] labelChars;
        ValuedSecretKey template = new ValuedSecretKey(keyType);
        template.getToken().setBooleanValue(Boolean.valueOf(true));
        char[] cArray = labelChars = this.newObjectConf.isIgnoreLabel() ? null : control.getLabel().toCharArray();
        if (labelChars != null) {
            template.getLabel().setCharArrayValue(labelChars);
        }
        if (control.getExtractable() != null) {
            template.getExtractable().setBooleanValue(control.getExtractable());
        }
        if (control.getSensitive() != null) {
            template.getSensitive().setBooleanValue(control.getSensitive());
        }
        template.getValue().setByteArrayValue(keyValue);
        Set<P11Slot.P11KeyUsage> usages = control.getUsages();
        Boolean TRUE = Boolean.TRUE;
        if (CollectionUtil.isNotEmpty(usages)) {
            for (P11Slot.P11KeyUsage usage : usages) {
                switch (usage) {
                    case DECRYPT: {
                        template.getDecrypt().setBooleanValue(TRUE);
                        break;
                    }
                    case DERIVE: {
                        template.getDerive().setBooleanValue(TRUE);
                        break;
                    }
                    case SIGN: {
                        template.getSign().setBooleanValue(TRUE);
                        break;
                    }
                    case UNWRAP: {
                        template.getUnwrap().setBooleanValue(TRUE);
                        break;
                    }
                }
            }
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            SecretKey key;
            Session session = (Session)bagEntry.value();
            if (labelChars != null && IaikP11Slot.labelExists(session, labelChars)) {
                throw new IllegalArgumentException("label " + control.getLabel() + " exists, please specify another one");
            }
            byte[] id = control.getId();
            if (id == null) {
                id = this.generateId(session);
            }
            if (id != null) {
                template.getId().setByteArrayValue(id);
            }
            try {
                key = (SecretKey)session.createObject((PKCS11Object)template);
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not create secret key", ex);
            }
            labelChars = key.getLabel().getCharArrayValue();
            P11ObjectIdentifier objId = new P11ObjectIdentifier(id, new String(labelChars));
            P11IdentityId entityId = new P11IdentityId(this.slotId, objId, null, null);
            IaikP11Identity iaikP11Identity = new IaikP11Identity(this, entityId, key);
            return iaikP11Identity;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11Identity generateRSAKeypair0(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) throws P11TokenException {
        long mech = 0L;
        this.assertMechanismSupported(mech);
        RSAPrivateKey privateKey = new RSAPrivateKey();
        RSAPublicKey publicKey = new RSAPublicKey();
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        publicKey.getModulusBits().setLongValue(Long.valueOf(keysize));
        if (publicExponent != null) {
            publicKey.getPublicExponent().setByteArrayValue(publicExponent.toByteArray());
        }
        return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    @Override
    protected P11Identity generateDSAKeypair0(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) throws P11TokenException {
        long mech = 16L;
        this.assertMechanismSupported(mech);
        DSAPrivateKey privateKey = new DSAPrivateKey();
        DSAPublicKey publicKey = new DSAPublicKey();
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        publicKey.getPrime().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)p));
        publicKey.getSubprime().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)q));
        publicKey.getBase().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)g));
        return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    @Override
    protected P11Identity generateECEdwardsKeypair0(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws P11TokenException {
        byte[] encodedCurveId;
        long mech = 4181L;
        this.assertMechanismSupported(mech);
        ECPrivateKey privateKey = new ECPrivateKey(Key.KeyType.EC_EDWARDS.longValue());
        ECPublicKey publicKey = new ECPublicKey(Key.KeyType.EC_EDWARDS.longValue());
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        publicKey.getEcdsaParams().setByteArrayValue(encodedCurveId);
        return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    @Override
    protected P11Identity generateECMontgomeryKeypair0(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws P11TokenException {
        byte[] encodedCurveId;
        long mech = 4182L;
        this.assertMechanismSupported(mech);
        ECPrivateKey privateKey = new ECPrivateKey(Key.KeyType.EC_MONTGOMERY.longValue());
        ECPublicKey publicKey = new ECPublicKey(Key.KeyType.EC_MONTGOMERY.longValue());
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        publicKey.getEcdsaParams().setByteArrayValue(encodedCurveId);
        return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    @Override
    protected P11Identity generateECKeypair0(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws P11TokenException {
        byte[] encodedCurveId;
        long mech = 4160L;
        this.assertMechanismSupported(mech);
        ECPrivateKey privateKey = new ECPrivateKey();
        ECPublicKey publicKey = new ECPublicKey();
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        try {
            publicKey.getEcdsaParams().setByteArrayValue(encodedCurveId);
            return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
        }
        catch (P11TokenException ex) {
            X9ECParameters ecParams = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveId);
            if (ecParams == null) {
                throw new IllegalArgumentException("could not get X9ECParameters for curve " + curveId.getId());
            }
            try {
                publicKey.getEcdsaParams().setByteArrayValue(ecParams.getEncoded());
            }
            catch (IOException ex2) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
            return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
        }
    }

    @Override
    protected P11Identity generateSM2Keypair0(P11Slot.P11NewKeyControl control) throws P11TokenException {
        long mech = PKCS11Constants.CKM_VENDOR_SM2_KEY_PAIR_GEN;
        this.assertMechanismSupported(mech);
        ECPrivateKey privateKey = new ECPrivateKey(Key.KeyType.VENDOR_SM2.longValue());
        ECPublicKey publicKey = new ECPublicKey(Key.KeyType.VENDOR_SM2.longValue());
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey);
        return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P11Identity generateKeyPair(long mech, byte[] id, PrivateKey privateKeyTemplate, iaik.pkcs.pkcs11.objects.PublicKey publicKeyTemplate) throws P11TokenException {
        char[] labelChars = null;
        if (privateKeyTemplate.getLabel() != null) {
            labelChars = privateKeyTemplate.getLabel().getCharArrayValue();
        }
        boolean succ = false;
        try {
            IaikP11Identity iaikP11Identity;
            ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
            try {
                PublicKey jcePublicKey;
                KeyPair keypair;
                Session session = (Session)bagEntry.value();
                if (labelChars != null && IaikP11Slot.labelExists(session, labelChars)) {
                    throw new IllegalArgumentException("label " + new String(labelChars) + " exists, please specify another one");
                }
                if (id == null) {
                    id = this.generateId(session);
                }
                privateKeyTemplate.getId().setByteArrayValue(id);
                publicKeyTemplate.getId().setByteArrayValue(id);
                try {
                    keypair = session.generateKeyPair(Mechanism.get((long)mech), (PKCS11Object)publicKeyTemplate, (PKCS11Object)privateKeyTemplate);
                    labelChars = keypair.getPrivateKey().getLabel().getCharArrayValue();
                }
                catch (TokenException ex) {
                    throw new P11TokenException("could not generate keypair " + Functions.mechanismCodeToString((long)mech), ex);
                }
                String publicKeyLabel = new String(keypair.getPublicKey().getLabel().getCharArrayValue());
                P11ObjectIdentifier objId = new P11ObjectIdentifier(id, new String(labelChars));
                try {
                    jcePublicKey = IaikP11Slot.generatePublicKey(keypair.getPublicKey());
                }
                catch (XiSecurityException ex) {
                    throw new P11TokenException("could not generate public key " + objId, ex);
                }
                PrivateKey privateKey2 = this.getPrivateKeyObject(session, id, labelChars);
                if (privateKey2 == null) {
                    throw new P11TokenException("could not read the generated private key");
                }
                X509PublicKeyCertificate cert2 = this.getCertificateObject(session, id, null);
                String certLabel = null;
                X509Certificate[] certs = null;
                if (cert2 != null) {
                    certLabel = new String(cert2.getLabel().getCharArrayValue());
                    certs = new X509Certificate[1];
                    try {
                        certs[0] = X509Util.parseCert(cert2.getValue().getByteArrayValue());
                    }
                    catch (CertificateException ex) {
                        throw new P11TokenException("coult not parse certifcate", ex);
                    }
                }
                P11IdentityId entityId = new P11IdentityId(this.slotId, objId, publicKeyLabel, certLabel);
                IaikP11Identity ret = new IaikP11Identity(this, entityId, privateKey2, jcePublicKey, certs);
                succ = true;
                iaikP11Identity = ret;
            }
            catch (Throwable throwable) {
                this.sessions.requite(bagEntry);
                throw throwable;
            }
            this.sessions.requite(bagEntry);
            return iaikP11Identity;
        }
        finally {
            if (!(succ || id == null && labelChars == null)) {
                try {
                    this.removeObjects(id, labelChars);
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not remove objects");
                }
            }
        }
    }

    private X509PublicKeyCertificate createPkcs11Template(Session session, X509Cert cert, P11Slot.P11NewObjectControl control) throws P11TokenException {
        X509PublicKeyCertificate newCertTemp = new X509PublicKeyCertificate();
        byte[] id = control.getId();
        if (id == null) {
            id = this.generateId(session);
        }
        newCertTemp.getId().setByteArrayValue(id);
        if (!this.newObjectConf.isIgnoreLabel()) {
            newCertTemp.getLabel().setCharArrayValue(control.getLabel().toCharArray());
        }
        newCertTemp.getToken().setBooleanValue(Boolean.valueOf(true));
        newCertTemp.getCertificateType().setLongValue(Certificate.CertificateType.X_509_PUBLIC_KEY);
        Set<Long> setCertAttributes = this.newObjectConf.getSetCertObjectAttributes();
        if (setCertAttributes.contains(257L)) {
            newCertTemp.getSubject().setByteArrayValue(cert.getCert().getSubjectX500Principal().getEncoded());
        }
        if (setCertAttributes.contains(129L)) {
            newCertTemp.getIssuer().setByteArrayValue(cert.getCert().getIssuerX500Principal().getEncoded());
        }
        if (setCertAttributes.contains(130L)) {
            newCertTemp.getSerialNumber().setByteArrayValue(cert.getCert().getSerialNumber().toByteArray());
        }
        if (setCertAttributes.contains(272L)) {
            newCertTemp.getStartDate().setDateValue(cert.getCert().getNotBefore());
        }
        if (setCertAttributes.contains(273L)) {
            newCertTemp.getStartDate().setDateValue(cert.getCert().getNotAfter());
        }
        newCertTemp.getValue().setByteArrayValue(cert.getEncodedCert());
        return newCertTemp;
    }

    private void setKeyAttributes(P11Slot.P11NewKeyControl control, iaik.pkcs.pkcs11.objects.PublicKey publicKey, PrivateKey privateKey) {
        if (privateKey != null) {
            privateKey.getToken().setBooleanValue(Boolean.valueOf(true));
            if (!this.newObjectConf.isIgnoreLabel()) {
                privateKey.getLabel().setCharArrayValue(control.getLabel().toCharArray());
            }
            privateKey.getPrivate().setBooleanValue(Boolean.valueOf(true));
            if (control.getExtractable() != null) {
                privateKey.getExtractable().setBooleanValue(control.getExtractable());
            }
            if (control.getSensitive() != null) {
                privateKey.getSensitive().setBooleanValue(control.getSensitive());
            }
            Set<P11Slot.P11KeyUsage> usages = control.getUsages();
            Boolean TRUE = Boolean.TRUE;
            if (CollectionUtil.isNotEmpty(usages)) {
                for (P11Slot.P11KeyUsage usage : usages) {
                    switch (usage) {
                        case DECRYPT: {
                            privateKey.getDecrypt().setBooleanValue(TRUE);
                            break;
                        }
                        case DERIVE: {
                            privateKey.getDerive().setBooleanValue(TRUE);
                            break;
                        }
                        case SIGN: {
                            privateKey.getSign().setBooleanValue(TRUE);
                            break;
                        }
                        case SIGN_RECOVER: {
                            privateKey.getSignRecover().setBooleanValue(TRUE);
                            break;
                        }
                        case UNWRAP: {
                            privateKey.getUnwrap().setBooleanValue(TRUE);
                            break;
                        }
                    }
                }
            } else {
                long keyType = privateKey.getKeyType().getLongValue();
                if (keyType == 3L || keyType == 0L || keyType == 1L || keyType == PKCS11Constants.CKK_VENDOR_SM2) {
                    privateKey.getSign().setBooleanValue(TRUE);
                }
                if (keyType == 0L) {
                    privateKey.getUnwrap().setBooleanValue(TRUE);
                    privateKey.getDecrypt().setBooleanValue(TRUE);
                }
            }
        }
        if (publicKey != null) {
            publicKey.getToken().setBooleanValue(Boolean.valueOf(true));
            if (!this.newObjectConf.isIgnoreLabel()) {
                publicKey.getLabel().setCharArrayValue(control.getLabel().toCharArray());
            }
            publicKey.getVerify().setBooleanValue(Boolean.valueOf(true));
        }
    }

    @Override
    protected void updateCertificate0(P11ObjectIdentifier keyId, X509Certificate newCert) throws P11TokenException {
        try {
            this.removeCerts(keyId);
        }
        catch (P11UnknownEntityException p11UnknownEntityException) {
            // empty catch block
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        P11Slot.P11NewObjectControl control = new P11Slot.P11NewObjectControl(keyId.getId(), keyId.getLabel());
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            X509PublicKeyCertificate newCertTemp = this.createPkcs11Template(session, new X509Cert(newCert), control);
            session.createObject((PKCS11Object)newCertTemp);
        }
        catch (TokenException ex) {
            throw new P11TokenException("could not createObject: " + ex.getMessage(), ex);
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    private X509PublicKeyCertificate[] getCertificateObjects(Session session, byte[] keyId, char[] keyLabel) throws P11TokenException {
        List<Storage> tmpObjects;
        X509PublicKeyCertificate template = new X509PublicKeyCertificate();
        if (keyId != null) {
            template.getId().setByteArrayValue(keyId);
        }
        if (keyLabel != null) {
            template.getLabel().setCharArrayValue(keyLabel);
        }
        if (CollectionUtil.isEmpty(tmpObjects = IaikP11Slot.getObjects(session, (Storage)template))) {
            LOG.info("found no certificate identified by {}", (Object)IaikP11Slot.getDescription(keyId, keyLabel));
            return null;
        }
        int size = tmpObjects.size();
        X509PublicKeyCertificate[] certs = new X509PublicKeyCertificate[size];
        for (int i = 0; i < size; ++i) {
            certs[i] = (X509PublicKeyCertificate)tmpObjects.get(i);
        }
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeIdentity0(P11IdentityId identityId) throws P11TokenException {
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            X509PublicKeyCertificate[] certs;
            P11ObjectIdentifier certId;
            Session session = (Session)bagEntry.value();
            P11ObjectIdentifier keyId = identityId.getKeyId();
            byte[] id = keyId.getId();
            char[] label = keyId.getLabelChars();
            SecretKey secretKey = this.getSecretKeyObject(session, id, label);
            if (secretKey != null) {
                try {
                    session.destroyObject((PKCS11Object)secretKey);
                }
                catch (TokenException ex) {
                    String msg = "could not delete secret key " + keyId;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                    throw new P11TokenException(msg);
                }
            }
            if (this.vendor != IaikP11Module.Vendor.YUBIKEY) {
                iaik.pkcs.pkcs11.objects.PublicKey pubKey;
                P11ObjectIdentifier pubKeyId;
                PrivateKey privKey = this.getPrivateKeyObject(session, id, label);
                if (privKey != null) {
                    try {
                        session.destroyObject((PKCS11Object)privKey);
                    }
                    catch (TokenException ex) {
                        String msg = "could not delete private key " + keyId;
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new P11TokenException(msg);
                    }
                }
                if ((pubKeyId = identityId.getPublicKeyId()) != null && (pubKey = this.getPublicKeyObject(session, pubKeyId.getId(), pubKeyId.getLabelChars())) != null) {
                    try {
                        session.destroyObject((PKCS11Object)pubKey);
                    }
                    catch (TokenException ex) {
                        String msg = "could not delete public key " + pubKeyId;
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new P11TokenException(msg);
                    }
                }
            }
            if ((certId = identityId.getCertId()) != null && (certs = this.getCertificateObjects(session, certId.getId(), certId.getLabelChars())) != null && certs.length > 0) {
                for (int i = 0; i < certs.length; ++i) {
                    try {
                        session.destroyObject((PKCS11Object)certs[i]);
                        continue;
                    }
                    catch (TokenException ex) {
                        String msg = "could not delete certificate " + certId;
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new P11TokenException(msg);
                    }
                }
            }
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    private byte[] generateId(Session session) throws P11TokenException {
        byte[] keyId = null;
        do {
            keyId = new byte[this.newObjectConf.getIdLength()];
            this.random.nextBytes(keyId);
        } while (this.idExists(session, keyId));
        return keyId;
    }

    private boolean idExists(Session session, byte[] id) throws P11TokenException {
        PKCS11Object[] objects;
        if (this.existsIdentityForId(id) || this.existsCertForId(id)) {
            return true;
        }
        Key key = new Key();
        key.getId().setByteArrayValue(id);
        try {
            session.findObjectsInit((PKCS11Object)key);
            objects = session.findObjects(1);
            if (objects.length > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            try {
                session.findObjectsFinal();
            }
            catch (TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"session.findObjectsFinal() failed");
            }
        }
        X509PublicKeyCertificate cert = new X509PublicKeyCertificate();
        cert.getId().setByteArrayValue(id);
        try {
            session.findObjectsInit((PKCS11Object)cert);
            objects = session.findObjects(1);
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            try {
                session.findObjectsFinal();
            }
            catch (TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"session.findObjectsFinal() failed");
            }
        }
        return objects.length > 0;
    }

    private static boolean labelExists(Session session, char[] keyLabel) throws P11TokenException {
        PKCS11Object[] objects;
        Args.notNull((Object)keyLabel, (String)"keyLabel");
        Key key = new Key();
        key.getLabel().setCharArrayValue(keyLabel);
        try {
            session.findObjectsInit((PKCS11Object)key);
            objects = session.findObjects(1);
            if (objects.length > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            try {
                session.findObjectsFinal();
            }
            catch (TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"session.findObjectsFinal() failed");
            }
        }
        X509PublicKeyCertificate cert = new X509PublicKeyCertificate();
        cert.getLabel().setCharArrayValue(keyLabel);
        try {
            session.findObjectsInit((PKCS11Object)cert);
            objects = session.findObjects(1);
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            try {
                session.findObjectsFinal();
            }
            catch (TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"session.findObjectsFinal() failed");
            }
        }
        return objects.length > 0;
    }

    private static void logPkcs11ObjectAttributes(String prefix, PKCS11Object p11Object) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        Hashtable table = p11Object.getAttributeTable();
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
        }
        Enumeration keys = table.keys();
        while (keys.hasMoreElements()) {
            Attribute attr = p11Object.getAttribute(((Long)keys.nextElement()).longValue());
            sb.append("\n  ").append(attr.toString(true));
        }
        LOG.debug(sb.toString());
    }
}

