/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.math.BigInteger;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.util.BigIntegers;
import org.xipki.util.Hex;

public class GMUtil {
    private static final byte[] defaultIDA = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 49, 50, 51, 52, 53, 54, 55, 56};
    private static final BigInteger sm2primev2CurveA = new BigInteger(1, Hex.decode((String)"28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93"));

    private GMUtil() {
    }

    public static byte[] getSM2Z(ASN1ObjectIdentifier curveOid, BigInteger pubPointX, BigInteger pubPointY) {
        return GMUtil.getSM2Z(defaultIDA, curveOid, pubPointX, pubPointY);
    }

    public static byte[] getDefaultIDA() {
        return (byte[])defaultIDA.clone();
    }

    public static byte[] getSM2Z(byte[] userID, ASN1ObjectIdentifier curveOid, BigInteger pubPointX, BigInteger pubPointY) {
        SM3Digest digest = new SM3Digest();
        GMUtil.addUserId((Digest)digest, userID);
        X9ECParameters ecParams = GMNamedCurves.getByOID((ASN1ObjectIdentifier)curveOid);
        GMUtil.addFieldElement((Digest)digest, ecParams.getCurve().getA());
        GMUtil.addFieldElement((Digest)digest, ecParams.getCurve().getB());
        GMUtil.addFieldElement((Digest)digest, ecParams.getG().getAffineXCoord());
        GMUtil.addFieldElement((Digest)digest, ecParams.getG().getAffineYCoord());
        int fieldSize = (ecParams.getCurve().getFieldSize() + 7) / 8;
        byte[] bytes = BigIntegers.asUnsignedByteArray((int)fieldSize, (BigInteger)pubPointX);
        digest.update(bytes, 0, fieldSize);
        bytes = BigIntegers.asUnsignedByteArray((int)fieldSize, (BigInteger)pubPointY);
        digest.update(bytes, 0, fieldSize);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }

    private static void addUserId(Digest digest, byte[] userId) {
        int len = userId.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userId, 0, userId.length);
    }

    private static void addFieldElement(Digest digest, ECFieldElement element) {
        byte[] encoded = element.getEncoded();
        digest.update(encoded, 0, encoded.length);
    }

    public static boolean isSm2primev2Curve(EllipticCurve curve) {
        return curve.getB().equals(sm2primev2CurveA);
    }

    public static boolean isSm2primev2Curve(ECCurve curve) {
        return curve.getB().toBigInteger().equals(sm2primev2CurveA);
    }
}

