/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;

public class EdECConstants {
    private static final ASN1ObjectIdentifier id_edwards_curve_algs = new ASN1ObjectIdentifier("1.3.101");
    public static final ASN1ObjectIdentifier id_X25519 = id_edwards_curve_algs.branch("110").intern();
    public static final ASN1ObjectIdentifier id_X448 = id_edwards_curve_algs.branch("111").intern();
    public static final ASN1ObjectIdentifier id_Ed25519 = id_edwards_curve_algs.branch("112").intern();
    public static final ASN1ObjectIdentifier id_Ed448 = id_edwards_curve_algs.branch("113").intern();
    public static final String X25519 = "X25519";
    public static final String Ed25519 = "Ed25519";
    public static final String X448 = "X448";
    public static final String Ed448 = "Ed448";

    private EdECConstants() {
    }

    public static boolean isEdwardsCurve(ASN1ObjectIdentifier curveOid) {
        return id_Ed25519.equals((ASN1Primitive)curveOid) || id_Ed448.equals((ASN1Primitive)curveOid);
    }

    public static boolean isMontgomeryCurve(ASN1ObjectIdentifier curveOid) {
        return id_X25519.equals((ASN1Primitive)curveOid) || id_X448.equals((ASN1Primitive)curveOid);
    }

    public static boolean isEdwardsOrMontgomeryCurve(ASN1ObjectIdentifier curveOid) {
        return EdECConstants.isEdwardsCurve(curveOid) || EdECConstants.isMontgomeryCurve(curveOid);
    }

    public static int getKeyBitSize(ASN1ObjectIdentifier curveOid) {
        if (id_X25519.equals((ASN1Primitive)curveOid)) {
            return 256;
        }
        if (id_X448.equals((ASN1Primitive)curveOid)) {
            return 448;
        }
        if (id_Ed25519.equals((ASN1Primitive)curveOid)) {
            return 256;
        }
        if (id_Ed448.equals((ASN1Primitive)curveOid)) {
            return 448;
        }
        return 0;
    }

    public static int getPublicKeyByteSize(ASN1ObjectIdentifier curveOid) {
        if (id_X25519.equals((ASN1Primitive)curveOid)) {
            return 32;
        }
        if (id_X448.equals((ASN1Primitive)curveOid)) {
            return 56;
        }
        if (id_Ed25519.equals((ASN1Primitive)curveOid)) {
            return 32;
        }
        if (id_Ed448.equals((ASN1Primitive)curveOid)) {
            return 57;
        }
        return 0;
    }

    public static String getName(ASN1ObjectIdentifier curveOid) {
        if (id_X25519.equals((ASN1Primitive)curveOid)) {
            return X25519;
        }
        if (id_X448.equals((ASN1Primitive)curveOid)) {
            return X448;
        }
        if (id_Ed25519.equals((ASN1Primitive)curveOid)) {
            return Ed25519;
        }
        if (id_Ed448.equals((ASN1Primitive)curveOid)) {
            return Ed448;
        }
        return null;
    }

    public static ASN1ObjectIdentifier getCurveOid(String curveName) {
        if (X25519.equalsIgnoreCase(curveName) || id_X25519.getId().equals(curveName)) {
            return id_X25519;
        }
        if (X448.equalsIgnoreCase(curveName) || id_X448.getId().equals(curveName)) {
            return id_X448;
        }
        if (Ed25519.equalsIgnoreCase(curveName) || id_Ed25519.getId().equals(curveName)) {
            return id_Ed25519;
        }
        if (Ed448.equalsIgnoreCase(curveName) || id_Ed448.getId().equals(curveName)) {
            return id_Ed448;
        }
        return null;
    }
}

