/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import com.alibaba.fastjson.annotation.JSONField;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.Base64;
import org.xipki.util.InvalidConfException;
import org.xipki.util.StringUtil;
import org.xipki.util.ValidatableConf;

public class X509ExtensionType
extends ValidatableConf {
    private DescribableOid type;
    private ConstantExtnValue constant;

    public DescribableOid getType() {
        return this.type;
    }

    public void setType(DescribableOid type) {
        this.type = type;
    }

    public ConstantExtnValue getConstant() {
        return this.constant;
    }

    public void setConstant(ConstantExtnValue constant) {
        this.constant = constant;
    }

    public void validate() throws InvalidConfException {
        X509ExtensionType.notNull((Object)((Object)this.type), (String)"type");
        X509ExtensionType.notNull((Object)((Object)this.constant), (String)"constant");
        X509ExtensionType.validate((ValidatableConf)this.type);
        X509ExtensionType.validate((ValidatableConf)this.constant);
    }

    public static class Tag
    extends ValidatableConf {
        private int value;
        private boolean explicit;

        private Tag() {
        }

        public Tag(int value, boolean explicit) {
            this.value = value;
            this.explicit = explicit;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public boolean isExplicit() {
            return this.explicit;
        }

        public void setExplicit(boolean explicit) {
            this.explicit = explicit;
        }

        public void validate() throws InvalidConfException {
            if (this.value < 0) {
                throw new InvalidConfException("value may not be negative");
            }
        }

        public int hashCode() {
            return this.value + 31 * Boolean.valueOf(this.explicit).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)((Object)obj);
            return this.value == other.value && this.explicit == other.explicit;
        }
    }

    public static enum FieldType {
        TeletexString("TeletexString"),
        PrintableString("PrintableString"),
        UTF8String("UTF8String"),
        BMPString("BMPString"),
        IA5String("IA5String"),
        NULL("NULL"),
        INTEGER("INTEGER"),
        ENUMERATED("ENUMERATED"),
        GeneralizedTime("GeneralizedTime"),
        UTCTime("UTCTime"),
        BOOLEAN("BOOLEAN"),
        BIT_STRING("BIT STRING"),
        OCTET_STRING("OCTET STRING"),
        OID("OID"),
        Name("Name"),
        SEQUENCE("SEQUENCE"),
        SEQUENCE_OF("SEQUENCE OF"),
        SET("SET"),
        SET_OF("SET OF"),
        RAW("RAW");

        private final String text;

        private FieldType(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class ConstantExtnValue
    extends ValidatableConf {
        @JSONField(ordinal=1)
        private FieldType type;
        @JSONField(ordinal=2)
        private String description;
        @JSONField(ordinal=3)
        private Tag tag;
        @JSONField(ordinal=4)
        private String value;
        @JSONField(ordinal=5)
        private List<ConstantExtnValue> listValue;

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @JSONField(name="type")
        public String getTypeText() {
            return this.type.getText();
        }

        private ConstantExtnValue() {
        }

        public ConstantExtnValue(FieldType type) {
            this.type = (FieldType)((Object)Args.notNull((Object)((Object)type), (String)"type"));
        }

        @JSONField(name="type")
        public void setTypeText(String text) {
            if (text == null) {
                this.type = null;
            } else {
                this.type = null;
                for (FieldType m : FieldType.values()) {
                    if (!m.name().equalsIgnoreCase(text) && !m.getText().equalsIgnoreCase(text)) continue;
                    this.type = m;
                }
                if (this.type == null) {
                    throw new IllegalArgumentException("invalid type " + (Object)((Object)this.type));
                }
            }
        }

        public Tag getTag() {
            return this.tag;
        }

        public void setTag(Tag tag) {
            this.tag = tag;
        }

        public FieldType type() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public List<ConstantExtnValue> getListValue() {
            return this.listValue;
        }

        public void setListValue(List<ConstantExtnValue> listValue) {
            this.listValue = listValue;
        }

        public ASN1Encodable toASN1Encodable() throws InvalidConfException {
            DERNull rv;
            switch (this.type) {
                case BIT_STRING: {
                    rv = new DERBitString(Base64.decode((String)this.value));
                    break;
                }
                case BOOLEAN: {
                    rv = ASN1Boolean.getInstance((boolean)Boolean.parseBoolean(this.value));
                    break;
                }
                case BMPString: {
                    rv = new DERBMPString(this.value);
                    break;
                }
                case IA5String: {
                    rv = new DERIA5String(this.value);
                    break;
                }
                case INTEGER: 
                case ENUMERATED: {
                    BigInteger bi = StringUtil.startsWithIgnoreCase((String)this.value, (String)"0x") ? new BigInteger(this.value.substring(2), 16) : new BigInteger(this.value);
                    rv = this.type == FieldType.INTEGER ? new ASN1Integer(bi) : new ASN1Enumerated(bi);
                    break;
                }
                case GeneralizedTime: {
                    rv = new ASN1GeneralizedTime(this.value);
                    break;
                }
                case UTCTime: {
                    rv = new ASN1UTCTime(this.value);
                    break;
                }
                case NULL: {
                    rv = DERNull.INSTANCE;
                    break;
                }
                case OCTET_STRING: {
                    rv = new DEROctetString(Base64.decode((String)this.value));
                    break;
                }
                case OID: {
                    rv = new ASN1ObjectIdentifier(this.value);
                    break;
                }
                case PrintableString: {
                    rv = new DERPrintableString(this.value);
                    break;
                }
                case RAW: {
                    ASN1StreamParser parser = new ASN1StreamParser(Base64.decode((String)this.value));
                    try {
                        rv = parser.readObject();
                        break;
                    }
                    catch (IOException ex) {
                        throw new InvalidConfException("could not parse the constant extension value", (Throwable)ex);
                    }
                }
                case TeletexString: {
                    rv = new DERT61String(this.value);
                    break;
                }
                case UTF8String: {
                    rv = new DERUTF8String(this.value);
                    break;
                }
                case Name: {
                    rv = X509Util.reverse(new X500Name(this.value));
                    break;
                }
                case SEQUENCE: 
                case SEQUENCE_OF: 
                case SET: 
                case SET_OF: {
                    ASN1EncodableVector v = new ASN1EncodableVector();
                    for (ConstantExtnValue m : this.listValue) {
                        v.add(m.toASN1Encodable());
                    }
                    rv = FieldType.SEQUENCE == this.type || FieldType.SEQUENCE_OF == this.type ? new DERSequence(v) : new DERSet(v);
                    break;
                }
                default: {
                    throw new RuntimeException("should not reach here, unknown type " + (Object)((Object)this.type));
                }
            }
            return this.tag == null ? rv : new DERTaggedObject(this.tag.isExplicit(), this.tag.getValue(), (ASN1Encodable)rv);
        }

        public void validate() throws InvalidConfException {
            ConstantExtnValue.notNull((Object)((Object)this.type), (String)"type");
            ConstantExtnValue.validate((ValidatableConf)this.tag);
            if (FieldType.NULL == this.type) {
                if (this.value != null) {
                    throw new InvalidConfException("value may not be non-null");
                }
            } else if (FieldType.SEQUENCE == this.type || FieldType.SET == this.type || FieldType.SEQUENCE_OF == this.type || FieldType.SET_OF == this.type) {
                if (this.value != null) {
                    throw new InvalidConfException("value may not be non-null");
                }
                ConstantExtnValue.notEmpty(this.listValue, (String)"values");
                for (ConstantExtnValue m : this.listValue) {
                    m.validate();
                }
                if (this.listValue.size() > 1) {
                    HashSet<Integer> tags = new HashSet<Integer>();
                    for (ConstantExtnValue m : this.listValue) {
                        if (m.getTag() == null || tags.add(m.getTag().getValue())) continue;
                        throw new InvalidConfException("duplicated definition of tag " + m.getTag().getValue());
                    }
                }
            } else {
                if (this.listValue != null) {
                    throw new InvalidConfException("values may not be non-null");
                }
                ConstantExtnValue.notNull((Object)this.value, (String)"value");
            }
        }
    }

    public static class DescribableOid
    extends ValidatableConf {
        @JSONField(ordinal=1)
        private String oid;
        @JSONField(ordinal=2)
        private String description;

        public String getOid() {
            return this.oid;
        }

        public void setOid(String oid) {
            this.oid = oid;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void validate() throws InvalidConfException {
            DescribableOid.notNull((Object)this.oid, (String)"oid");
        }
    }

    public static class ExtensionsType
    extends ValidatableConf {
        private List<X509ExtensionType> extensions;

        public List<X509ExtensionType> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<X509ExtensionType> extensions) {
            this.extensions = extensions;
        }

        public void validate() throws InvalidConfException {
            for (X509ExtensionType m : this.extensions) {
                m.validate();
            }
        }
    }
}

