/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.asn1;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Certificate;
import org.xipki.security.asn1.Asn1StreamParser;
import org.xipki.util.Args;

public class CrlCertSetStreamParser
extends Asn1StreamParser {
    private BufferedInputStream instream;
    private int endIndex;
    private int offset;

    public CrlCertSetStreamParser(InputStream instream) throws IOException {
        Args.notNull((Object)instream, (String)"instream");
        this.instream = instream instanceof BufferedInputStream ? (BufferedInputStream)instream : new BufferedInputStream(instream);
        int tag = CrlCertSetStreamParser.markAndReadTag(instream);
        CrlCertSetStreamParser.assertTag(49, tag, "Xipki-CrlCertSet");
        Asn1StreamParser.MyInt lenBytesSize = new Asn1StreamParser.MyInt();
        int length = CrlCertSetStreamParser.readLength(lenBytesSize, instream);
        this.offset = 1 + lenBytesSize.get();
        this.endIndex = this.offset + length;
    }

    public CrlCertsIterator crlCerts() throws IOException {
        return new CrlCertsIterator();
    }

    public class CrlCertsIterator
    implements Iterator<CrlCert>,
    Closeable {
        private CrlCert next;

        private CrlCertsIterator() throws IOException {
            this.next0();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public CrlCert next() {
            if (this.next == null) {
                throw new IllegalStateException("no next object anymore");
            }
            CrlCert ret = this.next;
            this.next0();
            return ret;
        }

        private void next0() {
            byte[] bytes;
            if (CrlCertSetStreamParser.this.offset >= CrlCertSetStreamParser.this.endIndex) {
                this.next = null;
                return;
            }
            try {
                bytes = Asn1StreamParser.readBlock(48, CrlCertSetStreamParser.this.instream, "crlCert");
            }
            catch (IOException ex) {
                throw new IllegalStateException("error reading next crlCert", ex);
            }
            CrlCertSetStreamParser.this.offset = CrlCertSetStreamParser.this.offset + bytes.length;
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)bytes);
            BigInteger serialNumber = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
            Certificate cert = null;
            int size = seq.size();
            block5: for (int j = 1; j < size; ++j) {
                ASN1TaggedObject taggedObj = DERTaggedObject.getInstance((Object)seq.getObjectAt(j));
                int tagNo = taggedObj.getTagNo();
                switch (tagNo) {
                    case 0: {
                        cert = Certificate.getInstance((Object)taggedObj.getObject());
                        continue block5;
                    }
                }
            }
            this.next = new CrlCert(serialNumber, cert);
        }

        @Override
        public void close() throws IOException {
            if (CrlCertSetStreamParser.this.instream != null) {
                CrlCertSetStreamParser.this.instream.close();
            }
            CrlCertSetStreamParser.this.instream = null;
        }
    }

    public static class CrlCert {
        private BigInteger serial;
        private Certificate cert;

        private CrlCert(BigInteger serial, Certificate cert) {
            this.serial = serial;
            this.cert = cert;
        }

        public BigInteger getSerial() {
            return this.serial;
        }

        public void setSerial(BigInteger serial) {
            this.serial = serial;
        }

        public Certificate getCert() {
            return this.cert;
        }

        public void setCert(Certificate cert) {
            this.cert = cert;
        }
    }
}

