/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolver;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11CryptServiceFactory;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ModuleFactoryRegister;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.Pkcs11conf;
import org.xipki.util.InvalidConfException;
import org.xipki.util.IoUtil;
import org.xipki.util.StringUtil;

public class P11CryptServiceFactoryImpl
implements P11CryptServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(P11CryptServiceFactoryImpl.class);
    private static final Map<String, P11CryptService> services = new HashMap<String, P11CryptService>();
    private PasswordResolver passwordResolver;
    private Map<String, P11ModuleConf> moduleConfs;
    private Set<String> moduleNames;
    private String pkcs11ConfFile;
    private Pkcs11conf pkcs11Conf;
    private P11ModuleFactoryRegister p11ModuleFactoryRegister;

    public synchronized void init() throws InvalidConfException {
        if (this.moduleConfs != null) {
            return;
        }
        if (this.pkcs11Conf == null && StringUtil.isBlank((String)this.pkcs11ConfFile)) {
            LOG.error("neither pkcs11Conf nor pkcs11ConfFile is configured, could not initialize");
            return;
        }
        if (this.pkcs11Conf == null) {
            try (InputStream confStream = Files.newInputStream(Paths.get(this.pkcs11ConfFile, new String[0]), new OpenOption[0]);){
                this.pkcs11Conf = (Pkcs11conf)((Object)JSON.parseObject((InputStream)confStream, Pkcs11conf.class, (Feature[])new Feature[0]));
                this.pkcs11Conf.validate();
            }
            catch (IOException ex) {
                throw new InvalidConfException("could not create P11Conf: " + ex.getMessage(), (Throwable)ex);
            }
        }
        try {
            List<Pkcs11conf.Module> moduleTypes = this.pkcs11Conf.getModules();
            List<Pkcs11conf.MechanismSet> mechanismSets = this.pkcs11Conf.getMechanismSets();
            HashMap<String, P11ModuleConf> confs = new HashMap<String, P11ModuleConf>();
            for (Pkcs11conf.Module moduleType : moduleTypes) {
                P11ModuleConf conf = new P11ModuleConf(moduleType, mechanismSets, this.passwordResolver);
                confs.put(conf.getName(), conf);
            }
            if (!confs.containsKey("default")) {
                throw new InvalidConfException("module 'default' is not defined");
            }
            this.moduleConfs = Collections.unmodifiableMap(confs);
            this.moduleNames = Collections.unmodifiableSet(new HashSet(confs.keySet()));
        }
        catch (RuntimeException ex) {
            throw new InvalidConfException("could not create P11Conf: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void setP11ModuleFactoryRegister(P11ModuleFactoryRegister p11ModuleFactoryRegister) {
        this.p11ModuleFactoryRegister = p11ModuleFactoryRegister;
    }

    @Override
    public synchronized P11CryptService getP11CryptService(String moduleName) throws XiSecurityException, P11TokenException {
        try {
            this.init();
        }
        catch (InvalidConfException ex) {
            throw new IllegalStateException("could not initialize P11CryptServiceFactory: " + ex.getMessage(), ex);
        }
        if (this.moduleConfs == null) {
            throw new IllegalStateException("please set pkcs11ConfFile and then call init() first");
        }
        String name = this.getModuleName(moduleName);
        P11ModuleConf conf = this.moduleConfs.get(name);
        if (conf == null) {
            throw new XiSecurityException("PKCS#11 module " + name + " is not defined");
        }
        P11CryptService instance = services.get(name);
        if (instance == null) {
            P11Module p11Module = this.p11ModuleFactoryRegister.getP11Module(conf);
            instance = new P11CryptService(p11Module);
            LOG.info("added PKCS#11 module {}\n{}", (Object)name, (Object)instance.getModule().getDescription());
            services.put(name, instance);
        }
        return instance;
    }

    private String getModuleName(String moduleName) {
        return moduleName == null ? "default" : moduleName;
    }

    public void setPkcs11ConfFile(String confFile) {
        this.pkcs11ConfFile = StringUtil.isBlank((String)confFile) ? null : IoUtil.expandFilepath((String)confFile);
        this.pkcs11Conf = null;
    }

    public void setPkcs11Conf(Pkcs11conf conf) throws InvalidConfException {
        if (conf != null) {
            conf.validate();
        }
        this.pkcs11Conf = conf;
        this.pkcs11ConfFile = null;
    }

    public void setPasswordResolver(PasswordResolver passwordResolver) {
        this.passwordResolver = passwordResolver;
    }

    @Override
    public void close() {
        services.clear();
    }

    @Override
    public Set<String> getModuleNames() {
        try {
            this.init();
        }
        catch (InvalidConfException ex) {
            throw new IllegalStateException("could not initialize P11CryptServiceFactory: " + ex.getMessage(), ex);
        }
        return this.moduleNames;
    }
}

