/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfoBuilder;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;
import org.xipki.security.EdECConstants;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.util.Args;

class PrivateKeyCryptor {
    private static final ASN1ObjectIdentifier ALGO = PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC;
    private static final int ITERATION_COUNT = 2048;
    private OutputEncryptor encryptor;
    private InputDecryptorProvider decryptorProvider;

    PrivateKeyCryptor(char[] password) throws P11TokenException {
        Args.notNull((Object)password, (String)"password");
        JcePKCSPBEOutputEncryptorBuilder eb = new JcePKCSPBEOutputEncryptorBuilder(ALGO);
        eb.setProvider("BC");
        eb.setIterationCount(2048);
        try {
            this.encryptor = eb.build(password);
        }
        catch (OperatorCreationException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        JcePKCSPBEInputDecryptorProviderBuilder db = new JcePKCSPBEInputDecryptorProviderBuilder();
        this.decryptorProvider = db.build(password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrivateKey decrypt(PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) throws P11TokenException {
        PrivateKeyInfo privateKeyInfo;
        Args.notNull((Object)encryptedPrivateKeyInfo, (String)"encryptedPrivateKeyInfo");
        InputDecryptorProvider inputDecryptorProvider = this.decryptorProvider;
        synchronized (inputDecryptorProvider) {
            try {
                privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(this.decryptorProvider);
            }
            catch (PKCSException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        AlgorithmIdentifier keyAlg = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier keyAlgOid = keyAlg.getAlgorithm();
        String algoName = PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)keyAlgOid) ? "RSA" : (X9ObjectIdentifiers.id_dsa.equals((ASN1Primitive)keyAlgOid) ? "DSA" : (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)keyAlgOid) ? "EC" : EdECConstants.getName(keyAlg.getAlgorithm())));
        if (algoName == null) {
            throw new P11TokenException("unknown private key algorithm " + keyAlgOid.getId());
        }
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(algoName, "BC");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException ex) {
            throw new P11TokenException(ex.getClass().getName() + ": " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PKCS8EncryptedPrivateKeyInfo encrypt(PrivateKey privateKey) {
        Args.notNull((Object)privateKey, (String)"privateKey");
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        PKCS8EncryptedPrivateKeyInfoBuilder builder = new PKCS8EncryptedPrivateKeyInfoBuilder(privateKeyInfo);
        OutputEncryptor outputEncryptor = this.encryptor;
        synchronized (outputEncryptor) {
            return builder.build(this.encryptor);
        }
    }
}

