/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy;

import java.util.HashMap;
import java.util.Map;

public class P11ProxyConstants {
    public static final short VERSION_V1_0 = 256;
    public static final short RC_SUCCESS = 0;
    public static final short RC_INTERNAL_ERROR = 1;
    public static final short RC_UNSUPPORTED_VERSION = 2;
    public static final short RC_UNSUPPORTED_ACTION = 3;
    public static final short RC_BAD_REQUEST = 4;
    public static final short RC_UNKNOWN_MODULE = 257;
    public static final short RC_UNKNOWN_ENTITY = 258;
    public static final short RC_DUPLICATE_ENTITY = 259;
    public static final short RC_UNSUPPORTED_MECHANISM = 260;
    public static final short RC_P11_TOKENERROR = 261;
    public static final short ACTION_NOPE = 0;
    public static final short ACTION_GET_SERVER_CAPS = 1;
    public static final short ACTION_GET_MECHANISMS = 2;
    public static final short ACTION_GET_PUBLICKEY = 257;
    public static final short ACTION_GET_CERT = 258;
    public static final short ACTION_GET_SLOT_IDS = 259;
    public static final short ACTION_GET_IDENTITY_IDS = 260;
    public static final short ACTION_GET_CERT_IDS = 261;
    public static final short ACTION_GET_PUBLICKEY_IDS = 262;
    public static final short ACTION_SIGN = 288;
    public static final short ACTION_GEN_KEYPAIR_RSA = 304;
    public static final short ACTION_GEN_KEYPAIR_DSA = 305;
    public static final short ACTION_GEN_KEYPAIR_EC = 307;
    public static final short ACTION_DIGEST_SECRETKEY = 308;
    public static final short ACTION_GEN_SECRET_KEY = 309;
    public static final short ACTION_IMPORT_SECRET_KEY = 310;
    public static final short ACTION_ADD_CERT = 320;
    public static final short ACTION_REMOVE_IDENTITY = 321;
    public static final short ACTION_REMOVE_CERTS = 322;
    public static final short ACTION_UPDATE_CERT = 323;
    public static final short ACTION_REMOVE_OBJECTS = 324;
    public static final short ACTION_GEN_KEYPAIR_SM2 = 325;
    public static final short ACTION_GEN_KEYPAIR_EC_EDWARDS = 326;
    public static final short ACTION_GEN_KEYPAIR_EC_MONTGOMERY = 327;
    private static final Map<Short, String> rcMap = new HashMap<Short, String>();
    private static final Map<Short, String> actionMap;

    private P11ProxyConstants() {
    }

    public static String getReturnCodeName(short rc) {
        String name = rcMap.get(rc);
        return name == null ? "0x" + Integer.toString(rc, 16) : name;
    }

    public static String getActionName(short action) {
        String name = actionMap.get(action);
        return name == null ? "0x" + Integer.toString(action, 16) : name;
    }

    static {
        rcMap.put((short)4, "RC_BAD_REQUEST");
        rcMap.put((short)259, "RC_DUPLICATE_ENTITY");
        rcMap.put((short)1, "RC_INTERNAL_ERROR");
        rcMap.put((short)261, "RC_P11_TOKENERROR");
        rcMap.put((short)0, "RC_SUCCESS");
        rcMap.put((short)258, "RC_UNKNOWN_ENTITY");
        rcMap.put((short)257, "RC_UNKNOWN_MODULE");
        rcMap.put((short)3, "RC_UNSUPPORTED_ACTION");
        rcMap.put((short)260, "RC_UNSUPPORTED_MECHANISM");
        rcMap.put((short)2, "RC_UNSUPPORTED_VERSION");
        actionMap = new HashMap<Short, String>();
        actionMap.put((short)0, "ACTION_NOPE");
        actionMap.put((short)1, "ACTION_GET_SERVER_CAPS");
        actionMap.put((short)257, "ACTION_GET_PUBLICKEY");
        actionMap.put((short)258, "ACTION_GET_CERT");
        actionMap.put((short)259, "ACTION_GET_SLOT_IDS");
        actionMap.put((short)260, "ACTION_GET_IDENTITY_IDS");
        actionMap.put((short)261, "ACTION_GET_CERT_IDS");
        actionMap.put((short)2, "ACTION_GET_MECHANISMS");
        actionMap.put((short)288, "ACTION_SIGN");
        actionMap.put((short)304, "ACTION_GEN_KEYPAIR_RSA");
        actionMap.put((short)305, "ACTION_GEN_KEYPAIR_DSA");
        actionMap.put((short)307, "ACTION_GEN_KEYPAIR_EC");
        actionMap.put((short)308, "ACTION_DIGEST_SECRETKEY");
        actionMap.put((short)309, "ACTION_GEN_SECRET_KEY");
        actionMap.put((short)310, "ACTION_IMPORT_SECRET_KEY");
        actionMap.put((short)320, "ACTION_ADD_CERT");
        actionMap.put((short)321, "ACTION_REMOVE_IDENTITY");
        actionMap.put((short)322, "ACTION_REMOVE_CERTS");
        actionMap.put((short)323, "ACTION_UPDATE_CERT");
        actionMap.put((short)324, "ACTION_REMOVE_OBJECTS");
        actionMap.put((short)325, "ACTION_GEN_KEYPAIR_SM2");
    }
}

