/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.asn1;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.cms.Time;

public class Asn1StreamParser {
    protected static final int TAG_CONSTRUCTED_SEQUENCE = 48;
    protected static final int TAG_CONSTRUCTED_SET = 49;

    protected static byte[] readBlock(int expectedTag, BufferedInputStream instream, String name) throws IOException {
        instream.mark(10);
        int tag = instream.read();
        Asn1StreamParser.assertTag(expectedTag, tag, name);
        return Asn1StreamParser.readBlock(instream, name);
    }

    protected static byte[] readBlock(BufferedInputStream instream, String name) throws IOException {
        MyInt lenBytesSize = new MyInt();
        int length = Asn1StreamParser.readLength(lenBytesSize, instream);
        instream.reset();
        byte[] bytes = new byte[1 + lenBytesSize.get() + length];
        if (bytes.length != instream.read(bytes)) {
            throw new IOException("error reading " + name);
        }
        return bytes;
    }

    protected static int markAndReadTag(InputStream instream) throws IOException {
        instream.mark(10);
        return instream.read();
    }

    protected static int readLength(MyInt lenBytesSize, InputStream instream) throws IOException {
        int b = instream.read();
        if ((b & 0x80) == 0) {
            lenBytesSize.set(1);
            return b;
        }
        byte[] lengthBytes = new byte[b & 0x7F];
        if (lengthBytes.length > 4) {
            throw new IOException("length too long");
        }
        lenBytesSize.set(1 + lengthBytes.length);
        instream.read(lengthBytes);
        int length = 0xFF & lengthBytes[0];
        for (int i = 1; i < lengthBytes.length; ++i) {
            length = (length << 8) + (0xFF & lengthBytes[i]);
        }
        return length;
    }

    protected static void assertTag(int expectedTag, int tag, String name) {
        if (expectedTag != tag) {
            throw new IllegalArgumentException(String.format("invalid %s: tag is %d, but not expected %d", name, tag, expectedTag));
        }
    }

    protected static Date readTime(ASN1Encodable obj) {
        if (obj instanceof org.bouncycastle.asn1.x509.Time) {
            return ((org.bouncycastle.asn1.x509.Time)obj).getDate();
        }
        if (obj instanceof Time) {
            return ((Time)obj).getDate();
        }
        return org.bouncycastle.asn1.x509.Time.getInstance((Object)obj).getDate();
    }

    protected static Date readTime(MyInt bytesLen, BufferedInputStream instream, String name) throws IOException {
        int tag = Asn1StreamParser.markAndReadTag(instream);
        byte[] bytes = Asn1StreamParser.readBlock(instream, name);
        bytesLen.set(bytes.length);
        try {
            if (tag == 23) {
                return DERUTCTime.getInstance((Object)bytes).getDate();
            }
            if (tag == 24) {
                return DERGeneralizedTime.getInstance((Object)bytes).getDate();
            }
            throw new IllegalArgumentException("invalid tag for " + name + ": " + tag);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("error parsing time", ex);
        }
    }

    protected static void skip(InputStream instream, long count) throws IOException {
        for (long remaining = count; remaining > 0L; remaining -= instream.skip(remaining)) {
        }
    }

    protected static class MyInt {
        private int value;

        protected MyInt() {
        }

        void set(int value) {
            this.value = value;
        }

        int get() {
            return this.value;
        }
    }
}

