/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.bc;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.xipki.security.EdECConstants;
import org.xipki.util.Args;

public class XiEdDSAContentVerifierProvider
implements ContentVerifierProvider {
    private final PublicKey verifyKey;

    public XiEdDSAContentVerifierProvider(PublicKey verifyKey) {
        this.verifyKey = (PublicKey)Args.notNull((Object)verifyKey, (String)"verifyKey");
    }

    public boolean hasAssociatedCertificate() {
        return false;
    }

    public X509CertificateHolder getAssociatedCertificate() {
        return null;
    }

    public ContentVerifier get(AlgorithmIdentifier verifierAlgorithmIdentifier) throws OperatorCreationException {
        return new EdDSAContentVerifier(verifierAlgorithmIdentifier, this.verifyKey);
    }

    private class EdDSAContentVerifier
    implements ContentVerifier {
        private final String algorithm;
        private final AlgorithmIdentifier algId;
        private final ByteArrayOutputStream outstream;
        private final PublicKey verifyKey;

        private EdDSAContentVerifier(AlgorithmIdentifier algId, PublicKey verifyKey) {
            this.algId = algId;
            this.algorithm = EdECConstants.getName(algId.getAlgorithm());
            this.outstream = new ByteArrayOutputStream();
            this.verifyKey = verifyKey;
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algId;
        }

        public OutputStream getOutputStream() {
            this.outstream.reset();
            return this.outstream;
        }

        public boolean verify(byte[] expected) {
            try {
                Signature sig = Signature.getInstance(this.algorithm, "BC");
                sig.initVerify(this.verifyKey);
                sig.update(this.outstream.toByteArray());
                return sig.verify(expected);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
                throw new RuntimeCryptoException(ex.getMessage());
            }
            catch (SignatureException ex) {
                return false;
            }
        }
    }
}

