/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.cmp;

import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPObjectIdentifiers;
import org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import org.bouncycastle.asn1.cmp.PBMParameter;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.crmf.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.cmp.CMPException;
import org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import org.bouncycastle.cert.cmp.ProtectedPKIMessageBuilder;
import org.bouncycastle.cert.crmf.CRMFException;
import org.bouncycastle.cert.crmf.PKMACBuilder;
import org.bouncycastle.cert.crmf.PKMACValuesCalculator;
import org.bouncycastle.cert.crmf.jcajce.JcePKMACValuesCalculator;
import org.bouncycastle.operator.ContentSigner;
import org.xipki.security.ConcurrentBagEntrySigner;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.NoIdleSignerException;
import org.xipki.security.cmp.CmpUtf8Pairs;
import org.xipki.util.Args;

public class CmpUtil {
    private CmpUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PKIMessage addProtection(PKIMessage pkiMessage, ConcurrentContentSigner signer, GeneralName signerName, boolean addSignerCert) throws CMPException, NoIdleSignerException {
        ProtectedPKIMessage signedMessage;
        GeneralName tmpSignerName;
        Args.notNull((Object)pkiMessage, (String)"pkiMessage");
        Args.notNull((Object)signer, (String)"signer");
        if (signerName != null) {
            tmpSignerName = signerName;
        } else {
            if (signer.getCertificate() == null) {
                throw new IllegalArgumentException("signer without certificate is not allowed");
            }
            X500Name x500Name = signer.getCertificate().getSubject();
            tmpSignerName = new GeneralName(x500Name);
        }
        ProtectedPKIMessageBuilder builder = CmpUtil.newProtectedPKIMessageBuilder(pkiMessage, tmpSignerName, null);
        if (addSignerCert) {
            X509CertificateHolder signerCert = signer.getCertificate().toBcCert();
            builder.addCMPCertificate(signerCert);
        }
        ConcurrentBagEntrySigner signer0 = signer.borrowSigner();
        try {
            signedMessage = builder.build((ContentSigner)signer0.value());
        }
        finally {
            signer.requiteSigner(signer0);
        }
        return signedMessage.toASN1Structure();
    }

    public static PKIMessage addProtection(PKIMessage pkiMessage, char[] password, PBMParameter pbmParameter, GeneralName signerName, byte[] senderKid) throws CMPException {
        ProtectedPKIMessage signedMessage;
        ProtectedPKIMessageBuilder builder = CmpUtil.newProtectedPKIMessageBuilder(pkiMessage, signerName, senderKid);
        try {
            PKMACBuilder pkMacBuilder = new PKMACBuilder((PKMACValuesCalculator)new JcePKMACValuesCalculator());
            pkMacBuilder.setParameters(pbmParameter);
            signedMessage = builder.build(pkMacBuilder.build(password));
        }
        catch (CRMFException ex) {
            throw new CMPException(ex.getMessage(), (Throwable)ex);
        }
        return signedMessage.toASN1Structure();
    }

    private static ProtectedPKIMessageBuilder newProtectedPKIMessageBuilder(PKIMessage pkiMessage, GeneralName sender, byte[] senderKid) throws CMPException {
        ASN1OctetString octet;
        InfoTypeAndValue[] generalInfo;
        PKIHeader header = pkiMessage.getHeader();
        ProtectedPKIMessageBuilder builder = new ProtectedPKIMessageBuilder(sender, header.getRecipient());
        PKIFreeText freeText = header.getFreeText();
        if (freeText != null) {
            builder.setFreeText(freeText);
        }
        if ((generalInfo = header.getGeneralInfo()) != null) {
            for (InfoTypeAndValue gi : generalInfo) {
                builder.addGeneralInfo(gi);
            }
        }
        if ((octet = header.getRecipKID()) != null) {
            builder.setRecipKID(octet.getOctets());
        }
        if ((octet = header.getRecipNonce()) != null) {
            builder.setRecipNonce(octet.getOctets());
        }
        if (senderKid != null) {
            builder.setSenderKID(senderKid);
        }
        if ((octet = header.getSenderNonce()) != null) {
            builder.setSenderNonce(octet.getOctets());
        }
        if ((octet = header.getTransactionID()) != null) {
            builder.setTransactionID(octet.getOctets());
        }
        if (header.getMessageTime() != null) {
            builder.setMessageTime(new Date());
        }
        builder.setBody(pkiMessage.getBody());
        return builder;
    }

    public static boolean isImplictConfirm(PKIHeader header) {
        Args.notNull((Object)header, (String)"header");
        InfoTypeAndValue[] regInfos = header.getGeneralInfo();
        if (regInfos != null) {
            for (InfoTypeAndValue regInfo : regInfos) {
                if (!CMPObjectIdentifiers.it_implicitConfirm.equals((ASN1Primitive)regInfo.getInfoType())) continue;
                return true;
            }
        }
        return false;
    }

    public static InfoTypeAndValue getImplictConfirmGeneralInfo() {
        return new InfoTypeAndValue(CMPObjectIdentifiers.it_implicitConfirm, (ASN1Encodable)DERNull.INSTANCE);
    }

    public static CmpUtf8Pairs extract(InfoTypeAndValue[] regInfos) {
        if (regInfos != null) {
            for (InfoTypeAndValue regInfo : regInfos) {
                if (!CMPObjectIdentifiers.regInfo_utf8Pairs.equals((ASN1Primitive)regInfo.getInfoType())) continue;
                String regInfoValue = ((ASN1String)regInfo.getInfoValue()).getString();
                return new CmpUtf8Pairs(regInfoValue);
            }
        }
        return null;
    }

    public static CmpUtf8Pairs extract(AttributeTypeAndValue[] atvs) {
        if (atvs != null) {
            for (AttributeTypeAndValue atv : atvs) {
                if (!CMPObjectIdentifiers.regInfo_utf8Pairs.equals((ASN1Primitive)atv.getType())) continue;
                String regInfoValue = ((ASN1String)atv.getValue()).getString();
                return new CmpUtf8Pairs(regInfoValue);
            }
        }
        return null;
    }

    public static InfoTypeAndValue buildInfoTypeAndValue(CmpUtf8Pairs utf8Pairs) {
        Args.notNull((Object)utf8Pairs, (String)"utf8Pairs");
        return new InfoTypeAndValue(CMPObjectIdentifiers.regInfo_utf8Pairs, (ASN1Encodable)new DERUTF8String(utf8Pairs.encoded()));
    }

    public static AttributeTypeAndValue buildAttributeTypeAndValue(CmpUtf8Pairs utf8Pairs) {
        Args.notNull((Object)utf8Pairs, (String)"utf8Pairs");
        return new AttributeTypeAndValue(CMPObjectIdentifiers.regInfo_utf8Pairs, (ASN1Encodable)new DERUTF8String(utf8Pairs.encoded()));
    }
}

