/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.iaik;

import iaik.pkcs.pkcs11.DefaultInitializeArgs;
import iaik.pkcs.pkcs11.Info;
import iaik.pkcs.pkcs11.InitializeArgs;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.SlotInfo;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.password.PasswordResolverException;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.iaik.IaikP11Slot;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

public class IaikP11Module
extends P11Module {
    public static final String TYPE = "native";
    private static final Logger LOG = LoggerFactory.getLogger(IaikP11Module.class);
    private Module module;
    private String description;

    private IaikP11Module(Module module, P11ModuleConf moduleConf) throws P11TokenException {
        super(moduleConf);
        int size;
        Slot[] slotList;
        this.module = (Module)Args.notNull((Object)module, (String)"module");
        String library = moduleConf.getNativeLibrary();
        try {
            Info info = module.getInfo();
            this.description = StringUtil.concatObjects((Object)"PKCS#11 IAIK", (Object[])new Object[]{"\n\tPath: ", library, "\n\tCryptoki Version: ", info.getCryptokiVersion(), "\n\tManufacturerID: ", info.getManufacturerID(), "\n\tLibrary Description: ", info.getLibraryDescription(), "\n\tLibrary Version: ", info.getLibraryVersion()});
        }
        catch (TokenException ex) {
            this.description = StringUtil.concatObjects((Object)"PKCS#11 IAIK", (Object[])new Object[]{"\n\tPath", moduleConf.getNativeLibrary()});
        }
        try {
            slotList = module.getSlotList(false);
        }
        catch (Throwable th) {
            String msg = "could not getSlotList of module " + moduleConf.getName();
            LogUtil.error((Logger)LOG, (Throwable)th, (String)msg);
            throw new P11TokenException(msg);
        }
        int n = size = slotList == null ? 0 : slotList.length;
        if (size == 0) {
            throw new P11TokenException("no slot could be found");
        }
        for (int i = 0; i < size; ++i) {
            SlotInfo slotInfo;
            Slot slot = slotList[i];
            try {
                slotInfo = slot.getSlotInfo();
            }
            catch (TokenException ex) {
                LOG.error("ignore slot[{}] (id={} with error", (Object)i, (Object)slot.getSlotID());
                slotList[i] = null;
                continue;
            }
            if (slotInfo.isTokenPresent()) continue;
            slotList[i] = null;
            LOG.info("ignore slot[{}] (id={} without token", (Object)i, (Object)slot.getSlotID());
        }
        StringBuilder msg = new StringBuilder();
        HashSet<P11Slot> slots = new HashSet<P11Slot>();
        for (int i = 0; i < slotList.length; ++i) {
            List<char[]> pwd;
            Slot slot = slotList[i];
            if (slot == null) continue;
            P11SlotIdentifier slotId = new P11SlotIdentifier(i, slot.getSlotID());
            if (!moduleConf.isSlotIncluded(slotId)) {
                LOG.info("skipped slot {}", (Object)slotId);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                msg.append("--------------------Slot ").append(i).append("--------------------\n");
                msg.append("id: ").append(slot.getSlotID()).append("\n");
                try {
                    msg.append(slot.getSlotInfo()).append("\n");
                }
                catch (TokenException ex) {
                    msg.append("error: " + ex.getMessage());
                }
            }
            try {
                pwd = moduleConf.getPasswordRetriever().getPassword(slotId);
            }
            catch (PasswordResolverException ex) {
                throw new P11TokenException("PasswordResolverException: " + ex.getMessage(), ex);
            }
            IaikP11Slot p11Slot = new IaikP11Slot(moduleConf.getName(), slotId, slot, moduleConf.isReadOnly(), moduleConf.getUserType(), pwd, moduleConf.getMaxMessageSize(), moduleConf.getP11MechanismFilter(), moduleConf.getP11NewObjectConf());
            slots.add(p11Slot);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}", (Object)msg);
        }
        this.setSlots(slots);
    }

    public static P11Module getInstance(P11ModuleConf moduleConf) throws P11TokenException {
        Module module;
        Args.notNull((Object)moduleConf, (String)"moduleConf");
        try {
            module = Module.getInstance((String)moduleConf.getNativeLibrary());
        }
        catch (IOException ex) {
            String msg = "could not load the PKCS#11 module " + moduleConf.getName();
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
            throw new P11TokenException(msg, ex);
        }
        try {
            module.initialize((InitializeArgs)new DefaultInitializeArgs());
        }
        catch (PKCS11Exception ex) {
            if (ex.getErrorCode() != 401L) {
                LogUtil.error((Logger)LOG, (Throwable)ex);
                IaikP11Module.close(moduleConf.getName(), module);
                throw new P11TokenException(ex.getMessage(), ex);
            }
            LOG.info("PKCS#11 module already initialized");
            if (LOG.isInfoEnabled()) {
                try {
                    LOG.info("pkcs11.getInfo():\n{}", (Object)module.getInfo());
                }
                catch (TokenException e2) {
                    LOG.debug("module.getInfo()", (Throwable)e2);
                }
            }
        }
        catch (Throwable th) {
            LOG.error("unexpected Exception", th);
            IaikP11Module.close(moduleConf.getName(), module);
            throw new P11TokenException(th.getMessage());
        }
        return new IaikP11Module(module, moduleConf);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void close() {
        for (P11SlotIdentifier slotId : this.getSlotIds()) {
            try {
                this.getSlot(slotId).close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close PKCS#11 slot " + slotId));
            }
        }
        IaikP11Module.close(this.conf.getNativeLibrary(), this.module);
    }

    private static void close(String modulePath, Module module) {
        if (module == null) {
            return;
        }
        LOG.info("close", (Object)"close pkcs11 module: {}", (Object)modulePath);
        try {
            module.finalize(null);
        }
        catch (Throwable th) {
            LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close module " + modulePath));
        }
    }
}

