/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.dsa.DSAUtil;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcContentSignerBuilder;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DSAPlainDigestSigner;
import org.xipki.security.DfltConcurrentContentSigner;
import org.xipki.security.EdECConstants;
import org.xipki.security.SignatureSigner;
import org.xipki.security.X509Cert;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.XiWrappedContentSigner;
import org.xipki.security.pkcs12.KeypairWithCert;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;

public class P12ContentSignerBuilder {
    private static final AlgorithmIdentifier ALGID_SM2_SM3 = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
    private static final AlgorithmIdentifier ALGID_SM3 = new AlgorithmIdentifier(GMObjectIdentifiers.sm3);
    private final PrivateKey key;
    private final PublicKey publicKey;
    private final X509Cert[] certificateChain;

    public P12ContentSignerBuilder(PrivateKey privateKey, PublicKey publicKey) throws XiSecurityException {
        this.key = (PrivateKey)Args.notNull((Object)privateKey, (String)"privateKey");
        this.publicKey = (PublicKey)Args.notNull((Object)publicKey, (String)"publicKey");
        this.certificateChain = null;
    }

    public P12ContentSignerBuilder(KeypairWithCert keypairWithCert) throws XiSecurityException {
        Args.notNull((Object)keypairWithCert, (String)"keypairWithCert");
        this.key = keypairWithCert.getKey();
        this.publicKey = keypairWithCert.getPublicKey();
        this.certificateChain = keypairWithCert.getCertificateChain();
    }

    public ConcurrentContentSigner createSigner(AlgorithmIdentifier signatureAlgId, int parallelism, SecureRandom random) throws XiSecurityException, NoSuchPaddingException {
        DfltConcurrentContentSigner concurrentSigner;
        SignatureSigner signer;
        Args.notNull((Object)signatureAlgId, (String)"signatureAlgId");
        Args.positive((int)parallelism, (String)"parallelism");
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        String provName = null;
        if (AlgorithmUtil.isRSASigAlgId(signatureAlgId)) {
            provName = "SunRsaSign";
        } else if (AlgorithmUtil.isECSigAlg(signatureAlgId)) {
            provName = null;
        } else if (AlgorithmUtil.isDSASigAlg(signatureAlgId)) {
            provName = "SUN";
        } else {
            ASN1ObjectIdentifier oid = signatureAlgId.getAlgorithm();
            if (EdECConstants.id_ED25519.equals((ASN1Primitive)oid) || EdECConstants.id_ED448.equals((ASN1Primitive)oid)) {
                provName = "BC";
            }
        }
        if (provName != null && Security.getProvider(provName) != null) {
            String algoName;
            try {
                algoName = AlgorithmUtil.getSignatureAlgoName(signatureAlgId);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XiSecurityException(ex.getMessage());
            }
            try {
                for (int i = 0; i < parallelism; ++i) {
                    Signature signature = Signature.getInstance(algoName, provName);
                    signature.initSign(this.key);
                    if (i == 0) {
                        signature.update(new byte[]{1, 2, 3, 4});
                        signature.sign();
                    }
                    signer = new SignatureSigner(signatureAlgId, signature, this.key);
                    signers.add(signer);
                }
            }
            catch (Exception ex) {
                signers.clear();
            }
        }
        if (CollectionUtil.isEmpty(signers)) {
            BcContentSignerBuilder signerBuilder;
            RSAKeyParameters keyparam;
            block29: {
                try {
                    if (this.key instanceof RSAPrivateKey) {
                        keyparam = SignerUtil.generateRSAPrivateKeyParameter((RSAPrivateKey)this.key);
                        signerBuilder = new RSAContentSignerBuilder(signatureAlgId);
                        break block29;
                    }
                    if (this.key instanceof DSAPrivateKey) {
                        keyparam = DSAUtil.generatePrivateKeyParameter((PrivateKey)this.key);
                        signerBuilder = new DSAContentSignerBuilder(signatureAlgId, AlgorithmUtil.isDSAPlainSigAlg(signatureAlgId));
                        break block29;
                    }
                    if (this.key instanceof ECPrivateKey) {
                        keyparam = ECUtil.generatePrivateKeyParameter((PrivateKey)this.key);
                        EllipticCurve curve = ((ECPrivateKey)this.key).getParams().getCurve();
                        signerBuilder = GMUtil.isSm2primev2Curve(curve) ? new SM2ContentSignerBuilder() : new ECDSAContentSignerBuilder(signatureAlgId, AlgorithmUtil.isDSAPlainSigAlg(signatureAlgId));
                        break block29;
                    }
                    throw new XiSecurityException("unsupported key " + this.key.getClass().getName());
                }
                catch (InvalidKeyException ex) {
                    throw new XiSecurityException("invalid key", ex);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new XiSecurityException("no such algorithm", ex);
                }
            }
            for (int i = 0; i < parallelism; ++i) {
                if (random != null) {
                    signerBuilder.setSecureRandom(random);
                }
                try {
                    signer = signerBuilder.build((AsymmetricKeyParameter)keyparam);
                }
                catch (OperatorCreationException ex) {
                    throw new XiSecurityException("operator creation error", ex);
                }
                signers.add(new XiWrappedContentSigner(signer, true));
            }
        }
        boolean mac = false;
        try {
            concurrentSigner = new DfltConcurrentContentSigner(false, signers, this.key);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        if (this.certificateChain != null) {
            concurrentSigner.setCertificateChain(this.certificateChain);
        } else {
            concurrentSigner.setPublicKey(this.publicKey);
        }
        return concurrentSigner;
    }

    public X509Cert getCertificate() {
        return this.certificateChain != null && this.certificateChain.length > 0 ? this.certificateChain[0] : null;
    }

    public X509Cert[] getCertificateChain() {
        return this.certificateChain;
    }

    public PrivateKey getKey() {
        return this.key;
    }

    private static class SM2ContentSignerBuilder
    extends BcContentSignerBuilder {
        private SM2ContentSignerBuilder() throws NoSuchAlgorithmException {
            super(ALGID_SM2_SM3, ALGID_SM3);
        }

        protected Signer createSigner(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
            if (!AlgorithmUtil.isSM2SigAlg(sigAlgId)) {
                throw new OperatorCreationException("the given algorithm is not a valid EC signature algorithm '" + sigAlgId.getAlgorithm().getId() + "'");
            }
            return new SM2Signer();
        }
    }

    private static class ECDSAContentSignerBuilder
    extends BcContentSignerBuilder {
        private final boolean plain;

        private ECDSAContentSignerBuilder(AlgorithmIdentifier signatureAlgId, boolean plain) throws NoSuchAlgorithmException {
            super(signatureAlgId, AlgorithmUtil.extractDigesetAlgFromSigAlg(signatureAlgId));
            this.plain = plain;
        }

        protected Signer createSigner(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
            if (!AlgorithmUtil.isECSigAlg(sigAlgId)) {
                throw new OperatorCreationException("the given algorithm is not a valid EC signature algorithm '" + sigAlgId.getAlgorithm().getId() + "'");
            }
            ExtendedDigest dig = this.digestProvider.get(digAlgId);
            ECDSASigner dsaSigner = new ECDSASigner();
            return this.plain ? new DSAPlainDigestSigner((DSA)dsaSigner, (Digest)dig) : new DSADigestSigner((DSA)dsaSigner, (Digest)dig);
        }
    }

    private static class DSAContentSignerBuilder
    extends BcContentSignerBuilder {
        private final boolean plain;

        private DSAContentSignerBuilder(AlgorithmIdentifier signatureAlgId, boolean plain) throws NoSuchAlgorithmException {
            super(signatureAlgId, AlgorithmUtil.extractDigesetAlgFromSigAlg(signatureAlgId));
            this.plain = plain;
        }

        protected Signer createSigner(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
            if (!AlgorithmUtil.isDSASigAlg(sigAlgId)) {
                throw new OperatorCreationException("the given algorithm is not a valid DSA signature algirthm '" + sigAlgId.getAlgorithm().getId() + "'");
            }
            ExtendedDigest dig = this.digestProvider.get(digAlgId);
            DSASigner dsaSigner = new DSASigner();
            return this.plain ? new DSAPlainDigestSigner((DSA)dsaSigner, (Digest)dig) : new DSADigestSigner((DSA)dsaSigner, (Digest)dig);
        }
    }

    private static class RSAContentSignerBuilder
    extends BcContentSignerBuilder {
        private RSAContentSignerBuilder(AlgorithmIdentifier signatureAlgId) throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(signatureAlgId, AlgorithmUtil.extractDigesetAlgFromSigAlg(signatureAlgId));
        }

        protected Signer createSigner(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
            if (!AlgorithmUtil.isRSASigAlgId(sigAlgId)) {
                throw new OperatorCreationException("the given algorithm is not a valid RSA signature algirthm '" + sigAlgId.getAlgorithm().getId() + "'");
            }
            if (!PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)sigAlgId.getAlgorithm())) {
                ExtendedDigest dig = this.digestProvider.get(digAlgId);
                return new RSADigestSigner((Digest)dig);
            }
            try {
                return SignerUtil.createPSSRSASigner(sigAlgId);
            }
            catch (XiSecurityException ex) {
                throw new OperatorCreationException(ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

