/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.xipki.security.AlgorithmValidator;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DHSigStaticKeyCertPair;
import org.xipki.security.SecurityFactory;
import org.xipki.security.SignerConf;
import org.xipki.security.X509Cert;
import org.xipki.util.Args;
import org.xipki.util.exception.ObjectCreationException;

public abstract class AbstractSecurityFactory
implements SecurityFactory {
    @Override
    public ConcurrentContentSigner createSigner(String type, SignerConf conf, X509Cert cert) throws ObjectCreationException {
        X509Cert[] x509CertArray;
        if (cert == null) {
            x509CertArray = null;
        } else {
            X509Cert[] x509CertArray2 = new X509Cert[1];
            x509CertArray = x509CertArray2;
            x509CertArray2[0] = cert;
        }
        X509Cert[] certs = x509CertArray;
        return this.createSigner(type, conf, certs);
    }

    @Override
    public ContentVerifierProvider getContentVerifierProvider(X509Cert cert) throws InvalidKeyException {
        Args.notNull((Object)cert, (String)"cert");
        return this.getContentVerifierProvider(cert.getPublicKey());
    }

    @Override
    public ContentVerifierProvider getContentVerifierProvider(PublicKey publicKey) throws InvalidKeyException {
        return this.getContentVerifierProvider(publicKey, null);
    }

    @Override
    public boolean verifyPop(CertificationRequest csr, AlgorithmValidator algoValidator) {
        return this.verifyPop(new PKCS10CertificationRequest(csr), algoValidator, null);
    }

    @Override
    public boolean verifyPop(CertificationRequest csr, AlgorithmValidator algoValidator, DHSigStaticKeyCertPair ownerKeyAndCert) {
        return this.verifyPop(new PKCS10CertificationRequest(csr), algoValidator, ownerKeyAndCert);
    }

    @Override
    public boolean verifyPop(PKCS10CertificationRequest csr, AlgorithmValidator algoValidator) {
        return this.verifyPop(csr, algoValidator, null);
    }
}

