/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import org.xipki.util.Args;

public enum KeyUsage {
    digitalSignature(0, 128, new String[0]),
    contentCommitment(1, 64, "nonRepudiation"),
    keyEncipherment(2, 32, new String[0]),
    dataEncipherment(3, 16, new String[0]),
    keyAgreement(4, 8, new String[0]),
    keyCertSign(5, 4, new String[0]),
    cRLSign(6, 2, new String[0]),
    encipherOnly(7, 1, new String[0]),
    decipherOnly(8, 32768, new String[0]);

    private final int bit;
    private final int bcUsage;
    private final String[] names;

    private KeyUsage(int bit, int bcUsage, String ... aliases) {
        this.bit = bit;
        this.bcUsage = bcUsage;
        int len = aliases == null ? 1 : 1 + aliases.length;
        this.names = new String[len];
        this.names[0] = this.name();
        if (len > 1) {
            System.arraycopy(aliases, 0, this.names, 1, len - 1);
        }
    }

    public int getBit() {
        return this.bit;
    }

    public int getBcUsage() {
        return this.bcUsage;
    }

    public String getName() {
        return this.names[0];
    }

    public static KeyUsage getKeyUsage(String usage) {
        Args.notNull((Object)usage, (String)"usage");
        String u = usage.trim();
        for (KeyUsage ku : KeyUsage.values()) {
            for (String name : ku.names) {
                if (!name.equalsIgnoreCase(u)) continue;
                return ku;
            }
            if (!Integer.toString(ku.bit).equals(u)) continue;
            return ku;
        }
        throw new IllegalArgumentException("invalid KeyUsage " + usage);
    }

    public static KeyUsage getKeyUsage(int bit) {
        for (KeyUsage ku : KeyUsage.values()) {
            if (ku.bit != bit) continue;
            return ku;
        }
        throw new IllegalArgumentException("invalid KeyUsage(bit) " + bit);
    }

    public static KeyUsage getKeyUsageFromBcUsage(int bcUsage) {
        for (KeyUsage ku : KeyUsage.values()) {
            if (ku.bcUsage != bcUsage) continue;
            return ku;
        }
        throw new IllegalArgumentException("invalid KeyUsage(bcUsage) " + bcUsage);
    }
}

