/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.bsi.BSIObjectIdentifiers;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.operator.OperatorCreationException;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.security.SignatureAlgoControl;
import org.xipki.security.SignerConf;
import org.xipki.util.Args;

public enum SignAlgo {
    RSA_SHA1("SHA1WITHRSA", 1, PKCSObjectIdentifiers.sha1WithRSAEncryption, HashAlgo.SHA1, true),
    RSA_SHA224("SHA224WITHRSA", 2, PKCSObjectIdentifiers.sha224WithRSAEncryption, HashAlgo.SHA224, true),
    RSA_SHA256("SHA256WITHRSA", 3, PKCSObjectIdentifiers.sha256WithRSAEncryption, HashAlgo.SHA256, true),
    RSA_SHA384("SHA384WITHRSA", 4, PKCSObjectIdentifiers.sha384WithRSAEncryption, HashAlgo.SHA384, true),
    RSA_SHA512("SHA512WITHRSA", 5, PKCSObjectIdentifiers.sha512WithRSAEncryption, HashAlgo.SHA512, true),
    RSA_SHA3_224("SHA3-224WITHRSA", 6, NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_224, HashAlgo.SHA3_224, true),
    RSA_SHA3_256("SHA3-256WITHRSA", 7, NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_256, HashAlgo.SHA3_256, true),
    RSA_SHA3_384("SHA3-384WITHRSA", 8, NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_384, HashAlgo.SHA3_384, true),
    RSA_SHA3_512("SHA3-512WITHRSA", 9, NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, HashAlgo.SHA3_512, true),
    RSAPSS_SHA1("SHA1WITHRSAANDMGF1", 17, HashAlgo.SHA1),
    RSAPSS_SHA224("SHA224WITHRSAANDMGF1", 18, HashAlgo.SHA224),
    RSAPSS_SHA256("SHA256WITHRSAANDMGF1", 19, HashAlgo.SHA256),
    RSAPSS_SHA384("SHA384WITHRSAANDMGF1", 20, HashAlgo.SHA384),
    RSAPSS_SHA512("SHA512WITHRSAANDMGF1", 21, HashAlgo.SHA512),
    RSAPSS_SHA3_224("SHA3-224WITHRSAANDMGF1", 22, HashAlgo.SHA3_224),
    RSAPSS_SHA3_256("SHA3-256WITHRSAANDMGF1", 23, HashAlgo.SHA3_256),
    RSAPSS_SHA3_384("SHA3-384WITHRSAANDMGF1", 24, HashAlgo.SHA3_384),
    RSAPSS_SHA3_512("SHA3-512WITHRSAANDMGF1", 25, HashAlgo.SHA3_512),
    RSAPSS_SHAKE128("SHAKE128WITHRSAPSS", 26, CMSObjectIdentifiers.id_RSASSA_PSS_SHAKE128, HashAlgo.SHAKE128, false),
    RSAPSS_SHAKE256("SHAKE256WITHRSAPSS", 27, CMSObjectIdentifiers.id_RSASSA_PSS_SHAKE256, HashAlgo.SHAKE256, false),
    DSA_SHA1("SHA1WITHDSA", 33, X9ObjectIdentifiers.id_dsa_with_sha1, HashAlgo.SHA1, false),
    DSA_SHA224("SHA224WITHDSA", 34, NISTObjectIdentifiers.dsa_with_sha224, HashAlgo.SHA224, false),
    DSA_SHA256("SHA256WITHDSA", 35, NISTObjectIdentifiers.dsa_with_sha256, HashAlgo.SHA256, false),
    DSA_SHA384("SHA384WITHDSA", 36, NISTObjectIdentifiers.dsa_with_sha384, HashAlgo.SHA384, false),
    DSA_SHA512("SHA512WITHDSA", 37, NISTObjectIdentifiers.dsa_with_sha512, HashAlgo.SHA512, false),
    DSA_SHA3_224("SHA3-224WITHDSA", 38, NISTObjectIdentifiers.id_dsa_with_sha3_224, HashAlgo.SHA3_224, false),
    DSA_SHA3_256("SHA3-256WITHDSA", 39, NISTObjectIdentifiers.id_dsa_with_sha3_256, HashAlgo.SHA3_256, false),
    DSA_SHA3_384("SHA3-384WITHDSA", 40, NISTObjectIdentifiers.id_dsa_with_sha3_384, HashAlgo.SHA3_384, false),
    DSA_SHA3_512("SHA3-512WITHDSA", 41, NISTObjectIdentifiers.id_dsa_with_sha3_512, HashAlgo.SHA3_512, false),
    ECDSA_SHA1("SHA1WITHECDSA", 49, X9ObjectIdentifiers.ecdsa_with_SHA1, HashAlgo.SHA1, false),
    ECDSA_SHA224("SHA224WITHECDSA", 50, X9ObjectIdentifiers.ecdsa_with_SHA224, HashAlgo.SHA224, false),
    ECDSA_SHA256("SHA256WITHECDSA", 51, X9ObjectIdentifiers.ecdsa_with_SHA256, HashAlgo.SHA256, false),
    ECDSA_SHA384("SHA384WITHECDSA", 52, X9ObjectIdentifiers.ecdsa_with_SHA384, HashAlgo.SHA384, false),
    ECDSA_SHA512("SHA512WITHECDSA", 53, X9ObjectIdentifiers.ecdsa_with_SHA512, HashAlgo.SHA512, false),
    ECDSA_SHA3_224("SHA3-224WITHECDSA", 54, NISTObjectIdentifiers.id_ecdsa_with_sha3_224, HashAlgo.SHA3_224, false),
    ECDSA_SHA3_256("SHA3-256WITHECDSA", 55, NISTObjectIdentifiers.id_ecdsa_with_sha3_256, HashAlgo.SHA3_256, false),
    ECDSA_SHA3_384("SHA3-384WITHECDSA", 56, NISTObjectIdentifiers.id_ecdsa_with_sha3_384, HashAlgo.SHA3_384, false),
    ECDSA_SHA3_512("SHA3-512WITHECDSA", 57, NISTObjectIdentifiers.id_ecdsa_with_sha3_512, HashAlgo.SHA3_512, false),
    SM2_SM3("SM3WITHSM2", 58, GMObjectIdentifiers.sm2sign_with_sm3, HashAlgo.SM3, false),
    ECDSA_SHAKE128("SHAKE128WITHECDSA", 59, CMSObjectIdentifiers.id_ecdsa_with_shake128, HashAlgo.SHAKE128, false),
    ECDSA_SHAKE256("SHAKE256WITHECDSA", 60, CMSObjectIdentifiers.id_ecdsa_with_shake256, HashAlgo.SHAKE256, false),
    PLAINECDSA_SHA1("SHA1WITHPLAINECDSA", 65, BSIObjectIdentifiers.ecdsa_plain_SHA1, HashAlgo.SHA1, false),
    PLAINECDSA_SHA224("SHA224WITHPLAINECDSA", 66, BSIObjectIdentifiers.ecdsa_plain_SHA224, HashAlgo.SHA224, false),
    PLAINECDSA_SHA256("SHA256WITHPLAINECDSA", 67, BSIObjectIdentifiers.ecdsa_plain_SHA256, HashAlgo.SHA256, false),
    PLAINECDSA_SHA384("SHA384WITHPLAINECDSA", 68, BSIObjectIdentifiers.ecdsa_plain_SHA384, HashAlgo.SHA384, false),
    PLAINECDSA_SHA512("SHA512WITHPLAINECDSA", 69, BSIObjectIdentifiers.ecdsa_plain_SHA512, HashAlgo.SHA512, false),
    ED25519("ED25519", 70, EdECConstants.id_ED25519, null, false),
    ED448("ED448", 71, EdECConstants.id_ED448, null, false),
    HMAC_SHA1("HMACSHA1", 81, PKCSObjectIdentifiers.id_hmacWithSHA1, HashAlgo.SHA1, true),
    HMAC_SHA224("HMACSHA224", 82, PKCSObjectIdentifiers.id_hmacWithSHA224, HashAlgo.SHA224, true),
    HMAC_SHA256("HMACSHA256", 83, PKCSObjectIdentifiers.id_hmacWithSHA256, HashAlgo.SHA256, true),
    HMAC_SHA384("HMACSHA384", 84, PKCSObjectIdentifiers.id_hmacWithSHA384, HashAlgo.SHA384, true),
    HMAC_SHA512("HMACSHA512", 85, PKCSObjectIdentifiers.id_hmacWithSHA512, HashAlgo.SHA512, true),
    HMAC_SHA3_224("HMACSHA3-224", 86, NISTObjectIdentifiers.id_hmacWithSHA3_224, HashAlgo.SHA3_224, true),
    HMAC_SHA3_256("HMACSHA3-256", 87, NISTObjectIdentifiers.id_hmacWithSHA3_256, HashAlgo.SHA3_256, true),
    HMAC_SHA3_384("HMACSHA3-384", 88, NISTObjectIdentifiers.id_hmacWithSHA3_384, HashAlgo.SHA3_384, true),
    HMAC_SHA3_512("HMACSHA3-512", 89, NISTObjectIdentifiers.id_hmacWithSHA3_512, HashAlgo.SHA3_512, true),
    GMAC_AES128("AES128GMAC", 97, new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.9")),
    GMAC_AES192("AES192GMAC", 98, new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.29")),
    GMAC_AES256("AES256GMAC", 99, new ASN1ObjectIdentifier("2.16.840.1.101.3.4.1.49")),
    DHPOP_X25519("DHPOP-X25519", 90, ObjectIdentifiers.Xipki.id_alg_dhPop_x25519, HashAlgo.SHA512, false),
    DHPOP_X448("DHPOP-X448", 91, ObjectIdentifiers.Xipki.id_alg_dhPop_x448, HashAlgo.SHA512, false);

    private static final int TRAILER_FIELD_BC = 1;
    private static final Map<String, SignAlgo> map;
    private static final Map<HashAlgo, SignAlgo> mgf1HashToSigMap;
    private final ASN1ObjectIdentifier oid;
    private final AlgorithmIdentifier algId;
    private final String jceName;
    private final byte code;
    private final HashAlgo hashAlgo;

    private SignAlgo(String jceName, int code, ASN1ObjectIdentifier oid, HashAlgo hashAlgo, boolean withNullParams) {
        this.code = (byte)Args.range((int)code, (String)"code", (int)0, (int)255);
        this.jceName = jceName.toUpperCase();
        this.oid = oid;
        this.hashAlgo = hashAlgo;
        this.algId = withNullParams ? new AlgorithmIdentifier(this.oid, (ASN1Encodable)DERNull.INSTANCE) : new AlgorithmIdentifier(this.oid);
    }

    private SignAlgo(String jceName, int code, HashAlgo hashAlgo) {
        this.code = (byte)Args.range((int)code, (String)"code", (int)0, (int)255);
        this.jceName = jceName.toUpperCase();
        this.hashAlgo = hashAlgo;
        AlgorithmIdentifier digAlgId = hashAlgo.getAlgIdWithNullParams();
        int saltSize = hashAlgo.getLength();
        RSASSAPSSparams params = new RSASSAPSSparams(digAlgId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)digAlgId), new ASN1Integer((long)saltSize), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
        this.oid = PKCSObjectIdentifiers.id_RSASSA_PSS;
        this.algId = new AlgorithmIdentifier(this.oid, (ASN1Encodable)params);
    }

    private SignAlgo(String jceName, int code, ASN1ObjectIdentifier oid) {
        if (!jceName.startsWith("AES") || !jceName.endsWith("GMAC")) {
            throw new IllegalArgumentException("not AES*GMAC: " + jceName);
        }
        this.code = (byte)Args.range((int)code, (String)"code", (int)0, (int)255);
        this.jceName = jceName.toUpperCase();
        this.oid = oid;
        this.hashAlgo = null;
        int tagLen = 12;
        int nonceLen = 12;
        GCMParameters params = new GCMParameters(new byte[12], 12);
        this.algId = new AlgorithmIdentifier(oid, (ASN1Encodable)params);
    }

    public HashAlgo getHashAlgo() {
        return this.hashAlgo;
    }

    public byte getCode() {
        return this.code;
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    public String getJceName() {
        return this.jceName;
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algId;
    }

    public Signature newSignature() throws NoSuchAlgorithmException {
        return Signature.getInstance(this.jceName);
    }

    public Signature newSignature(String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Signature.getInstance(this.jceName, provider);
    }

    public boolean isDSASigAlgo() {
        switch (this) {
            case DSA_SHA1: 
            case DSA_SHA224: 
            case DSA_SHA256: 
            case DSA_SHA384: 
            case DSA_SHA512: 
            case DSA_SHA3_224: 
            case DSA_SHA3_256: 
            case DSA_SHA3_384: 
            case DSA_SHA3_512: {
                return true;
            }
        }
        return false;
    }

    public boolean isECDSASigAlgo() {
        switch (this) {
            case ECDSA_SHA1: 
            case ECDSA_SHA224: 
            case ECDSA_SHA256: 
            case ECDSA_SHA384: 
            case ECDSA_SHA512: 
            case ECDSA_SHA3_224: 
            case ECDSA_SHA3_256: 
            case ECDSA_SHA3_384: 
            case ECDSA_SHA3_512: 
            case ECDSA_SHAKE128: 
            case ECDSA_SHAKE256: {
                return true;
            }
        }
        return false;
    }

    public boolean isEDDSASigAlgo() {
        switch (this) {
            case ED25519: 
            case ED448: {
                return true;
            }
        }
        return false;
    }

    public boolean isPlainECDSASigAlgo() {
        switch (this) {
            case PLAINECDSA_SHA1: 
            case PLAINECDSA_SHA224: 
            case PLAINECDSA_SHA256: 
            case PLAINECDSA_SHA384: 
            case PLAINECDSA_SHA512: {
                return true;
            }
        }
        return false;
    }

    public boolean isSM2SigAlgo() {
        ASN1ObjectIdentifier oid = ((AlgorithmIdentifier)Args.notNull((Object)this.algId, (String)"algId")).getAlgorithm();
        return GMObjectIdentifiers.sm2sign_with_sm3.equals((ASN1Primitive)oid);
    }

    public boolean isRSAPkcs1SigAlgo() {
        switch (this) {
            case RSA_SHA1: 
            case RSA_SHA224: 
            case RSA_SHA256: 
            case RSA_SHA384: 
            case RSA_SHA512: 
            case RSA_SHA3_224: 
            case RSA_SHA3_256: 
            case RSA_SHA3_384: 
            case RSA_SHA3_512: {
                return true;
            }
        }
        return false;
    }

    public boolean isRSAPSSSigAlgo() {
        if (this.isRSAPSSMGF1SigAlgo()) {
            return true;
        }
        switch (this) {
            case RSAPSS_SHAKE128: 
            case RSAPSS_SHAKE256: {
                return true;
            }
        }
        return false;
    }

    public boolean isRSAPSSMGF1SigAlgo() {
        switch (this) {
            case RSAPSS_SHA1: 
            case RSAPSS_SHA224: 
            case RSAPSS_SHA256: 
            case RSAPSS_SHA384: 
            case RSAPSS_SHA512: 
            case RSAPSS_SHA3_224: 
            case RSAPSS_SHA3_256: 
            case RSAPSS_SHA3_384: 
            case RSAPSS_SHA3_512: {
                return true;
            }
        }
        return false;
    }

    public boolean isHmac() {
        switch (this) {
            case HMAC_SHA1: 
            case HMAC_SHA224: 
            case HMAC_SHA256: 
            case HMAC_SHA384: 
            case HMAC_SHA512: 
            case HMAC_SHA3_224: 
            case HMAC_SHA3_256: 
            case HMAC_SHA3_384: {
                return true;
            }
        }
        return false;
    }

    public boolean isGmac() {
        switch (this) {
            case GMAC_AES128: 
            case GMAC_AES192: 
            case GMAC_AES256: {
                return true;
            }
        }
        return false;
    }

    public boolean isMac() {
        return this.isHmac() || this.isGmac();
    }

    public static SignAlgo getInstance(AlgorithmIdentifier algId) throws NoSuchAlgorithmException {
        ASN1ObjectIdentifier oid = algId.getAlgorithm();
        ASN1Encodable params = algId.getParameters();
        SignAlgo rv = null;
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)oid)) {
            RSASSAPSSparams param = RSASSAPSSparams.getInstance((Object)params);
            AlgorithmIdentifier digestAlgId = param.getHashAlgorithm();
            AlgorithmIdentifier mgf = param.getMaskGenAlgorithm();
            ASN1ObjectIdentifier mgfOid = mgf.getAlgorithm();
            if (!PKCSObjectIdentifiers.id_mgf1.equals((ASN1Primitive)mgfOid)) {
                throw new NoSuchAlgorithmException("mgf != MGF1");
            }
            AlgorithmIdentifier mgfDigestAlgId = AlgorithmIdentifier.getInstance((Object)mgf.getParameters());
            if (!digestAlgId.equals((Object)mgfDigestAlgId)) {
                throw new NoSuchAlgorithmException("digestAlg != MGF1.digestAlg");
            }
            if (1 != param.getTrailerField().intValueExact()) {
                return null;
            }
            HashAlgo hashAlgo = HashAlgo.getInstance(digestAlgId);
            if (hashAlgo.getLength() != param.getSaltLength().intValueExact()) {
                return null;
            }
            return mgf1HashToSigMap.get((Object)hashAlgo);
        }
        if (SignAlgo.GMAC_AES128.oid.equals((ASN1Primitive)oid) || SignAlgo.GMAC_AES192.oid.equals((ASN1Primitive)oid) || SignAlgo.GMAC_AES256.oid.equals((ASN1Primitive)oid)) {
            if (SignAlgo.GMAC_AES128.oid.equals((ASN1Primitive)oid)) {
                return GMAC_AES128;
            }
            if (SignAlgo.GMAC_AES192.oid.equals((ASN1Primitive)oid)) {
                return GMAC_AES192;
            }
            return GMAC_AES256;
        }
        if (params != null && !DERNull.INSTANCE.equals(params)) {
            return null;
        }
        for (SignAlgo algo : SignAlgo.values()) {
            if (!algo.oid.equals((ASN1Primitive)oid)) continue;
            rv = algo;
        }
        return rv;
    }

    public static SignAlgo getInstance(String nameOrOid) throws NoSuchAlgorithmException {
        SignAlgo alg = map.get(nameOrOid.toUpperCase().replace("-", ""));
        if (alg == null) {
            throw new NoSuchAlgorithmException("Unknown HashAlgo OID/name '" + nameOrOid + "'");
        }
        return alg;
    }

    public static SignAlgo getInstance(Key key, SignerConf signerConf) throws NoSuchAlgorithmException {
        if (((SignerConf)Args.notNull((Object)signerConf, (String)"signerConf")).getHashAlgo() == null) {
            return SignAlgo.getInstance(signerConf.getConfValue("algo"));
        }
        SignatureAlgoControl algoControl = signerConf.getSignatureAlgoControl();
        HashAlgo hashAlgo = signerConf.getHashAlgo();
        if (key instanceof RSAPublicKey || key instanceof RSAPrivateKey) {
            boolean rsaPss = algoControl != null && algoControl.isRsaPss();
            return SignAlgo.getRSAInstance(hashAlgo, rsaPss);
        }
        if (key instanceof ECPublicKey || key instanceof ECPrivateKey) {
            boolean dsaPlain = algoControl != null && algoControl.isDsaPlain();
            boolean gm = algoControl != null && algoControl.isGm();
            return SignAlgo.getECSigAlgo(hashAlgo, dsaPlain, gm);
        }
        if (key instanceof DSAPublicKey || key instanceof DSAPrivateKey) {
            return SignAlgo.getDSASigAlgo(hashAlgo);
        }
        if (key instanceof EdDSAKey) {
            String keyAlgo = key.getAlgorithm().toUpperCase();
            if (keyAlgo.equals("ED25519")) {
                return ED25519;
            }
            if (keyAlgo.equals("ED448")) {
                return ED448;
            }
            throw new NoSuchAlgorithmException("Unknown Edwards public key " + keyAlgo);
        }
        throw new NoSuchAlgorithmException("Unknown key " + key.getClass().getName());
    }

    public static SignAlgo getInstance(Key key, HashAlgo hashAlgo, SignatureAlgoControl algoControl) throws NoSuchAlgorithmException {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        Args.notNull((Object)key, (String)"key");
        if (key instanceof RSAPublicKey || key instanceof RSAPrivateKey) {
            boolean rsaPss = algoControl != null && algoControl.isRsaPss();
            return SignAlgo.getRSAInstance(hashAlgo, rsaPss);
        }
        if (key instanceof ECPublicKey || key instanceof ECPrivateKey) {
            boolean dsaPlain = algoControl != null && algoControl.isDsaPlain();
            boolean gm = algoControl != null && algoControl.isGm();
            return SignAlgo.getECSigAlgo(hashAlgo, dsaPlain, gm);
        }
        if (key instanceof DSAPublicKey || key instanceof DSAPrivateKey) {
            return SignAlgo.getDSASigAlgo(hashAlgo);
        }
        if (key instanceof EdDSAKey) {
            String keyAlgo = key.getAlgorithm().toUpperCase();
            if (keyAlgo.equals("ED25519")) {
                return ED25519;
            }
            if (keyAlgo.equals("ED448")) {
                return ED448;
            }
            throw new NoSuchAlgorithmException("Unknown Edwards public key " + keyAlgo);
        }
        throw new NoSuchAlgorithmException("Unknown key '" + key.getClass().getName());
    }

    private static SignAlgo getRSAInstance(HashAlgo hashAlgo, boolean rsaPss) throws NoSuchAlgorithmException {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        switch (hashAlgo) {
            case SHAKE128: {
                return RSAPSS_SHAKE128;
            }
            case SHAKE256: {
                return RSAPSS_SHAKE256;
            }
            case SHA1: {
                return rsaPss ? RSAPSS_SHA1 : RSA_SHA1;
            }
            case SHA224: {
                return rsaPss ? RSAPSS_SHA224 : RSA_SHA224;
            }
            case SHA256: {
                return rsaPss ? RSAPSS_SHA256 : RSA_SHA256;
            }
            case SHA384: {
                return rsaPss ? RSAPSS_SHA384 : RSA_SHA384;
            }
            case SHA512: {
                return rsaPss ? RSAPSS_SHA512 : RSA_SHA512;
            }
            case SHA3_224: {
                return rsaPss ? RSAPSS_SHA3_224 : RSA_SHA3_224;
            }
            case SHA3_256: {
                return rsaPss ? RSAPSS_SHA3_256 : RSA_SHA3_256;
            }
            case SHA3_384: {
                return rsaPss ? RSAPSS_SHA3_384 : RSA_SHA3_384;
            }
            case SHA3_512: {
                return rsaPss ? RSAPSS_SHA3_512 : RSA_SHA3_512;
            }
        }
        throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for RSA");
    }

    private static SignAlgo getDSASigAlgo(HashAlgo hashAlgo) throws NoSuchAlgorithmException {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        switch (hashAlgo) {
            case SHAKE128: {
                return RSAPSS_SHAKE128;
            }
            case SHAKE256: {
                return RSAPSS_SHAKE256;
            }
            case SHA1: {
                return DSA_SHA1;
            }
            case SHA224: {
                return DSA_SHA224;
            }
            case SHA256: {
                return DSA_SHA256;
            }
            case SHA384: {
                return DSA_SHA384;
            }
            case SHA512: {
                return DSA_SHA512;
            }
            case SHA3_224: {
                return DSA_SHA3_224;
            }
            case SHA3_256: {
                return DSA_SHA3_256;
            }
            case SHA3_384: {
                return DSA_SHA3_384;
            }
            case SHA3_512: {
                return DSA_SHA3_512;
            }
        }
        throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for DSA");
    }

    private static SignAlgo getECSigAlgo(HashAlgo hashAlgo, boolean plainSignature, boolean gm) throws NoSuchAlgorithmException {
        Args.notNull((Object)((Object)hashAlgo), (String)"hashAlgo");
        if (gm && plainSignature) {
            throw new IllegalArgumentException("plainSignature and gm cannot be both true");
        }
        if (gm) {
            if (hashAlgo == HashAlgo.SM3) {
                return SM2_SM3;
            }
            throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for SM2");
        }
        if (plainSignature) {
            switch (hashAlgo) {
                case SHA1: {
                    return PLAINECDSA_SHA1;
                }
                case SHA224: {
                    return PLAINECDSA_SHA224;
                }
                case SHA256: {
                    return PLAINECDSA_SHA256;
                }
                case SHA384: {
                    return PLAINECDSA_SHA384;
                }
                case SHA512: {
                    return PLAINECDSA_SHA512;
                }
            }
            throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for PlainECDSA");
        }
        switch (hashAlgo) {
            case SHA1: {
                return ECDSA_SHA1;
            }
            case SHA224: {
                return ECDSA_SHA224;
            }
            case SHA256: {
                return ECDSA_SHA256;
            }
            case SHA384: {
                return ECDSA_SHA384;
            }
            case SHA512: {
                return ECDSA_SHA512;
            }
            case SHA3_224: {
                return ECDSA_SHA3_224;
            }
            case SHA3_256: {
                return ECDSA_SHA3_256;
            }
            case SHA3_384: {
                return ECDSA_SHA3_384;
            }
            case SHA3_512: {
                return ECDSA_SHA3_512;
            }
            case SHAKE128: {
                return ECDSA_SHAKE128;
            }
            case SHAKE256: {
                return ECDSA_SHAKE256;
            }
        }
        throw new NoSuchAlgorithmException("unsupported hash " + (Object)((Object)hashAlgo) + " for ECDSA");
    }

    public void assertSameAlgorithm(AlgorithmIdentifier sigAlgId, AlgorithmIdentifier digAlgId) throws OperatorCreationException {
        if (!this.algId.equals((Object)sigAlgId)) {
            throw new OperatorCreationException("sigAlgId differs");
        }
        if (this.hashAlgo != null ? !this.hashAlgo.getAlgorithmIdentifier().equals((Object)digAlgId) : digAlgId != null) {
            throw new OperatorCreationException("digAlgId differs");
        }
    }

    static {
        map = new HashMap<String, SignAlgo>();
        mgf1HashToSigMap = new HashMap<HashAlgo, SignAlgo>();
        for (SignAlgo type : SignAlgo.values()) {
            if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)type.oid)) {
                mgf1HashToSigMap.put(type.hashAlgo, type);
            } else {
                map.put(type.oid.getId(), type);
            }
            LinkedList<String> names = new LinkedList<String>();
            names.add(type.jceName);
            if (type.jceName.endsWith("RSAANDMGF1")) {
                names.add(type.jceName.replace("RSAANDMGF1", "RSAPSS"));
            }
            for (String name : names) {
                int index;
                boolean withMinus;
                map.put(name, type);
                boolean bl = withMinus = name.indexOf(45) != -1;
                if (withMinus) {
                    map.put(name.replace("-", ""), type);
                }
                if ((index = name.indexOf("WITH")) == -1) continue;
                String inverseName = name.substring(index + "WITH".length()) + "WITH" + name.substring(0, index);
                map.put(inverseName, type);
                if (!withMinus) continue;
                map.put(inverseName.replace("-", ""), type);
            }
        }
    }
}

