/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.bc;

import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcECContentVerifierProviderBuilder;
import org.xipki.security.DSAPlainDigestSigner;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;

public class XiECContentVerifierProviderBuilder
extends BcECContentVerifierProviderBuilder {
    private static final DigestAlgorithmIdentifierFinder digestAlgorithmFinder = new DefaultDigestAlgorithmIdentifierFinder();

    public XiECContentVerifierProviderBuilder() {
        super(digestAlgorithmFinder);
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        SignAlgo signAlgo;
        try {
            signAlgo = SignAlgo.getInstance(sigAlgId);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new OperatorCreationException(ex.getMessage(), (Throwable)ex);
        }
        HashAlgo hashAlgo = signAlgo.getHashAlgo();
        if (SignAlgo.SM2_SM3 == signAlgo) {
            return new SM2Signer();
        }
        if (signAlgo.isPlainECDSASigAlgo()) {
            return new DSAPlainDigestSigner((DSA)new ECDSASigner(), (Digest)hashAlgo.createDigest());
        }
        return new DSADigestSigner((DSA)new ECDSASigner(), (Digest)hashAlgo.createDigest());
    }
}

