/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.ctlog;

import java.io.IOException;
import java.math.BigInteger;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.util.Pack;
import org.xipki.security.ObjectIdentifiers;
import org.xipki.util.Args;

public class CtLog {
    private static int writeInt(int value, byte[] buffer, int offset, int bytesLenOfValue) {
        if (bytesLenOfValue == 4) {
            buffer[offset++] = (byte)(value >>> 24);
        }
        if (bytesLenOfValue >= 3) {
            buffer[offset++] = (byte)(value >>> 16);
        }
        if (bytesLenOfValue >= 2) {
            buffer[offset++] = (byte)(value >>> 8);
        }
        buffer[offset] = (byte)value;
        return bytesLenOfValue;
    }

    private static int readInt2(byte[] buffer, int offset) {
        return (0xFF & buffer[offset]) << 8 | 0xFF & buffer[offset + 1];
    }

    private static byte[] copyOf(byte[] original, int from, int len) {
        return Arrays.copyOfRange(original, from, from + len);
    }

    public static void update(Signature sig, byte version, long timestamp, byte[] sctExtensions, byte[] issuerKeyHash, byte[] preCertTbsCert) throws SignatureException {
        sig.update(version);
        sig.update((byte)0);
        byte[] timestampBytes = Pack.longToBigEndian((long)timestamp);
        sig.update(timestampBytes);
        sig.update(new byte[]{0, 1});
        sig.update(issuerKeyHash);
        int len = preCertTbsCert.length;
        sig.update(CtLog.encodeLength(len, 3));
        sig.update(preCertTbsCert);
        len = sctExtensions == null ? 0 : sctExtensions.length;
        sig.update(CtLog.encodeLength(len, 2));
        if (len > 0) {
            sig.update(sctExtensions);
        }
    }

    public static byte[] getPreCertTbsCert(TBSCertificate tbsCert) throws IOException {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        ASN1Sequence tbs = (ASN1Sequence)tbsCert.toASN1Primitive();
        for (int i = 0; i < 7; ++i) {
            vec.add(tbs.getObjectAt(i));
        }
        ASN1TaggedObject taggedExtns = (ASN1TaggedObject)tbs.getObjectAt(7);
        int tagNo = taggedExtns.getTagNo();
        ASN1Sequence extns = (ASN1Sequence)taggedExtns.getBaseObject().toASN1Primitive();
        ASN1EncodableVector extnsVec = new ASN1EncodableVector(extns.size() - 1);
        int size = extns.size();
        for (int i = 0; i < size; ++i) {
            ASN1Primitive extn = extns.getObjectAt(i).toASN1Primitive();
            ASN1Encodable type = ((ASN1Sequence)extn).getObjectAt(0);
            if (ObjectIdentifiers.Extn.id_precertificate.equals(type) || ObjectIdentifiers.Extn.id_SCTs.equals(type)) continue;
            extnsVec.add((ASN1Encodable)extn);
        }
        vec.add((ASN1Encodable)new DERTaggedObject(true, tagNo, (ASN1Encodable)new DERSequence(extnsVec)));
        return new DERSequence(vec).getEncoded();
    }

    private static byte[] encodeLength(int length, int lengthBytes) {
        byte[] encoded = new byte[lengthBytes];
        CtLog.writeInt(length, encoded, 0, lengthBytes);
        return encoded;
    }

    public static class SignedCertificateTimestampList {
        private final SerializedSCT sctList;

        public static SignedCertificateTimestampList getInstance(byte[] encoded) {
            SerializedSCT sctList = SerializedSCT.getInstance(encoded);
            return new SignedCertificateTimestampList(sctList);
        }

        public SignedCertificateTimestampList(SerializedSCT sctList) {
            this.sctList = (SerializedSCT)Args.notNull((Object)sctList, (String)"sctList");
        }

        public SerializedSCT getSctList() {
            return this.sctList;
        }

        public byte[] getEncoded() {
            return this.sctList.getEncoded();
        }
    }

    public static class SignedCertificateTimestamp {
        private final byte version;
        private final byte[] logId;
        private final long timestamp;
        private final byte[] extensions;
        private final DigitallySigned digitallySigned;

        public static SignedCertificateTimestamp getInstance(byte[] encoded, AtomicInteger offsetObj, int len) {
            int startOffset;
            int offset = startOffset = offsetObj.get();
            byte version = encoded[offset++];
            byte[] logID = CtLog.copyOf(encoded, offset, 32);
            long timestamp = Pack.bigEndianToLong((byte[])encoded, (int)(offset += 32));
            int extensionsLen = CtLog.readInt2(encoded, offset += 8);
            byte[] extensions = extensionsLen == 0 ? new byte[]{} : CtLog.copyOf(encoded, offset += 2, extensionsLen);
            offsetObj.set(offset += extensionsLen);
            DigitallySigned digitallySigned = DigitallySigned.getInstance(encoded, offsetObj);
            if (offsetObj.get() != startOffset + len) {
                throw new IllegalArgumentException("length unmatch");
            }
            return new SignedCertificateTimestamp(version, logID, timestamp, extensions, digitallySigned);
        }

        public SignedCertificateTimestamp(byte version, byte[] logId, long timestamp, byte[] extensions, DigitallySigned digitallySigned) {
            this.version = version;
            Args.notNull((Object)logId, (String)"logId");
            Args.equals((int)logId.length, (String)"logID.length", (int)32);
            this.logId = logId;
            this.timestamp = timestamp;
            this.extensions = extensions == null ? new byte[]{} : extensions;
            this.digitallySigned = (DigitallySigned)Args.notNull((Object)digitallySigned, (String)"digitallySigned");
        }

        public int getVersion() {
            return this.version;
        }

        public byte[] getLogId() {
            return Arrays.copyOf(this.logId, this.logId.length);
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public byte[] getExtensions() {
            return this.extensions.length == 0 ? this.extensions : Arrays.copyOf(this.extensions, this.extensions.length);
        }

        public DigitallySigned getDigitallySigned() {
            return this.digitallySigned;
        }

        public byte[] getEncoded() {
            byte[] encodedDs = this.digitallySigned.getEncoded();
            int totoalLen = 43 + this.extensions.length + encodedDs.length;
            byte[] res = new byte[totoalLen];
            int offset = 0;
            res[offset++] = this.version;
            System.arraycopy(this.logId, 0, res, 1, this.logId.length);
            byte[] tsBytes = Pack.longToBigEndian((long)this.timestamp);
            System.arraycopy(tsBytes, 0, res, offset += this.logId.length, 8);
            offset += 8;
            offset += CtLog.writeInt(this.extensions.length, res, offset, 2);
            if (this.extensions.length > 0) {
                System.arraycopy(this.extensions, 0, res, offset, this.extensions.length);
                offset += this.extensions.length;
            }
            System.arraycopy(encodedDs, 0, res, offset, encodedDs.length);
            return res;
        }
    }

    public static class SignatureAndHashAlgorithm {
        private final HashAlgorithm hash;
        private final SignatureAlgorithm signature;

        public static SignatureAndHashAlgorithm getInstance(byte[] encoded) {
            return new SignatureAndHashAlgorithm(HashAlgorithm.ofCode(encoded[0]), SignatureAlgorithm.ofCode(encoded[1]));
        }

        public SignatureAndHashAlgorithm(HashAlgorithm hash, SignatureAlgorithm signature) {
            this.hash = (HashAlgorithm)((Object)Args.notNull((Object)((Object)hash), (String)"hash"));
            this.signature = (SignatureAlgorithm)((Object)Args.notNull((Object)((Object)signature), (String)"signature"));
        }

        public HashAlgorithm getHash() {
            return this.hash;
        }

        public SignatureAlgorithm getSignature() {
            return this.signature;
        }

        public byte[] getEncoded() {
            return new byte[]{this.hash.getCode(), this.signature.getCode()};
        }
    }

    public static enum SignatureAlgorithm {
        anonymous(0),
        rsa(1),
        dsa(2),
        ecdsa(3);

        private final byte code;

        private SignatureAlgorithm(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static SignatureAlgorithm ofCode(byte code) {
            for (SignatureAlgorithm m : SignatureAlgorithm.values()) {
                if (m.code != code) continue;
                return m;
            }
            return null;
        }
    }

    public static enum HashAlgorithm {
        none(0),
        md5(1),
        sha1(2),
        sha224(3),
        sha256(4),
        sha384(5),
        sha512(6);

        private final byte code;

        private HashAlgorithm(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        public static HashAlgorithm ofCode(byte code) {
            for (HashAlgorithm m : HashAlgorithm.values()) {
                if (m.code != code) continue;
                return m;
            }
            return null;
        }
    }

    public static class SerializedSCT {
        private final List<SignedCertificateTimestamp> scts;

        public static SerializedSCT getInstance(byte[] encoded) {
            int length = CtLog.readInt2(encoded, 0);
            if (2 + length != encoded.length) {
                throw new IllegalArgumentException("length unmatch");
            }
            LinkedList<SignedCertificateTimestamp> scts = new LinkedList<SignedCertificateTimestamp>();
            AtomicInteger offsetObj = new AtomicInteger(2);
            while (offsetObj.get() < encoded.length) {
                int sctLen = CtLog.readInt2(encoded, offsetObj.getAndAdd(2));
                SignedCertificateTimestamp sct = SignedCertificateTimestamp.getInstance(encoded, offsetObj, sctLen);
                scts.add(sct);
            }
            return new SerializedSCT(scts);
        }

        public SerializedSCT(List<SignedCertificateTimestamp> scts) {
            this.scts = scts == null ? new LinkedList<SignedCertificateTimestamp>() : new LinkedList<SignedCertificateTimestamp>(scts);
        }

        public int size() {
            return this.scts.size();
        }

        public SignedCertificateTimestamp get(int index) {
            return this.scts.get(index);
        }

        public SignedCertificateTimestamp remove(int index) {
            return this.scts.remove(index);
        }

        public void add(SignedCertificateTimestamp sct) {
            this.scts.add(sct);
        }

        public byte[] getEncoded() {
            if (this.scts.isEmpty()) {
                return new byte[]{0, 0};
            }
            ArrayList<byte[]> encodedScts = new ArrayList<byte[]>(this.scts.size());
            int totalLen = 0;
            for (SignedCertificateTimestamp sct : this.scts) {
                byte[] encodedSct = sct.getEncoded();
                byte[] encodedSctWithLen = new byte[2 + encodedSct.length];
                CtLog.writeInt(encodedSct.length, encodedSctWithLen, 0, 2);
                System.arraycopy(encodedSct, 0, encodedSctWithLen, 2, encodedSct.length);
                totalLen += encodedSctWithLen.length;
                encodedScts.add(encodedSctWithLen);
            }
            byte[] res = new byte[2 + totalLen];
            int offset = CtLog.writeInt(totalLen, res, 0, 2);
            for (byte[] m : encodedScts) {
                System.arraycopy(m, 0, res, offset, m.length);
                offset += m.length;
            }
            return res;
        }
    }

    public static class DigitallySigned {
        private final SignatureAndHashAlgorithm algorithm;
        private final byte[] signature;

        public static DigitallySigned getInstance(byte[] encoded, AtomicInteger offsetObj) {
            int offset = offsetObj.get();
            SignatureAndHashAlgorithm algorithm = SignatureAndHashAlgorithm.getInstance(CtLog.copyOf(encoded, offset, 2));
            int signatureLen = CtLog.readInt2(encoded, offset += 2);
            byte[] signature = CtLog.copyOf(encoded, offset += 2, signatureLen);
            offsetObj.set(offset += signatureLen);
            return new DigitallySigned(algorithm, signature);
        }

        public DigitallySigned(SignatureAndHashAlgorithm algorithm, byte[] signature) {
            this.algorithm = (SignatureAndHashAlgorithm)Args.notNull((Object)algorithm, (String)"algorithm");
            this.signature = (byte[])Args.notNull((Object)signature, (String)"signature");
        }

        public SignatureAndHashAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public byte[] getSignature() {
            return Arrays.copyOf(this.signature, this.signature.length);
        }

        public Object getSignatureObject() {
            switch (this.algorithm.signature) {
                case ecdsa: 
                case dsa: {
                    ASN1Sequence seq = ASN1Sequence.getInstance((Object)this.signature);
                    return new BigInteger[]{ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getPositiveValue(), ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getPositiveValue()};
                }
            }
            return this.signature;
        }

        public byte[] getEncoded() {
            byte[] ea = this.algorithm.getEncoded();
            int n = ea.length + 2 + this.signature.length;
            byte[] res = new byte[n];
            System.arraycopy(ea, 0, res, 0, ea.length);
            int offset = ea.length;
            int sigLen = this.signature.length;
            offset += CtLog.writeInt(sigLen, res, offset, 2);
            System.arraycopy(this.signature, 0, res, offset, sigLen);
            return res;
        }
    }
}

