/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.RuntimeCryptoException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.HashAlgo;
import org.xipki.security.SignAlgo;
import org.xipki.security.XiContentSigner;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.DigestOutputStream;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11PlainRSASigner;
import org.xipki.security.pkcs11.P11RSAKeyParameter;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.PKCS1Util;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

abstract class P11ContentSigner
implements XiContentSigner {
    private static final Logger LOG = LoggerFactory.getLogger(P11ContentSigner.class);
    protected final P11CryptService cryptService;
    protected final P11IdentityId identityId;
    protected final SignAlgo signAlgo;
    protected final byte[] encodedAlgorithmIdentifier;

    P11ContentSigner(P11CryptService cryptService, P11IdentityId identityId, SignAlgo signAlgo) throws XiSecurityException {
        this.identityId = (P11IdentityId)Args.notNull((Object)identityId, (String)"identityId");
        this.cryptService = (P11CryptService)Args.notNull((Object)cryptService, (String)"cryptService");
        this.signAlgo = (SignAlgo)((Object)Args.notNull((Object)((Object)signAlgo), (String)"signAlgo"));
        try {
            this.encodedAlgorithmIdentifier = signAlgo.getAlgorithmIdentifier().getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
        }
    }

    public final AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.signAlgo.getAlgorithmIdentifier();
    }

    @Override
    public final byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    static class SM2
    extends P11ContentSigner {
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final long mechanism;
        private final OutputStream outputStream;
        private final byte[] z;

        SM2(P11CryptService cryptService, P11IdentityId identityId, SignAlgo signAlgo, ASN1ObjectIdentifier curveOid, BigInteger pubPointX, BigInteger pubPointY) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signAlgo);
            if (!signAlgo.isSM2SigAlgo()) {
                throw new XiSecurityException("not an SM2 algorithm: " + (Object)((Object)signAlgo));
            }
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            HashAlgo hashAlgo = signAlgo.getHashAlgo();
            Long mech = hashMechMap.get((Object)hashAlgo);
            if (mech != null && slot.supportsMechanism(mech)) {
                this.mechanism = mech;
                this.z = null;
                this.outputStream = new ByteArrayOutputStream();
            } else if (slot.supportsMechanism(0xFFFFF002L)) {
                this.mechanism = 0xFFFFF002L;
                this.z = GMUtil.getSM2Z(curveOid, pubPointX, pubPointY);
                this.outputStream = new DigestOutputStream((Digest)hashAlgo.createDigest());
            } else {
                throw new XiSecurityException("unsupported signature algorithm " + (Object)((Object)signAlgo));
            }
        }

        public OutputStream getOutputStream() {
            this.reset();
            return this.outputStream;
        }

        private void reset() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                ((DigestOutputStream)this.outputStream).reset();
                try {
                    this.outputStream.write(this.z, 0, this.z.length);
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex.getMessage());
                }
            }
        }

        public byte[] getSignature() {
            try {
                byte[] plainSignature = this.getPlainSignature();
                return SignerUtil.dsaSigPlainToX962(plainSignature);
            }
            catch (XiSecurityException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }

        private byte[] getPlainSignature() throws XiSecurityException, P11TokenException {
            byte[] dataToSign;
            P11Params.P11ByteArrayParams params;
            if (this.outputStream instanceof ByteArrayOutputStream) {
                params = new P11Params.P11ByteArrayParams(GMUtil.getDefaultIDA());
                dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
            } else {
                params = null;
                dataToSign = ((DigestOutputStream)this.outputStream).digest();
            }
            this.reset();
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, params, dataToSign);
        }

        static {
            hashMechMap.put(HashAlgo.SM3, 0xFFFFF003L);
        }
    }

    static class RSAPSS
    extends P11ContentSigner {
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final long mechanism;
        private final P11Params.P11RSAPkcsPssParams parameters;
        private final OutputStream outputStream;

        RSAPSS(P11CryptService cryptService, P11IdentityId identityId, SignAlgo signAlgo, SecureRandom random) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signAlgo);
            if (!signAlgo.isRSAPSSSigAlgo()) {
                throw new XiSecurityException("not an RSA PSS algorithm: " + (Object)((Object)signAlgo));
            }
            Args.notNull((Object)random, (String)"random");
            HashAlgo hashAlgo = signAlgo.getHashAlgo();
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            Long mech = hashMechMap.get((Object)hashAlgo);
            if (mech != null && slot.supportsMechanism(mech)) {
                this.mechanism = mech;
                this.parameters = new P11Params.P11RSAPkcsPssParams(hashAlgo);
                this.outputStream = new ByteArrayOutputStream();
            } else if (!signAlgo.getHashAlgo().isShake() && slot.supportsMechanism(13L)) {
                this.mechanism = 13L;
                this.parameters = new P11Params.P11RSAPkcsPssParams(hashAlgo);
                this.outputStream = new DigestOutputStream((Digest)hashAlgo.createDigest());
            } else if (slot.supportsMechanism(3L)) {
                P11RSAKeyParameter keyParam;
                this.mechanism = 3L;
                this.parameters = null;
                P11PlainRSASigner cipher = new P11PlainRSASigner();
                try {
                    keyParam = P11RSAKeyParameter.getInstance(cryptService, identityId);
                }
                catch (InvalidKeyException ex) {
                    throw new XiSecurityException(ex.getMessage(), ex);
                }
                Signer pssSigner = SignerUtil.createPSSRSASigner(signAlgo, cipher);
                pssSigner.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParam, random));
                this.outputStream = new SignerOutputStream(pssSigner);
            } else {
                throw new XiSecurityException("unsupported signature algorithm " + (Object)((Object)signAlgo));
            }
        }

        public OutputStream getOutputStream() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else if (this.outputStream instanceof DigestOutputStream) {
                ((DigestOutputStream)this.outputStream).reset();
            } else {
                ((SignerOutputStream)this.outputStream).reset();
            }
            return this.outputStream;
        }

        public byte[] getSignature() {
            if (this.outputStream instanceof SignerOutputStream) {
                try {
                    return ((SignerOutputStream)this.outputStream).generateSignature();
                }
                catch (CryptoException ex) {
                    LogUtil.warn((Logger)LOG, (Throwable)ex);
                    throw new RuntimeCryptoException("CryptoException: " + ex.getMessage());
                }
            }
            byte[] dataToSign = this.outputStream instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)this.outputStream).toByteArray() : ((DigestOutputStream)this.outputStream).digest();
            try {
                return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, this.parameters, dataToSign);
            }
            catch (P11TokenException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"could not sign");
                throw new RuntimeCryptoException("SignerException: " + ex.getMessage());
            }
        }

        static {
            hashMechMap.put(HashAlgo.SHA1, 14L);
            hashMechMap.put(HashAlgo.SHA224, 71L);
            hashMechMap.put(HashAlgo.SHA256, 67L);
            hashMechMap.put(HashAlgo.SHA384, 68L);
            hashMechMap.put(HashAlgo.SHA512, 69L);
            hashMechMap.put(HashAlgo.SHA3_224, 103L);
            hashMechMap.put(HashAlgo.SHA3_256, 99L);
            hashMechMap.put(HashAlgo.SHA3_384, 100L);
            hashMechMap.put(HashAlgo.SHA3_512, 101L);
        }
    }

    static class RSA
    extends P11ContentSigner {
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final long mechanism;
        private final OutputStream outputStream;
        private final byte[] digestPkcsPrefix;
        private final int modulusBitLen;

        RSA(P11CryptService cryptService, P11IdentityId identityId, SignAlgo signAlgo) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signAlgo);
            if (!signAlgo.isRSAPkcs1SigAlgo()) {
                throw new XiSecurityException("not an RSA PKCS#1 algorithm: " + (Object)((Object)signAlgo));
            }
            HashAlgo hashAlgo = signAlgo.getHashAlgo();
            Long mech = hashMechMap.get((Object)hashAlgo);
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            if (mech != null && slot.supportsMechanism(mech)) {
                this.mechanism = mech;
            } else if (slot.supportsMechanism(1L)) {
                this.mechanism = 1L;
            } else if (slot.supportsMechanism(3L)) {
                this.mechanism = 3L;
            } else {
                throw new XiSecurityException("unsupported signature algorithm " + (Object)((Object)signAlgo));
            }
            if (this.mechanism == 1L || this.mechanism == 3L) {
                this.digestPkcsPrefix = PKCS1Util.getDigestPkcsPrefix(hashAlgo);
                this.outputStream = new DigestOutputStream((Digest)hashAlgo.createDigest());
            } else {
                this.digestPkcsPrefix = null;
                this.outputStream = new ByteArrayOutputStream();
            }
            RSAPublicKey rsaPubKey = (RSAPublicKey)cryptService.getIdentity(identityId).getPublicKey();
            this.modulusBitLen = rsaPubKey.getModulus().bitLength();
        }

        public OutputStream getOutputStream() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.outputStream;
        }

        public byte[] getSignature() {
            byte[] dataToSign;
            if (this.outputStream instanceof ByteArrayOutputStream) {
                dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                byte[] hashValue = ((DigestOutputStream)this.outputStream).digest();
                ((DigestOutputStream)this.outputStream).reset();
                dataToSign = new byte[this.digestPkcsPrefix.length + hashValue.length];
                System.arraycopy(this.digestPkcsPrefix, 0, dataToSign, 0, this.digestPkcsPrefix.length);
                System.arraycopy(hashValue, 0, dataToSign, this.digestPkcsPrefix.length, hashValue.length);
            }
            try {
                if (this.mechanism == 3L) {
                    dataToSign = PKCS1Util.EMSA_PKCS1_v1_5_encoding(dataToSign, this.modulusBitLen);
                }
                return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
            }
            catch (XiSecurityException | P11TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not sign");
                throw new RuntimeCryptoException("SignerException: " + ex.getMessage());
            }
        }

        static {
            hashMechMap.put(HashAlgo.SHA1, 6L);
            hashMechMap.put(HashAlgo.SHA224, 70L);
            hashMechMap.put(HashAlgo.SHA256, 64L);
            hashMechMap.put(HashAlgo.SHA384, 65L);
            hashMechMap.put(HashAlgo.SHA512, 66L);
            hashMechMap.put(HashAlgo.SHA3_224, 102L);
            hashMechMap.put(HashAlgo.SHA3_256, 96L);
            hashMechMap.put(HashAlgo.SHA3_384, 97L);
            hashMechMap.put(HashAlgo.SHA3_512, 98L);
        }
    }

    static class Mac
    extends P11ContentSigner {
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final long mechanism;
        private final ByteArrayOutputStream outputStream;

        Mac(P11CryptService cryptService, P11IdentityId identityId, SignAlgo signAlgo) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signAlgo);
            HashAlgo hashAlgo = signAlgo.getHashAlgo();
            Long mech = hashMechMap.get((Object)hashAlgo);
            if (mech == null) {
                throw new XiSecurityException("Unsupported signature algorithm " + (Object)((Object)signAlgo));
            }
            this.mechanism = mech;
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            if (slot.supportsMechanism(this.mechanism)) {
                throw new XiSecurityException("unsupported MAC algorithm " + (Object)((Object)signAlgo));
            }
            this.outputStream = new ByteArrayOutputStream();
        }

        public OutputStream getOutputStream() {
            this.outputStream.reset();
            return this.outputStream;
        }

        public byte[] getSignature() {
            try {
                byte[] dataToSign = this.outputStream.toByteArray();
                this.outputStream.reset();
                return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
            }
            catch (P11TokenException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("P11TokenException: " + ex.getMessage());
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }

        static {
            hashMechMap.put(HashAlgo.SHA1, 545L);
            hashMechMap.put(HashAlgo.SHA224, 598L);
            hashMechMap.put(HashAlgo.SHA256, 593L);
            hashMechMap.put(HashAlgo.SHA384, 609L);
            hashMechMap.put(HashAlgo.SHA512, 625L);
            hashMechMap.put(HashAlgo.SHA3_224, 694L);
            hashMechMap.put(HashAlgo.SHA3_256, 689L);
            hashMechMap.put(HashAlgo.SHA3_384, 705L);
            hashMechMap.put(HashAlgo.SHA3_512, 721L);
        }
    }

    static class EdDSA
    extends P11ContentSigner {
        private final ByteArrayOutputStream outputStream;
        private final long mechanism;

        EdDSA(P11CryptService cryptService, P11IdentityId identityId, SignAlgo signAlgo) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signAlgo);
            if (SignAlgo.ED25519 != signAlgo) {
                throw new XiSecurityException("unsupported signature algorithm " + (Object)((Object)signAlgo));
            }
            this.mechanism = 4183L;
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            if (!slot.supportsMechanism(this.mechanism)) {
                throw new XiSecurityException("unsupported signature algorithm " + (Object)((Object)signAlgo));
            }
            this.outputStream = new ByteArrayOutputStream();
        }

        public OutputStream getOutputStream() {
            this.outputStream.reset();
            return this.outputStream;
        }

        public byte[] getSignature() {
            byte[] content = this.outputStream.toByteArray();
            this.outputStream.reset();
            try {
                return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, content);
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }
    }

    static class ECDSA
    extends P11ContentSigner {
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final OutputStream outputStream;
        private final long mechanism;

        ECDSA(P11CryptService cryptService, P11IdentityId identityId, SignAlgo signAlgo) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signAlgo);
            if (!signAlgo.isECDSASigAlgo()) {
                throw new XiSecurityException("not an ECDSA algorithm: " + (Object)((Object)signAlgo));
            }
            Long mech = hashMechMap.get((Object)signAlgo.getHashAlgo());
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            if (mech != null && slot.supportsMechanism(mech)) {
                this.mechanism = mech;
                this.outputStream = new ByteArrayOutputStream();
            } else if (slot.supportsMechanism(4161L)) {
                this.mechanism = 4161L;
                this.outputStream = new DigestOutputStream((Digest)signAlgo.getHashAlgo().createDigest());
            } else {
                throw new XiSecurityException("unsupported signature algorithm " + (Object)((Object)signAlgo));
            }
        }

        public OutputStream getOutputStream() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.outputStream;
        }

        public byte[] getSignature() {
            try {
                byte[] plainSignature = this.getPlainSignature();
                return this.signAlgo.isPlainECDSASigAlgo() ? plainSignature : SignerUtil.dsaSigPlainToX962(plainSignature);
            }
            catch (XiSecurityException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }

        private byte[] getPlainSignature() throws XiSecurityException, P11TokenException {
            byte[] dataToSign;
            if (this.outputStream instanceof ByteArrayOutputStream) {
                dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                dataToSign = ((DigestOutputStream)this.outputStream).digest();
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
        }

        static {
            hashMechMap.put(HashAlgo.SHA1, 4162L);
            hashMechMap.put(HashAlgo.SHA224, 4163L);
            hashMechMap.put(HashAlgo.SHA256, 4164L);
            hashMechMap.put(HashAlgo.SHA384, 4165L);
            hashMechMap.put(HashAlgo.SHA512, 4166L);
            hashMechMap.put(HashAlgo.SHA3_224, 4167L);
            hashMechMap.put(HashAlgo.SHA3_256, 4168L);
            hashMechMap.put(HashAlgo.SHA3_384, 4169L);
            hashMechMap.put(HashAlgo.SHA3_512, 4170L);
        }
    }

    static class DSA
    extends P11ContentSigner {
        private static final Map<HashAlgo, Long> hashMechMap = new HashMap<HashAlgo, Long>();
        private final OutputStream outputStream;
        private final long mechanism;

        DSA(P11CryptService cryptService, P11IdentityId identityId, SignAlgo signAlgo) throws XiSecurityException, P11TokenException {
            super(cryptService, identityId, signAlgo);
            if (!signAlgo.isDSASigAlgo()) {
                throw new XiSecurityException("not a DSA algorithm: " + (Object)((Object)signAlgo));
            }
            Long mech = hashMechMap.get((Object)signAlgo.getHashAlgo());
            P11Slot slot = cryptService.getSlot(identityId.getSlotId());
            if (mech != null && slot.supportsMechanism(mech)) {
                this.mechanism = mech;
                this.outputStream = new ByteArrayOutputStream();
            } else if (slot.supportsMechanism(17L)) {
                this.mechanism = 17L;
                this.outputStream = new DigestOutputStream((Digest)signAlgo.getHashAlgo().createDigest());
            } else {
                throw new XiSecurityException("unsupported signature algorithm " + (Object)((Object)signAlgo));
            }
        }

        public OutputStream getOutputStream() {
            if (this.outputStream instanceof ByteArrayOutputStream) {
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.outputStream;
        }

        public byte[] getSignature() {
            try {
                byte[] plainSignature = this.getPlainSignature();
                return SignerUtil.dsaSigPlainToX962(plainSignature);
            }
            catch (XiSecurityException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex);
                throw new RuntimeCryptoException("XiSecurityException: " + ex.getMessage());
            }
            catch (Throwable th) {
                LogUtil.warn((Logger)LOG, (Throwable)th);
                throw new RuntimeCryptoException(th.getClass().getName() + ": " + th.getMessage());
            }
        }

        private byte[] getPlainSignature() throws XiSecurityException, P11TokenException {
            byte[] dataToSign;
            if (this.outputStream instanceof ByteArrayOutputStream) {
                dataToSign = ((ByteArrayOutputStream)this.outputStream).toByteArray();
                ((ByteArrayOutputStream)this.outputStream).reset();
            } else {
                dataToSign = ((DigestOutputStream)this.outputStream).digest();
                ((DigestOutputStream)this.outputStream).reset();
            }
            return this.cryptService.getIdentity(this.identityId).sign(this.mechanism, null, dataToSign);
        }

        static {
            hashMechMap.put(HashAlgo.SHA1, 18L);
            hashMechMap.put(HashAlgo.SHA224, 19L);
            hashMechMap.put(HashAlgo.SHA256, 20L);
            hashMechMap.put(HashAlgo.SHA384, 21L);
            hashMechMap.put(HashAlgo.SHA512, 22L);
            hashMechMap.put(HashAlgo.SHA3_224, 24L);
            hashMechMap.put(HashAlgo.SHA3_256, 25L);
            hashMechMap.put(HashAlgo.SHA3_384, 26L);
            hashMechMap.put(HashAlgo.SHA3_512, 27L);
        }
    }

    private static class SignerOutputStream
    extends OutputStream {
        private final Signer pssSigner;

        SignerOutputStream(Signer pssSigner) {
            this.pssSigner = pssSigner;
        }

        @Override
        public void write(int oneByte) throws IOException {
            this.pssSigner.update((byte)oneByte);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.pssSigner.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.pssSigner.update(bytes, off, len);
        }

        public void reset() {
            this.pssSigner.reset();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }

        byte[] generateSignature() throws DataLengthException, CryptoException {
            byte[] signature = this.pssSigner.generateSignature();
            this.pssSigner.reset();
            return signature;
        }
    }
}

