/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.util.Args;
import org.xipki.util.LogUtil;

public class P11CryptService {
    private static final Logger LOG = LoggerFactory.getLogger(P11CryptService.class);
    private final P11Module module;

    public P11CryptService(P11Module module) throws P11TokenException {
        this.module = (P11Module)Args.notNull((Object)module, (String)"module");
    }

    public synchronized void refresh() throws P11TokenException {
        LOG.info("refreshing PKCS#11 module {}", (Object)this.module.getName());
        List<P11SlotIdentifier> slotIds = this.module.getSlotIds();
        for (P11SlotIdentifier slotId : slotIds) {
            P11Slot slot;
            try {
                slot = this.module.getSlot(slotId);
            }
            catch (P11TokenException ex) {
                LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("P11TokenException while initializing slot " + slotId));
                continue;
            }
            catch (Throwable th) {
                LOG.error("unexpected error while initializing slot " + slotId, th);
                continue;
            }
            slot.refresh();
        }
        LOG.info("refreshed PKCS#11 module {}", (Object)this.module.getName());
    }

    public P11Module getModule() {
        return this.module;
    }

    public P11Slot getSlot(P11SlotIdentifier slotId) throws P11TokenException {
        return this.module.getSlot(slotId);
    }

    public P11Identity getIdentity(P11IdentityId identityId) throws P11TokenException {
        return this.getIdentity(identityId.getSlotId(), identityId.getKeyId());
    }

    public P11Identity getIdentity(P11SlotIdentifier slotId, P11ObjectIdentifier keyId) throws P11TokenException {
        return this.module.getSlot(slotId).getIdentity(keyId);
    }

    public X509Cert getCert(P11SlotIdentifier slotId, P11ObjectIdentifier certId) throws P11TokenException {
        return this.module.getSlot(slotId).getCert(certId);
    }

    public String toString() {
        return this.module.toString();
    }
}

