/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;

public class P11IdentityId
implements Comparable<P11IdentityId> {
    private final P11SlotIdentifier slotId;
    private final P11ObjectIdentifier keyId;
    private final P11ObjectIdentifier publicKeyId;
    private P11ObjectIdentifier certId;

    public P11IdentityId(P11SlotIdentifier slotId, P11ObjectIdentifier keyId) {
        this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
        this.keyId = (P11ObjectIdentifier)Args.notNull((Object)keyId, (String)"keyId");
        this.publicKeyId = null;
    }

    public P11IdentityId(P11SlotIdentifier slotId, P11ObjectIdentifier keyId, boolean publicKeyAvailable, String publicKeyLabel, boolean certAvailable, String certLabel) {
        this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
        this.keyId = (P11ObjectIdentifier)Args.notNull((Object)keyId, (String)"keyId");
        this.publicKeyId = publicKeyAvailable ? (CompareUtil.equalsObject((Object)publicKeyLabel, (Object)keyId.getLabel()) ? keyId : new P11ObjectIdentifier(keyId.getId(), publicKeyLabel)) : null;
        this.certId = certAvailable ? (CompareUtil.equalsObject((Object)certLabel, (Object)keyId.getLabel()) ? keyId : new P11ObjectIdentifier(keyId.getId(), certLabel)) : null;
    }

    public P11SlotIdentifier getSlotId() {
        return this.slotId;
    }

    public P11ObjectIdentifier getKeyId() {
        return this.keyId;
    }

    public P11ObjectIdentifier getPublicKeyId() {
        return this.publicKeyId;
    }

    public void addCertLabel(String certLabel) {
        this.certId = CompareUtil.equalsObject((Object)certLabel, (Object)this.keyId.getLabel()) ? this.keyId : new P11ObjectIdentifier(this.keyId.getId(), certLabel);
    }

    public P11ObjectIdentifier getCertId() {
        return this.certId;
    }

    @Override
    public int compareTo(P11IdentityId obj) {
        int ct = this.slotId.compareTo(obj.slotId);
        if (ct != 0) {
            return ct;
        }
        return this.keyId.compareTo(obj.keyId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof P11IdentityId)) {
            return false;
        }
        P11IdentityId ei = (P11IdentityId)obj;
        return this.slotId.equals(ei.slotId) && this.keyId.equals(ei.keyId) && CompareUtil.equalsObject((Object)this.publicKeyId, (Object)ei.publicKeyId) && CompareUtil.equalsObject((Object)this.certId, (Object)ei.certId);
    }

    public boolean match(P11SlotIdentifier slotId, String keyLabel) {
        Args.notNull((Object)keyLabel, (String)"objectLabel");
        return this.slotId.equals(slotId) && CompareUtil.equalsObject((Object)keyLabel, (Object)this.keyId.getLabel());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("slot ").append(this.slotId).append(", key ").append(this.keyId);
        if (this.publicKeyId != null && this.publicKeyId != this.keyId) {
            sb.append(", public key ").append(this.publicKeyId);
        }
        if (this.certId != null && this.certId != this.keyId) {
            sb.append(", certificate ").append(this.certId);
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = this.slotId.hashCode() + 31 * this.keyId.hashCode();
        if (this.publicKeyId != null) {
            hashCode += 961 * this.publicKeyId.hashCode();
        }
        if (this.certId != null) {
            hashCode += 29791 * this.certId.hashCode();
        }
        return hashCode;
    }
}

