/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.math.BigInteger;
import java.util.Arrays;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;
import org.xipki.util.Hex;

public class P11ObjectIdentifier
implements Comparable<P11ObjectIdentifier> {
    private final byte[] id;
    private final String idHex;
    private final String label;

    public P11ObjectIdentifier(byte[] id, String label) {
        this.id = (byte[])Args.notNull((Object)id, (String)"id");
        this.idHex = Hex.encode((byte[])id);
        this.label = label;
    }

    public byte[] getId() {
        return this.id;
    }

    public boolean matchesId(byte[] id) {
        return Arrays.equals(id, this.id);
    }

    public boolean matchesLabel(String label) {
        return CompareUtil.equalsObject((Object)label, (Object)this.label);
    }

    public String getIdHex() {
        return this.idHex;
    }

    public String getLabel() {
        return this.label;
    }

    public char[] getLabelChars() {
        return this.label == null ? null : this.label.toCharArray();
    }

    public String toString() {
        return String.format("(id = %s, label = %s)", this.idHex, this.label);
    }

    public int hashCode() {
        int hashCode = new BigInteger(1, this.id).hashCode();
        if (this.label != null) {
            hashCode += 31 * this.label.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof P11ObjectIdentifier)) {
            return false;
        }
        P11ObjectIdentifier another = (P11ObjectIdentifier)obj;
        return Arrays.equals(this.id, another.id) && CompareUtil.equalsObject((Object)this.label, (Object)another.label);
    }

    @Override
    public int compareTo(P11ObjectIdentifier obj) {
        Args.notNull((Object)obj, (String)"obj");
        if (this == obj) {
            return 0;
        }
        if (this.label == null) {
            return obj.label == null ? 0 : 1;
        }
        return obj.label == null ? -1 : this.label.compareTo(obj.label);
    }
}

