/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.xipki.security.EdECConstants;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.util.Args;

public class P11PrivateKey
implements PrivateKey {
    private final P11CryptService p11CryptService;
    private final P11IdentityId identityId;
    private final String algorithm;
    private final int keysize;
    private final PublicKey publicKey;

    public P11PrivateKey(P11CryptService p11CryptService, P11IdentityId identityId) throws P11TokenException {
        this.p11CryptService = (P11CryptService)Args.notNull((Object)p11CryptService, (String)"p11CryptService");
        this.identityId = (P11IdentityId)Args.notNull((Object)identityId, (String)"identityId");
        this.publicKey = p11CryptService.getIdentity(identityId).getPublicKey();
        if (this.publicKey instanceof RSAPublicKey) {
            this.algorithm = "RSA";
            this.keysize = ((RSAPublicKey)this.publicKey).getModulus().bitLength();
        } else if (this.publicKey instanceof DSAPublicKey) {
            this.algorithm = "DSA";
            this.keysize = ((DSAPublicKey)this.publicKey).getParams().getP().bitLength();
        } else if (this.publicKey instanceof ECPublicKey) {
            this.algorithm = "EC";
            this.keysize = ((ECPublicKey)this.publicKey).getParams().getCurve().getField().getFieldSize();
        } else if (this.publicKey instanceof EdDSAKey) {
            this.algorithm = this.publicKey.getAlgorithm();
            this.keysize = EdECConstants.getKeyBitSize(EdECConstants.getCurveOid(this.algorithm));
        } else {
            throw new P11TokenException("unknown public key: " + this.publicKey);
        }
    }

    public boolean supportsMechanism(long mechanism) {
        try {
            return this.p11CryptService.getSlot(this.identityId.getSlotId()).supportsMechanism(mechanism);
        }
        catch (P11TokenException ex) {
            return false;
        }
    }

    @Override
    public String getFormat() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return null;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getKeysize() {
        return this.keysize;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(long mechanism, P11Params parameters, byte[] content) throws XiSecurityException, P11TokenException {
        return this.p11CryptService.getIdentity(this.identityId).sign(mechanism, parameters, content);
    }

    public P11CryptService getP11CryptService() {
        return this.p11CryptService;
    }

    public P11IdentityId getIdentityId() {
        return this.identityId;
    }
}

