/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import iaik.pkcs.pkcs11.wrapper.Functions;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs11.P11DuplicateEntityException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11PermissionException;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.P11UnknownEntityException;
import org.xipki.security.pkcs11.P11UnsupportedMechanismException;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CompareUtil;
import org.xipki.util.Hex;
import org.xipki.util.StringUtil;

public abstract class P11Slot
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(P11Slot.class);
    protected final String moduleName;
    protected final P11SlotIdentifier slotId;
    private final boolean readOnly;
    private final SecureRandom random = new SecureRandom();
    private final ConcurrentHashMap<P11ObjectIdentifier, P11Identity> identities = new ConcurrentHashMap();
    private final ConcurrentHashMap<P11ObjectIdentifier, X509Cert> certificates = new ConcurrentHashMap();
    private final Set<Long> mechanisms = new HashSet<Long>();
    private final P11ModuleConf.P11MechanismFilter mechanismFilter;
    protected final Integer numSessions;
    protected final List<Long> secretKeyTypes;
    protected final List<Long> keyPairTypes;

    protected P11Slot(String moduleName, P11SlotIdentifier slotId, boolean readOnly, P11ModuleConf.P11MechanismFilter mechanismFilter, Integer numSessions, List<Long> secretKeyTypes, List<Long> keyPairTypes) throws P11TokenException {
        this.mechanismFilter = (P11ModuleConf.P11MechanismFilter)Args.notNull((Object)mechanismFilter, (String)"mechanismFilter");
        this.moduleName = Args.notBlank((String)moduleName, (String)"moduleName");
        this.slotId = (P11SlotIdentifier)Args.notNull((Object)slotId, (String)"slotId");
        this.readOnly = readOnly;
        this.numSessions = numSessions;
        this.secretKeyTypes = secretKeyTypes;
        this.keyPairTypes = keyPairTypes;
    }

    protected static String hex(byte[] bytes) {
        return Hex.encode((byte[])bytes);
    }

    protected static byte[] decodeHex(String hex) {
        return Hex.decode((String)hex);
    }

    public static String getDescription(byte[] keyId, char[] keyLabel) {
        return StringUtil.concat((String)"id ", (String[])new String[]{keyId == null ? "null" : P11Slot.hex(keyId), " and label ", keyLabel == null ? "null" : new String(keyLabel)});
    }

    public static String getDescription(byte[] keyId, String keyLabel) {
        return StringUtil.concat((String)"id ", (String[])new String[]{keyId == null ? "null" : P11Slot.hex(keyId), " and label ", keyLabel});
    }

    protected abstract void updateCertificate0(P11ObjectIdentifier var1, X509Cert var2) throws P11TokenException, CertificateException;

    protected abstract void removeIdentity0(P11IdentityId var1) throws P11TokenException;

    protected abstract P11ObjectIdentifier addCert0(X509Cert var1, P11NewObjectControl var2) throws P11TokenException, CertificateException;

    protected abstract P11Identity generateSecretKey0(long var1, int var3, P11NewKeyControl var4) throws P11TokenException;

    protected abstract P11Identity importSecretKey0(long var1, byte[] var3, P11NewKeyControl var4) throws P11TokenException;

    protected abstract P11Identity generateDSAKeypair0(BigInteger var1, BigInteger var2, BigInteger var3, P11NewKeyControl var4) throws P11TokenException;

    protected abstract P11Identity generateECEdwardsKeypair0(ASN1ObjectIdentifier var1, P11NewKeyControl var2) throws P11TokenException;

    protected abstract PrivateKeyInfo generateECEdwardsKeypairOtf0(ASN1ObjectIdentifier var1) throws P11TokenException;

    protected abstract P11Identity generateECMontgomeryKeypair0(ASN1ObjectIdentifier var1, P11NewKeyControl var2) throws P11TokenException;

    protected abstract PrivateKeyInfo generateECMontgomeryKeypairOtf0(ASN1ObjectIdentifier var1) throws P11TokenException;

    protected abstract P11Identity generateECKeypair0(ASN1ObjectIdentifier var1, P11NewKeyControl var2) throws P11TokenException;

    protected abstract PrivateKeyInfo generateECKeypairOtf0(ASN1ObjectIdentifier var1) throws P11TokenException;

    protected abstract P11Identity generateSM2Keypair0(P11NewKeyControl var1) throws P11TokenException;

    protected abstract PrivateKeyInfo generateSM2KeypairOtf0() throws P11TokenException;

    protected abstract P11Identity generateRSAKeypair0(int var1, BigInteger var2, P11NewKeyControl var3) throws P11TokenException;

    protected abstract P11SlotRefreshResult refresh0() throws P11TokenException;

    protected abstract void removeCerts0(P11ObjectIdentifier var1) throws P11TokenException;

    @Override
    public abstract void close();

    public abstract int removeObjectsForId(byte[] var1) throws P11TokenException;

    public abstract int removeObjectsForLabel(String var1) throws P11TokenException;

    public abstract int removeObjects(byte[] var1, String var2) throws P11TokenException;

    public X509Cert getCertForId(byte[] id) {
        for (P11ObjectIdentifier objId : this.certificates.keySet()) {
            if (!objId.matchesId(id)) continue;
            return this.certificates.get(objId);
        }
        return null;
    }

    public X509Cert getCert(P11ObjectIdentifier objectId) {
        return this.certificates.get(objectId);
    }

    private void updateCaCertsOfIdentities() {
        for (P11Identity identity : this.identities.values()) {
            this.updateCaCertsOfIdentity(identity);
        }
    }

    private void updateCaCertsOfIdentity(P11Identity identity) {
        Object[] certchain = identity.certificateChain();
        if (certchain == null || certchain.length == 0) {
            return;
        }
        Object[] newCertchain = this.buildCertPath(certchain[0]);
        if (!Arrays.equals(certchain, newCertchain)) {
            try {
                identity.setCertificates((X509Cert[])newCertchain);
            }
            catch (P11TokenException ex) {
                LOG.warn("could not set certificates for identity {}", (Object)identity.getId());
            }
        }
    }

    private X509Cert[] buildCertPath(X509Cert cert) {
        LinkedList<X509Cert> certs = new LinkedList<X509Cert>();
        X509Cert cur = cert;
        while (cur != null) {
            certs.add(cur);
            cur = this.getIssuerForCert(cur);
        }
        return certs.toArray(new X509Cert[0]);
    }

    private X509Cert getIssuerForCert(X509Cert cert) {
        try {
            if (cert.isSelfSigned()) {
                return null;
            }
            for (X509Cert cert2 : this.certificates.values()) {
                if (cert2 == cert || !X509Util.issues(cert2, cert)) continue;
                return cert2;
            }
        }
        catch (CertificateEncodingException ex) {
            LOG.warn("invalid encoding of certificate {}", (Object)ex.getMessage());
        }
        return null;
    }

    public void refresh() throws P11TokenException {
        P11SlotRefreshResult res = this.refresh0();
        this.mechanisms.clear();
        this.certificates.clear();
        this.identities.clear();
        ArrayList<Long> ignoreMechs = new ArrayList<Long>();
        for (Long mech : res.getMechanisms()) {
            if (this.mechanismFilter.isMechanismPermitted(this.slotId, mech)) {
                this.mechanisms.add(mech);
                continue;
            }
            ignoreMechs.add(mech);
        }
        this.certificates.putAll(res.getCertificates());
        this.identities.putAll(res.getIdentities());
        this.updateCaCertsOfIdentities();
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("initialized module ").append(this.moduleName).append(", slot ").append(this.slotId);
            sb.append("\nsupported mechanisms:\n");
            ArrayList<Long> sortedMechs = new ArrayList<Long>(this.mechanisms);
            Collections.sort(sortedMechs);
            for (Long mech : sortedMechs) {
                sb.append("\t").append(Functions.getMechanismDescription((long)mech)).append("\n");
            }
            sb.append("\nsupported by device but ignored mechanisms:\n");
            if (ignoreMechs.isEmpty()) {
                sb.append("\tNONE\n");
            } else {
                Collections.sort(ignoreMechs);
                for (Long mech : ignoreMechs) {
                    sb.append("\t").append(Functions.getMechanismDescription((long)mech)).append("\n");
                }
            }
            List<P11ObjectIdentifier> ids = this.getSortedObjectIds(this.certificates.keySet());
            sb.append(ids.size()).append(" certificates:\n");
            for (P11ObjectIdentifier objectId : ids) {
                X509Cert entity = this.certificates.get(objectId);
                sb.append("\t").append(objectId);
                sb.append(", subject='").append(entity.getSubjectText()).append("'\n");
            }
            ids = this.getSortedObjectIds(this.identities.keySet());
            sb.append(ids.size()).append(" identities:\n");
            for (P11ObjectIdentifier objectId : ids) {
                P11Identity identity = this.identities.get(objectId);
                sb.append("\t").append(objectId);
                PublicKey publicKey = identity.getPublicKey();
                if (publicKey != null) {
                    String algo = P11Slot.getAlgorithmDesc(publicKey);
                    sb.append(", algo=").append(algo);
                    if (identity.getCertificate() != null) {
                        String subject = identity.getCertificate().getSubjectText();
                        sb.append(", subject='").append(subject).append("'");
                    }
                } else {
                    sb.append(", algo=<symmetric>");
                }
                sb.append("\n");
            }
            LOG.info(sb.toString());
        }
    }

    protected void addIdentity(P11Identity identity) throws P11DuplicateEntityException {
        if (!this.slotId.equals(identity.getId().getSlotId())) {
            throw new IllegalArgumentException("invalid identity");
        }
        P11ObjectIdentifier keyId = identity.getId().getKeyId();
        if (this.hasIdentity(keyId)) {
            throw new P11DuplicateEntityException(this.slotId, keyId);
        }
        this.identities.put(keyId, identity);
        this.updateCaCertsOfIdentity(identity);
    }

    public boolean hasIdentity(P11ObjectIdentifier keyId) {
        return this.identities.containsKey(keyId);
    }

    public Set<Long> getMechanisms() {
        return Collections.unmodifiableSet(this.mechanisms);
    }

    public boolean supportsMechanism(long mechanism) {
        return this.mechanisms.contains(mechanism);
    }

    public void assertMechanismSupported(long mechanism) throws P11UnsupportedMechanismException {
        if (!this.mechanisms.contains(mechanism)) {
            throw new P11UnsupportedMechanismException(mechanism, this.slotId);
        }
    }

    public Set<P11ObjectIdentifier> getIdentityKeyIds() {
        return Collections.unmodifiableSet(this.identities.keySet());
    }

    public Set<P11ObjectIdentifier> getCertIds() {
        return Collections.unmodifiableSet(this.certificates.keySet());
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public P11SlotIdentifier getSlotId() {
        return this.slotId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public P11Identity getIdentity(P11ObjectIdentifier keyId) throws P11UnknownEntityException {
        P11Identity ident = this.identities.get(keyId);
        if (ident == null) {
            throw new P11UnknownEntityException(this.slotId, keyId);
        }
        return ident;
    }

    protected void assertNoIdentityAndCert(byte[] id, String label) throws P11DuplicateEntityException {
        if (id == null && label == null) {
            return;
        }
        HashSet objectIds = new HashSet(this.identities.keySet());
        objectIds.addAll(this.certificates.keySet());
        for (P11ObjectIdentifier objectId : objectIds) {
            boolean matchId = id != null && objectId.matchesId(id);
            boolean matchLabel = CompareUtil.equalsObject((Object)label, (Object)objectId.getLabel());
            if (!matchId && !matchLabel) continue;
            StringBuilder sb = new StringBuilder("Identity or Certificate with ");
            if (matchId) {
                sb.append("id=0x").append(Hex.encodeUpper((byte[])id));
                if (matchLabel) {
                    sb.append(" and ");
                }
            }
            if (matchLabel) {
                sb.append("label=").append(label);
            }
            sb.append(" already exists");
            throw new P11DuplicateEntityException(sb.toString());
        }
    }

    public P11ObjectIdentifier getObjectIdForId(byte[] id) {
        return this.getObjectId(id, null);
    }

    public P11ObjectIdentifier getObjectIdForLabel(String label) {
        return this.getObjectId(null, label);
    }

    private P11ObjectIdentifier getObjectId(byte[] id, String label) {
        boolean match;
        if (id == null && label == null) {
            return null;
        }
        for (P11ObjectIdentifier objectId : this.identities.keySet()) {
            match = true;
            if (id != null) {
                match = objectId.matchesId(id);
            }
            if (label != null) {
                match = objectId.matchesLabel(label);
            }
            if (!match) continue;
            return objectId;
        }
        for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
            match = true;
            if (id != null) {
                match = objectId.matchesId(id);
            }
            if (label != null) {
                match = label.equals(objectId.getLabel());
            }
            if (!match) continue;
            return objectId;
        }
        return null;
    }

    public P11IdentityId getIdentityId(byte[] keyId, String keyLabel) {
        if (keyId == null && keyLabel == null) {
            return null;
        }
        for (P11ObjectIdentifier objectId : this.identities.keySet()) {
            boolean match = true;
            if (keyId != null) {
                match = objectId.matchesId(keyId);
            }
            if (keyLabel != null) {
                match = keyLabel.equals(objectId.getLabel());
            }
            if (!match) continue;
            return this.identities.get(objectId).getId();
        }
        return null;
    }

    public X509Cert exportCert(P11ObjectIdentifier objectId) throws P11TokenException {
        Args.notNull((Object)objectId, (String)"objectId");
        try {
            return this.getIdentity(objectId).getCertificate();
        }
        catch (P11UnknownEntityException p11UnknownEntityException) {
            X509Cert cert = this.certificates.get(objectId);
            if (cert == null) {
                throw new P11UnknownEntityException(this.slotId, objectId);
            }
            return cert;
        }
    }

    public void removeCerts(P11ObjectIdentifier objectId) throws P11TokenException {
        Args.notNull((Object)objectId, (String)"objectId");
        this.assertWritable("removeCerts");
        P11ObjectIdentifier keyId = null;
        for (P11ObjectIdentifier m : this.identities.keySet()) {
            P11Identity identity = this.identities.get(m);
            if (!objectId.equals(identity.getId().getCertId())) continue;
            keyId = m;
            break;
        }
        if (keyId != null) {
            this.certificates.remove(objectId);
            this.identities.get(keyId).setCertificates(null);
        } else if (this.certificates.containsKey(objectId)) {
            this.certificates.remove(objectId);
        } else {
            throw new P11UnknownEntityException(this.slotId, objectId);
        }
        this.updateCaCertsOfIdentities();
        this.removeCerts0(objectId);
    }

    public void removeIdentity(P11IdentityId identityId) throws P11TokenException {
        Args.notNull((Object)identityId, (String)"identityId");
        this.assertWritable("removeIdentity");
        P11ObjectIdentifier keyId = identityId.getKeyId();
        if (this.identities.containsKey(keyId)) {
            if (identityId.getCertId() != null) {
                this.certificates.remove(identityId.getCertId());
            }
            this.identities.get(keyId).setCertificates(null);
            this.identities.remove(keyId);
            this.updateCaCertsOfIdentities();
        }
        this.removeIdentity0(identityId);
    }

    public void removeIdentityByKeyId(P11ObjectIdentifier keyId) throws P11TokenException {
        Args.notNull((Object)keyId, (String)"keyId");
        this.assertWritable("removeIdentityByKeyId");
        if (this.identities.containsKey(keyId)) {
            P11IdentityId entityId = this.identities.get(keyId).getId();
            if (entityId.getCertId() != null) {
                this.certificates.remove(entityId.getCertId());
            }
            this.identities.get(keyId).setCertificates(null);
            this.identities.remove(keyId);
            this.updateCaCertsOfIdentities();
            this.removeIdentity0(entityId);
        }
    }

    public P11ObjectIdentifier addCert(X509Cert cert, P11NewObjectControl control) throws P11TokenException, CertificateException {
        Args.notNull((Object)cert, (String)"cert");
        Args.notNull((Object)control, (String)"control");
        this.assertWritable("addCert");
        if (control.getLabel() == null) {
            String cn = cert.getCommonName();
            control = new P11NewObjectControl(control.getId(), this.generateLabel(cn));
        }
        P11ObjectIdentifier objectId = this.addCert0(cert, control);
        this.certificates.put(objectId, cert);
        this.updateCaCertsOfIdentities();
        LOG.info("added certificate {}", (Object)objectId);
        return objectId;
    }

    protected String generateLabel(String label) {
        String tmpLabel = label;
        int idx = 0;
        while (true) {
            boolean duplicated = false;
            for (P11ObjectIdentifier objectId : this.identities.keySet()) {
                P11IdentityId identityId = this.identities.get(objectId).getId();
                P11ObjectIdentifier pubKeyId = identityId.getPublicKeyId();
                P11ObjectIdentifier certId = identityId.getCertId();
                if (!label.equals(objectId.getLabel()) && (pubKeyId == null || !label.equals(pubKeyId.getLabel())) && (certId == null || !label.equals(certId.getLabel()))) continue;
                duplicated = true;
                break;
            }
            if (!duplicated) {
                for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
                    if (!objectId.getLabel().equals(label)) continue;
                    duplicated = true;
                    break;
                }
            }
            if (!duplicated) {
                return tmpLabel;
            }
            tmpLabel = label + "-" + ++idx;
        }
    }

    public P11IdentityId generateSecretKey(long keyType, int keysize, P11NewKeyControl control) throws P11TokenException {
        this.assertWritable("generateSecretKey");
        Args.notNull((Object)control, (String)"control");
        this.assertNoIdentityAndCert(control.getId(), control.getLabel());
        this.assertSecretKeyAllowed(keyType);
        P11Identity identity = this.generateSecretKey0(keyType, keysize, control);
        this.addIdentity(identity);
        P11IdentityId id = identity.getId();
        LOG.info("generated secret key {}", (Object)id);
        return id;
    }

    public P11ObjectIdentifier importSecretKey(long keyType, byte[] keyValue, P11NewKeyControl control) throws P11TokenException {
        Args.notNull((Object)control, (String)"control");
        this.assertWritable("createSecretKey");
        this.assertNoIdentityAndCert(control.getId(), control.getLabel());
        this.assertSecretKeyAllowed(keyType);
        P11Identity identity = this.importSecretKey0(keyType, keyValue, control);
        this.addIdentity(identity);
        P11ObjectIdentifier objId = identity.getId().getKeyId();
        LOG.info("created secret key {}", (Object)objId);
        return objId;
    }

    private void assertSecretKeyAllowed(long keyType) throws P11TokenException {
        if (this.secretKeyTypes == null) {
            return;
        }
        if (!this.secretKeyTypes.contains(keyType)) {
            throw new P11TokenException("secret key type 0x" + Long.toHexString(keyType) + "unsupported");
        }
    }

    public PrivateKeyInfo generateRSAKeypairOtf(int keysize, BigInteger publicExponent) throws P11TokenException {
        Args.min((int)keysize, (String)"keysize", (int)1024);
        if (keysize % 1024 != 0) {
            throw new IllegalArgumentException("key size is not multiple of 1024: " + keysize);
        }
        this.assertMechanismSupported(0L);
        return this.generateRSAKeypairOtf0(keysize, publicExponent == null ? RSAKeyGenParameterSpec.F4 : publicExponent);
    }

    protected abstract PrivateKeyInfo generateRSAKeypairOtf0(int var1, BigInteger var2) throws P11TokenException;

    public P11IdentityId generateRSAKeypair(int keysize, BigInteger publicExponent, P11NewKeyControl control) throws P11TokenException {
        Args.min((int)keysize, (String)"keysize", (int)1024);
        if (keysize % 1024 != 0) {
            throw new IllegalArgumentException("key size is not multiple of 1024: " + keysize);
        }
        this.assertCanGenKeypair("generateRSAKeypair", 0L, control);
        P11Identity identity = this.generateRSAKeypair0(keysize, publicExponent == null ? RSAKeyGenParameterSpec.F4 : publicExponent, control);
        this.addIdentity(identity);
        P11IdentityId id = identity.getId();
        LOG.info("generated RSA keypair {}", (Object)id);
        return id;
    }

    public PrivateKeyInfo generateDSAKeypairOtf(BigInteger p, BigInteger q, BigInteger g) throws P11TokenException {
        Args.notNull((Object)p, (String)"p");
        Args.notNull((Object)q, (String)"q");
        Args.notNull((Object)g, (String)"g");
        this.assertMechanismSupported(16L);
        return this.generateDSAKeypairOtf0(p, q, g);
    }

    protected abstract PrivateKeyInfo generateDSAKeypairOtf0(BigInteger var1, BigInteger var2, BigInteger var3) throws P11TokenException;

    public P11IdentityId generateDSAKeypair(int plength, int qlength, P11NewKeyControl control) throws P11TokenException {
        Args.min((int)plength, (String)"plength", (int)1024);
        if (plength % 1024 != 0) {
            throw new IllegalArgumentException("key size is not multiple of 1024: " + plength);
        }
        DSAParameterSpec dsaParams = DSAParameterCache.getDSAParameterSpec(plength, qlength, this.random);
        return this.generateDSAKeypair(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG(), control);
    }

    public P11IdentityId generateDSAKeypair(BigInteger p, BigInteger q, BigInteger g, P11NewKeyControl control) throws P11TokenException {
        Args.notNull((Object)p, (String)"p");
        Args.notNull((Object)q, (String)"q");
        Args.notNull((Object)g, (String)"g");
        this.assertCanGenKeypair("generateDSAKeypair", 16L, control);
        P11Identity identity = this.generateDSAKeypair0(p, q, g, control);
        this.addIdentity(identity);
        P11IdentityId id = identity.getId();
        LOG.info("generated DSA keypair {}", (Object)id);
        return id;
    }

    public PrivateKeyInfo generateECKeypairOtf(ASN1ObjectIdentifier curveOid) throws P11TokenException {
        Args.notNull((Object)curveOid, (String)"curveOid");
        if (EdECConstants.isEdwardsCurve(curveOid)) {
            this.assertMechanismSupported(4181L);
            return this.generateECEdwardsKeypairOtf0(curveOid);
        }
        if (EdECConstants.isMontgomeryCurve(curveOid)) {
            this.assertMechanismSupported(4182L);
            return this.generateECMontgomeryKeypairOtf0(curveOid);
        }
        this.assertMechanismSupported(4160L);
        return this.generateECKeypairOtf0(curveOid);
    }

    public P11IdentityId generateECKeypair(ASN1ObjectIdentifier curveOid, P11NewKeyControl control) throws P11TokenException {
        P11Identity identity;
        Args.notNull((Object)curveOid, (String)"curveOid");
        if (EdECConstants.isEdwardsCurve(curveOid)) {
            this.assertCanGenKeypair("generateECKeypair", 4181L, control);
            identity = this.generateECEdwardsKeypair0(curveOid, control);
        } else if (EdECConstants.isMontgomeryCurve(curveOid)) {
            this.assertCanGenKeypair("generateECKeypair", 4182L, control);
            identity = this.generateECMontgomeryKeypair0(curveOid, control);
        } else {
            this.assertCanGenKeypair("generateECKeypair", 4160L, control);
            identity = this.generateECKeypair0(curveOid, control);
        }
        this.addIdentity(identity);
        P11IdentityId id = identity.getId();
        LOG.info("generated EC keypair {}", (Object)id);
        return id;
    }

    public PrivateKeyInfo generateSM2KeypairOtf() throws P11TokenException {
        this.assertMechanismSupported(0xFFFFF001L);
        return this.generateSM2KeypairOtf0();
    }

    public P11IdentityId generateSM2Keypair(P11NewKeyControl control) throws P11TokenException {
        this.assertCanGenKeypair("generateSM2Keypair", 0xFFFFF001L, control);
        P11Identity identity = this.generateSM2Keypair0(control);
        this.addIdentity(identity);
        P11IdentityId id = identity.getId();
        LOG.info("generated SM2 keypair {}", (Object)id);
        return id;
    }

    private void assertCanGenKeypair(String methodName, long mechanism, P11NewKeyControl control) throws P11UnsupportedMechanismException, P11PermissionException, P11DuplicateEntityException {
        long keyType;
        Args.notNull((Object)control, (String)"control");
        this.assertWritable(methodName);
        this.assertMechanismSupported(mechanism);
        this.assertNoIdentityAndCert(control.getId(), control.getLabel());
        if (this.keyPairTypes == null) {
            return;
        }
        if (0L == mechanism) {
            keyType = 0L;
        } else if (4160L == mechanism) {
            keyType = 3L;
        } else if (4181L == mechanism) {
            keyType = 64L;
        } else if (4182L == mechanism) {
            keyType = 65L;
        } else if (16L == mechanism) {
            keyType = 1L;
        } else if (0xFFFFF001L == mechanism) {
            keyType = 0xFFFFF001L;
        } else {
            throw new IllegalStateException("unknown KeyPair generation mechanism " + mechanism);
        }
        if (!this.keyPairTypes.contains(keyType)) {
            LOG.error("Keypair of key type 0x{} unsupported", (Object)Long.toHexString(keyType));
            throw new P11UnsupportedMechanismException(mechanism, this.slotId);
        }
    }

    public void updateCertificate(P11ObjectIdentifier keyId, X509Cert newCert) throws P11TokenException, CertificateException {
        PublicKey newPk;
        Args.notNull((Object)keyId, (String)"keyId");
        Args.notNull((Object)newCert, (String)"newCert");
        this.assertWritable("updateCertificate");
        P11Identity identity = this.identities.get(keyId);
        if (identity == null) {
            throw new P11UnknownEntityException("could not find private key " + keyId);
        }
        PublicKey pk = identity.getPublicKey();
        if (!pk.equals(newPk = newCert.getPublicKey())) {
            throw new P11TokenException("the given certificate is not for key " + keyId);
        }
        this.updateCertificate0(keyId, newCert);
        this.certificates.put(keyId, newCert);
        identity.setCertificates(new X509Cert[]{newCert});
        identity.getId().addCertLabel(keyId.getLabel());
        this.updateCaCertsOfIdentities();
        LOG.info("updated certificate for key {}", (Object)keyId);
    }

    public void showDetails(OutputStream stream, boolean verbose) throws IOException {
        Args.notNull((Object)stream, (String)"stream");
        List<P11ObjectIdentifier> sortedKeyIds = this.getSortedObjectIds(this.identities.keySet());
        int size = sortedKeyIds.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            P11ObjectIdentifier pubKeyId;
            Iterator keyId = sortedKeyIds.get(i);
            P11Identity identity = this.identities.get(keyId);
            String label = ((P11ObjectIdentifier)((Object)keyId)).getLabel();
            sb.append("\t").append(i + 1).append(". ").append(label);
            sb.append(" (").append("id: ").append(((P11ObjectIdentifier)((Object)keyId)).getIdHex());
            P11IdentityId identityId = identity.getId();
            P11ObjectIdentifier certId = identityId.getCertId();
            if (certId != null && !certId.equals(keyId)) {
                sb.append(", certificate label: ").append(identityId.getCertId().getLabel());
            }
            if ((pubKeyId = identityId.getPublicKeyId()) != null && !pubKeyId.equals(keyId)) {
                sb.append(", publicKey label: ").append(pubKeyId.getLabel());
            }
            sb.append(")\n");
            if (identity.getPublicKey() != null) {
                String algo = P11Slot.getAlgorithmDesc(identity.getPublicKey());
                sb.append("\t\tAlgorithm: ").append(algo).append("\n");
                X509Cert[] certs = identity.certificateChain();
                if (certs == null || certs.length == 0) {
                    sb.append("\t\tCertificate: NONE\n");
                    continue;
                }
                for (int j = 0; j < certs.length; ++j) {
                    P11Slot.formatString(j, verbose, sb, certs[j]);
                }
                continue;
            }
            sb.append("\t\tSymmetric key\n");
        }
        HashSet<P11ObjectIdentifier> certIdsWithIdentities = new HashSet<P11ObjectIdentifier>();
        for (P11Identity identity : this.identities.values()) {
            P11ObjectIdentifier certId = identity.getId().getCertId();
            if (certId == null) continue;
            certIdsWithIdentities.add(certId);
        }
        sortedKeyIds.clear();
        for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
            if (certIdsWithIdentities.contains(objectId)) continue;
            sortedKeyIds.add(objectId);
        }
        Collections.sort(sortedKeyIds);
        if (!sortedKeyIds.isEmpty()) {
            size = sortedKeyIds.size();
            for (int i = 0; i < size; ++i) {
                P11ObjectIdentifier objectId;
                objectId = sortedKeyIds.get(i);
                sb.append("\tCert-").append(i + 1).append(". ").append(objectId.getLabel());
                sb.append(" (").append("id: ").append(objectId.getIdHex()).append(", label: ").append(objectId.getLabel()).append(")\n");
                P11Slot.formatString(null, verbose, sb, this.certificates.get(objectId));
            }
        }
        if (sb.length() > 0) {
            stream.write(StringUtil.toUtf8Bytes((String)sb.toString()));
        }
    }

    protected void assertWritable(String operationName) throws P11PermissionException {
        if (this.readOnly) {
            throw new P11PermissionException("Writable operation " + operationName + " is not permitted");
        }
    }

    protected boolean existsIdentityForId(byte[] id) {
        for (P11ObjectIdentifier objectId : this.identities.keySet()) {
            if (!objectId.matchesId(id)) continue;
            return true;
        }
        return false;
    }

    protected boolean existsIdentityForLabel(String label) {
        for (P11ObjectIdentifier objectId : this.identities.keySet()) {
            if (!objectId.matchesLabel(label)) continue;
            return true;
        }
        return false;
    }

    protected boolean existsCertForId(byte[] id) {
        for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
            if (!objectId.matchesId(id)) continue;
            return true;
        }
        return false;
    }

    protected boolean existsCertForLabel(String label) {
        for (P11ObjectIdentifier objectId : this.certificates.keySet()) {
            if (!objectId.matchesLabel(label)) continue;
            return true;
        }
        return false;
    }

    private static String getAlgorithmDesc(PublicKey publicKey) {
        String algo = publicKey.getAlgorithm();
        if (publicKey instanceof ECPublicKey) {
            String curveName = "UNKNOWN";
            ECParameterSpec paramSpec = ((ECPublicKey)publicKey).getParams();
            ASN1ObjectIdentifier curveOid = KeyUtil.detectCurveOid(paramSpec);
            if (curveOid != null) {
                String name = AlgorithmUtil.getCurveName(curveOid);
                curveName = name == null ? curveOid.getId() : name;
            }
            algo = algo + "/" + curveName;
        } else if (publicKey instanceof RSAPublicKey) {
            int keylen = ((RSAPublicKey)publicKey).getModulus().bitLength();
            algo = algo + "/" + keylen;
        } else if (publicKey instanceof DSAPublicKey) {
            int keylen = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
            algo = algo + "/" + keylen;
        }
        return algo;
    }

    private static void formatString(Integer index, boolean verbose, StringBuilder sb, X509Cert cert) {
        String subject = cert.getSubjectText();
        sb.append("\t\tCertificate");
        if (index != null) {
            sb.append("[").append(index).append("]");
        }
        sb.append(": ");
        if (!verbose) {
            sb.append(subject).append("\n");
            return;
        }
        sb.append("\n\t\t\tSubject: ").append(subject);
        sb.append("\n\t\t\tIssuer: ").append(cert.getIssuerText());
        sb.append("\n\t\t\tSerial: ").append(cert.getSerialNumberHex());
        sb.append("\n\t\t\tStart time: ").append(cert.getNotBefore());
        sb.append("\n\t\t\tEnd time: ").append(cert.getNotAfter());
        sb.append("\n\t\t\tSHA1 Sum: ");
        sb.append(HashAlgo.SHA1.hexHash(new byte[][]{cert.getEncoded()}));
        sb.append("\n");
    }

    private List<P11ObjectIdentifier> getSortedObjectIds(Set<P11ObjectIdentifier> sets) {
        ArrayList<P11ObjectIdentifier> ids = new ArrayList<P11ObjectIdentifier>(sets);
        Collections.sort(ids);
        return ids;
    }

    public static class P11NewKeyControl
    extends P11NewObjectControl {
        private Boolean extractable;
        private Boolean sensitive;
        private Set<P11KeyUsage> usages;

        public P11NewKeyControl(byte[] id, String label) {
            super(id, label);
        }

        public Boolean getExtractable() {
            return this.extractable;
        }

        public void setExtractable(Boolean extractable) {
            this.extractable = extractable;
        }

        public Boolean getSensitive() {
            return this.sensitive;
        }

        public void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }

        public Set<P11KeyUsage> getUsages() {
            if (this.usages == null) {
                this.usages = new HashSet<P11KeyUsage>();
            }
            return this.usages;
        }

        public void setUsages(Set<P11KeyUsage> usages) {
            this.usages = usages;
        }
    }

    public static enum P11KeyUsage {
        DECRYPT,
        DERIVE,
        SIGN,
        SIGN_RECOVER,
        UNWRAP;

    }

    public static class P11NewObjectControl {
        private final byte[] id;
        private final String label;

        public P11NewObjectControl(byte[] id, String label) {
            this.id = id;
            this.label = Args.notBlank((String)label, (String)"label");
        }

        public byte[] getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static class P11SlotRefreshResult {
        private final Map<P11ObjectIdentifier, P11Identity> identities = new HashMap<P11ObjectIdentifier, P11Identity>();
        private final Map<P11ObjectIdentifier, X509Cert> certificates = new HashMap<P11ObjectIdentifier, X509Cert>();
        private final Set<Long> mechanisms = new HashSet<Long>();

        public Map<P11ObjectIdentifier, P11Identity> getIdentities() {
            return this.identities;
        }

        public Map<P11ObjectIdentifier, X509Cert> getCertificates() {
            return this.certificates;
        }

        public Set<Long> getMechanisms() {
            return this.mechanisms;
        }

        public void addIdentity(P11Identity identity) {
            Args.notNull((Object)identity, (String)"identity");
            this.identities.put(identity.getId().getKeyId(), identity);
        }

        public void addMechanism(long mechanism) {
            this.mechanisms.add(mechanism);
        }

        public void addCertificate(P11ObjectIdentifier objectId, X509Cert certificate) {
            this.certificates.put((P11ObjectIdentifier)Args.notNull((Object)objectId, (String)"objectId"), (X509Cert)Args.notNull((Object)certificate, (String)"certificate"));
        }

        public X509Cert getCertForId(byte[] id) {
            for (Map.Entry<P11ObjectIdentifier, X509Cert> entry : this.certificates.entrySet()) {
                P11ObjectIdentifier objId = entry.getKey();
                if (!objId.matchesId(id)) continue;
                return entry.getValue();
            }
            return null;
        }

        public String getCertLabelForId(byte[] id) {
            for (P11ObjectIdentifier objId : this.certificates.keySet()) {
                if (!objId.matchesId(id)) continue;
                return objId.getLabel();
            }
            return null;
        }
    }
}

