/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import iaik.pkcs.pkcs11.wrapper.Functions;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.macs.GMac;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.emulator.SM2Signer;
import org.xipki.security.util.GMUtil;
import org.xipki.security.util.PKCS1Util;
import org.xipki.security.util.SignerUtil;
import org.xipki.util.Args;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

public class EmulatorP11Identity
extends P11Identity {
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorP11Identity.class);
    private static final Map<Long, HashAlgo> mgfMechHashMap = new HashMap<Long, HashAlgo>();
    private static final Map<Long, HashAlgo> mechHashMap = new HashMap<Long, HashAlgo>();
    private final Key signingKey;
    private final ConcurrentBag<ConcurrentBagEntry<Cipher>> rsaCiphers = new ConcurrentBag();
    private final ConcurrentBag<ConcurrentBagEntry<Signature>> dsaSignatures = new ConcurrentBag();
    private final ConcurrentBag<ConcurrentBagEntry<Signature>> eddsaSignatures = new ConcurrentBag();
    private final ConcurrentBag<ConcurrentBagEntry<SM2Signer>> sm2Signers = new ConcurrentBag();
    private final SecureRandom random;
    private final int maxSessions;
    private boolean initialized;

    public EmulatorP11Identity(P11Slot slot, P11IdentityId identityId, SecretKey signingKey, int maxSessions, SecureRandom random) {
        super(slot, identityId, 0);
        this.signingKey = (Key)Args.notNull((Object)signingKey, (String)"signingKey");
        this.random = (SecureRandom)Args.notNull((Object)random, (String)"random");
        this.maxSessions = maxSessions;
    }

    public EmulatorP11Identity(P11Slot slot, P11IdentityId identityId, PrivateKey privateKey, PublicKey publicKey, X509Cert[] certificateChain, int maxSessions, SecureRandom random) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        super(slot, identityId, publicKey, certificateChain);
        this.signingKey = (Key)Args.notNull((Object)privateKey, (String)"privateKey");
        this.random = (SecureRandom)Args.notNull((Object)random, (String)"random");
        this.maxSessions = maxSessions;
    }

    private synchronized void init() throws P11TokenException {
        block30: {
            if (this.initialized) {
                return;
            }
            try {
                int i;
                String algorithm;
                if (this.publicKey instanceof RSAPublicKey) {
                    String providerName = "BC";
                    LOG.info("use provider {}", (Object)providerName);
                    for (int i2 = 0; i2 < this.maxSessions; ++i2) {
                        Cipher rsaCipher;
                        try {
                            String algo = "RSA/ECB/NoPadding";
                            rsaCipher = Cipher.getInstance("RSA/ECB/NoPadding", providerName);
                            LOG.info("use cipher algorithm {}", (Object)"RSA/ECB/NoPadding");
                        }
                        catch (NoSuchPaddingException ex) {
                            throw new P11TokenException("NoSuchPadding", ex);
                        }
                        catch (NoSuchAlgorithmException ex) {
                            String algo = "RSA/NONE/NoPadding";
                            try {
                                rsaCipher = Cipher.getInstance("RSA/NONE/NoPadding", providerName);
                                LOG.info("use cipher algorithm {}", (Object)"RSA/NONE/NoPadding");
                            }
                            catch (NoSuchPaddingException e1) {
                                throw new P11TokenException("NoSuchPadding", ex);
                            }
                        }
                        rsaCipher.init(1, this.signingKey);
                        this.rsaCiphers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)rsaCipher));
                    }
                    break block30;
                }
                if (this.publicKey instanceof ECPublicKey) {
                    boolean sm2curve = GMUtil.isSm2primev2Curve(((ECPublicKey)this.publicKey).getParams().getCurve());
                    algorithm = sm2curve ? null : "NONEwithECDSA";
                } else if (this.publicKey instanceof DSAPublicKey) {
                    algorithm = "NONEwithDSA";
                } else if (this.publicKey instanceof EdDSAKey) {
                    algorithm = null;
                } else if (this.publicKey instanceof XDHKey) {
                    algorithm = null;
                } else {
                    throw new P11TokenException("Currently only RSA, DSA, EC, EC Edwards and EC Montgomery public key are supported, but not " + this.publicKey.getAlgorithm() + " (class: " + this.publicKey.getClass().getName() + ")");
                }
                if (algorithm != null) {
                    for (i = 0; i < this.maxSessions; ++i) {
                        Signature dsaSignature = Signature.getInstance(algorithm, "BC");
                        dsaSignature.initSign((PrivateKey)this.signingKey, this.random);
                        this.dsaSignatures.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)dsaSignature));
                    }
                } else if (this.publicKey instanceof EdDSAKey) {
                    algorithm = this.publicKey.getAlgorithm();
                    for (i = 0; i < this.maxSessions; ++i) {
                        Signature signature = Signature.getInstance(algorithm, "BC");
                        signature.initSign((PrivateKey)this.signingKey);
                        this.eddsaSignatures.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)signature));
                    }
                } else if (this.publicKey instanceof XDHKey) {
                } else {
                    for (i = 0; i < this.maxSessions; ++i) {
                        SM2Signer sm2signer = new SM2Signer((CipherParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)((PrivateKey)this.signingKey)));
                        this.sm2Signers.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)sm2signer));
                    }
                }
            }
            catch (GeneralSecurityException ex) {
                throw new P11TokenException(ex);
            }
            finally {
                this.initialized = true;
            }
        }
    }

    @Override
    protected byte[] digestSecretKey0(long mechanism) throws P11TokenException {
        if (!(this.signingKey instanceof SecretKey)) {
            throw new P11TokenException("digestSecretKey could not be applied to non-SecretKey");
        }
        HashAlgo hashAlgo = mechHashMap.get(mechanism);
        if (hashAlgo == null) {
            throw new P11TokenException("unknown mechanism " + Functions.mechanismCodeToString((long)mechanism));
        }
        return hashAlgo.hash(new byte[][]{this.signingKey.getEncoded()});
    }

    @Override
    protected byte[] sign0(long mechanism, P11Params parameters, byte[] content) throws P11TokenException {
        this.init();
        if (mechanism == 4161L) {
            return this.dsaAndEcdsaSign(content, null);
        }
        if (mechanism == 0xFFFFF002L) {
            return this.sm2SignHash(content);
        }
        if (mechanism == 17L) {
            return this.dsaAndEcdsaSign(content, null);
        }
        if (mechanism == 4183L) {
            return this.eddsaSign(content);
        }
        if (mechanism == 3L) {
            return this.rsaX509Sign(content);
        }
        if (mechanism == 1L) {
            return this.rsaPkcsSign(content, null);
        }
        if (13L == mechanism) {
            return this.rsaPkcsPssSign(parameters, content, null);
        }
        if (4238L == mechanism) {
            return this.aesGmac(parameters, content);
        }
        HashAlgo hashAlgo = mechHashMap.get(mechanism);
        if (mechanism == 4162L || mechanism == 4163L || mechanism == 4164L || mechanism == 4165L || mechanism == 4166L || mechanism == 4167L || mechanism == 4168L || mechanism == 4169L || mechanism == 4170L) {
            return this.dsaAndEcdsaSign(content, hashAlgo);
        }
        if (mechanism == 0xFFFFF003L) {
            return this.sm2Sign(parameters, content);
        }
        if (mechanism == 18L || mechanism == 19L || mechanism == 20L || mechanism == 21L || mechanism == 22L || mechanism == 24L || mechanism == 25L || mechanism == 26L || mechanism == 27L) {
            return this.dsaAndEcdsaSign(content, hashAlgo);
        }
        if (mechanism == 6L || mechanism == 70L || mechanism == 64L || mechanism == 65L || mechanism == 66L || mechanism == 102L || mechanism == 96L || mechanism == 97L || mechanism == 98L) {
            return this.rsaPkcsSign(content, hashAlgo);
        }
        if (mechanism == 14L || mechanism == 71L || mechanism == 67L || mechanism == 68L || mechanism == 69L || mechanism == 103L || mechanism == 99L || mechanism == 100L || mechanism == 101L) {
            return this.rsaPkcsPssSign(parameters, content, hashAlgo);
        }
        if (mechanism == 545L || mechanism == 598L || mechanism == 593L || mechanism == 609L || mechanism == 625L || mechanism == 694L || mechanism == 689L || mechanism == 705L || mechanism == 721L) {
            return this.hmac(content, hashAlgo);
        }
        throw new P11TokenException("unsupported mechanism " + mechanism);
    }

    private byte[] hmac(byte[] contentToSign, HashAlgo hashAlgo) {
        HMac hmac = new HMac((Digest)hashAlgo.createDigest());
        hmac.init((CipherParameters)new KeyParameter(this.signingKey.getEncoded()));
        hmac.update(contentToSign, 0, contentToSign.length);
        byte[] signature = new byte[hmac.getMacSize()];
        hmac.doFinal(signature, 0);
        return signature;
    }

    private byte[] aesGmac(P11Params params, byte[] contentToSign) throws P11TokenException {
        if (params == null) {
            throw new P11TokenException("iv may not be null");
        }
        if (!(params instanceof P11Params.P11IVParams)) {
            throw new P11TokenException("params must be instanceof P11IVParams");
        }
        byte[] iv = ((P11Params.P11IVParams)params).getIV();
        GMac gmac = new GMac(new GCMBlockCipher((BlockCipher)new AESEngine()));
        gmac.init((CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(this.signingKey.getEncoded()), iv));
        gmac.update(contentToSign, 0, contentToSign.length);
        byte[] signature = new byte[gmac.getMacSize()];
        gmac.doFinal(signature, 0);
        return signature;
    }

    private byte[] rsaPkcsPssSign(P11Params parameters, byte[] contentToSign, HashAlgo hashAlgo) throws P11TokenException {
        byte[] encodedHashValue;
        if (!(parameters instanceof P11Params.P11RSAPkcsPssParams)) {
            throw new P11TokenException("the parameters is not of " + P11Params.P11RSAPkcsPssParams.class.getName());
        }
        P11Params.P11RSAPkcsPssParams pssParam = (P11Params.P11RSAPkcsPssParams)parameters;
        HashAlgo contentHash = mechHashMap.get(pssParam.getHashAlgorithm());
        if (contentHash == null) {
            throw new P11TokenException("unsupported HashAlgorithm " + pssParam.getHashAlgorithm());
        }
        if (hashAlgo != null && contentHash != hashAlgo) {
            throw new P11TokenException("Invalid parameters: invalid hash algorithm");
        }
        HashAlgo mgfHash = mgfMechHashMap.get(pssParam.getMaskGenerationFunction());
        if (mgfHash == null) {
            throw new P11TokenException("unsupported MaskGenerationFunction " + pssParam.getHashAlgorithm());
        }
        byte[] hashValue = hashAlgo == null ? contentToSign : hashAlgo.hash(new byte[][]{contentToSign});
        try {
            encodedHashValue = PKCS1Util.EMSA_PSS_ENCODE(contentHash, hashValue, mgfHash, (int)pssParam.getSaltLength(), this.getSignatureKeyBitLength(), this.random);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        return this.rsaX509Sign(encodedHashValue);
    }

    private byte[] rsaPkcsSign(byte[] contentToSign, HashAlgo hashAlgo) throws P11TokenException {
        byte[] paddedHash;
        int modulusBitLen = this.getSignatureKeyBitLength();
        try {
            paddedHash = hashAlgo == null ? PKCS1Util.EMSA_PKCS1_v1_5_encoding(contentToSign, modulusBitLen) : PKCS1Util.EMSA_PKCS1_v1_5_encoding(hashAlgo.hash(new byte[][]{contentToSign}), modulusBitLen, hashAlgo);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        return this.rsaX509Sign(paddedHash);
    }

    private byte[] rsaX509Sign(byte[] dataToSign) throws P11TokenException {
        ConcurrentBagEntry cipher;
        try {
            cipher = (ConcurrentBagEntry)this.rsaCiphers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("could not take any idle signer");
        }
        if (cipher == null) {
            throw new P11TokenException("no idle RSA cipher available");
        }
        try {
            byte[] ex = ((Cipher)cipher.value()).doFinal(dataToSign);
            return ex;
        }
        catch (BadPaddingException ex) {
            throw new P11TokenException("BadPaddingException: " + ex.getMessage(), ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new P11TokenException("IllegalBlockSizeException: " + ex.getMessage(), ex);
        }
        finally {
            this.rsaCiphers.requite((ConcurrentBag.IConcurrentBagEntry)cipher);
        }
    }

    private byte[] dsaAndEcdsaSign(byte[] dataToSign, HashAlgo hashAlgo) throws P11TokenException {
        ConcurrentBagEntry sig0;
        byte[] hash = hashAlgo == null ? dataToSign : hashAlgo.hash(new byte[][]{dataToSign});
        try {
            sig0 = (ConcurrentBagEntry)this.dsaSignatures.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle DSA Signature available");
        }
        try {
            Signature sig = (Signature)sig0.value();
            sig.update(hash);
            byte[] x962Signature = sig.sign();
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.getSignatureKeyBitLength());
            return byArray;
        }
        catch (SignatureException ex) {
            throw new P11TokenException("SignatureException: " + ex.getMessage(), ex);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        finally {
            this.dsaSignatures.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    private byte[] eddsaSign(byte[] dataToSign) throws P11TokenException {
        ConcurrentBagEntry sig0;
        if (!(this.signingKey instanceof EdDSAKey)) {
            throw new P11TokenException("given signing key is not suitable for EdDSA sign");
        }
        try {
            sig0 = (ConcurrentBagEntry)this.eddsaSignatures.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle DSA Signature available");
        }
        try {
            Signature sig = (Signature)sig0.value();
            sig.update(dataToSign);
            byte[] byArray = sig.sign();
            return byArray;
        }
        catch (SignatureException ex) {
            throw new P11TokenException("SignatureException: " + ex.getMessage(), ex);
        }
        finally {
            this.eddsaSignatures.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    private byte[] sm2SignHash(byte[] hash) throws P11TokenException {
        ConcurrentBagEntry sig0;
        try {
            sig0 = (ConcurrentBagEntry)this.sm2Signers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle SM2 Signer available");
        }
        try {
            SM2Signer sig = (SM2Signer)sig0.value();
            byte[] x962Signature = sig.generateSignatureForHash(hash);
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.getSignatureKeyBitLength());
            return byArray;
        }
        catch (CryptoException ex) {
            throw new P11TokenException("CryptoException: " + ex.getMessage(), ex);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        finally {
            this.sm2Signers.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    private byte[] sm2Sign(P11Params params, byte[] dataToSign) throws P11TokenException {
        ConcurrentBagEntry sig0;
        if (params == null) {
            throw new P11TokenException("userId may not be null");
        }
        if (!(params instanceof P11Params.P11ByteArrayParams)) {
            throw new P11TokenException("params must be instanceof P11ByteArrayParams");
        }
        byte[] userId = ((P11Params.P11ByteArrayParams)params).getBytes();
        try {
            sig0 = (ConcurrentBagEntry)this.sm2Signers.borrow(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new P11TokenException("InterruptedException occurs while retrieving idle signature");
        }
        if (sig0 == null) {
            throw new P11TokenException("no idle SM2 Signer available");
        }
        try {
            SM2Signer sig = (SM2Signer)sig0.value();
            byte[] x962Signature = sig.generateSignatureForMessage(userId, dataToSign);
            byte[] byArray = SignerUtil.dsaSigX962ToPlain(x962Signature, this.getSignatureKeyBitLength());
            return byArray;
        }
        catch (CryptoException ex) {
            throw new P11TokenException("CryptoException: " + ex.getMessage(), ex);
        }
        catch (XiSecurityException ex) {
            throw new P11TokenException("XiSecurityException: " + ex.getMessage(), ex);
        }
        finally {
            this.sm2Signers.requite((ConcurrentBag.IConcurrentBagEntry)sig0);
        }
    }

    static {
        mgfMechHashMap.put(1L, HashAlgo.SHA1);
        mgfMechHashMap.put(5L, HashAlgo.SHA224);
        mgfMechHashMap.put(2L, HashAlgo.SHA256);
        mgfMechHashMap.put(3L, HashAlgo.SHA384);
        mgfMechHashMap.put(4L, HashAlgo.SHA512);
        mgfMechHashMap.put(6L, HashAlgo.SHA3_224);
        mgfMechHashMap.put(7L, HashAlgo.SHA3_256);
        mgfMechHashMap.put(8L, HashAlgo.SHA3_384);
        mgfMechHashMap.put(9L, HashAlgo.SHA3_512);
        mechHashMap.put(544L, HashAlgo.SHA1);
        mechHashMap.put(597L, HashAlgo.SHA224);
        mechHashMap.put(592L, HashAlgo.SHA256);
        mechHashMap.put(608L, HashAlgo.SHA384);
        mechHashMap.put(624L, HashAlgo.SHA512);
        mechHashMap.put(693L, HashAlgo.SHA3_224);
        mechHashMap.put(688L, HashAlgo.SHA3_256);
        mechHashMap.put(704L, HashAlgo.SHA3_384);
        mechHashMap.put(720L, HashAlgo.SHA3_512);
        mechHashMap.put(0xFFFFF005L, HashAlgo.SM3);
        mechHashMap.put(4162L, HashAlgo.SHA1);
        mechHashMap.put(4163L, HashAlgo.SHA224);
        mechHashMap.put(4164L, HashAlgo.SHA256);
        mechHashMap.put(4165L, HashAlgo.SHA384);
        mechHashMap.put(4166L, HashAlgo.SHA512);
        mechHashMap.put(4167L, HashAlgo.SHA3_224);
        mechHashMap.put(4168L, HashAlgo.SHA3_256);
        mechHashMap.put(4169L, HashAlgo.SHA3_384);
        mechHashMap.put(4170L, HashAlgo.SHA3_512);
        mechHashMap.put(0xFFFFF003L, HashAlgo.SM3);
        mechHashMap.put(18L, HashAlgo.SHA1);
        mechHashMap.put(19L, HashAlgo.SHA224);
        mechHashMap.put(20L, HashAlgo.SHA256);
        mechHashMap.put(21L, HashAlgo.SHA384);
        mechHashMap.put(22L, HashAlgo.SHA512);
        mechHashMap.put(24L, HashAlgo.SHA3_224);
        mechHashMap.put(25L, HashAlgo.SHA3_256);
        mechHashMap.put(26L, HashAlgo.SHA3_384);
        mechHashMap.put(27L, HashAlgo.SHA3_512);
        mechHashMap.put(6L, HashAlgo.SHA1);
        mechHashMap.put(70L, HashAlgo.SHA224);
        mechHashMap.put(64L, HashAlgo.SHA256);
        mechHashMap.put(65L, HashAlgo.SHA384);
        mechHashMap.put(66L, HashAlgo.SHA512);
        mechHashMap.put(102L, HashAlgo.SHA3_224);
        mechHashMap.put(96L, HashAlgo.SHA3_256);
        mechHashMap.put(97L, HashAlgo.SHA3_384);
        mechHashMap.put(98L, HashAlgo.SHA3_512);
        mechHashMap.put(14L, HashAlgo.SHA1);
        mechHashMap.put(71L, HashAlgo.SHA224);
        mechHashMap.put(67L, HashAlgo.SHA256);
        mechHashMap.put(68L, HashAlgo.SHA384);
        mechHashMap.put(69L, HashAlgo.SHA512);
        mechHashMap.put(103L, HashAlgo.SHA3_224);
        mechHashMap.put(99L, HashAlgo.SHA3_256);
        mechHashMap.put(100L, HashAlgo.SHA3_384);
        mechHashMap.put(101L, HashAlgo.SHA3_512);
        mechHashMap.put(545L, HashAlgo.SHA1);
        mechHashMap.put(598L, HashAlgo.SHA224);
        mechHashMap.put(593L, HashAlgo.SHA256);
        mechHashMap.put(609L, HashAlgo.SHA384);
        mechHashMap.put(625L, HashAlgo.SHA512);
        mechHashMap.put(694L, HashAlgo.SHA224);
        mechHashMap.put(689L, HashAlgo.SHA256);
        mechHashMap.put(705L, HashAlgo.SHA384);
        mechHashMap.put(721L, HashAlgo.SHA512);
    }
}

