/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import iaik.pkcs.pkcs11.wrapper.Functions;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.jcajce.interfaces.EdDSAKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.EdECConstants;
import org.xipki.security.HashAlgo;
import org.xipki.security.X509Cert;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.P11UnknownEntityException;
import org.xipki.security.pkcs11.emulator.EmulatorP11Identity;
import org.xipki.security.pkcs11.emulator.KeyCryptor;
import org.xipki.security.util.KeyUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.IoUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.StringUtil;

class EmulatorP11Slot
extends P11Slot {
    private static final Logger LOG = LoggerFactory.getLogger(EmulatorP11Slot.class);
    private static final String FILE_SLOTINFO = "slot.info";
    private static final String PROP_NAMED_CURVE_SUPPORTED = "namedCurveSupported";
    private static final String DIR_PRIV_KEY = "privkey";
    private static final String DIR_PUB_KEY = "pubkey";
    private static final String DIR_SEC_KEY = "seckey";
    private static final String DIR_CERT = "cert";
    private static final String INFO_FILE_SUFFIX = ".info";
    private static final String VALUE_FILE_SUFFIX = ".value";
    private static final String PROP_ID = "id";
    private static final String PROP_LABEL = "label";
    private static final String PROP_SHA1SUM = "sha1";
    private static final String PROP_ALGO = "algo";
    private static final String PROP_ALGORITHM = "algorithm";
    private static final String PROP_RSA_MODUS = "modus";
    private static final String PROP_RSA_PUBLIC_EXPONENT = "publicExponent";
    private static final String PROP_DSA_PRIME = "prime";
    private static final String PROP_DSA_SUBPRIME = "subprime";
    private static final String PROP_DSA_BASE = "base";
    private static final String PROP_DSA_VALUE = "value";
    private static final String PROP_EC_ECDSA_PARAMS = "ecdsaParams";
    private static final String PROP_EC_EC_POINT = "ecPoint";
    private static final long[] supportedMechs = new long[]{16L, 0L, 4160L, 4181L, 4182L, 848L, 544L, 597L, 592L, 608L, 624L, 693L, 688L, 704L, 720L, 545L, 598L, 593L, 609L, 625L, 694L, 689L, 705L, 721L, 3L, 1L, 6L, 70L, 64L, 65L, 66L, 102L, 96L, 97L, 98L, 13L, 14L, 71L, 67L, 68L, 69L, 103L, 99L, 100L, 101L, 17L, 18L, 19L, 20L, 21L, 22L, 24L, 25L, 26L, 27L, 4161L, 4162L, 4163L, 4164L, 4165L, 4166L, 4167L, 4168L, 4169L, 4170L, 4183L, 0xFFFFF001L, 0xFFFFF003L, 0xFFFFF002L};
    private static final FilenameFilter INFO_FILENAME_FILTER = new InfoFilenameFilter();
    private final boolean namedCurveSupported;
    private final File slotDir;
    private final File privKeyDir;
    private final File pubKeyDir;
    private final File secKeyDir;
    private final File certDir;
    private final KeyCryptor keyCryptor;
    private final SecureRandom random = new SecureRandom();
    private final int maxSessions;
    private final P11ModuleConf.P11NewObjectConf newObjectConf;

    EmulatorP11Slot(String moduleName, File slotDir, P11SlotIdentifier slotId, boolean readOnly, KeyCryptor keyCryptor, P11ModuleConf.P11MechanismFilter mechanismFilter, P11ModuleConf.P11NewObjectConf newObjectConf, Integer numSessions, List<Long> secretKeyTypes, List<Long> keypairTypes) throws P11TokenException {
        super(moduleName, slotId, readOnly, mechanismFilter, numSessions, secretKeyTypes, keypairTypes);
        File slotInfoFile;
        this.newObjectConf = (P11ModuleConf.P11NewObjectConf)Args.notNull((Object)newObjectConf, (String)"newObjectConf");
        this.slotDir = (File)Args.notNull((Object)slotDir, (String)"slotDir");
        this.keyCryptor = (KeyCryptor)Args.notNull((Object)keyCryptor, (String)"privateKeyCryptor");
        this.maxSessions = numSessions != null ? Args.positive((int)numSessions, (String)"numSessions") : 20;
        this.privKeyDir = new File(slotDir, DIR_PRIV_KEY);
        if (!this.privKeyDir.exists()) {
            this.privKeyDir.mkdirs();
        }
        this.pubKeyDir = new File(slotDir, DIR_PUB_KEY);
        if (!this.pubKeyDir.exists()) {
            this.pubKeyDir.mkdirs();
        }
        this.secKeyDir = new File(slotDir, DIR_SEC_KEY);
        if (!this.secKeyDir.exists()) {
            this.secKeyDir.mkdirs();
        }
        this.certDir = new File(slotDir, DIR_CERT);
        if (!this.certDir.exists()) {
            this.certDir.mkdirs();
        }
        if ((slotInfoFile = new File(slotDir, FILE_SLOTINFO)).exists()) {
            Properties props = this.loadProperties(slotInfoFile);
            this.namedCurveSupported = Boolean.parseBoolean(props.getProperty(PROP_NAMED_CURVE_SUPPORTED, "true"));
        } else {
            this.namedCurveSupported = true;
        }
        this.refresh();
    }

    @Override
    protected P11Slot.P11SlotRefreshResult refresh0() throws P11TokenException {
        File[] privKeyInfoFiles;
        File[] certInfoFiles;
        Properties props;
        P11Slot.P11SlotRefreshResult ret = new P11Slot.P11SlotRefreshResult();
        for (long mech : supportedMechs) {
            ret.addMechanism(mech);
        }
        File[] secKeyInfoFiles = this.secKeyDir.listFiles(INFO_FILENAME_FILTER);
        if (secKeyInfoFiles != null && secKeyInfoFiles.length != 0) {
            for (File secKeyInfoFile : secKeyInfoFiles) {
                byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(secKeyInfoFile.getName());
                String hexId = EmulatorP11Slot.hex(id);
                try {
                    props = this.loadProperties(secKeyInfoFile);
                    String keyAlgo = props.getProperty(PROP_ALGO);
                    P11ObjectIdentifier p11ObjId = new P11ObjectIdentifier(id, props.getProperty(PROP_LABEL));
                    byte[] encodedValue = IoUtil.read((File)new File(this.secKeyDir, hexId + VALUE_FILE_SUFFIX));
                    byte[] keyValue = this.keyCryptor.decrypt(encodedValue);
                    SecretKeySpec key = new SecretKeySpec(keyValue, keyAlgo);
                    EmulatorP11Identity identity = new EmulatorP11Identity(this, new P11IdentityId(this.slotId, p11ObjId), key, this.maxSessions, this.random);
                    LOG.info("added PKCS#11 secret key {}", (Object)p11ObjId);
                    ret.addIdentity(identity);
                }
                catch (ClassCastException ex) {
                    LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("InvalidKeyException while initializing key with key-id " + hexId));
                }
                catch (Throwable th) {
                    LOG.error("unexpected exception while initializing key with key-id " + hexId, th);
                }
            }
        }
        if ((certInfoFiles = this.certDir.listFiles(INFO_FILENAME_FILTER)) != null) {
            for (File infoFile : certInfoFiles) {
                byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName());
                props = this.loadProperties(infoFile);
                P11ObjectIdentifier objId = new P11ObjectIdentifier(id, props.getProperty(PROP_LABEL));
                try {
                    ret.addCertificate(objId, this.readCertificate(id));
                }
                catch (IOException | CertificateException ex) {
                    LOG.warn("could not parse certificate " + objId);
                }
            }
        }
        if ((privKeyInfoFiles = this.privKeyDir.listFiles(INFO_FILENAME_FILTER)) != null && privKeyInfoFiles.length != 0) {
            for (File privKeyInfoFile : privKeyInfoFiles) {
                byte[] id = EmulatorP11Slot.getKeyIdFromInfoFilename(privKeyInfoFile.getName());
                String hexId = EmulatorP11Slot.hex(id);
                try {
                    X509Cert[] x509CertArray;
                    PublicKey publicKey;
                    Properties props2 = this.loadProperties(privKeyInfoFile);
                    String label = props2.getProperty(PROP_LABEL);
                    if (label == null) continue;
                    P11ObjectIdentifier p11ObjId = new P11ObjectIdentifier(id, label);
                    X509Cert cert = ret.getCertForId(id);
                    PublicKey publicKey2 = publicKey = cert == null ? this.readPublicKey(id) : cert.getPublicKey();
                    if (publicKey == null) {
                        LOG.warn("Neither public key nor certificate is associated with private key {}", (Object)p11ObjId);
                        continue;
                    }
                    byte[] encodedValue = IoUtil.read((File)new File(this.privKeyDir, hexId + VALUE_FILE_SUFFIX));
                    PrivateKey privateKey = this.keyCryptor.decryptPrivateKey(encodedValue);
                    if (cert == null) {
                        x509CertArray = null;
                    } else {
                        X509Cert[] x509CertArray2 = new X509Cert[1];
                        x509CertArray = x509CertArray2;
                        x509CertArray2[0] = cert;
                    }
                    X509Cert[] certs = x509CertArray;
                    EmulatorP11Identity identity = new EmulatorP11Identity(this, new P11IdentityId(this.slotId, p11ObjId, true, label, true, label), privateKey, publicKey, certs, this.maxSessions, this.random);
                    LOG.info("added PKCS#11 key {}", (Object)p11ObjId);
                    ret.addIdentity(identity);
                }
                catch (InvalidKeyException ex) {
                    LogUtil.warn((Logger)LOG, (Throwable)ex, (String)("InvalidKeyException while initializing key with key-id " + hexId));
                }
                catch (Throwable th) {
                    LOG.error("unexpected exception while initializing key with key-id " + hexId, th);
                }
            }
        }
        return ret;
    }

    File slotDir() {
        return this.slotDir;
    }

    private PublicKey readPublicKey(byte[] keyId) throws P11TokenException {
        File pubKeyFile = new File(this.pubKeyDir, EmulatorP11Slot.hex(keyId) + INFO_FILE_SUFFIX);
        Properties props = this.loadProperties(pubKeyFile);
        String algorithm = props.getProperty(PROP_ALGORITHM);
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(algorithm)) {
            BigInteger exp = new BigInteger(props.getProperty(PROP_RSA_PUBLIC_EXPONENT), 16);
            BigInteger mod = new BigInteger(props.getProperty(PROP_RSA_MODUS), 16);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
            try {
                return KeyUtil.generateRSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        if (X9ObjectIdentifiers.id_dsa.getId().equals(algorithm)) {
            BigInteger prime = new BigInteger(props.getProperty(PROP_DSA_PRIME), 16);
            BigInteger subPrime = new BigInteger(props.getProperty(PROP_DSA_SUBPRIME), 16);
            BigInteger base = new BigInteger(props.getProperty(PROP_DSA_BASE), 16);
            BigInteger value = new BigInteger(props.getProperty(PROP_DSA_VALUE), 16);
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(value, prime, subPrime, base);
            try {
                return KeyUtil.generateDSAPublicKey(keySpec);
            }
            catch (InvalidKeySpecException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(algorithm)) {
            byte[] ecdsaParams = EmulatorP11Slot.decodeHex(props.getProperty(PROP_EC_ECDSA_PARAMS));
            byte[] asn1EncodedPoint = EmulatorP11Slot.decodeHex(props.getProperty(PROP_EC_EC_POINT));
            byte[] ecPoint = DEROctetString.getInstance((Object)asn1EncodedPoint).getOctets();
            try {
                return KeyUtil.createECPublicKey(ecdsaParams, ecPoint);
            }
            catch (InvalidKeySpecException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        if (EdECConstants.id_X25519.getId().equals(algorithm) || EdECConstants.id_ED25519.getId().equals(algorithm) || EdECConstants.id_X448.getId().equals(algorithm) || EdECConstants.id_ED448.getId().equals(algorithm)) {
            byte[] encodedPoint = EmulatorP11Slot.decodeHex(props.getProperty(PROP_EC_EC_POINT));
            SubjectPublicKeyInfo pkInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(new ASN1ObjectIdentifier(algorithm)), encodedPoint);
            try {
                return KeyUtil.generatePublicKey(pkInfo);
            }
            catch (InvalidKeySpecException ex) {
                throw new P11TokenException("error  key algorithm " + algorithm);
            }
        }
        throw new P11TokenException("unknown key algorithm " + algorithm);
    }

    private X509Cert readCertificate(byte[] keyId) throws CertificateException, IOException {
        return X509Util.parseCert(IoUtil.read((File)new File(this.certDir, EmulatorP11Slot.hex(keyId) + VALUE_FILE_SUFFIX)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadProperties(File file) throws P11TokenException {
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            Properties props = new Properties();
            props.load(stream);
            Properties properties = props;
            return properties;
        }
        catch (IOException ex) {
            throw new P11TokenException("could not load properties from the file " + file.getPath(), ex);
        }
    }

    private static byte[] getKeyIdFromInfoFilename(String fileName) {
        return EmulatorP11Slot.decodeHex(fileName.substring(0, fileName.length() - INFO_FILE_SUFFIX.length()));
    }

    @Override
    public void close() {
        LOG.info("close slot " + this.slotId);
    }

    private boolean removePkcs11Cert(P11ObjectIdentifier objectId) throws P11TokenException {
        return this.removePkcs11Entry(this.certDir, objectId);
    }

    private boolean removePkcs11Entry(File dir, P11ObjectIdentifier objectId) throws P11TokenException {
        byte[] id = objectId.getId();
        String label = objectId.getLabel();
        if (id != null) {
            String hextId = EmulatorP11Slot.hex(id);
            File infoFile = new File(dir, hextId + INFO_FILE_SUFFIX);
            if (!infoFile.exists()) {
                return false;
            }
            if (StringUtil.isBlank((String)label)) {
                return EmulatorP11Slot.deletePkcs11Entry(dir, id);
            }
            Properties props = this.loadProperties(infoFile);
            return label.equals(props.getProperty(PROP_LABEL)) && EmulatorP11Slot.deletePkcs11Entry(dir, id);
        }
        boolean deleted = false;
        File[] infoFiles = dir.listFiles(INFO_FILENAME_FILTER);
        if (infoFiles != null) {
            for (File infoFile : infoFiles) {
                Properties props;
                if (!infoFile.isFile() || !label.equals((props = this.loadProperties(infoFile)).getProperty(PROP_LABEL)) || !EmulatorP11Slot.deletePkcs11Entry(dir, EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName()))) continue;
                deleted = true;
            }
        }
        return deleted;
    }

    private static boolean deletePkcs11Entry(File dir, byte[] objectId) {
        String hextId = EmulatorP11Slot.hex(objectId);
        File infoFile = new File(dir, hextId + INFO_FILE_SUFFIX);
        boolean b1 = infoFile.exists() ? infoFile.delete() : true;
        File valueFile = new File(dir, hextId + VALUE_FILE_SUFFIX);
        boolean b2 = valueFile.exists() ? valueFile.delete() : true;
        return b1 || b2;
    }

    private int deletePkcs11Entry(File dir, byte[] id, String label) throws P11TokenException {
        if (StringUtil.isBlank((String)label)) {
            return EmulatorP11Slot.deletePkcs11Entry(dir, id) ? 1 : 0;
        }
        if (id != null && id.length > 0) {
            String hextId = EmulatorP11Slot.hex(id);
            File infoFile = new File(dir, hextId + INFO_FILE_SUFFIX);
            if (!infoFile.exists()) {
                return 0;
            }
            Properties props = this.loadProperties(infoFile);
            if (!label.equals(props.get(PROP_LABEL))) {
                return 0;
            }
            return EmulatorP11Slot.deletePkcs11Entry(dir, id) ? 1 : 0;
        }
        File[] infoFiles = dir.listFiles(INFO_FILENAME_FILTER);
        if (infoFiles == null || infoFiles.length == 0) {
            return 0;
        }
        LinkedList<byte[]> ids = new LinkedList<byte[]>();
        for (File infoFile : infoFiles) {
            Properties props = this.loadProperties(infoFile);
            if (!label.equals(props.getProperty(PROP_LABEL))) continue;
            ids.add(EmulatorP11Slot.getKeyIdFromInfoFilename(infoFile.getName()));
        }
        if (ids.isEmpty()) {
            return 0;
        }
        for (byte[] m : ids) {
            EmulatorP11Slot.deletePkcs11Entry(dir, m);
        }
        return ids.size();
    }

    private String savePkcs11SecretKey(byte[] id, String label, SecretKey secretKey) throws P11TokenException {
        byte[] encrytedValue = this.keyCryptor.encrypt(secretKey);
        this.savePkcs11Entry(this.secKeyDir, id, label, secretKey.getAlgorithm(), encrytedValue);
        return label;
    }

    private String savePkcs11PrivateKey(byte[] id, String label, PrivateKey privateKey) throws P11TokenException {
        byte[] encryptedPrivKeyInfo = this.keyCryptor.encrypt(privateKey);
        this.savePkcs11Entry(this.privKeyDir, id, label, privateKey.getAlgorithm(), encryptedPrivKeyInfo);
        return label;
    }

    private String savePkcs11PublicKey(byte[] id, String label, PublicKey publicKey) throws P11TokenException {
        String hexId = EmulatorP11Slot.hex(id);
        StringBuilder sb = new StringBuilder(100);
        sb.append(PROP_ID).append('=').append(hexId).append('\n');
        sb.append(PROP_LABEL).append('=').append(label).append('\n');
        if (publicKey instanceof RSAPublicKey) {
            sb.append(PROP_ALGORITHM).append('=').append(PKCSObjectIdentifiers.rsaEncryption.getId()).append('\n');
            RSAPublicKey rsaKey = (RSAPublicKey)publicKey;
            sb.append(PROP_RSA_MODUS).append('=').append(EmulatorP11Slot.hex(rsaKey.getModulus().toByteArray())).append('\n');
            sb.append(PROP_RSA_PUBLIC_EXPONENT).append('=').append(EmulatorP11Slot.hex(rsaKey.getPublicExponent().toByteArray())).append('\n');
        } else if (publicKey instanceof DSAPublicKey) {
            sb.append(PROP_ALGORITHM).append('=').append(X9ObjectIdentifiers.id_dsa.getId()).append('\n');
            DSAPublicKey dsaKey = (DSAPublicKey)publicKey;
            sb.append(PROP_DSA_PRIME).append('=').append(EmulatorP11Slot.hex(dsaKey.getParams().getP().toByteArray())).append('\n');
            sb.append(PROP_DSA_SUBPRIME).append('=').append(EmulatorP11Slot.hex(dsaKey.getParams().getQ().toByteArray())).append('\n');
            sb.append(PROP_DSA_BASE).append('=').append(EmulatorP11Slot.hex(dsaKey.getParams().getG().toByteArray())).append('\n');
            sb.append(PROP_DSA_VALUE).append('=').append(EmulatorP11Slot.hex(dsaKey.getY().toByteArray())).append('\n');
        } else if (publicKey instanceof ECPublicKey) {
            byte[] encodedEcPoint;
            byte[] encodedParams;
            sb.append(PROP_ALGORITHM).append('=').append(X9ObjectIdentifiers.id_ecPublicKey.getId()).append('\n');
            ECPublicKey ecKey = (ECPublicKey)publicKey;
            ECParameterSpec paramSpec = ecKey.getParams();
            org.bouncycastle.jce.spec.ECParameterSpec bcParamSpec = EC5Util.convertSpec((ECParameterSpec)paramSpec);
            ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid((org.bouncycastle.jce.spec.ECParameterSpec)bcParamSpec);
            if (curveOid == null) {
                throw new P11TokenException("EC public key is not of namedCurve");
            }
            try {
                encodedParams = this.namedCurveSupported ? curveOid.getEncoded() : ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOid).getEncoded();
            }
            catch (IOException | NullPointerException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
            sb.append(PROP_EC_ECDSA_PARAMS).append('=').append(EmulatorP11Slot.hex(encodedParams)).append('\n');
            ECPoint pointW = ecKey.getW();
            int keysize = (paramSpec.getOrder().bitLength() + 7) / 8;
            byte[] ecPoint = new byte[1 + keysize * 2];
            ecPoint[0] = 4;
            EmulatorP11Slot.bigIntToBytes("Wx", pointW.getAffineX(), ecPoint, 1, keysize);
            EmulatorP11Slot.bigIntToBytes("Wy", pointW.getAffineY(), ecPoint, 1 + keysize, keysize);
            try {
                encodedEcPoint = new DEROctetString(ecPoint).getEncoded();
            }
            catch (IOException ex) {
                throw new P11TokenException("could not ASN.1 encode the ECPoint");
            }
            sb.append(PROP_EC_EC_POINT).append('=').append(EmulatorP11Slot.hex(encodedEcPoint)).append('\n');
        } else if (publicKey instanceof EdDSAKey || publicKey instanceof XDHKey) {
            byte[] encodedParams;
            String algorithm = publicKey.getAlgorithm();
            ASN1ObjectIdentifier curveOid = EdECConstants.getCurveOid(algorithm);
            if (curveOid == null) {
                throw new P11TokenException("Invalid EdDSA key algorithm " + algorithm);
            }
            sb.append(PROP_ALGORITHM).append('=').append(curveOid.getId()).append('\n');
            try {
                encodedParams = curveOid.getEncoded();
            }
            catch (IOException | NullPointerException ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
            sb.append(PROP_EC_ECDSA_PARAMS).append('=').append(EmulatorP11Slot.hex(encodedParams)).append('\n');
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
            byte[] encodedEcPoint = spki.getPublicKeyData().getOctets();
            sb.append(PROP_EC_EC_POINT).append('=').append(EmulatorP11Slot.hex(encodedEcPoint)).append('\n');
        } else {
            throw new IllegalArgumentException("unsupported public key " + publicKey.getClass().getName());
        }
        try {
            IoUtil.save((File)new File(this.pubKeyDir, hexId + INFO_FILE_SUFFIX), (byte[])StringUtil.toUtf8Bytes((String)sb.toString()));
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return label;
    }

    private static void bigIntToBytes(String numName, BigInteger num, byte[] dest, int destPos, int length) throws P11TokenException {
        if (num.signum() != 1) {
            throw new P11TokenException(numName + " is not positive");
        }
        byte[] bytes = num.toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, dest, destPos, length);
        } else if (bytes.length < length) {
            System.arraycopy(bytes, 0, dest, destPos + length - bytes.length, bytes.length);
        } else {
            System.arraycopy(bytes, bytes.length - length, dest, destPos, length);
        }
    }

    private void savePkcs11Cert(byte[] id, String label, X509Cert cert) throws P11TokenException {
        this.savePkcs11Entry(this.certDir, id, label, null, cert.getEncoded());
    }

    private void savePkcs11Entry(File dir, byte[] id, String label, String algo, byte[] value) throws P11TokenException {
        Args.notNull((Object)dir, (String)"dir");
        Args.notBlank((String)label, (String)PROP_LABEL);
        Args.notNull((Object)value, (String)PROP_DSA_VALUE);
        String hexId = EmulatorP11Slot.hex((byte[])Args.notNull((Object)id, (String)PROP_ID));
        String str = StringUtil.concat((String)PROP_ID, (String[])new String[]{"=", hexId, "\n", PROP_LABEL, "=", label, "\n"});
        if (algo != null) {
            str = StringUtil.concat((String)str, (String[])new String[]{PROP_ALGO, "=", algo, "\n"});
        }
        str = StringUtil.concat((String)str, (String[])new String[]{PROP_SHA1SUM, "=", HashAlgo.SHA1.hexHash(new byte[][]{value}), "\n"});
        try {
            IoUtil.save((File)new File(dir, hexId + INFO_FILE_SUFFIX), (byte[])StringUtil.toUtf8Bytes((String)str));
            IoUtil.save((File)new File(dir, hexId + VALUE_FILE_SUFFIX), (byte[])value);
        }
        catch (IOException ex) {
            throw new P11TokenException("could not save certificate");
        }
    }

    @Override
    public int removeObjectsForId(byte[] id) throws P11TokenException {
        return this.removeObjects(id, null);
    }

    @Override
    public int removeObjectsForLabel(String label) throws P11TokenException {
        return this.removeObjects(null, label);
    }

    @Override
    public int removeObjects(byte[] id, String label) throws P11TokenException {
        if ((id == null || id.length == 0) && StringUtil.isBlank((String)label)) {
            throw new IllegalArgumentException("at least one of id and label may not be null");
        }
        return this.deletePkcs11Entry(this.privKeyDir, id, label) + this.deletePkcs11Entry(this.pubKeyDir, id, label) + this.deletePkcs11Entry(this.certDir, id, label) + this.deletePkcs11Entry(this.secKeyDir, id, label);
    }

    @Override
    protected void removeIdentity0(P11IdentityId identityId) throws P11TokenException {
        P11ObjectIdentifier keyId = identityId.getKeyId();
        boolean b1 = true;
        if (identityId.getCertId() != null) {
            b1 = this.removePkcs11Entry(this.certDir, identityId.getCertId());
        }
        boolean b2 = this.removePkcs11Entry(this.privKeyDir, keyId);
        boolean b3 = true;
        if (identityId.getPublicKeyId() != null) {
            b3 = this.removePkcs11Entry(this.pubKeyDir, identityId.getPublicKeyId());
        }
        boolean b4 = this.removePkcs11Entry(this.secKeyDir, keyId);
        if (!(b1 || b2 || b3 || b4)) {
            throw new P11UnknownEntityException(this.slotId, keyId);
        }
    }

    @Override
    protected void removeCerts0(P11ObjectIdentifier objectId) throws P11TokenException {
        EmulatorP11Slot.deletePkcs11Entry(this.certDir, objectId.getId());
    }

    @Override
    protected P11ObjectIdentifier addCert0(X509Cert cert, P11Slot.P11NewObjectControl control) throws P11TokenException, CertificateException {
        byte[] id = control.getId();
        if (id == null) {
            id = this.generateId();
        }
        String label = control.getLabel();
        this.savePkcs11Cert(id, label, cert);
        return new P11ObjectIdentifier(id, label);
    }

    @Override
    protected P11Identity generateSecretKey0(long keyType, int keysize, P11Slot.P11NewKeyControl control) throws P11TokenException {
        long mech;
        if (keysize % 8 != 0) {
            throw new IllegalArgumentException("keysize is not multiple of 8: " + keysize);
        }
        if (31L == keyType) {
            mech = 4224L;
        } else if (21L == keyType) {
            mech = 305L;
        } else if (16L == keyType) {
            mech = 848L;
        } else if (40L == keyType || 46L == keyType || 43L == keyType || 44L == keyType || 45L == keyType || 54L == keyType || 55L == keyType || 56L == keyType || 57L == keyType) {
            mech = 848L;
        } else {
            throw new IllegalArgumentException("unsupported key type 0x" + Functions.toFullHex((long)((int)keyType)));
        }
        this.assertMechanismSupported(mech);
        byte[] keyBytes = new byte[keysize / 8];
        this.random.nextBytes(keyBytes);
        SecretKeySpec key = new SecretKeySpec(keyBytes, EmulatorP11Slot.getSecretKeyAlgorithm(keyType));
        return this.saveP11Entity(key, (P11Slot.P11NewObjectControl)control);
    }

    @Override
    protected P11Identity importSecretKey0(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) throws P11TokenException {
        SecretKeySpec key = new SecretKeySpec(keyValue, EmulatorP11Slot.getSecretKeyAlgorithm(keyType));
        return this.saveP11Entity(key, (P11Slot.P11NewObjectControl)control);
    }

    private static String getSecretKeyAlgorithm(long keyType) {
        String algorithm;
        if (16L == keyType) {
            algorithm = "generic";
        } else if (31L == keyType) {
            algorithm = "AES";
        } else if (40L == keyType) {
            algorithm = "HMACSHA1";
        } else if (46L == keyType) {
            algorithm = "HMACSHA224";
        } else if (43L == keyType) {
            algorithm = "HMACSHA256";
        } else if (44L == keyType) {
            algorithm = "HMACSHA384";
        } else if (45L == keyType) {
            algorithm = "HMACSHA512";
        } else if (54L == keyType) {
            algorithm = "HMACSHA3-224";
        } else if (55L == keyType) {
            algorithm = "HMACSHA3-256";
        } else if (56L == keyType) {
            algorithm = "HMACSHA3-384";
        } else if (57L == keyType) {
            algorithm = "HMACSHA3-512";
        } else {
            throw new IllegalArgumentException("unsupported keyType " + keyType);
        }
        return algorithm;
    }

    @Override
    protected P11Identity generateRSAKeypair0(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) throws P11TokenException {
        KeyPair keypair;
        try {
            keypair = KeyUtil.generateRSAKeypair(keysize, publicExponent, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.saveP11Entity(keypair, (P11Slot.P11NewObjectControl)control);
    }

    @Override
    protected PrivateKeyInfo generateRSAKeypairOtf0(int keysize, BigInteger publicExponent) throws P11TokenException {
        try {
            KeyPair kp = KeyUtil.generateRSAKeypair(keysize, publicExponent, this.random);
            return KeyUtil.toPrivateKeyInfo((RSAPrivateCrtKey)kp.getPrivate());
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    protected P11Identity generateDSAKeypair0(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) throws P11TokenException {
        KeyPair keypair;
        DSAParameters dsaParams = new DSAParameters(p, q, g);
        try {
            keypair = KeyUtil.generateDSAKeypair(dsaParams, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.saveP11Entity(keypair, (P11Slot.P11NewObjectControl)control);
    }

    @Override
    protected PrivateKeyInfo generateDSAKeypairOtf0(BigInteger p, BigInteger q, BigInteger g) throws P11TokenException {
        DSAParameters spec = new DSAParameters(p, q, g);
        try {
            KeyPair kp = KeyUtil.generateDSAKeypair(spec, this.random);
            DSAParameter parameter = new DSAParameter(spec.getP(), spec.getQ(), spec.getG());
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)parameter);
            byte[] publicKey = new ASN1Integer(((DSAPublicKey)kp.getPublic()).getY()).getEncoded();
            DSAPrivateKey priv = (DSAPrivateKey)kp.getPrivate();
            return new PrivateKeyInfo(algId, (ASN1Encodable)new ASN1Integer(priv.getX()), null, publicKey);
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    protected P11Identity generateSM2Keypair0(P11Slot.P11NewKeyControl control) throws P11TokenException {
        return this.generateECKeypair0(GMObjectIdentifiers.sm2p256v1, control);
    }

    @Override
    protected PrivateKeyInfo generateSM2KeypairOtf0() throws P11TokenException {
        return this.generateECKeypairOtf0(GMObjectIdentifiers.sm2p256v1);
    }

    @Override
    protected P11Identity generateECEdwardsKeypair0(ASN1ObjectIdentifier curveOid, P11Slot.P11NewKeyControl control) throws P11TokenException {
        KeyPair keypair;
        try {
            if (!EdECConstants.isEdwardsCurve(curveOid)) {
                throw new P11TokenException("unknown curve  " + curveOid.getId());
            }
            keypair = KeyUtil.generateEdECKeypair(curveOid, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.saveP11Entity(keypair, (P11Slot.P11NewObjectControl)control);
    }

    @Override
    protected PrivateKeyInfo generateECEdwardsKeypairOtf0(ASN1ObjectIdentifier curveId) throws P11TokenException {
        try {
            KeyPair kp = KeyUtil.generateEdECKeypair(curveId, this.random);
            return PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    protected P11Identity generateECMontgomeryKeypair0(ASN1ObjectIdentifier curveOid, P11Slot.P11NewKeyControl control) throws P11TokenException {
        KeyPair keypair;
        try {
            if (!EdECConstants.isMontgomeryCurve(curveOid)) {
                throw new P11TokenException("unknown curve  " + curveOid.getId());
            }
            keypair = KeyUtil.generateEdECKeypair(curveOid, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.saveP11Entity(keypair, (P11Slot.P11NewObjectControl)control);
    }

    @Override
    protected PrivateKeyInfo generateECMontgomeryKeypairOtf0(ASN1ObjectIdentifier curveId) throws P11TokenException {
        try {
            KeyPair kp = KeyUtil.generateEdECKeypair(curveId, this.random);
            return PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    @Override
    protected P11Identity generateECKeypair0(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws P11TokenException {
        KeyPair keypair;
        try {
            keypair = KeyUtil.generateECKeypair(curveId, this.random);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.saveP11Entity(keypair, (P11Slot.P11NewObjectControl)control);
    }

    @Override
    protected PrivateKeyInfo generateECKeypairOtf0(ASN1ObjectIdentifier curveId) throws P11TokenException {
        try {
            AlgorithmIdentifier keyAlgId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveId);
            KeyPair kp = KeyUtil.generateECKeypair(curveId, this.random);
            ECPublicKey pub = (ECPublicKey)kp.getPublic();
            int orderBitLength = pub.getParams().getOrder().bitLength();
            byte[] publicKey = KeyUtil.getUncompressedEncodedECPoint(pub.getW(), orderBitLength);
            java.security.interfaces.ECPrivateKey priv = (java.security.interfaces.ECPrivateKey)kp.getPrivate();
            return new PrivateKeyInfo(keyAlgId, (ASN1Encodable)new ECPrivateKey(orderBitLength, priv.getS(), (ASN1BitString)new DERBitString(publicKey), null));
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    private P11Identity saveP11Entity(KeyPair keypair, P11Slot.P11NewObjectControl control) throws P11TokenException {
        byte[] id = control.getId();
        if (id == null) {
            id = this.generateId();
        }
        String label = control.getLabel();
        long t1 = System.currentTimeMillis();
        String keyLabel = this.savePkcs11PrivateKey(id, label, keypair.getPrivate());
        long t2 = System.currentTimeMillis();
        String pubKeyLabel = this.savePkcs11PublicKey(id, label, keypair.getPublic());
        long t3 = System.currentTimeMillis();
        P11IdentityId identityId = new P11IdentityId(this.slotId, new P11ObjectIdentifier(id, keyLabel), true, pubKeyLabel, false, null);
        long t4 = System.currentTimeMillis();
        try {
            EmulatorP11Identity ret = new EmulatorP11Identity(this, identityId, keypair.getPrivate(), keypair.getPublic(), null, this.maxSessions, this.random);
            long t5 = System.currentTimeMillis();
            LOG.info("duration: t1: {}ms t2: {}ms t3 {}ms t4 {}ms t5", new Object[]{t2 - t1, t3 - t2, t4 - t3, t5 - t4});
            return ret;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException ex) {
            throw new P11TokenException("could not construct KeyStoreP11Identity: " + ex.getMessage(), ex);
        }
    }

    private P11Identity saveP11Entity(SecretKey key, P11Slot.P11NewObjectControl control) throws P11TokenException {
        byte[] id = control.getId();
        if (id == null) {
            id = this.generateId();
        }
        String label = control.getLabel();
        this.savePkcs11SecretKey(id, label, key);
        P11IdentityId identityId = new P11IdentityId(this.slotId, new P11ObjectIdentifier(id, label));
        return new EmulatorP11Identity(this, identityId, key, this.maxSessions, this.random);
    }

    @Override
    protected void updateCertificate0(P11ObjectIdentifier keyId, X509Cert newCert) throws P11TokenException, CertificateException {
        this.removePkcs11Cert(keyId);
        this.savePkcs11Cert(keyId.getId(), keyId.getLabel(), newCert);
    }

    private byte[] generateId() {
        byte[] id;
        do {
            id = new byte[this.newObjectConf.getIdLength()];
            this.random.nextBytes(id);
        } while (this.existsIdentityForId(id) || this.existsCertForId(id));
        return id;
    }

    private static class InfoFilenameFilter
    implements FilenameFilter {
        private InfoFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(EmulatorP11Slot.INFO_FILE_SUFFIX);
        }
    }
}

