/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.generators.SCrypt;
import org.xipki.security.EdECConstants;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

class KeyCryptor {
    private static final byte ALG_SCRYPT1_AESGCMNopadding_128 = 1;
    private static final int AES_GCM_NONCE_BYTE_SIZE = 12;
    private static final int AES_GCM_TAG_BIT_SIZE = 128;
    private final SecretKey key;
    private final SecureRandom rnd;

    KeyCryptor(char[] password) {
        Args.notNull((Object)password, (String)"password");
        byte[] P = StringUtil.toUtf8Bytes((String)new String(password));
        byte[] S = new byte[8];
        byte[] dkey = SCrypt.generate((byte[])P, (byte[])S, (int)16384, (int)8, (int)1, (int)16);
        this.key = new SecretKeySpec(dkey, "AES");
        this.rnd = new SecureRandom();
    }

    PrivateKey decryptPrivateKey(byte[] encryptedPrivateKeyInfo) throws P11TokenException {
        Args.notNull((Object)encryptedPrivateKeyInfo, (String)"encryptedPrivateKeyInfo");
        byte[] plain = this.decrypt(encryptedPrivateKeyInfo);
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)plain);
        AlgorithmIdentifier keyAlg = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier keyAlgOid = keyAlg.getAlgorithm();
        String algoName = PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)keyAlgOid) ? "RSA" : (X9ObjectIdentifiers.id_dsa.equals((ASN1Primitive)keyAlgOid) ? "DSA" : (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)keyAlgOid) ? "EC" : EdECConstants.getName(keyAlg.getAlgorithm())));
        if (algoName == null) {
            throw new P11TokenException("unknown private key algorithm " + keyAlgOid.getId());
        }
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(algoName, "BC");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException ex) {
            throw new P11TokenException(ex.getClass().getName() + ": " + ex.getMessage(), ex);
        }
    }

    byte[] decrypt(byte[] cipherBlob) throws P11TokenException {
        Args.notNull((Object)cipherBlob, (String)"cipherBlob");
        if (cipherBlob[0] != 1) {
            throw new P11TokenException("unknown encryption algorithm");
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, cipherBlob, 1, 12);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            cipher.init(2, (Key)this.key, spec);
            int cipherValueOffset = 13;
            int cipherLen = cipherBlob.length - cipherValueOffset;
            int plainLen = cipher.getOutputSize(cipherLen);
            byte[] plain = new byte[plainLen];
            int realPlainLen = cipher.doFinal(cipherBlob, cipherValueOffset, cipherLen, plain, 0);
            if (plainLen > realPlainLen) {
                plain = Arrays.copyOf(plain, realPlainLen);
            }
            return plain;
        }
        catch (GeneralSecurityException ex) {
            throw new P11TokenException(ex);
        }
    }

    byte[] encrypt(PrivateKey privateKey) throws P11TokenException {
        return this.encrypt(((PrivateKey)Args.notNull((Object)privateKey, (String)"privateKey")).getEncoded());
    }

    byte[] encrypt(SecretKey secretKey) throws P11TokenException {
        return this.encrypt(secretKey.getEncoded());
    }

    byte[] encrypt(byte[] data) throws P11TokenException {
        byte[] nonce = new byte[12];
        this.rnd.nextBytes(nonce);
        GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            cipher.init(1, (Key)this.key, spec);
            int cipherLen = cipher.getOutputSize(data.length);
            byte[] cipherBlob = new byte[1 + nonce.length + cipherLen];
            cipherBlob[0] = 1;
            System.arraycopy(nonce, 0, cipherBlob, 1, nonce.length);
            int offset = 1 + nonce.length;
            int realCipherLen = cipher.doFinal(data, 0, data.length, cipherBlob, offset);
            return cipherLen == realCipherLen ? cipherBlob : Arrays.copyOf(cipherBlob, offset + realCipherLen);
        }
        catch (GeneralSecurityException ex) {
            throw new P11TokenException(ex);
        }
    }
}

