/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.emulator;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.RandomDSAKCalculator;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.xipki.security.HashAlgo;
import org.xipki.security.util.GMUtil;

class SM2Signer {
    private final DSAKCalculator kCalculator = new RandomDSAKCalculator();
    private final Digest digest;
    private final ECDomainParameters ecParams;
    private final ECKeyParameters ecKey;
    private final ECPoint pubPoint;

    public SM2Signer(CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rdmParam = (ParametersWithRandom)param;
            this.ecKey = (ECKeyParameters)rdmParam.getParameters();
            this.ecParams = this.ecKey.getParameters();
            this.kCalculator.init(this.ecParams.getN(), rdmParam.getRandom());
        } else {
            this.ecKey = (ECKeyParameters)param;
            this.ecParams = this.ecKey.getParameters();
            this.kCalculator.init(this.ecParams.getN(), new SecureRandom());
        }
        if (!GMUtil.isSm2primev2Curve(this.ecKey.getParameters().getCurve())) {
            throw new IllegalArgumentException("Given EC key is not of the curve sm2primev2");
        }
        this.pubPoint = new FixedPointCombMultiplier().multiply(this.ecParams.getG(), ((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        this.digest = HashAlgo.SM3.createDigest();
    }

    public byte[] generateSignatureForMessage(byte[] userId, byte[] message) throws CryptoException {
        byte[] z = GMUtil.getSM2Z(userId, GMObjectIdentifiers.sm2p256v1, this.pubPoint.getAffineXCoord().toBigInteger(), this.pubPoint.getAffineYCoord().toBigInteger());
        this.digest.reset();
        this.digest.update(z, 0, z.length);
        this.digest.update(message, 0, message.length);
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return this.generateSignatureForHash(hash);
    }

    public byte[] generateSignatureForHash(byte[] eHash) throws CryptoException {
        BigInteger s;
        BigInteger r;
        BigInteger n = this.ecParams.getN();
        BigInteger e = new BigInteger(1, eHash);
        BigInteger d = ((ECPrivateKeyParameters)this.ecKey).getD();
        FixedPointCombMultiplier basePointMultiplier = new FixedPointCombMultiplier();
        while (true) {
            BigInteger k = this.kCalculator.nextK();
            ECPoint p = basePointMultiplier.multiply(this.ecParams.getG(), k).normalize();
            r = e.add(p.getAffineXCoord().toBigInteger()).mod(n);
            if (r.equals(ECConstants.ZERO) || r.add(k).equals(n)) continue;
            BigInteger dPlus1ModN = d.add(ECConstants.ONE).modInverse(n);
            s = k.subtract(r.multiply(d)).mod(n);
            if (!(s = dPlus1ModN.multiply(s).mod(n)).equals(ECConstants.ZERO)) break;
        }
        try {
            return new DERSequence((ASN1Encodable[])new ASN1Integer[]{new ASN1Integer(r), new ASN1Integer(s)}).getEncoded("DER");
        }
        catch (IOException ex) {
            throw new CryptoException("unable to encode signature: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

