/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.iaik;

import iaik.pkcs.pkcs11.Info;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.Util;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.DSAPrivateKey;
import iaik.pkcs.pkcs11.objects.DSAPublicKey;
import iaik.pkcs.pkcs11.objects.ECPrivateKey;
import iaik.pkcs.pkcs11.objects.ECPublicKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.KeyPair;
import iaik.pkcs.pkcs11.objects.PKCS11Object;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.Storage;
import iaik.pkcs.pkcs11.objects.ValuedSecretKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.security.X509Cert;
import org.xipki.security.XiSecurityException;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11IdentityId;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11Params;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.P11TokenException;
import org.xipki.security.pkcs11.P11UnknownEntityException;
import org.xipki.security.pkcs11.iaik.IaikP11Identity;
import org.xipki.security.pkcs11.iaik.IaikP11SlotUtil;
import org.xipki.security.util.SignerUtil;
import org.xipki.security.util.X509Util;
import org.xipki.util.Args;
import org.xipki.util.CollectionUtil;
import org.xipki.util.LogUtil;
import org.xipki.util.concurrent.ConcurrentBag;
import org.xipki.util.concurrent.ConcurrentBagEntry;

class IaikP11Slot
extends P11Slot {
    public static final AlgorithmIdentifier ALGID_RSA = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE);
    private static final Logger LOG = LoggerFactory.getLogger(IaikP11Slot.class);
    private static final long DEFAULT_MAX_COUNT_SESSION = 32L;
    private final int maxMessageSize;
    private Slot slot;
    private final long userType;
    private List<char[]> password;
    private final int maxSessionCount;
    private final long timeOutWaitNewSession = 10000L;
    private final AtomicLong countSessions = new AtomicLong(0L);
    private final SecureRandom random = new SecureRandom();
    private final P11ModuleConf.P11NewObjectConf newObjectConf;
    private final ConcurrentBag<ConcurrentBagEntry<Session>> sessions = new ConcurrentBag();
    private String libDesc;
    private boolean omitDateAttrsInCertObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IaikP11Slot(String moduleName, P11SlotIdentifier slotId, Slot slot, boolean readOnly, long userType, List<char[]> password, int maxMessageSize, P11ModuleConf.P11MechanismFilter mechanismFilter, P11ModuleConf.P11NewObjectConf newObjectConf, Integer numSessions, List<Long> secretKeyTypes, List<Long> keyPairTypes) throws P11TokenException {
        super(moduleName, slotId, readOnly, mechanismFilter, numSessions, secretKeyTypes, keyPairTypes);
        this.newObjectConf = (P11ModuleConf.P11NewObjectConf)Args.notNull((Object)newObjectConf, (String)"newObjectConf");
        this.slot = (Slot)Args.notNull((Object)slot, (String)"slot");
        this.maxMessageSize = Args.positive((int)maxMessageSize, (String)"maxMessageSize");
        this.userType = userType;
        this.password = password;
        boolean successful = false;
        try {
            Info moduleInfo = slot.getModule().getInfo();
            this.libDesc = moduleInfo.getLibraryDescription();
            if (this.libDesc == null) {
                this.libDesc = "";
            }
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"Module.getInfo()");
            throw new P11TokenException("could not get Module Info: " + ex.getMessage(), ex);
        }
        try {
            long maxSessionCount2;
            Token token;
            Session session;
            try {
                session = this.openSession();
            }
            catch (P11TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"openSession");
                throw ex;
            }
            try {
                this.firstLogin(session, password);
            }
            catch (P11TokenException ex) {
                LogUtil.error((Logger)LOG, (Throwable)ex, (String)"firstLogin");
                throw ex;
            }
            try {
                token = this.slot.getToken();
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not getToken: " + ex.getMessage(), ex);
            }
            try {
                maxSessionCount2 = token.getTokenInfo().getMaxSessionCount();
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not get tokenInfo: " + ex.getMessage(), ex);
            }
            if (maxSessionCount2 <= 0L) {
                maxSessionCount2 = 32L;
            } else {
                long l = maxSessionCount2 = maxSessionCount2 < 3L ? 1L : maxSessionCount2 - 2L;
            }
            if (numSessions != null) {
                maxSessionCount2 = Math.min((long)numSessions.intValue(), maxSessionCount2);
            }
            this.maxSessionCount = (int)maxSessionCount2;
            LOG.info("maxSessionCount: {}", (Object)this.maxSessionCount);
            this.sessions.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)session));
            this.refresh();
            successful = true;
        }
        finally {
            if (!successful) {
                this.close();
            }
        }
    }

    Slot getSlot() {
        return this.slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11Slot.P11SlotRefreshResult refresh0() throws P11TokenException {
        Mechanism[] mechanisms;
        try {
            mechanisms = this.slot.getToken().getMechanismList();
        }
        catch (TokenException ex) {
            throw new P11TokenException("could not getMechanismList: " + ex.getMessage(), ex);
        }
        P11Slot.P11SlotRefreshResult ret = new P11Slot.P11SlotRefreshResult();
        if (mechanisms != null) {
            StringBuilder ignoreMechs = new StringBuilder();
            boolean smartcard = this.libDesc.toLowerCase().contains("smartcard");
            for (Mechanism mech : mechanisms) {
                long code = mech.getMechanismCode();
                if (smartcard) {
                    if (code == 4162L || code == 4163L || code == 4164L || code == 4165L || code == 4166L || code == 4167L || code == 4168L || code == 4169L || code == 4170L) {
                        ignoreMechs.append(Functions.getMechanismDescription((long)code)).append(", ");
                        continue;
                    }
                    ret.addMechanism(code);
                    continue;
                }
                ret.addMechanism(code);
            }
            if (ignoreMechs.length() > 0) {
                LOG.info("Ignore mechanisms in smartcard-based HSM: {}", (Object)ignoreMechs.substring(0, ignoreMechs.length() - 2));
            }
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            List<Object> privKeys;
            List<Object> secretKeys;
            Session session = (Session)bagEntry.value();
            if (this.secretKeyTypes == null) {
                secretKeys = IaikP11SlotUtil.getObjects(session, (Storage)new SecretKey());
            } else if (this.secretKeyTypes.isEmpty()) {
                secretKeys = Collections.emptyList();
            } else {
                secretKeys = new LinkedList<Storage>();
                for (Long keyType : this.secretKeyTypes) {
                    secretKeys.addAll(IaikP11SlotUtil.getObjects(session, (Storage)new ValuedSecretKey(keyType.longValue())));
                }
            }
            LOG.info("found {} secret keys", (Object)secretKeys.size());
            int count = 0;
            for (Object secretKey : secretKeys) {
                if (!(secretKey instanceof SecretKey) || !this.analyseSingleSecretKey((SecretKey)secretKey, ret)) continue;
                ++count;
            }
            LOG.info("accepted {} secret keys", (Object)count);
            List<X509PublicKeyCertificate> p11Certs = IaikP11SlotUtil.getAllCertificateObjects(session);
            LOG.info("found {} X.509 certificates", (Object)p11Certs.size());
            count = 0;
            for (X509PublicKeyCertificate p11Cert : p11Certs) {
                byte[] byArray = IaikP11SlotUtil.value(p11Cert.getId());
                String label = IaikP11SlotUtil.valueStr(p11Cert.getLabel());
                if (byArray == null || byArray.length == 0) {
                    LOG.warn("ignored X.509 certificate with ID: null and label: " + label);
                    continue;
                }
                ret.addCertificate(new P11ObjectIdentifier(byArray, label), IaikP11SlotUtil.parseCert(p11Cert));
                ++count;
            }
            LOG.info("accepted {} X.509 certificates", (Object)count);
            if (this.keyPairTypes == null) {
                PrivateKey template = new PrivateKey();
                privKeys = IaikP11SlotUtil.getObjects(session, (Storage)template);
            } else if (this.keyPairTypes.isEmpty()) {
                privKeys = Collections.emptyList();
            } else {
                privKeys = new LinkedList();
                Iterator iterator = this.keyPairTypes.iterator();
                while (iterator.hasNext()) {
                    iaik.pkcs.pkcs11.objects.RSAPrivateKey template;
                    long l = (Long)iterator.next();
                    if (l == 0L) {
                        template = new iaik.pkcs.pkcs11.objects.RSAPrivateKey();
                    } else if (l == 1L) {
                        template = new DSAPrivateKey();
                    } else if (l == 3L) {
                        template = new ECPrivateKey();
                    } else if (l == 0xFFFFF001L) {
                        template = ECPrivateKey.newSM2PrivateKey((Module)this.slot.getModule());
                    } else if (l == 64L) {
                        template = new ECPrivateKey(64L);
                    } else if (l == 65L) {
                        template = new ECPrivateKey(65L);
                    } else {
                        LOG.error("unknown KeyPair keyType " + l);
                        continue;
                    }
                    privKeys.addAll(IaikP11SlotUtil.getObjects(session, (Storage)template));
                }
            }
            LOG.info("found {} private keys", (Object)privKeys.size());
            count = 0;
            for (Storage storage : privKeys) {
                if (!(storage instanceof PrivateKey) || !this.analyseSinglePrivateKey(session, (PrivateKey)storage, ret)) continue;
                ++count;
            }
            LOG.info("accepted {} private keys", (Object)count);
            P11Slot.P11SlotRefreshResult p11SlotRefreshResult = ret;
            return p11SlotRefreshResult;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    public final void close() {
        if (this.slot != null) {
            try {
                LOG.info("close all sessions on token: {}", (Object)this.slot.getSlotID());
                for (ConcurrentBagEntry session : this.sessions.values()) {
                    ((Session)session.value()).closeSession();
                }
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not slot.getToken().closeAllSessions()");
            }
            this.slot = null;
        }
        this.sessions.close();
        this.countSessions.lazySet(0L);
    }

    private boolean analyseSingleSecretKey(SecretKey secretKey, P11Slot.P11SlotRefreshResult refreshResult) {
        byte[] id = IaikP11SlotUtil.value(secretKey.getId());
        String label = IaikP11SlotUtil.valueStr(secretKey.getLabel());
        if (id == null || id.length == 0) {
            LOG.warn("ignored secret key with ID: null and label: " + label);
            return false;
        }
        IaikP11Identity identity = new IaikP11Identity(this, new P11IdentityId(this.slotId, new P11ObjectIdentifier(id, label)), secretKey);
        refreshResult.addIdentity(identity);
        return true;
    }

    private boolean analyseSinglePrivateKey(Session session, PrivateKey privKey, P11Slot.P11SlotRefreshResult refreshResult) {
        byte[] id = IaikP11SlotUtil.value(privKey.getId());
        String label = IaikP11SlotUtil.valueStr(privKey.getLabel());
        if (id == null || id.length == 0) {
            LOG.warn("ignored private key with ID: null and label: " + label);
            return false;
        }
        try {
            X509Cert[] x509CertArray;
            String pubKeyLabel = null;
            iaik.pkcs.pkcs11.objects.PublicKey p11PublicKey = (iaik.pkcs.pkcs11.objects.PublicKey)this.getKeyObjectForId(session, (Key)new iaik.pkcs.pkcs11.objects.PublicKey(), id);
            if (p11PublicKey != null) {
                pubKeyLabel = IaikP11SlotUtil.valueStr(p11PublicKey.getLabel());
            }
            String certLabel = null;
            PublicKey pubKey = null;
            X509Cert cert = refreshResult.getCertForId(id);
            if (cert != null) {
                certLabel = refreshResult.getCertLabelForId(id);
                pubKey = cert.getPublicKey();
            } else if (p11PublicKey != null) {
                pubKey = IaikP11SlotUtil.generatePublicKey(p11PublicKey);
            } else {
                iaik.pkcs.pkcs11.objects.RSAPrivateKey p11RsaSk;
                if (privKey instanceof iaik.pkcs.pkcs11.objects.RSAPrivateKey && (p11RsaSk = (iaik.pkcs.pkcs11.objects.RSAPrivateKey)privKey).getPublicExponent() != null && p11RsaSk.getModulus() == null) {
                    pubKey = IaikP11SlotUtil.buildRSAKey(new BigInteger(1, IaikP11SlotUtil.value(p11RsaSk.getModulus())), new BigInteger(1, IaikP11SlotUtil.value(p11RsaSk.getPublicExponent())));
                }
                if (pubKey == null) {
                    LOG.info("neither certificate nor public key for the key (" + IaikP11Slot.hex(id) + " is available");
                    return false;
                }
            }
            if (cert == null) {
                x509CertArray = null;
            } else {
                X509Cert[] x509CertArray2 = new X509Cert[1];
                x509CertArray = x509CertArray2;
                x509CertArray2[0] = cert;
            }
            X509Cert[] certs = x509CertArray;
            P11IdentityId p11Id = new P11IdentityId(this.slotId, new P11ObjectIdentifier(id, label), pubKey != null, pubKeyLabel, cert != null, certLabel);
            refreshResult.addIdentity(new IaikP11Identity(this, p11Id, privKey, pubKey, certs));
            return true;
        }
        catch (XiSecurityException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)("XiSecurityException while initializing private key with id " + IaikP11Slot.hex(id)));
        }
        catch (Throwable th) {
            LOG.error("unexpected exception while initializing private key with id " + IaikP11Slot.hex(id) + " and label " + label, th);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    byte[] digestSecretKey(long mech, IaikP11Identity identity) throws P11TokenException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 6[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] sign(long mech, P11Params parameters, byte[] content, IaikP11Identity identity) throws P11TokenException {
        Args.notNull((Object)content, (String)"content");
        this.assertMechanismSupported(mech);
        int expectedSignatureLen = mech == 545L ? 20 : (mech == 598L || mech == 693L ? 28 : (mech == 593L || mech == 688L ? 32 : (mech == 609L || mech == 704L ? 48 : (mech == 625L || mech == 720L ? 64 : identity.getExpectedSignatureLen()))));
        Mechanism mechanismObj = IaikP11SlotUtil.getMechanism(mech, parameters);
        Key signingKey = identity.getSigningKey();
        ConcurrentBagEntry<Session> session0 = this.borrowSession();
        try {
            Session session = (Session)session0.value();
            try {
                byte[] byArray = this.sign0(session, expectedSignatureLen, mechanismObj, content, signingKey);
                return byArray;
            }
            catch (PKCS11Exception ex) {
                if (ex.getErrorCode() != 257L) throw ex;
                LOG.info("sign ended with ERROR CKR_USER_NOT_LOGGED_IN, login and then retry it");
                this.forceLogin(session);
                byte[] byArray2 = this.sign0(session, expectedSignatureLen, mechanismObj, content, signingKey);
                return byArray2;
            }
            finally {
                this.sessions.requite(session0);
            }
        }
        catch (TokenException ex2) {
            throw new P11TokenException(ex2.getMessage(), ex2);
        }
    }

    private byte[] sign0(Session session, int expectedSignatureLen, Mechanism mechanism, byte[] content, Key signingKey) throws TokenException {
        byte[] sigvalue;
        long keytype = signingKey.getKeyType().getLongValue();
        boolean weierstrausKey = 3L == keytype || 0xFFFFF001L == keytype;
        int len = content.length;
        if (len <= this.maxMessageSize) {
            sigvalue = this.singleSign(session, mechanism, content, signingKey);
        } else {
            LOG.debug("sign (init, update, then finish)");
            session.signInit(mechanism, signingKey);
            for (int i = 0; i < len; i += this.maxMessageSize) {
                int blockLen = Math.min(this.maxMessageSize, len - i);
                session.signUpdate(content, i, blockLen);
            }
            int maxSignatureLen = weierstrausKey ? expectedSignatureLen + 20 : expectedSignatureLen;
            sigvalue = session.signFinal(maxSignatureLen);
        }
        if (sigvalue.length > expectedSignatureLen && sigvalue[0] == 48) {
            try {
                sigvalue = SignerUtil.dsaSigX962ToPlain(sigvalue, expectedSignatureLen * 4);
            }
            catch (XiSecurityException e) {
                LOG.error(String.format("ERROR: sigvalue (%d): %s", sigvalue.length, Hex.toHexString((byte[])sigvalue)), (Throwable)e);
                throw new TokenException((Exception)e);
            }
            catch (RuntimeException e) {
                LOG.error(String.format("ERROR: sigvalue (%d): %s", sigvalue.length, Hex.toHexString((byte[])sigvalue)), (Throwable)e);
                throw e;
            }
        }
        return sigvalue;
    }

    private byte[] singleSign(Session session, Mechanism mechanism, byte[] content, Key signingKey) throws TokenException {
        LOG.debug("single sign");
        session.signInit(mechanism, signingKey);
        return session.sign(content);
    }

    private Session openSession() throws P11TokenException {
        Session session;
        try {
            boolean rw = !this.isReadOnly();
            session = this.slot.getToken().openSession(true, rw, null, null);
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        this.countSessions.incrementAndGet();
        return session;
    }

    private ConcurrentBagEntry<Session> borrowSession() throws P11TokenException {
        int i = 0;
        while ((long)i < Math.min(32L, (long)this.maxSessionCount)) {
            try {
                return this.borrowSession0();
            }
            catch (P11TokenException ex) {
                long ckr;
                Throwable cause = ex.getCause();
                if (cause instanceof PKCS11Exception && ((ckr = ((PKCS11Exception)cause).getErrorCode()) == 179L || ckr == 176L)) break;
                ++i;
            }
        }
        throw new P11TokenException("could not borrow valid session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentBagEntry<Session> borrowSession0() throws P11TokenException {
        ConcurrentBagEntry session = null;
        ConcurrentBag<ConcurrentBagEntry<Session>> concurrentBag = this.sessions;
        synchronized (concurrentBag) {
            if (this.countSessions.get() < (long)this.maxSessionCount) {
                try {
                    session = (ConcurrentBagEntry)this.sessions.borrow(1L, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (session == null) {
                    this.sessions.add((ConcurrentBag.IConcurrentBagEntry)new ConcurrentBagEntry((Object)this.openSession()));
                }
            }
        }
        if (session == null) {
            try {
                session = (ConcurrentBagEntry)this.sessions.borrow(10000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (session == null) {
            throw new P11TokenException("no idle session");
        }
        this.login((Session)session.value());
        return session;
    }

    private void firstLogin(Session session, List<char[]> password) throws P11TokenException {
        try {
            boolean isProtectedAuthenticationPath = session.getToken().getTokenInfo().isProtectedAuthenticationPath();
            if (isProtectedAuthenticationPath || CollectionUtil.isEmpty(password)) {
                LOG.info("verify on PKCS11Module with PROTECTED_AUTHENTICATION_PATH");
                IaikP11SlotUtil.singleLogin(session, this.userType, null);
            } else {
                LOG.info("verify on PKCS11Module with PIN");
                for (char[] singlePwd : password) {
                    IaikP11SlotUtil.singleLogin(session, this.userType, singlePwd);
                }
                this.password = password;
            }
        }
        catch (PKCS11Exception ex) {
            if (ex.getErrorCode() != 256L) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
    }

    private void login(Session session) throws P11TokenException {
        boolean loginRequired;
        boolean isSessionLoggedIn = IaikP11SlotUtil.checkSessionLoggedIn(session, this.userType);
        if (isSessionLoggedIn) {
            return;
        }
        try {
            loginRequired = session.getToken().getTokenInfo().isLoginRequired();
        }
        catch (TokenException ex) {
            LogUtil.error((Logger)LOG, (Throwable)ex, (String)"could not check isLoginRequired of token");
            loginRequired = true;
        }
        LOG.debug("loginRequired: {}", (Object)loginRequired);
        if (!loginRequired) {
            return;
        }
        if (CollectionUtil.isEmpty(this.password)) {
            IaikP11SlotUtil.singleLogin(session, this.userType, null);
        } else {
            for (char[] singlePwd : this.password) {
                IaikP11SlotUtil.singleLogin(session, this.userType, singlePwd);
            }
        }
    }

    private void forceLogin(Session session) throws P11TokenException {
        if (CollectionUtil.isEmpty(this.password)) {
            LOG.info("verify on PKCS11Module with NULL PIN");
            IaikP11SlotUtil.singleLogin(session, this.userType, null);
        } else {
            LOG.info("verify on PKCS11Module with PIN");
            for (char[] singlePwd : this.password) {
                IaikP11SlotUtil.singleLogin(session, this.userType, singlePwd);
            }
        }
    }

    private Key getKeyObjectForId(Session session, Key template, byte[] keyId) throws P11TokenException {
        return this.getKeyObject(session, template, keyId, true, null);
    }

    private Key getKeyObject(Session session, Key template, byte[] keyId, char[] keyLabel) throws P11TokenException {
        return this.getKeyObject(session, template, keyId, false, keyLabel);
    }

    private Key getKeyObject(Session session, Key template, byte[] keyId, boolean ignoreLabel, char[] keyLabel) throws P11TokenException {
        List<Storage> tmpObjects;
        template.getId().setByteArrayValue((byte[])Args.notNull((Object)keyId, (String)"keyId"));
        if (!ignoreLabel) {
            template.getLabel().setCharArrayValue(keyLabel);
        }
        if (CollectionUtil.isEmpty(tmpObjects = IaikP11SlotUtil.getObjects(session, (Storage)template, 2))) {
            return null;
        }
        int size = tmpObjects.size();
        if (size > 1) {
            LOG.warn("found {} public key identified by {}, use the first one", (Object)size, (Object)IaikP11Slot.getDescription(keyId, keyLabel));
        }
        return (Key)tmpObjects.get(0);
    }

    @Override
    public int removeObjectsForId(byte[] id) throws P11TokenException {
        return this.removeObjects(id, true, null);
    }

    @Override
    public int removeObjectsForLabel(String label) throws P11TokenException {
        return this.removeObjects(null, false, ((String)Args.notNull((Object)label, (String)"label")).toCharArray());
    }

    @Override
    public int removeObjects(byte[] id, String label) throws P11TokenException {
        return this.removeObjects(id, false, label == null ? null : label.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeObjects(byte[] id, boolean ignoreLabel, char[] label) throws P11TokenException {
        boolean labelBlank;
        if (ignoreLabel) {
            label = null;
        }
        boolean bl = labelBlank = label == null || label.length == 0;
        if ((id == null || id.length == 0) && labelBlank) {
            throw new IllegalArgumentException("at least one of id and label may not be null");
        }
        Key keyTemplate = new Key();
        if (id != null && id.length > 0) {
            keyTemplate.getId().setByteArrayValue(id);
        }
        if (!ignoreLabel) {
            keyTemplate.getLabel().setCharArrayValue(label);
        }
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            String objIdDesc = IaikP11Slot.getDescription(id, label);
            int num = IaikP11SlotUtil.removeObjects0(session, (Storage)keyTemplate, "keys " + objIdDesc);
            X509PublicKeyCertificate certTemplate = new X509PublicKeyCertificate();
            if (id != null && id.length > 0) {
                certTemplate.getId().setByteArrayValue(id);
            }
            if (!ignoreLabel) {
                certTemplate.getLabel().setCharArrayValue(label);
            }
            int n = num += IaikP11SlotUtil.removeObjects0(session, (Storage)certTemplate, "certificates " + objIdDesc);
            return n;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected void removeCerts0(P11ObjectIdentifier objectId) throws P11TokenException {
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            X509PublicKeyCertificate[] existingCerts = IaikP11SlotUtil.getCertificateObjects(session, objectId.getId(), objectId.getLabelChars());
            if (existingCerts == null || existingCerts.length == 0) {
                LOG.warn("could not find certificates " + objectId);
                return;
            }
            for (X509PublicKeyCertificate cert : existingCerts) {
                session.destroyObject((PKCS11Object)cert);
            }
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11ObjectIdentifier addCert0(X509Cert cert, P11Slot.P11NewObjectControl control) throws P11TokenException {
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            X509PublicKeyCertificate newCert;
            Session session = (Session)bagEntry.value();
            boolean omit = this.omitDateAttrsInCertObject;
            X509PublicKeyCertificate newCertTemp = this.createPkcs11Template(session, cert, control, omit);
            try {
                newCert = (X509PublicKeyCertificate)session.createObject((PKCS11Object)newCertTemp);
            }
            catch (PKCS11Exception ex) {
                long errCode = ex.getErrorCode();
                if (!omit && 209L == errCode) {
                    newCertTemp = this.createPkcs11Template(session, cert, control, true);
                    newCert = (X509PublicKeyCertificate)session.createObject((PKCS11Object)newCertTemp);
                    this.omitDateAttrsInCertObject = true;
                    LOG.warn("The HSM does not accept certificate object with attributes CKA_START_DATE and CKA_END_DATE, ignore them");
                }
                throw ex;
            }
            P11ObjectIdentifier p11ObjectIdentifier = new P11ObjectIdentifier(IaikP11SlotUtil.value(newCert.getId()), IaikP11SlotUtil.valueStr(newCert.getLabel()));
            return p11ObjectIdentifier;
        }
        catch (TokenException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11Identity generateSecretKey0(long keyType, int keysize, P11Slot.P11NewKeyControl control) throws P11TokenException {
        char[] labelChars;
        long mech;
        if (keysize % 8 != 0) {
            throw new IllegalArgumentException("keysize is not multiple of 8: " + keysize);
        }
        if (31L == keyType) {
            mech = 4224L;
        } else if (21L == keyType) {
            mech = 305L;
        } else if (16L == keyType) {
            mech = 848L;
        } else if (40L == keyType || 46L == keyType || 43L == keyType || 44L == keyType || 45L == keyType || 54L == keyType || 55L == keyType || 56L == keyType || 57L == keyType) {
            mech = 848L;
        } else {
            throw new IllegalArgumentException("unsupported key type 0x" + Functions.toFullHex((long)((int)keyType)));
        }
        this.assertMechanismSupported(mech);
        if (this.newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
            labelChars = null;
        } else {
            labelChars = control.getLabel().toCharArray();
        }
        byte[] id = control.getId();
        ValuedSecretKey template = new ValuedSecretKey(keyType);
        IaikP11SlotUtil.setKeyAttributes(control, (SecretKey)template, labelChars);
        template.getValueLen().setLongValue(Long.valueOf(keysize / 8));
        Mechanism mechanism = Mechanism.get((long)mech);
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            SecretKey key;
            Session session = (Session)bagEntry.value();
            if (labelChars != null && this.labelExists(session, labelChars)) {
                throw new IllegalArgumentException("label " + control.getLabel() + " exists, please specify another one");
            }
            if (id == null) {
                id = this.generateId(session);
            }
            template.getId().setByteArrayValue(id);
            try {
                key = (SecretKey)session.generateKey(mechanism, (PKCS11Object)template);
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not generate generic secret key using " + mechanism.getName(), ex);
            }
            P11ObjectIdentifier objId = new P11ObjectIdentifier(id, IaikP11SlotUtil.valueStr(key.getLabel()));
            P11IdentityId entityId = new P11IdentityId(this.slotId, objId);
            IaikP11Identity iaikP11Identity = new IaikP11Identity(this, entityId, key);
            return iaikP11Identity;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected P11Identity importSecretKey0(long keyType, byte[] keyValue, P11Slot.P11NewKeyControl control) throws P11TokenException {
        char[] labelChars;
        ValuedSecretKey template = new ValuedSecretKey(keyType);
        if (this.newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
            labelChars = null;
        } else {
            labelChars = control.getLabel().toCharArray();
        }
        IaikP11SlotUtil.setKeyAttributes(control, (SecretKey)template, labelChars);
        template.getValue().setByteArrayValue(keyValue);
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            SecretKey key;
            Session session = (Session)bagEntry.value();
            if (labelChars != null && this.labelExists(session, labelChars)) {
                throw new IllegalArgumentException("label " + control.getLabel() + " exists, please specify another one");
            }
            byte[] id = control.getId();
            if (id == null) {
                id = this.generateId(session);
            }
            template.getId().setByteArrayValue(id);
            try {
                key = (SecretKey)session.createObject((PKCS11Object)template);
            }
            catch (TokenException ex) {
                throw new P11TokenException("could not create secret key", ex);
            }
            P11ObjectIdentifier objId = new P11ObjectIdentifier(id, IaikP11SlotUtil.valueStr(key.getLabel()));
            P11IdentityId entityId = new P11IdentityId(this.slotId, objId);
            IaikP11Identity iaikP11Identity = new IaikP11Identity(this, entityId, key);
            return iaikP11Identity;
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11Identity generateRSAKeypair0(int keysize, BigInteger publicExponent, P11Slot.P11NewKeyControl control) throws P11TokenException {
        iaik.pkcs.pkcs11.objects.RSAPrivateKey privateKey = new iaik.pkcs.pkcs11.objects.RSAPrivateKey();
        RSAPublicKey publicKey = new RSAPublicKey();
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey, this.newObjectConf);
        publicKey.getModulusBits().setLongValue(Long.valueOf(keysize));
        publicKey.getPublicExponent().setByteArrayValue(publicExponent.toByteArray());
        return this.generateKeyPair(0L, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    /*
     * Loose catch block
     */
    @Override
    protected PrivateKeyInfo generateRSAKeypairOtf0(int keysize, BigInteger publicExponent) throws P11TokenException {
        RSAPublicKey publicKeyTemplate = new RSAPublicKey();
        publicKeyTemplate.getModulusBits().setLongValue(Long.valueOf(keysize));
        publicKeyTemplate.getPublicExponent().setByteArrayValue(publicExponent.toByteArray());
        iaik.pkcs.pkcs11.objects.RSAPrivateKey privateKeyTemplate = new iaik.pkcs.pkcs11.objects.RSAPrivateKey();
        IaikP11Slot.setPrivateKeyAttrsOtf((PrivateKey)privateKeyTemplate);
        long mech = 0L;
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            KeyPair keypair = null;
            try {
                keypair = session.generateKeyPair(Mechanism.get((long)mech), (PKCS11Object)publicKeyTemplate, (PKCS11Object)privateKeyTemplate);
                iaik.pkcs.pkcs11.objects.RSAPrivateKey sk = (iaik.pkcs.pkcs11.objects.RSAPrivateKey)keypair.getPrivateKey();
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(ALGID_RSA, (ASN1Encodable)new RSAPrivateKey(IaikP11Slot.toBigInt(sk.getModulus()), IaikP11Slot.toBigInt(sk.getPublicExponent()), IaikP11Slot.toBigInt(sk.getPrivateExponent()), IaikP11Slot.toBigInt(sk.getPrime1()), IaikP11Slot.toBigInt(sk.getPrime2()), IaikP11Slot.toBigInt(sk.getExponent1()), IaikP11Slot.toBigInt(sk.getExponent2()), IaikP11Slot.toBigInt(sk.getCoefficient())));
                return privateKeyInfo;
            }
            catch (TokenException | IOException ex) {
                throw new P11TokenException("could not generate keypair " + Functions.mechanismCodeToString((long)mech), ex);
            }
            finally {
                if (keypair != null) {
                    IaikP11Slot.destroyObject(session, (PKCS11Object)keypair.getPrivateKey());
                    IaikP11Slot.destroyObject(session, (PKCS11Object)keypair.getPublicKey());
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11Identity generateDSAKeypair0(BigInteger p, BigInteger q, BigInteger g, P11Slot.P11NewKeyControl control) throws P11TokenException {
        DSAPrivateKey privateKey = new DSAPrivateKey();
        DSAPublicKey publicKey = new DSAPublicKey();
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey, this.newObjectConf);
        publicKey.getPrime().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)p));
        publicKey.getSubprime().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)q));
        publicKey.getBase().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)g));
        return this.generateKeyPair(16L, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    /*
     * Loose catch block
     */
    @Override
    protected PrivateKeyInfo generateDSAKeypairOtf0(BigInteger p, BigInteger q, BigInteger g) throws P11TokenException {
        DSAPublicKey publicKeyTemplate = new DSAPublicKey();
        publicKeyTemplate.getPrime().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)p));
        publicKeyTemplate.getSubprime().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)q));
        publicKeyTemplate.getBase().setByteArrayValue(Util.unsignedBigIntergerToByteArray((BigInteger)g));
        DSAPrivateKey privateKeyTemplate = new DSAPrivateKey();
        IaikP11Slot.setPrivateKeyAttrsOtf((PrivateKey)privateKeyTemplate);
        long mech = 16L;
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            Session session = (Session)bagEntry.value();
            KeyPair keypair = null;
            try {
                DSAParameter parameter = new DSAParameter(p, q, g);
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)parameter);
                keypair = session.generateKeyPair(Mechanism.get((long)mech), (PKCS11Object)publicKeyTemplate, (PKCS11Object)privateKeyTemplate);
                DSAPrivateKey sk = (DSAPrivateKey)keypair.getPrivateKey();
                DSAPublicKey pk = (DSAPublicKey)keypair.getPublicKey();
                BigInteger value = IaikP11Slot.toBigInt(pk.getValue());
                byte[] publicKey = new ASN1Integer(value).getEncoded();
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algId, (ASN1Encodable)new ASN1Integer(IaikP11Slot.toBigInt(sk.getValue())), null, publicKey);
                return privateKeyInfo;
            }
            catch (TokenException | IOException ex) {
                throw new P11TokenException("could not generate keypair " + Functions.mechanismCodeToString((long)mech), ex);
            }
            finally {
                if (keypair != null) {
                    IaikP11Slot.destroyObject(session, (PKCS11Object)keypair.getPrivateKey());
                    IaikP11Slot.destroyObject(session, (PKCS11Object)keypair.getPublicKey());
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11Identity generateECEdwardsKeypair0(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws P11TokenException {
        byte[] encodedCurveId;
        ECPrivateKey privateKey = new ECPrivateKey(64L);
        ECPublicKey publicKey = new ECPublicKey(64L);
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey, this.newObjectConf);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        publicKey.getEcdsaParams().setByteArrayValue(encodedCurveId);
        return this.generateKeyPair(4181L, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    @Override
    protected PrivateKeyInfo generateECEdwardsKeypairOtf0(ASN1ObjectIdentifier curveId) throws P11TokenException {
        return this.generateECKeypairOtf0(64L, 4181L, curveId);
    }

    @Override
    protected P11Identity generateECMontgomeryKeypair0(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws P11TokenException {
        ECPrivateKey privateKey = new ECPrivateKey(65L);
        ECPublicKey publicKey = new ECPublicKey(65L);
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey, this.newObjectConf);
        try {
            publicKey.getEcdsaParams().setByteArrayValue(curveId.getEncoded());
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        return this.generateKeyPair(4182L, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
    }

    @Override
    protected PrivateKeyInfo generateECMontgomeryKeypairOtf0(ASN1ObjectIdentifier curveId) throws P11TokenException {
        return this.generateECKeypairOtf0(65L, 4182L, curveId);
    }

    @Override
    protected P11Identity generateECKeypair0(ASN1ObjectIdentifier curveId, P11Slot.P11NewKeyControl control) throws P11TokenException {
        byte[] encodedCurveId;
        ECPrivateKey privateKey = new ECPrivateKey();
        ECPublicKey publicKey = new ECPublicKey();
        this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey, this.newObjectConf);
        try {
            encodedCurveId = curveId.getEncoded();
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        long mech = 4160L;
        try {
            publicKey.getEcdsaParams().setByteArrayValue(encodedCurveId);
            return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
        }
        catch (P11TokenException ex) {
            X9ECParameters ecParams = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveId);
            if (ecParams == null) {
                throw new IllegalArgumentException("got no X9ECParameters for curve " + curveId.getId());
            }
            try {
                publicKey.getEcdsaParams().setByteArrayValue(ecParams.getEncoded());
            }
            catch (IOException ex2) {
                throw new P11TokenException(ex2.getMessage(), ex2);
            }
            return this.generateKeyPair(mech, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
        }
    }

    @Override
    protected PrivateKeyInfo generateECKeypairOtf0(ASN1ObjectIdentifier curveId) throws P11TokenException {
        return this.generateECKeypairOtf0(3L, 4160L, curveId);
    }

    /*
     * Loose catch block
     */
    private PrivateKeyInfo generateECKeypairOtf0(long keyType, long mech, ASN1ObjectIdentifier curveId) throws P11TokenException {
        ECPublicKey publicKeyTemplate;
        ECPrivateKey privateKeyTemplate;
        if (keyType == 0xFFFFF001L) {
            if (!GMObjectIdentifiers.sm2p256v1.equals((ASN1Primitive)curveId)) {
                throw new P11TokenException("keyType and curveId do not match.");
            }
            privateKeyTemplate = ECPrivateKey.newSM2PrivateKey((Module)this.slot.getModule());
            publicKeyTemplate = ECPublicKey.newSM2PublicKey((Module)this.slot.getModule());
        } else {
            privateKeyTemplate = new ECPrivateKey(keyType);
            publicKeyTemplate = new ECPublicKey(keyType);
        }
        try {
            publicKeyTemplate.getEcdsaParams().setByteArrayValue(curveId.getEncoded());
        }
        catch (IOException ex) {
            throw new P11TokenException(ex.getMessage(), ex);
        }
        IaikP11Slot.setPrivateKeyAttrsOtf((PrivateKey)privateKeyTemplate);
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            PrivateKeyInfo privateKeyInfo;
            Session session = (Session)bagEntry.value();
            KeyPair keypair = null;
            try {
                keypair = session.generateKeyPair(Mechanism.get((long)mech), (PKCS11Object)publicKeyTemplate, (PKCS11Object)privateKeyTemplate);
                ECPrivateKey sk = (ECPrivateKey)keypair.getPrivateKey();
                ECPublicKey pk = (ECPublicKey)keypair.getPublicKey();
                if (64L == keyType || 65L == keyType) {
                    AlgorithmIdentifier algId = new AlgorithmIdentifier(curveId);
                    byte[] encodedPublicPoint = ASN1OctetString.getInstance((Object)pk.getEcPoint().getByteArrayValue()).getOctets();
                    byte[] privValue = sk.getValue().getByteArrayValue();
                    PrivateKeyInfo privateKeyInfo2 = new PrivateKeyInfo(algId, (ASN1Encodable)new DEROctetString(privValue), null, encodedPublicPoint);
                    return privateKeyInfo2;
                }
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveId);
                byte[] encodedPublicPoint = ASN1OctetString.getInstance((Object)pk.getEcPoint().getByteArrayValue()).getOctets();
                if (encodedPublicPoint[0] != 4) {
                    throw new P11TokenException("EcPoint does not start with 0x04");
                }
                int orderBigLen = (encodedPublicPoint.length - 1) / 2 * 8;
                privateKeyInfo = new PrivateKeyInfo(algId, (ASN1Encodable)new org.bouncycastle.asn1.sec.ECPrivateKey(orderBigLen, new BigInteger(1, sk.getValue().getByteArrayValue()), (ASN1BitString)new DERBitString(encodedPublicPoint), null));
            }
            catch (TokenException | IOException ex) {
                throw new P11TokenException("could not generate keypair " + Functions.mechanismCodeToString((long)mech), ex);
            }
            finally {
                if (keypair != null) {
                    IaikP11Slot.destroyObject(session, (PKCS11Object)keypair.getPrivateKey());
                    IaikP11Slot.destroyObject(session, (PKCS11Object)keypair.getPublicKey());
                }
            }
            return privateKeyInfo;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    @Override
    protected P11Identity generateSM2Keypair0(P11Slot.P11NewKeyControl control) throws P11TokenException {
        long ckm = 0xFFFFF001L;
        if (this.supportsMechanism(ckm)) {
            ECPrivateKey privateKey = ECPrivateKey.newSM2PrivateKey((Module)this.slot.getModule());
            ECPublicKey publicKey = ECPublicKey.newSM2PublicKey((Module)this.slot.getModule());
            publicKey.getEcdsaParams().setByteArrayValue(Hex.decode((String)"06082A811CCF5501822D"));
            this.setKeyAttributes(control, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey, (PrivateKey)privateKey, this.newObjectConf);
            return this.generateKeyPair(ckm, control.getId(), (PrivateKey)privateKey, (iaik.pkcs.pkcs11.objects.PublicKey)publicKey);
        }
        return this.generateECKeypair0(GMObjectIdentifiers.sm2p256v1, control);
    }

    @Override
    protected PrivateKeyInfo generateSM2KeypairOtf0() throws P11TokenException {
        long ckm = 0xFFFFF001L;
        if (this.supportsMechanism(ckm)) {
            return this.generateECKeypairOtf0(0xFFFFF001L, ckm, GMObjectIdentifiers.sm2p256v1);
        }
        return this.generateECKeypairOtf0(GMObjectIdentifiers.sm2p256v1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P11Identity generateKeyPair(long mech, byte[] id, PrivateKey privateKeyTemplate, iaik.pkcs.pkcs11.objects.PublicKey publicKeyTemplate) throws P11TokenException {
        char[] labelChars = IaikP11SlotUtil.value(privateKeyTemplate.getLabel());
        boolean succ = false;
        try {
            IaikP11Identity iaikP11Identity;
            ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
            try {
                PublicKey jcePublicKey;
                KeyPair keypair;
                Session session = (Session)bagEntry.value();
                if (labelChars != null && this.labelExists(session, labelChars)) {
                    throw new IllegalArgumentException("label " + new String(labelChars) + " exists, please specify another one");
                }
                if (id == null) {
                    id = this.generateId(session);
                }
                privateKeyTemplate.getId().setByteArrayValue(id);
                publicKeyTemplate.getId().setByteArrayValue(id);
                try {
                    keypair = session.generateKeyPair(Mechanism.get((long)mech), (PKCS11Object)publicKeyTemplate, (PKCS11Object)privateKeyTemplate);
                    labelChars = IaikP11SlotUtil.value(keypair.getPrivateKey().getLabel());
                }
                catch (TokenException ex) {
                    throw new P11TokenException("could not generate keypair " + Functions.mechanismCodeToString((long)mech), ex);
                }
                if (labelChars == null) {
                    throw new P11TokenException("Label of the generated PrivateKey is not set");
                }
                String pubKeyLabel = IaikP11SlotUtil.valueStr(keypair.getPublicKey().getLabel());
                P11ObjectIdentifier objId = new P11ObjectIdentifier(id, new String(labelChars));
                try {
                    jcePublicKey = IaikP11SlotUtil.generatePublicKey(keypair.getPublicKey());
                }
                catch (XiSecurityException ex) {
                    throw new P11TokenException("could not generate public key " + objId, ex);
                }
                PrivateKey privKey2 = (PrivateKey)this.getKeyObject(session, (Key)new PrivateKey(), id, labelChars);
                if (privKey2 == null) {
                    throw new P11TokenException("could not read the generated private key");
                }
                X509PublicKeyCertificate cert2 = IaikP11SlotUtil.getCertificateObject(session, id, null);
                String certLabel = null;
                X509Cert[] certs = null;
                if (cert2 != null) {
                    certLabel = IaikP11SlotUtil.valueStr(cert2.getLabel());
                    certs = new X509Cert[1];
                    try {
                        certs[0] = X509Util.parseCert(IaikP11SlotUtil.value(cert2.getValue()));
                    }
                    catch (CertificateException ex) {
                        throw new P11TokenException("could not parse certifcate", ex);
                    }
                }
                P11IdentityId entityId = new P11IdentityId(this.slotId, objId, true, pubKeyLabel, certs != null, certLabel);
                IaikP11Identity ret = new IaikP11Identity(this, entityId, privKey2, jcePublicKey, certs);
                succ = true;
                iaikP11Identity = ret;
            }
            catch (Throwable throwable) {
                this.sessions.requite(bagEntry);
                throw throwable;
            }
            this.sessions.requite(bagEntry);
            return iaikP11Identity;
        }
        finally {
            if (!succ && id != null) {
                try {
                    this.removeObjects(id, false, labelChars);
                }
                catch (Throwable th) {
                    LogUtil.error((Logger)LOG, (Throwable)th, (String)"could not remove objects");
                }
            }
        }
    }

    private X509PublicKeyCertificate createPkcs11Template(Session session, X509Cert cert, P11Slot.P11NewObjectControl control, boolean omitDateAttrs) throws P11TokenException {
        X509PublicKeyCertificate newCertTemp = new X509PublicKeyCertificate();
        byte[] id = control.getId();
        if (id == null) {
            id = this.generateId(session);
        }
        newCertTemp.getId().setByteArrayValue(id);
        if (this.newObjectConf.isIgnoreLabel()) {
            if (control.getLabel() != null) {
                LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
            }
        } else {
            newCertTemp.getLabel().setCharArrayValue(control.getLabel().toCharArray());
        }
        newCertTemp.getToken().setBooleanValue(Boolean.valueOf(true));
        newCertTemp.getCertificateType().setLongValue(Long.valueOf(0L));
        Set<Long> setCertAttributes = this.newObjectConf.getSetCertObjectAttributes();
        try {
            if (setCertAttributes.contains(257L)) {
                newCertTemp.getSubject().setByteArrayValue(cert.getSubject().getEncoded());
            }
            if (setCertAttributes.contains(129L)) {
                newCertTemp.getIssuer().setByteArrayValue(cert.getIssuer().getEncoded());
            }
        }
        catch (IOException ex) {
            throw new P11TokenException("error encoding certificate: " + ex.getMessage(), ex);
        }
        if (setCertAttributes.contains(130L)) {
            newCertTemp.getSerialNumber().setByteArrayValue(cert.getSerialNumber().toByteArray());
        }
        if (!omitDateAttrs) {
            if (setCertAttributes.contains(272L)) {
                newCertTemp.getStartDate().setDateValue(cert.getNotBefore());
            }
            if (setCertAttributes.contains(273L)) {
                newCertTemp.getStartDate().setDateValue(cert.getNotAfter());
            }
        }
        newCertTemp.getValue().setByteArrayValue(cert.getEncoded());
        return newCertTemp;
    }

    @Override
    protected void updateCertificate0(P11ObjectIdentifier keyId, X509Cert newCert) throws P11TokenException {
        try {
            this.removeCerts(keyId);
        }
        catch (P11UnknownEntityException p11UnknownEntityException) {
            // empty catch block
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.addCert0(newCert, new P11Slot.P11NewObjectControl(keyId.getId(), keyId.getLabel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeIdentity0(P11IdentityId identityId) throws P11TokenException {
        ConcurrentBagEntry<Session> bagEntry = this.borrowSession();
        try {
            X509PublicKeyCertificate[] certs;
            P11ObjectIdentifier certId;
            iaik.pkcs.pkcs11.objects.PublicKey pubKey;
            P11ObjectIdentifier pubKeyId;
            PrivateKey privKey;
            Session session = (Session)bagEntry.value();
            P11ObjectIdentifier keyId = identityId.getKeyId();
            byte[] id = keyId.getId();
            char[] label = keyId.getLabelChars();
            SecretKey secretKey = (SecretKey)this.getKeyObject(session, (Key)new SecretKey(), id, label);
            if (secretKey != null) {
                try {
                    session.destroyObject((PKCS11Object)secretKey);
                }
                catch (TokenException ex) {
                    String msg = "could not delete secret key " + keyId;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                    throw new P11TokenException(msg);
                }
            }
            if ((privKey = (PrivateKey)this.getKeyObject(session, (Key)new PrivateKey(), id, label)) != null) {
                try {
                    session.destroyObject((PKCS11Object)privKey);
                }
                catch (TokenException ex) {
                    String msg = "could not delete private key " + keyId;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                    throw new P11TokenException(msg);
                }
            }
            if ((pubKeyId = identityId.getPublicKeyId()) != null && (pubKey = (iaik.pkcs.pkcs11.objects.PublicKey)this.getKeyObject(session, (Key)new iaik.pkcs.pkcs11.objects.PublicKey(), pubKeyId.getId(), pubKeyId.getLabelChars())) != null) {
                try {
                    session.destroyObject((PKCS11Object)pubKey);
                }
                catch (TokenException ex) {
                    String msg = "could not delete public key " + pubKeyId;
                    LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                    throw new P11TokenException(msg);
                }
            }
            if ((certId = identityId.getCertId()) != null && (certs = IaikP11SlotUtil.getCertificateObjects(session, certId.getId(), certId.getLabelChars())) != null && certs.length > 0) {
                for (X509PublicKeyCertificate cert : certs) {
                    try {
                        session.destroyObject((PKCS11Object)cert);
                    }
                    catch (TokenException ex) {
                        String msg = "could not delete certificate " + certId;
                        LogUtil.error((Logger)LOG, (Throwable)ex, (String)msg);
                        throw new P11TokenException(msg);
                    }
                }
            }
        }
        finally {
            this.sessions.requite(bagEntry);
        }
    }

    private byte[] generateId(Session session) throws P11TokenException {
        byte[] keyId;
        while (true) {
            keyId = new byte[this.newObjectConf.getIdLength()];
            this.random.nextBytes(keyId);
            keyId[0] = (byte)(0x7F & keyId[0]);
            if (this.existsIdentityForId(keyId) || this.existsCertForId(keyId)) continue;
            Key key = new Key();
            key.getId().setByteArrayValue(keyId);
            if (!CollectionUtil.isEmpty(IaikP11SlotUtil.getObjects(session, (Storage)key, 1))) continue;
            X509PublicKeyCertificate cert = new X509PublicKeyCertificate();
            cert.getId().setByteArrayValue(keyId);
            if (CollectionUtil.isEmpty(IaikP11SlotUtil.getObjects(session, (Storage)cert, 1))) break;
        }
        return keyId;
    }

    private boolean labelExists(Session session, char[] keyLabel) throws P11TokenException {
        Args.notNull((Object)keyLabel, (String)"keyLabel");
        String strLabel = new String(keyLabel);
        if (this.existsIdentityForLabel(strLabel) || this.existsCertForLabel(strLabel)) {
            return true;
        }
        Key key = new Key();
        key.getLabel().setCharArrayValue(keyLabel);
        if (!CollectionUtil.isEmpty(IaikP11SlotUtil.getObjects(session, (Storage)key, 1))) {
            return true;
        }
        X509PublicKeyCertificate cert = new X509PublicKeyCertificate();
        cert.getLabel().setCharArrayValue(keyLabel);
        return !CollectionUtil.isEmpty(IaikP11SlotUtil.getObjects(session, (Storage)cert, 1));
    }

    void setKeyAttributes(P11Slot.P11NewKeyControl control, iaik.pkcs.pkcs11.objects.PublicKey publicKey, PrivateKey privateKey, P11ModuleConf.P11NewObjectConf newObjectConf) {
        if (privateKey != null) {
            privateKey.getToken().setBooleanValue(Boolean.valueOf(true));
            if (newObjectConf.isIgnoreLabel()) {
                if (control.getLabel() != null) {
                    LOG.warn("label is set, but ignored: '{}'", (Object)control.getLabel());
                }
            } else {
                privateKey.getLabel().setCharArrayValue(control.getLabel().toCharArray());
            }
            privateKey.getPrivate().setBooleanValue(Boolean.valueOf(true));
            if (control.getExtractable() != null) {
                privateKey.getExtractable().setBooleanValue(control.getExtractable());
            }
            if (control.getSensitive() != null) {
                privateKey.getSensitive().setBooleanValue(control.getSensitive());
            }
            Set<P11Slot.P11KeyUsage> usages = control.getUsages();
            Boolean TRUE = Boolean.TRUE;
            if (CollectionUtil.isNotEmpty(usages)) {
                for (P11Slot.P11KeyUsage usage : usages) {
                    if (usage == P11Slot.P11KeyUsage.DECRYPT) {
                        privateKey.getDecrypt().setBooleanValue(TRUE);
                        continue;
                    }
                    if (usage == P11Slot.P11KeyUsage.DERIVE) {
                        privateKey.getDerive().setBooleanValue(TRUE);
                        continue;
                    }
                    if (usage == P11Slot.P11KeyUsage.SIGN) {
                        privateKey.getSign().setBooleanValue(TRUE);
                        continue;
                    }
                    if (usage == P11Slot.P11KeyUsage.SIGN_RECOVER) {
                        privateKey.getSignRecover().setBooleanValue(TRUE);
                        continue;
                    }
                    if (usage != P11Slot.P11KeyUsage.UNWRAP) continue;
                    privateKey.getUnwrap().setBooleanValue(TRUE);
                }
            } else {
                long keyType = privateKey.getKeyType().getLongValue();
                if (keyType == 3L || keyType == 0L || keyType == 1L) {
                    privateKey.getSign().setBooleanValue(TRUE);
                }
                if (this.slot.getModule().getVendorCodeConverter() != null && keyType == this.slot.getModule().getVendorCodeConverter().genericToVendorCKK(0xFFFFF001L)) {
                    privateKey.getSign().setBooleanValue(TRUE);
                }
                if (keyType == 0L) {
                    privateKey.getUnwrap().setBooleanValue(TRUE);
                    privateKey.getDecrypt().setBooleanValue(TRUE);
                }
            }
        }
        if (publicKey != null) {
            publicKey.getToken().setBooleanValue(Boolean.valueOf(true));
            if (!newObjectConf.isIgnoreLabel()) {
                publicKey.getLabel().setCharArrayValue(control.getLabel().toCharArray());
            }
            publicKey.getVerify().setBooleanValue(Boolean.valueOf(true));
        }
    }

    private static void setPrivateKeyAttrsOtf(PrivateKey privateKeyTemplate) {
        privateKeyTemplate.getToken().setBooleanValue(Boolean.valueOf(false));
        privateKeyTemplate.getSensitive().setBooleanValue(Boolean.valueOf(false));
        privateKeyTemplate.getExtractable().setBooleanValue(Boolean.valueOf(true));
    }

    private static void destroyObject(Session session, PKCS11Object object) {
        try {
            session.destroyObject(object);
        }
        catch (TokenException ex) {
            LogUtil.warn((Logger)LOG, (Throwable)ex, (String)"error destroying object");
        }
    }

    private static BigInteger toBigInt(ByteArrayAttribute attr) {
        return new BigInteger(1, attr.getByteArrayValue());
    }
}

