/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.IOException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAParameterSpec;
import java.util.Locale;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.xipki.password.PasswordResolver;
import org.xipki.security.EdECConstants;
import org.xipki.security.KeypairGenerator;
import org.xipki.security.XiSecurityException;
import org.xipki.security.util.DSAParameterCache;
import org.xipki.security.util.KeyUtil;
import org.xipki.util.ConfPairs;

public class SoftwareKeypairGenerator
extends KeypairGenerator {
    private final SecureRandom random;

    public SoftwareKeypairGenerator(SecureRandom random) {
        this.random = random == null ? new SecureRandom() : random;
    }

    @Override
    public void initialize0(ConfPairs conf, PasswordResolver passwordResolver) throws XiSecurityException {
    }

    @Override
    public PrivateKeyInfo generateKeypair(String keyspec) throws XiSecurityException {
        if (!this.supports(keyspec)) {
            throw new XiSecurityException(this.name + " cannot generate keypair of keyspec " + keyspec);
        }
        try {
            return this.generateKeypair0(keyspec);
        }
        catch (XiSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XiSecurityException(ex);
        }
    }

    private PrivateKeyInfo generateKeypair0(String keyspec) throws Exception {
        String type;
        String[] tokens = keyspec.split("/");
        switch (type = tokens[0].toUpperCase(Locale.ROOT)) {
            case "RSA": {
                int keysize = Integer.parseInt(tokens[1]);
                if (keysize > 4096) {
                    throw new XiSecurityException("keysize too large");
                }
                KeyPair kp = KeyUtil.generateRSAKeypair(keysize, this.rsaE, this.random);
                return KeyUtil.toPrivateKeyInfo((RSAPrivateCrtKey)kp.getPrivate());
            }
            case "EC": {
                ASN1ObjectIdentifier curveOid = new ASN1ObjectIdentifier(tokens[1]);
                KeyPair kp = KeyUtil.generateECKeypair(curveOid, this.random);
                ECPublicKey pub = (ECPublicKey)kp.getPublic();
                int orderBitLength = pub.getParams().getOrder().bitLength();
                byte[] publicKey = KeyUtil.getUncompressedEncodedECPoint(pub.getW(), orderBitLength);
                java.security.interfaces.ECPrivateKey priv = (java.security.interfaces.ECPrivateKey)kp.getPrivate();
                return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)curveOid), (ASN1Encodable)new ECPrivateKey(orderBitLength, priv.getS(), (ASN1BitString)new DERBitString(publicKey), null));
            }
            case "DSA": {
                int pLength = Integer.parseInt(tokens[1]);
                int qLength = Integer.parseInt(tokens[2]);
                DSAParameterSpec spec = DSAParameterCache.getDSAParameterSpec(pLength, qLength, null);
                KeyPair kp = KeyUtil.generateDSAKeypair(spec, this.random);
                DSAParameter parameter = new DSAParameter(spec.getP(), spec.getQ(), spec.getG());
                AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)parameter);
                byte[] publicKey = new ASN1Integer(((DSAPublicKey)kp.getPublic()).getY()).getEncoded();
                DSAPrivateKey priv = (DSAPrivateKey)kp.getPrivate();
                return new PrivateKeyInfo(algId, (ASN1Encodable)new ASN1Integer(priv.getX()), null, publicKey);
            }
            case "ED25519": 
            case "ED448": 
            case "X25519": 
            case "X448": {
                ASN1ObjectIdentifier curveId = EdECConstants.getCurveOid(keyspec);
                KeyPair kp = KeyUtil.generateEdECKeypair(curveId, this.random);
                return PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
            }
        }
        throw new IllegalArgumentException("unknown keyspec " + keyspec);
    }

    @Override
    public boolean isHealthy() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

