/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.xipki.util.Args;
import org.xipki.util.StringUtil;

public class AlgorithmUtil {
    private static final List<String> curveNames;
    private static final Map<String, ASN1ObjectIdentifier> curveNameToOidMap;
    private static final Map<ASN1ObjectIdentifier, String> curveOidToNameMap;

    private AlgorithmUtil() {
    }

    public static boolean equalsAlgoName(String algoNameA, String algoNameB) {
        String tmpB;
        if (Args.notBlank((String)algoNameA, (String)"algoNameA").equalsIgnoreCase(Args.notBlank((String)algoNameB, (String)"algoNameB"))) {
            return true;
        }
        String tmpA = algoNameA;
        if (tmpA.indexOf(45) != -1) {
            tmpA = tmpA.replace("-", "");
        }
        if ((tmpB = algoNameB).indexOf(45) != -1) {
            tmpB = tmpB.replace("-", "");
        }
        if (tmpA.equalsIgnoreCase(tmpB)) {
            return true;
        }
        return AlgorithmUtil.splitAlgoNameTokens(tmpA).equals(AlgorithmUtil.splitAlgoNameTokens(tmpB));
    }

    private static Set<String> splitAlgoNameTokens(String algoName) {
        String tmpAlgoName = Args.notBlank((String)algoName, (String)"algoName").toUpperCase();
        int idx = tmpAlgoName.indexOf("AND");
        HashSet<String> set = new HashSet<String>();
        if (idx == -1) {
            set.add(tmpAlgoName);
            return set;
        }
        int len = tmpAlgoName.length();
        int beginIndex = 0;
        int endIndex = idx;
        while (true) {
            String token;
            if (StringUtil.isNotBlank((String)(token = tmpAlgoName.substring(beginIndex, endIndex)))) {
                set.add(token);
            }
            if (endIndex >= len) {
                return set;
            }
            beginIndex = endIndex + 3;
            if ((endIndex = tmpAlgoName.indexOf("AND", beginIndex)) != -1) continue;
            endIndex = len;
        }
    }

    private static ASN1ObjectIdentifier getCurveOidForName(String curveName) {
        return curveNameToOidMap.get(Args.toNonBlankLower((String)curveName, (String)"curveName"));
    }

    public static List<String> getECCurveNames() {
        return curveNames;
    }

    public static String getCurveName(ASN1ObjectIdentifier curveOid) {
        Args.notNull((Object)curveOid, (String)"curveOid");
        return curveOidToNameMap.get(curveOid);
    }

    public static ASN1ObjectIdentifier getCurveOidForCurveNameOrOid(String curveNameOrOid) {
        ASN1ObjectIdentifier oid;
        Args.notBlank((String)curveNameOrOid, (String)"curveNameOrOid");
        try {
            oid = new ASN1ObjectIdentifier(curveNameOrOid);
        }
        catch (Exception ex) {
            oid = AlgorithmUtil.getCurveOidForName(curveNameOrOid);
        }
        return oid;
    }

    static {
        HashMap<String, ASN1ObjectIdentifier> nameOidMap = new HashMap<String, ASN1ObjectIdentifier>();
        Enumeration names = ECNamedCurveTable.getNames();
        LinkedList<String> nameList = new LinkedList<String>();
        while (names.hasMoreElements()) {
            String name = ((String)names.nextElement()).toLowerCase();
            ASN1ObjectIdentifier oid = org.bouncycastle.asn1.x9.ECNamedCurveTable.getOID((String)name);
            if (oid == null) continue;
            nameList.add(name);
            nameOidMap.put(name, oid);
        }
        HashMap<ASN1ObjectIdentifier, String> oidNameMap = new HashMap<ASN1ObjectIdentifier, String>();
        Enumeration nistNames = NISTNamedCurves.getNames();
        while (nistNames.hasMoreElements()) {
            String nistName = (String)nistNames.nextElement();
            ASN1ObjectIdentifier oid = NISTNamedCurves.getOID((String)nistName);
            oidNameMap.put(oid, nistName);
        }
        for (String name : nameList) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)nameOidMap.get(name);
            nameOidMap.put(name, oid);
            if (oidNameMap.containsKey(oid)) continue;
            oidNameMap.put(oid, name);
        }
        Collections.sort(nameList);
        curveNames = Collections.unmodifiableList(nameList);
        curveNameToOidMap = Collections.unmodifiableMap(nameOidMap);
        curveOidToNameMap = Collections.unmodifiableMap(oidNameMap);
    }
}

